/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.entity;

import com.onewhohears.dscombat.entity.PhysicsBody;
import com.onewhohears.onewholibs.util.math.QuaternionF;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import com.onewhohears.onewholibs.util.math.UtilGeometry;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public interface DrivingBody
extends PhysicsBody {
    @Override
    default public void calcGroundMovement(QuaternionF q) {
        if (this.canFlattenOnGround()) {
            this.flatten(q, 4.0f, 4.0f, true);
        }
        if (this.canDriveOnGround()) {
            this.calcDriveMovement(q);
        } else {
            this.calcOtherGroundMovement(q);
        }
        if (this.canGroundBrake() && this.isGroundBraking()) {
            this.applyGroundBreaks();
        }
    }

    default public void applyGroundBreaks() {
        this.driveSlowDown(this.getGroundBreaksDeAcceleration());
    }

    default public void calcDriveMovement(QuaternionF q) {
        Vec3 n = UtilAngles.rotationToVector((double)this.m_146908_(), (double)0.0);
        double driveAcc = this.getDriveAcc();
        double minDriveAcc = this.getMinDriveAcc();
        if (Math.abs(driveAcc) < minDriveAcc) {
            driveAcc = minDriveAcc * (double)(driveAcc < 0.0 ? -1 : 1);
        }
        if (this.isSliding() || this.willSlideFromTurn()) {
            this.m_20256_(this.m_20184_().m_82549_(n.m_82490_(driveAcc * 0.5)));
            this.addFrictionForce(this.getKineticFriction());
        } else {
            this.m_20256_(n.m_82490_((double)(this.getXZSpeed() * (float)this.getXZSpeedDir()) + driveAcc));
            if (this.getCurrentThrottle() == 0.0f && this.getXZSpeed() != 0.0f) {
                this.driveSlowDown(2.0E-4);
            }
        }
        if (this.dontUseDriveTurnPhysics()) {
            return;
        }
        float max_tr = this.getTurnRadius();
        Vec3 av = this.getAngularVel();
        if (this.getYawInput() == 0.0f || max_tr == 0.0f) {
            if (!this.isSliding()) {
                this.setAngularVel(av.m_82542_(1.0, 0.0, 1.0));
            }
            return;
        }
        float tr = 1.0f / this.getYawInput() * max_tr;
        float turn = this.getXZSpeed() / tr * (float)this.getXZSpeedDir();
        float turnDeg = turn * 57.295776f;
        if (!this.isSliding()) {
            av = av.m_82542_(1.0, 0.0, 1.0).m_82520_(0.0, (double)turnDeg, 0.0);
        } else {
            this.addMomentY(turnDeg * this.getSlideAngleCos() * 5000000.0f, false);
        }
        this.setAngularVel(av);
    }

    default public boolean willSlideFromTurn() {
        double max_tr = this.getTurnRadius();
        if (this.getYawInput() != 0.0f && max_tr != 0.0) {
            double tr = max_tr * 1.0 / (double)Math.abs(this.getYawInput());
            double cen_acc = (double)(this.getXZSpeed() * this.getXZSpeed()) / tr * 400.0;
            double cen_force = cen_acc * (double)this.getTotalMass();
            return cen_force >= this.getStaticFriction();
        }
        return false;
    }

    default public boolean isSlideAngleNearZero() {
        if (this.getXZSpeedDir() == -1) {
            return Mth.m_14154_((float)(Mth.m_14154_((float)this.getSlideAngle()) - 180.0f)) < 2.0f;
        }
        return Mth.m_14154_((float)this.getSlideAngle()) < 2.0f;
    }

    default public boolean isSliding() {
        return !this.canDriveOnGround() || !this.isSlideAngleNearZero();
    }

    default public void calcOtherGroundMovement(QuaternionF q) {
        this.addFrictionForce(this.getKineticFriction());
    }

    default public void driveSlowDown(double amount) {
        Vec3 m = this.m_20184_().m_82542_(1.0, 0.0, 1.0);
        if (UtilGeometry.isZero((Vec3)m)) {
            return;
        }
        double speed = m.m_82553_();
        double newSpeed = speed - amount;
        if (Math.signum(newSpeed) != Math.signum(speed)) {
            newSpeed = 0.0;
        }
        m = m.m_82490_(newSpeed / speed);
        this.m_20256_(new Vec3(m.f_82479_, this.m_20184_().f_82480_, m.f_82481_));
    }

    public boolean canDriveOnGround();

    public boolean canGroundBrake();

    public boolean isGroundBraking();

    public double getKineticFriction();

    public double getStaticFriction();

    public boolean canAirBrake();

    public boolean isAirBreaking();

    public double getGroundBreaksDeAcceleration();

    public double getAirBreaksDeAcceleration();

    public double getDriveAcc();

    public float getCurrentThrottle();

    public float getTurnRadius();

    public boolean canFlattenOnGround();

    public double getMinDriveAcc();

    @Override
    default public void calcAirMovement(QuaternionF q) {
        if (this.canAirBrake() && this.isAirBreaking()) {
            this.applyAirBreaks();
        }
    }

    default public void applyAirBreaks() {
        this.airSlowDown(this.getAirBreaksDeAcceleration());
    }

    default public void airSlowDown(double amount) {
        Vec3 m = this.m_20184_();
        if (UtilGeometry.isZero((Vec3)m)) {
            return;
        }
        double speed = m.m_82553_();
        double newSpeed = speed - amount;
        if (Math.signum(newSpeed) != Math.signum(speed)) {
            newSpeed = 0.0;
        }
        m = m.m_82490_(newSpeed / speed);
        this.m_20256_(m);
    }

    @Override
    default public void calcMoveStatsPost(QuaternionF q) {
        Vec3 m = this.m_20184_();
        float y = this.m_146908_();
        this.setXZSpeed((float)Math.sqrt(m.f_82479_ * m.f_82479_ + m.f_82481_ * m.f_82481_));
        if (this.getXZSpeed() == 0.0f) {
            this.setXZYaw(y);
            this.setSlideAngle(0.0f);
        } else {
            this.setXZYaw(UtilAngles.getYaw((Vec3)m));
            this.setSlideAngle(Mth.m_14118_((float)this.getXZYaw(), (float)y));
            this.setSlideAngleCos((float)Math.abs(Math.cos(Math.toRadians(this.getSlideAngle()))));
        }
        this.setXZSpeedDir(1);
        if (Math.abs(this.getSlideAngle()) > 90.0f) {
            this.setXZSpeedDir(-1);
        }
    }

    public float getXZSpeed();

    public void setXZSpeed(float var1);

    public int getXZSpeedDir();

    public void setXZSpeedDir(int var1);

    public float getXZYaw();

    public void setXZYaw(float var1);

    public float getSlideAngle();

    public void setSlideAngle(float var1);

    public float getSlideAngleCos();

    public void setSlideAngleCos(float var1);
}

