/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.entity.damagesource;

import com.onewhohears.dscombat.entity.weapon.EntityWeapon;
import com.onewhohears.dscombat.init.ModDamageTypes;
import com.onewhohears.onewholibs.util.UtilMCText;
import com.onewhohears.onewholibs.util.UtilParse;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WeaponDamageSource
extends DamageSource {
    protected final WeaponDamageType type;
    protected final EntityWeapon<?> weapon;
    protected final String deathMsgId;
    public static final String[] saltyDeaths = new String[]{"salty1"};
    public static final String[] explodeDeaths = new String[]{"explode1", "explode2"};
    public static final String[] bulletDeaths = new String[]{"bullet1", "bullet2"};
    public static final String[] bombDeaths = new String[]{"bomb1", "bomb2"};
    public static final String[] missileContactDeaths = new String[]{"missile_contact1", "missile_contact2"};
    public static final String[] missileDeaths = new String[]{"missile1", "missile2", "missile3", "missile4"};
    public static final String[] torpedoDeaths = new String[]{"torpedo1", "torpedo2"};
    public static final String[] irMissileDeaths = new String[]{"ir_missile1", "ir_missile2"};

    public WeaponDamageSource(WeaponDamageType type, @Nullable Entity shooter, @NotNull EntityWeapon<?> weapon) {
        super(ModDamageTypes.getDamageTypeHolder(weapon.m_9236_(), type.type), shooter);
        this.type = type;
        this.weapon = weapon;
        this.deathMsgId = type.deathMessages.get();
    }

    public WeaponDamageType getWeaponDamageType() {
        return this.type;
    }

    public static String getBulletDeath() {
        return UtilParse.getRandomString((int[])new int[]{1, 2}, (String[][])new String[][]{saltyDeaths, bulletDeaths});
    }

    public static String getBulletExplodeDeath() {
        return UtilParse.getRandomString((int[])new int[]{1, 2, 4}, (String[][])new String[][]{saltyDeaths, bulletDeaths, explodeDeaths});
    }

    public static String getBombDeath() {
        return UtilParse.getRandomString((int[])new int[]{1, 4, 2}, (String[][])new String[][]{saltyDeaths, bombDeaths, explodeDeaths});
    }

    public static String getMissileContactDeath() {
        return UtilParse.getRandomString((int[])new int[]{1, 2, 4}, (String[][])new String[][]{saltyDeaths, missileDeaths, missileContactDeaths});
    }

    public static String getMissileDeath() {
        return UtilParse.getRandomString((int[])new int[]{1, 4, 2}, (String[][])new String[][]{saltyDeaths, missileDeaths, explodeDeaths});
    }

    public static String getTorpedoDeath() {
        return UtilParse.getRandomString((int[])new int[]{1, 2, 1, 4}, (String[][])new String[][]{saltyDeaths, missileDeaths, explodeDeaths, torpedoDeaths});
    }

    public static String getIRMissileDeath() {
        return UtilParse.getRandomString((int[])new int[]{1, 2, 1, 4}, (String[][])new String[][]{saltyDeaths, missileDeaths, explodeDeaths, irMissileDeaths});
    }

    @NotNull
    public Entity m_7640_() {
        return this.weapon;
    }

    public boolean m_7986_() {
        return false;
    }

    public Vec3 m_7270_() {
        return this.weapon.m_20182_();
    }

    @NotNull
    public String toString() {
        return "WDS: " + this.m_19385_() + " / " + String.valueOf(this.weapon) + " / " + String.valueOf(this.m_7639_());
    }

    @NotNull
    public Component m_6157_(LivingEntity livingEntity) {
        LivingEntity killer = livingEntity.m_21232_();
        String s = "death.attack.dscombat." + this.deathMsgId;
        if (killer == null) {
            return UtilMCText.translatable((String)s, (Object[])new Object[]{livingEntity.m_5446_()});
        }
        int dist = (int)livingEntity.m_20182_().m_82554_(this.weapon.getShootPos());
        s = s + ".player";
        return UtilMCText.translatable((String)s, (Object[])new Object[]{livingEntity.m_5446_(), killer.m_5446_(), "" + dist});
    }

    public static enum WeaponDamageType {
        BULLET(WeaponDamageSource::getBulletDeath, ModDamageTypes.BULLET),
        BULLET_EXPLODE(WeaponDamageSource::getBulletExplodeDeath, ModDamageTypes.BULLET_EXPLODE),
        BOMB(WeaponDamageSource::getBombDeath, ModDamageTypes.BOMB),
        MISSILE_CONTACT(WeaponDamageSource::getMissileContactDeath, ModDamageTypes.MISSILE_CONTACT),
        MISSILE(WeaponDamageSource::getMissileDeath, ModDamageTypes.MISSILE),
        TORPEDO(WeaponDamageSource::getTorpedoDeath, ModDamageTypes.TORPEDO),
        IR_MISSILE(WeaponDamageSource::getIRMissileDeath, ModDamageTypes.IR_MISSILE);

        public final String damageTypeId;
        public final RandomDeathMessageFactory deathMessages;
        public final ResourceKey<DamageType> type;

        @Nullable
        public static WeaponDamageType byId(String id) {
            for (WeaponDamageType wdt : WeaponDamageType.values()) {
                if (!wdt.damageTypeId.equals(id)) continue;
                return wdt;
            }
            return null;
        }

        private WeaponDamageType(RandomDeathMessageFactory deathMessages, ResourceKey<DamageType> type) {
            this.damageTypeId = type.m_135782_().m_135815_();
            this.deathMessages = deathMessages;
            this.type = type;
        }

        public WeaponDamageSource getSource(@Nullable Entity shooter, @NotNull EntityWeapon<?> weapon) {
            return new WeaponDamageSource(this, shooter, weapon);
        }

        public boolean isContact() {
            return this == BULLET || this == MISSILE_CONTACT;
        }

        public boolean isMissileExplode() {
            return this == MISSILE || this == TORPEDO || this == IR_MISSILE;
        }
    }

    public static interface RandomDeathMessageFactory {
        public String get();
    }
}

