/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.entity.vehicle.hitbox;

import com.onewhohears.dscombat.data.vehicle.RotableHitboxData;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.dscombat.entity.CustomExplosion;
import com.onewhohears.dscombat.entity.Revivable;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.entity.vehicle.hitbox.RotableHitboxes;
import com.onewhohears.dscombat.init.ModEntities;
import com.onewhohears.dscombat.util.UtilVehicleEntity;
import com.onewhohears.dscombat.util.math.RotableAABB;
import com.onewhohears.onewholibs.common.network.toclient.ClientBoundSpawnDataPacket;
import com.onewhohears.onewholibs.entity.AdditionalSpawnDataEntity;
import com.onewhohears.onewholibs.util.UtilEntity;
import com.onewhohears.onewholibs.util.math.QuaternionF;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;
import org.jetbrains.annotations.NotNull;

public class RotableHitbox
extends Entity
implements CustomExplosion,
Revivable,
AdditionalSpawnDataEntity {
    public static final EntityDataAccessor<Float> HEALTH = SynchedEntityData.m_135353_(RotableHitbox.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> ARMOR = SynchedEntityData.m_135353_(RotableHitbox.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private EntityVehicle parent;
    private RotableHitboxData data;
    private RotableAABB hitbox;
    private Vec3 test_pos;
    private Vec3 test_size;

    public RotableHitbox(EntityVehicle parent, RotableHitboxData data) {
        this((EntityType)ModEntities.ROTABLE_HITBOX.get(), parent.getWorld());
        this.parent = parent;
        this.data = data;
        this.f_19794_ = true;
        this.initStats();
        this.setHealth(data.getMaxHealth());
        this.setArmor(data.getMaxArmor());
        RotableHitboxes.addHitbox(this);
    }

    public void readNbt(CompoundTag nbt) {
        CompoundTag tag = nbt.m_128469_(this.getHitboxName());
        if (tag == null || tag.m_128456_()) {
            return;
        }
        if (tag.m_128441_("health")) {
            this.setHealth(tag.m_128457_("health"));
        }
        if (tag.m_128441_("armor")) {
            this.setArmor(tag.m_128457_("armor"));
        }
    }

    public void writeNbt(CompoundTag nbt) {
        CompoundTag tag = new CompoundTag();
        tag.m_128350_("health", this.getHealth());
        tag.m_128350_("armor", this.getArmor());
        nbt.m_128365_(this.getHitboxName(), (Tag)tag);
    }

    public RotableHitbox(EntityType<?> type, Level level) {
        super(type, level);
    }

    public void handleClientAddEntityPacket(int parentId, String name) {
        this.parent = (EntityVehicle)this.getWorld().m_6815_(parentId);
        if (this.parent == null) {
            return;
        }
        this.data = ((VehicleStats)this.parent.getStats()).getHitboxDataByName(name);
        this.initStats();
        this.parent.addRotableHitboxForClient(this);
    }

    protected void initStats() {
        if (this.data == null) {
            return;
        }
        this.hitbox = new RotableAABB(this.getHitboxSize().m_7096_(), this.getHitboxSize().m_7098_(), this.getHitboxSize().m_7094_());
        this.m_6210_();
    }

    public void m_8119_() {
        if (this.parent == null || this.parent.m_213877_()) {
            this.m_146870_();
            return;
        }
        if (this.data == null || this.hitbox == null) {
            this.m_146870_();
            return;
        }
        if (!this.isClientSide() && this.f_19797_ > 20 && this.data.isRemoveOnDestroy() && this.isDestroyed()) {
            this.m_6074_();
            return;
        }
        this.positionSelf();
        this.f_19803_ = false;
    }

    public boolean isClientSide() {
        return this.getWorld().m_5776_();
    }

    public Level getWorld() {
        return UtilEntity.getLevel((Entity)this);
    }

    protected void positionSelf() {
        this.m_146867_();
        QuaternionF q = this.getParent().getQBySide();
        Vec3 pos = this.getParent().m_20182_().m_82549_(UtilAngles.rotateVector((Vec3)this.getRelPos(), (QuaternionF)q));
        this.hitbox.setCenterAndRot(pos, q);
        this.m_146884_(pos);
    }

    public Vec3 collide(Entity entity, AABB aabb, Vec3 move) {
        if (this.hitbox == null || this.getParent() == null) {
            return move;
        }
        if (this.getParent().isEntityHitboxCooldown(entity)) {
            return move;
        }
        if (!this.couldCollide(entity)) {
            return move;
        }
        if (!this.hitbox.isInside(aabb, 0.0)) {
            return move;
        }
        if (this.isInside(entity)) {
            Vec3 push = this.hitbox.getPushOutPos(entity.m_20182_(), entity.m_20191_(), 0.0);
            entity.m_20219_(push);
            entity.m_6853_(true);
            entity.m_183634_();
            move = move.m_82542_(1.0, 0.0, 1.0);
        }
        this.moveEntityFromParent(entity);
        move = this.hitbox.collide(entity.m_20182_(), entity.m_20191_(), move);
        this.getParent().addEntityCollideInfo(entity, this, entity.m_20182_());
        if (this.getParent().isStuckInHitbox(entity)) {
            this.getParent().addEntityToHitboxCooldown(entity);
            entity.m_20219_(new Vec3(entity.m_20185_(), this.getParent().getMaxHitboxY(), entity.m_20189_()));
        }
        return move;
    }

    public Vec3 moveEntityFromParent(Entity entity) {
        Vec3 parent_pos = this.getParent().m_20182_();
        Vec3 parent_move = this.getParent().m_20184_();
        Vec3 parent_rot_rate = this.getParent().getAngularVel();
        QuaternionF q = this.getParent().getQBySide();
        QuaternionF qi = q.copy();
        qi.conj();
        Vec3 rel_pos = UtilAngles.rotateVector((Vec3)entity.m_20182_().m_82546_(parent_pos), (QuaternionF)qi);
        Vec3 rel_tan_vel = parent_rot_rate.m_82490_(Math.toRadians(1.0)).m_82542_(-1.0, -1.0, 1.0).m_82537_(rel_pos);
        Vec3 tan_vel = UtilAngles.rotateVector((Vec3)rel_tan_vel, (QuaternionF)q);
        Vec3 entityMoveByParent = parent_move.m_82549_(tan_vel);
        entity.m_146884_(entity.m_20182_().m_82549_(entityMoveByParent));
        entity.m_146922_(entity.m_146908_() + (float)parent_rot_rate.f_82480_);
        return entityMoveByParent;
    }

    public boolean isInside(Entity entity) {
        return this.hitbox.isInside(entity.m_20191_(), -0.01);
    }

    public boolean couldCollide(Entity entity) {
        if (this.getParent() == null) {
            return false;
        }
        if (this.m_213877_()) {
            return false;
        }
        if (this.isDestroyed()) {
            return false;
        }
        if (entity.f_19794_) {
            return false;
        }
        if (entity.m_213877_()) {
            return false;
        }
        if (entity.m_20159_()) {
            return false;
        }
        return !entity.m_20201_().equals((Object)this.getParent());
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return this.getParent().hurtHitbox(source, amount, this);
    }

    protected AABB m_142242_() {
        if (this.hitbox == null) {
            return AABB.m_165882_((Vec3)this.m_20182_(), (double)1.0, (double)1.0, (double)1.0);
        }
        return this.hitbox.getDisguisedAABB(this.m_20182_());
    }

    public RotableHitboxData getHitboxData() {
        return this.data;
    }

    public String getHitboxName() {
        return this.getHitboxData().getName();
    }

    public RotableAABB getHitbox() {
        return this.hitbox;
    }

    public Vec3 getRelPos() {
        if (this.test_pos != null) {
            return this.test_pos;
        }
        return this.getHitboxData().getRelPos();
    }

    public Vec3 getHitboxSize() {
        if (this.test_size != null) {
            return this.test_size;
        }
        return this.getHitboxData().getSize();
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_7337_(Entity entity) {
        return this.couldCollide(entity);
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientBoundSpawnDataPacket((Entity)this, (AdditionalSpawnDataEntity)this);
    }

    public boolean m_142391_() {
        return false;
    }

    public void m_142687_(Entity.RemovalReason removalReason) {
        super.m_142687_(removalReason);
        RotableHitboxes.removeHitbox(this);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(HEALTH, (Object)Float.valueOf(10.0f));
        this.f_19804_.m_135372_(ARMOR, (Object)Float.valueOf(10.0f));
    }

    protected void m_7378_(CompoundTag nbt) {
    }

    protected void m_7380_(CompoundTag nbt) {
    }

    public EntityVehicle getParent() {
        return this.parent;
    }

    public boolean m_6000_(double pX, double pY, double pZ) {
        return false;
    }

    public boolean m_6783_(double pDistance) {
        return false;
    }

    public void m_7334_(Entity entity) {
    }

    public float getHealth() {
        return ((Float)this.f_19804_.m_135370_(HEALTH)).floatValue();
    }

    public float getMaxHealth() {
        if (this.data == null) {
            return 0.0f;
        }
        return this.data.getMaxHealth();
    }

    public float getArmor() {
        return ((Float)this.f_19804_.m_135370_(ARMOR)).floatValue();
    }

    public float getMaxArmor() {
        if (this.data == null) {
            return 0.0f;
        }
        return this.data.getMaxArmor();
    }

    public void setHealth(float health) {
        if (health < 0.0f) {
            health = 0.0f;
        } else if (health > this.data.getMaxHealth()) {
            health = this.getMaxHealth();
        }
        this.f_19804_.m_135381_(HEALTH, (Object)Float.valueOf(health));
    }

    public void setArmor(float armor) {
        if (armor < 0.0f) {
            armor = 0.0f;
        } else if (armor > this.data.getMaxArmor()) {
            armor = this.getMaxArmor();
        }
        this.f_19804_.m_135381_(ARMOR, (Object)Float.valueOf(armor));
    }

    public void addHealth(float health) {
        this.setHealth(this.getHealth() + health);
    }

    public void addArmor(float armor) {
        this.setArmor(this.getArmor() + armor);
    }

    public void fullyRepair() {
        this.repair(100000.0f);
        this.repair(100000.0f);
    }

    public void repair(float repair) {
        if (!this.isClientSide() && this.m_213877_()) {
            this.invokeRevive();
            this.getWorld().m_7967_((Entity)this);
        }
        if (this.getHealth() < this.getMaxHealth()) {
            this.addHealth(repair);
        } else if (this.getArmor() < this.getMaxArmor()) {
            this.addArmor(repair);
        }
    }

    public boolean isDamaged() {
        return this.getHealth() < this.getMaxHealth() || this.getArmor() < this.getMaxArmor();
    }

    public boolean isDestroyed() {
        return this.getHealth() <= 0.0f && this.getMaxHealth() > 0.0f;
    }

    public String toString() {
        if (this.getParent() == null) {
            return super.toString() + "{" + this.getHitboxName() + ",NO_PARENT}";
        }
        return super.toString() + "{" + this.getHitboxName() + ",HI:" + this.getHitboxIndex() + ",PID:" + this.getParent().m_19879_() + "}";
    }

    public void setTestPos(Vec3 test_pos) {
        this.test_pos = test_pos;
    }

    public void setTestSize(Vec3 test_size) {
        this.test_size = test_size;
        this.getHitbox().setExtents(test_size.m_82490_(0.5));
    }

    public boolean m_6128_() {
        return true;
    }

    @Override
    public void customExplosionHandler(Explosion exp) {
        if (this.getParent() != null) {
            this.getParent().customExplosionHandler(exp, this);
        }
    }

    public int getHitboxIndex() {
        if (this.data == null) {
            return -1;
        }
        return this.data.getIndex();
    }

    public boolean canHandleInteract() {
        return this.getHitboxIndex() == 0 && this.getParent() != null && !this.getParent().rootHitboxEntityInteract();
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (this.canHandleInteract()) {
            return this.getParent().m_6096_(player, hand);
        }
        return InteractionResult.PASS;
    }

    public Entity m_20201_() {
        return this.getParent() != null ? this.getParent() : this;
    }

    public boolean m_7307_(Entity entity) {
        return this.m_20201_().m_7307_(entity);
    }

    public boolean m_20031_(Team team) {
        return this.m_20201_().m_20031_(team);
    }

    public double getMaxY() {
        return this.hitbox.getMaxY();
    }

    public ItemStack m_142340_() {
        if (this.getParent() != null) {
            return this.getParent().getItem();
        }
        return null;
    }

    @Override
    public void invokeRevive() {
        UtilVehicleEntity.revive(this);
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        int parentId = buffer.readInt();
        String hitboxName = buffer.m_130277_();
        this.handleClientAddEntityPacket(parentId, hitboxName);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeInt(this.getParent().m_19879_());
        buffer.m_130070_(this.getHitboxName());
    }
}

