/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.init;

import com.onewhohears.dscombat.block.entity.VehicleBlockEntity;
import com.onewhohears.dscombat.block.entity.WeaponPartsBlockEntity;
import com.onewhohears.dscombat.block.entity.WeaponsBlockEntity;
import com.onewhohears.dscombat.common.container.menu.VehicleBlockContainerMenu;
import com.onewhohears.dscombat.common.container.menu.VehiclePartsMenu;
import com.onewhohears.dscombat.common.container.menu.WeaponPartsBlockContainerMenu;
import com.onewhohears.dscombat.common.container.menu.WeaponsBlockContainerMenu;
import com.onewhohears.dscombat.data.parts.instance.StorageInstance;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.onewholibs.util.UtilEntity;
import dev.architectury.registry.menu.MenuRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;

public class ModContainers {
    public static final DeferredRegister<MenuType<?>> CONTAINERS = DeferredRegister.create((String)"dscombat", (ResourceKey)Registries.f_256798_);
    public static final RegistrySupplier<MenuType<VehiclePartsMenu>> VEHICLE_PARTS_MENU = ModContainers.register("vehicle_parts_menu", MenuRegistry.ofExtended((windowId, playerInv, data) -> new VehiclePartsMenu(windowId, playerInv)));
    public static final RegistrySupplier<MenuType<WeaponsBlockContainerMenu>> WEAPONS_BLOCK_MENU = ModContainers.register("weapons_block_menu", MenuRegistry.ofExtended((windowId, playerInv, data) -> {
        WeaponsBlockEntity weaponsBlock = (WeaponsBlockEntity)UtilEntity.getLevel((Entity)playerInv.f_35978_).m_7702_(data.m_130135_());
        return new WeaponsBlockContainerMenu(windowId, (Container)playerInv, weaponsBlock);
    }));
    public static final RegistrySupplier<MenuType<VehicleBlockContainerMenu>> AIRCRAFT_BLOCK_MENU = ModContainers.register("aircraft_block_menu", MenuRegistry.ofExtended((windowId, playerInv, data) -> {
        VehicleBlockEntity aircraftBlock = (VehicleBlockEntity)UtilEntity.getLevel((Entity)playerInv.f_35978_).m_7702_(data.m_130135_());
        return new VehicleBlockContainerMenu(windowId, (Container)playerInv, aircraftBlock);
    }));
    public static final RegistrySupplier<MenuType<WeaponPartsBlockContainerMenu>> WEAPON_PARTS_BLOCK_MENU = ModContainers.register("weapon_parts_block_menu", MenuRegistry.ofExtended((windowId, playerInv, data) -> {
        WeaponPartsBlockEntity weaponsBlock = (WeaponPartsBlockEntity)UtilEntity.getLevel((Entity)playerInv.f_35978_).m_7702_(data.m_130135_());
        return new WeaponPartsBlockContainerMenu(windowId, (Container)playerInv, weaponsBlock);
    }));
    public static final RegistrySupplier<MenuType<ChestMenu>> VEHICLE_STORAGE_MENU_9x0 = ModContainers.register("vehicle_storage_menu_9x0", ModContainers.createVehicleStorageMenuFactory());
    public static final RegistrySupplier<MenuType<ChestMenu>> VEHICLE_STORAGE_MENU_9x1 = ModContainers.register("vehicle_storage_menu_9x1", ModContainers.createVehicleStorageMenuFactory());
    public static final RegistrySupplier<MenuType<ChestMenu>> VEHICLE_STORAGE_MENU_9x2 = ModContainers.register("vehicle_storage_menu_9x2", ModContainers.createVehicleStorageMenuFactory());
    public static final RegistrySupplier<MenuType<ChestMenu>> VEHICLE_STORAGE_MENU_9x3 = ModContainers.register("vehicle_storage_menu_9x3", ModContainers.createVehicleStorageMenuFactory());
    public static final RegistrySupplier<MenuType<ChestMenu>> VEHICLE_STORAGE_MENU_9x4 = ModContainers.register("vehicle_storage_menu_9x4", ModContainers.createVehicleStorageMenuFactory());
    public static final RegistrySupplier<MenuType<ChestMenu>> VEHICLE_STORAGE_MENU_9x5 = ModContainers.register("vehicle_storage_menu_9x5", ModContainers.createVehicleStorageMenuFactory());
    public static final RegistrySupplier<MenuType<ChestMenu>> VEHICLE_STORAGE_MENU_9x6 = ModContainers.register("vehicle_storage_menu_9x6", ModContainers.createVehicleStorageMenuFactory());

    public static MenuType<ChestMenu> createVehicleStorageMenuFactory() {
        return MenuRegistry.ofExtended((windowId, playerInv, data) -> {
            int storageId = data.readInt();
            Entity patt0$temp = playerInv.f_35978_.m_20201_();
            if (patt0$temp instanceof EntityVehicle) {
                EntityVehicle vehicle = (EntityVehicle)patt0$temp;
                StorageInstance<?> storageInstance = vehicle.partsManager.getStorageData(storageId);
                if (storageInstance != null) {
                    return storageInstance.createMenu(windowId, playerInv);
                }
            }
            return StorageInstance.getEmptyStorageMenu(windowId, playerInv);
        });
    }

    private static <T extends AbstractContainerMenu> RegistrySupplier<MenuType<T>> register(String id, MenuType<T> type) {
        return CONTAINERS.register(id, () -> type);
    }

    public static void register() {
        CONTAINERS.register();
    }
}

