/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.item;

import com.onewhohears.dscombat.data.parts.client.PartAssets;
import com.onewhohears.dscombat.data.parts.client.PartClientStats;
import com.onewhohears.dscombat.data.parts.instance.TurretInstance;
import com.onewhohears.dscombat.data.parts.stats.PartStats;
import com.onewhohears.dscombat.data.weapon.WeaponPresets;
import com.onewhohears.dscombat.data.weapon.stats.WeaponStats;
import com.onewhohears.dscombat.init.ModCMTabs;
import com.onewhohears.dscombat.item.ItemPart;
import com.onewhohears.dscombat.item.forge.ItemTurretImpl;
import com.onewhohears.dscombat.util.UtilPresetParse;
import com.onewhohears.onewholibs.client.model.obj.ObjEntityModels;
import com.onewhohears.onewholibs.item.ObjModelItem;
import com.onewhohears.onewholibs.util.UtilMCText;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class ItemTurret
extends ItemPart
implements ObjModelItem {
    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ItemTurret create(int stackSize, String defaultPresetId) {
        void var1_1;
        return ItemTurretImpl.create(stackSize, (String)var1_1);
    }

    public static Item.Properties weaponPartProps(int stackSize) {
        return ItemTurret.partProps(stackSize).arch$tab(ModCMTabs.WEAPON_PARTS);
    }

    public ItemTurret(int stackSize, String defaultPresetId) {
        super(ItemTurret.weaponPartProps(stackSize), defaultPresetId);
    }

    @Override
    @NotNull
    public Component m_7626_(@NotNull ItemStack stack) {
        TurretInstance data = (TurretInstance)UtilPresetParse.parsePartFromItem(stack);
        if (data == null) {
            return super.m_7626_(stack);
        }
        MutableComponent name = ((MutableComponent)super.m_7626_(stack)).m_130946_(" ");
        String weapon = data.getWeaponId();
        if (weapon.isEmpty()) {
            name.m_130946_("EMPTY");
        } else {
            WeaponStats wd = WeaponPresets.get().get(weapon);
            if (wd != null) {
                name.m_7220_((Component)wd.getDisplayNameComponent()).m_130946_(" ").m_7220_((Component)UtilMCText.literal((String)wd.getWeaponTypeCode()));
            } else {
                name.m_130946_(weapon + "?");
            }
        }
        int ammo = (int)data.getCurrentAmmo();
        int max = (int)data.getMaxAmmo();
        if (max != 0) {
            name.m_130946_(" " + ammo + "/" + max);
        }
        return name;
    }

    @Override
    protected void fillItemCategory(PartStats stats, List<ItemStack> items) {
        List<String> list = WeaponPresets.get().getCompatibleWeapons(stats.getId());
        for (String s : list) {
            this.addTurret(stats, s, items);
        }
    }

    private void addTurret(PartStats stats, String preset, List<ItemStack> items) {
        ItemStack turret = new ItemStack((ItemLike)this);
        if (stats != null) {
            turret.m_41751_(stats.createFilledPartInstance(preset).writeNBT());
        }
        items.add(turret);
    }

    @Override
    public ResourceKey<CreativeModeTab> getCreativeTab() {
        return ModCMTabs.WEAPON_PARTS.getKey();
    }

    public TurretInstance<?> getTurretInstance(ItemStack stack) {
        return (TurretInstance)this.getPartInstance(stack);
    }

    @NotNull
    public String getObjModelId(@NotNull String preset) {
        PartClientStats pcs = PartAssets.get().get(preset);
        if (pcs == null) {
            return "";
        }
        return pcs.getModelId();
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull ObjEntityModels.ModelOverrides getItemModelOverrides(@NotNull String preset) {
        PartClientStats pcs = PartAssets.get().get(preset);
        if (pcs == null) {
            return ObjEntityModels.NO_OVERRIDES;
        }
        return pcs.getItemModelOverrides();
    }
}

