/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.util;

import com.onewhohears.dscombat.common.network.PacketHandler;
import com.onewhohears.dscombat.common.network.toclient.ToClientVehicleChainUpdate;
import com.onewhohears.dscombat.entity.parts.EntityChainHook;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class UtilServerPacket {
    public static void sendChainAddPlayer(EntityChainHook hook, Player player) {
        UtilServerPacket.sendChainUpdateToClient(null, hook, player, EntityChainHook.ChainUpdateType.CHAIN_ADD_PLAYER);
    }

    public static void sendChainAddVehicle(EntityVehicle vehicle, EntityChainHook hook, @Nullable Player player) {
        UtilServerPacket.sendChainUpdateToClient(vehicle, hook, player, EntityChainHook.ChainUpdateType.CHAIN_ADD_VEHICLE);
    }

    public static void sendChainDisconnectPlayer(EntityChainHook hook, Player player) {
        UtilServerPacket.sendChainUpdateToClient(null, hook, player, EntityChainHook.ChainUpdateType.CHAIN_DISCONNECT_PLAYER);
    }

    public static void sendChainDisconnectVehicle(EntityVehicle vehicle, EntityChainHook hook) {
        UtilServerPacket.sendChainUpdateToClient(vehicle, hook, null, EntityChainHook.ChainUpdateType.CHAIN_DISCONNECT_VEHICLE);
    }

    public static void sendVehicleAddPlayer(EntityVehicle vehicle, Player player) {
        UtilServerPacket.sendChainUpdateToClient(vehicle, null, player, EntityChainHook.ChainUpdateType.VEHICLE_ADD_PLAYER);
    }

    private static void sendChainUpdateToClient(EntityVehicle vehicle, EntityChainHook hook, Player player, EntityChainHook.ChainUpdateType type) {
        EntityVehicle entity;
        Object object = vehicle != null ? vehicle : (hook != null ? hook : (entity = player != null ? player : null));
        if (entity == null) {
            return;
        }
        PacketHandler.sendToTrackers(new ToClientVehicleChainUpdate(vehicle, hook, player, type), (Entity)entity);
    }

    public static void sendChainAddVehicleTo(EntityVehicle vehicle, EntityChainHook hook, ServerPlayer reciever) {
        if (vehicle == null || hook == null || reciever == null) {
            return;
        }
        PacketHandler.sendToTrackers(new ToClientVehicleChainUpdate(vehicle, hook, null, EntityChainHook.ChainUpdateType.CHAIN_ADD_VEHICLE), (Entity)reciever);
    }

    public static List<ServerPlayer> getPlayersWithinRadius(MinecraftServer server, ResourceKey<Level> dimension, Vec3 center, double radius) {
        ServerLevel level = server.m_129880_(dimension);
        if (level == null) {
            return List.of();
        }
        return UtilServerPacket.getPlayersWithinRadius(level, center, radius);
    }

    public static List<ServerPlayer> getPlayersWithinRadius(ServerLevel level, Vec3 center, double radius) {
        double radiusSq = radius * radius;
        return level.m_8795_(player -> player.m_20182_().m_82557_(center) <= radiusSq);
    }
}

