/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.util;

import com.onewhohears.dscombat.common.network.toclient.ToClientDelayedSound;
import com.onewhohears.dscombat.util.UtilServerPacket;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.phys.Vec3;

public class UtilSound {
    private static final Map<String, SoundEvent> cachedCustomSoundEvents = new HashMap<String, SoundEvent>();

    public static SoundEvent getSoundById(String id, SoundEvent alt, RegistryAccess ra) {
        ResourceLocation rl;
        if (id == null || id.isEmpty()) {
            return alt;
        }
        if (cachedCustomSoundEvents.containsKey(id)) {
            return cachedCustomSoundEvents.get(id);
        }
        Registry reg = ra.m_175515_(Registries.f_256840_);
        Optional sound = reg.m_6612_(rl = ResourceLocation.m_135820_((String)id));
        if (sound.isEmpty()) {
            SoundEvent event = SoundEvent.m_262824_((ResourceLocation)rl);
            cachedCustomSoundEvents.put(id, event);
            return event;
        }
        return (SoundEvent)sound.get();
    }

    public static SoundEvent getSoundByIdClient(String id, SoundEvent alt) {
        return UtilSound.getSoundById(id, alt, Minecraft.m_91087_().f_91073_.m_9598_());
    }

    public static void sendDelayedSound(ServerLevel level, SoundEvent sound, Vec3 pos, float radius, float volume, float pitch) {
        List<ServerPlayer> players = UtilServerPacket.getPlayersWithinRadius(level, pos, radius);
        new ToClientDelayedSound(sound, pos, radius, volume, pitch).sendTo(players);
    }
}

