/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.client.model.obj;

import com.mojang.blaze3d.vertex.PoseStack;
import com.onewhohears.onewholibs.client.model.obj.ObjBakedModel;
import com.onewhohears.onewholibs.client.model.obj.ObjModelHandler;
import com.onewhohears.onewholibs.client.model.obj.ObjUnbakedModel;
import com.onewhohears.onewholibs.shadow.de.javagl.obj.FloatTuple;
import com.onewhohears.onewholibs.util.math.Mat4f;
import com.onewhohears.onewholibs.util.math.UtilGeometry;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjModelHandlerImpl
implements ObjModelHandler {
    @NotNull
    private final String modelId;
    @NotNull
    private final ObjBakedModel bakedModel;
    @NotNull
    private final ObjUnbakedModel unbakedModel;
    @Nullable
    private Vec3 size = null;
    @Nullable
    private Vec3 center = null;

    public ObjModelHandlerImpl(@NotNull String modelId, @NotNull ObjBakedModel bakedModel, @NotNull ObjUnbakedModel unbakedModel) {
        this.modelId = modelId;
        this.bakedModel = bakedModel;
        this.unbakedModel = unbakedModel;
    }

    @Override
    public void render(PoseStack poseStack, MultiBufferSource bufferSource, float partialTicks, int lightmap, int overlay, Map<String, Mat4f> transforms, Function<ResourceLocation, RenderType> renderType) {
        this.bakedModel.render(poseStack, bufferSource, renderType, lightmap, overlay, partialTicks, transforms);
    }

    @Override
    @NotNull
    public String getModelId() {
        return this.modelId;
    }

    @Override
    @NotNull
    public Vec3 getSize() {
        if (this.size == null) {
            this.calcSizeCenter();
        }
        return this.size;
    }

    @Override
    @NotNull
    public Vec3 getCenter() {
        if (this.center == null) {
            this.calcSizeCenter();
        }
        return this.center;
    }

    private void calcSizeCenter() {
        int numV = this.unbakedModel.getObj().getNumVertices();
        Vec3[] vertices = new Vec3[numV];
        for (int i = 0; i < vertices.length; ++i) {
            FloatTuple ft = this.unbakedModel.getObj().getVertex(i);
            vertices[i] = new Vec3((double)ft.getX(), (double)ft.getY(), (double)ft.getZ());
        }
        Vec3[] sizeCenter = UtilGeometry.getSizeCenter(vertices);
        this.size = sizeCenter[0];
        this.center = sizeCenter[1];
    }

    @NotNull
    public ObjBakedModel getBakedModel() {
        return this.bakedModel;
    }

    @NotNull
    public ObjUnbakedModel getUnbakedModel() {
        return this.unbakedModel;
    }
}

