/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.client.renderer;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.onewhohears.onewholibs.client.model.obj.ObjEntityModels;
import com.onewhohears.onewholibs.client.model.obj.ObjModelHandler;
import com.onewhohears.onewholibs.item.ObjModelItem;
import com.onewhohears.onewholibs.util.math.Mat4f;
import com.onewhohears.onewholibs.util.math.Vec3f;
import dev.architectury.registry.ReloadListenerRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class RendererObjModelItems
extends BlockEntityWithoutLevelRenderer {
    private static RendererObjModelItems instance;
    private final Map<String, ItemObjModelData> models = new HashMap<String, ItemObjModelData>();
    public static final Map<String, Mat4f> EMPTY_TRANSFORMS;

    public static RendererObjModelItems get() {
        return instance;
    }

    public static void register() {
        instance = RendererObjModelItems.createNew();
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)instance);
    }

    public static RendererObjModelItems createNew() {
        Minecraft m = Minecraft.m_91087_();
        return new RendererObjModelItems(m.m_167982_(), m.m_167973_());
    }

    protected RendererObjModelItems(BlockEntityRenderDispatcher blockEntityRenderDispatcher, EntityModelSet entityModelSet) {
        super(blockEntityRenderDispatcher, entityModelSet);
    }

    public void m_6213_(ResourceManager resourceManager) {
        this.models.clear();
    }

    public void m_108829_(ItemStack stack, ItemDisplayContext transformType, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Item item = stack.m_41720_();
        if (item instanceof ObjModelItem) {
            ObjModelItem objItem = (ObjModelItem)item;
            String preset = objItem.getPreset(stack);
            ItemObjModelData model = this.models.get(preset);
            if (model == null) {
                String modelId = objItem.getObjModelId(preset);
                ObjModelHandler handler = ObjEntityModels.get().getObjModelHandler(modelId);
                ObjEntityModels.ModelOverrides override = ObjEntityModels.get().getModelOverride(modelId);
                ObjEntityModels.ModelOverrides itemModelOverrides = objItem.getItemModelOverrides(preset);
                model = new ItemObjModelData(handler, override, itemModelOverrides);
                this.models.put(preset, model);
            }
            model.render(transformType, poseStack, buffer, packedLight, packedOverlay);
        }
    }

    static {
        EMPTY_TRANSFORMS = ImmutableMap.of();
    }

    public static class ItemObjModelData {
        public static final float SIZE_SCALE_FACTOR = 1.25f;
        public final ObjModelHandler handler;
        public final ObjEntityModels.ModelOverrides modelOverrides;
        public final ObjEntityModels.ModelOverrides itemModelOverrides;
        public final Vec3 center;
        public final float scale;

        public ItemObjModelData(ObjModelHandler handler, ObjEntityModels.ModelOverrides modelOverrides, ObjEntityModels.ModelOverrides itemModelOverrides) {
            this.handler = handler;
            this.modelOverrides = modelOverrides;
            this.itemModelOverrides = itemModelOverrides;
            Vec3 size = handler.getSize();
            float maxSize = (float)Math.max(size.m_7094_(), Math.max(size.m_7096_(), size.m_7098_()));
            this.center = handler.getCenter();
            this.scale = 1.25f / maxSize;
        }

        public void render(ItemDisplayContext transformType, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
            poseStack.m_85836_();
            this.modelOverrides.applyRotation(poseStack);
            this.itemModelOverrides.apply(poseStack);
            if (transformType == ItemDisplayContext.GUI) {
                poseStack.m_85837_(0.5, 0.5, 0.5);
                poseStack.m_252781_(Vec3f.XP.rotationDegrees(30.0f).convert());
                poseStack.m_252781_(Vec3f.YP.rotationDegrees(45.0f).convert());
            } else if (transformType == ItemDisplayContext.FIXED) {
                poseStack.m_85837_(0.5, 0.5, 0.35);
                poseStack.m_252781_(Vec3f.XP.rotationDegrees(-90.0f).convert());
            } else if (transformType == ItemDisplayContext.GROUND) {
                poseStack.m_85837_(0.5, 0.5, 0.5);
            } else if (transformType == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
                poseStack.m_85837_(0.5, 0.5, 0.3);
                poseStack.m_252781_(Vec3f.XP.rotationDegrees(30.0f).convert());
                poseStack.m_252781_(Vec3f.YP.rotationDegrees(225.0f).convert());
            } else if (transformType == ItemDisplayContext.FIRST_PERSON_LEFT_HAND) {
                poseStack.m_85837_(0.5, 0.5, 0.3);
                poseStack.m_252781_(Vec3f.XP.rotationDegrees(30.0f).convert());
                poseStack.m_252781_(Vec3f.YP.rotationDegrees(135.0f).convert());
            } else if (transformType == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND) {
                poseStack.m_85837_(0.5, 0.5, 0.5);
                poseStack.m_252781_(Vec3f.XP.rotationDegrees(90.0f).convert());
                poseStack.m_252781_(Vec3f.YP.rotationDegrees(225.0f).convert());
            } else if (transformType == ItemDisplayContext.THIRD_PERSON_LEFT_HAND) {
                poseStack.m_85837_(0.5, 0.5, 0.5);
                poseStack.m_252781_(Vec3f.XP.rotationDegrees(90.0f).convert());
                poseStack.m_252781_(Vec3f.YP.rotationDegrees(135.0f).convert());
            } else if (transformType == ItemDisplayContext.HEAD) {
                poseStack.m_85837_(0.5, 1.2, 0.5);
                poseStack.m_85841_(2.0f, 2.0f, 2.0f);
                poseStack.m_252781_(Vec3f.YP.rotationDegrees(180.0f).convert());
            } else if (transformType == ItemDisplayContext.NONE) {
                poseStack.m_85837_(0.5, 0.5, 0.5);
            }
            poseStack.m_85841_(this.scale, this.scale, this.scale);
            poseStack.m_252880_((float)(-this.center.m_7096_()), (float)(-this.center.m_7098_()), (float)(-this.center.m_7094_()));
            this.handler.render(poseStack, buffer, 0.0f, packedLight, packedOverlay, EMPTY_TRANSFORMS, RenderType::m_110446_);
            poseStack.m_85849_();
        }
    }
}

