/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.entity;

import com.onewhohears.onewholibs.common.network.toclient.ClientBoundSpawnDataPacket;
import com.onewhohears.onewholibs.data.jsonpreset.CustomAnimStats;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetStats;
import com.onewhohears.onewholibs.data.jsonpreset.PresetStatsHolder;
import com.onewhohears.onewholibs.entity.CustomAnimEntityHolder;
import com.onewhohears.onewholibs.util.UtilEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CustomAnimProjectile<P extends JsonPresetStats, C extends CustomAnimStats>
extends Projectile
implements CustomAnimEntityHolder<P, C> {
    @NotNull
    final String defaultPreset;
    private String preset;
    private PresetStatsHolder<P> statsHolder;
    @Nullable
    private PresetStatsHolder<C> clientStatsHolder = null;
    private boolean isStatsHolderLoaded = false;

    public CustomAnimProjectile(EntityType<? extends Projectile> type, Level level, @NotNull String defaultPreset) {
        super(type, level);
        this.defaultPreset = defaultPreset;
        this.setPreset(defaultPreset);
        this.isStatsHolderLoaded = true;
    }

    @Override
    public boolean isClientSide() {
        return UtilEntity.getLevel((Entity)this).m_5776_();
    }

    @Override
    @Nullable
    public PresetStatsHolder<C> getClientStatsHolder() {
        return this.clientStatsHolder;
    }

    @Override
    public void setClientStatsHolder(PresetStatsHolder<C> holder) {
        this.clientStatsHolder = holder;
    }

    @Override
    @NotNull
    public String getDefaultStatsId() {
        return this.defaultPreset;
    }

    @Override
    @NotNull
    public String getStatsId() {
        return this.preset;
    }

    @Override
    @NotNull
    public PresetStatsHolder<P> getStatsHolder() {
        return this.statsHolder;
    }

    @Override
    public void setStatsId(@NotNull String id) {
        this.preset = id;
    }

    @Override
    public void setStatsHolder(@NotNull PresetStatsHolder<P> holder) {
        this.statsHolder = holder;
    }

    @Override
    public void m_7378_(@NotNull CompoundTag nbt) {
        super.m_7378_(nbt);
        CustomAnimEntityHolder.super.m_7378_(nbt);
    }

    @Override
    public void m_7380_(@NotNull CompoundTag nbt) {
        super.m_7380_(nbt);
        CustomAnimEntityHolder.super.m_7380_(nbt);
    }

    @Override
    public boolean isStatsHolderLoaded() {
        return this.isStatsHolderLoaded;
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientBoundSpawnDataPacket((Entity)this, this);
    }
}

