/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.util;

import com.onewhohears.onewholibs.OWLDependencySafety;
import com.onewhohears.onewholibs.util.UtilParse;
import com.onewhohears.onewholibs.util.forge.UtilEntityImpl;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import com.onewhohears.onewholibs.util.math.UtilGeometry;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UtilEntity {
    public static final Random random = new Random();

    public static boolean canPosSeePos(Level level, Vec3 start_pos, Vec3 end_pos, int maxBlockCheckDepth, double throWater, double throBlock) {
        Vec3 diff = end_pos.m_82546_(start_pos);
        Vec3 look = diff.m_82541_();
        double distance = diff.m_82553_();
        double[] through = new double[]{throWater, throBlock};
        if (distance <= (double)maxBlockCheckDepth) {
            if (!UtilEntity.checkBlocksByRange(level, start_pos, look, (int)distance, through, false)) {
                return false;
            }
        } else {
            int maxCheckDist = maxBlockCheckDepth / 2;
            if (!UtilEntity.checkBlocksByRange(level, start_pos, look, maxCheckDist, through, false)) {
                return false;
            }
            if (!UtilEntity.checkBlocksByRange(level, start_pos.m_82549_(look.m_82490_(distance - (double)maxCheckDist).m_82546_(look)), look, maxCheckDist, through, false)) {
                return false;
            }
        }
        return true;
    }

    public static boolean canPosSeeEntity(Vec3 start_pos, Entity entity, int maxBlockCheckDepth, double throWater, double throBlock) {
        return UtilEntity.canPosSeePos(UtilEntity.getLevel(entity), start_pos, entity.m_146892_(), maxBlockCheckDepth, throWater, throBlock);
    }

    public static boolean canEntitySeeEntity(Entity entity1, Entity entity2, int maxBlockCheckDepth) {
        return UtilEntity.canEntitySeeEntity(entity1, entity2, maxBlockCheckDepth, 0.0, 0.0);
    }

    public static boolean canEntitySeeEntity(Entity entity1, Entity entity2, int maxBlockCheckDepth, double throWater, double throBlock) {
        return UtilEntity.canPosSeeEntity(entity1.m_146892_(), entity2, maxBlockCheckDepth, throWater, throBlock);
    }

    private static boolean checkBlocksByRange(Level level, Vec3 pos, Vec3 look, int dist, double[] through, boolean endIfNoChunk) {
        int k = 0;
        while (k++ < dist) {
            pos = pos.m_82549_(look);
            BlockPos bp = UtilGeometry.toBlockPos(pos);
            ChunkPos cp = new ChunkPos(bp);
            if (!level.m_7232_(cp.f_45578_, cp.f_45579_)) {
                if (!endIfNoChunk) continue;
                return true;
            }
            BlockState block = level.m_8055_(bp);
            if (block == null || block.m_60795_() || !UtilEntity.blocksMotion(block) && !UtilEntity.isLiquid(block)) continue;
            if (through[0] <= 0.0 && through[1] <= 0.0) {
                return false;
            }
            if (block.m_60819_().m_76152_().m_6212_((Fluid)Fluids.f_76193_)) {
                if (through[0] > 0.0) {
                    through[0] = through[0] - 1.0;
                    continue;
                }
                return false;
            }
            if (through[1] > 0.0) {
                through[1] = through[1] - 1.0;
                continue;
            }
            return false;
        }
        return true;
    }

    public static boolean isLocalVisionBlocked(Level level, Vec3 start, Vec3 end, double throWater, double throBlock, int maxDepth) {
        Vec3 diff = end.m_82546_(start);
        Vec3 look = diff.m_82541_();
        double[] through = new double[]{throWater, throBlock};
        return UtilEntity.checkBlocksByRange(level, start, look, maxDepth, through, true);
    }

    public static boolean blocksMotion(BlockState state) {
        return state.m_280555_();
    }

    public static boolean isLiquid(BlockState state) {
        return state.m_278721_();
    }

    @Nullable
    public static Vec3 raycastBlock(Level level, Vec3 start, Vec3 end) {
        block2: {
            Vec3 diff = end.m_82546_(start);
            Vec3 dir = diff.m_82541_();
            double dist = diff.m_82553_();
            Vec3 pos = start;
            if (UtilEntity.posBlocksMotion(level, pos)) {
                return pos;
            }
            int k = 1;
            do {
                int n = k++;
                if (!((double)n < dist)) break block2;
            } while (!UtilEntity.posBlocksMotion(level, pos = pos.m_82549_(dir)));
            return pos;
        }
        return null;
    }

    public static boolean posBlocksMotion(Level level, Vec3 pos) {
        BlockPos bp = UtilGeometry.toBlockPos(pos);
        ChunkPos cp = new ChunkPos(bp);
        if (!level.m_7232_(cp.f_45578_, cp.f_45579_)) {
            return false;
        }
        BlockState block = level.m_8055_(bp);
        if (block == null || block.m_60795_()) {
            return false;
        }
        return UtilEntity.blocksMotion(block);
    }

    public static int getDistFromGround(Entity entity) {
        BlockState block;
        Level l = UtilEntity.getLevel(entity);
        int[] pos = new int[]{entity.m_146903_(), entity.m_146904_(), entity.m_146907_()};
        int dist = 0;
        while (pos[1] >= -64 && ((block = l.m_8055_(new BlockPos(pos[0], pos[1], pos[2]))) == null || block.m_60795_())) {
            pos[1] = pos[1] - 1;
            ++dist;
        }
        return dist;
    }

    public static int getDistFromSeaLevel(Entity e) {
        return UtilEntity.getDistFromSeaLevel(e.m_20182_().f_82480_, UtilEntity.getLevel(e));
    }

    public static int getDistFromSeaLevel(double yPos, Level level) {
        int sea = UtilEntity.getSeaLevel(level);
        return (int)yPos - sea;
    }

    public static int getSeaLevel(Level level) {
        if (level.m_6042_().f_63858_()) {
            return 64;
        }
        return 0;
    }

    public static Vec3 getLookingAtBlockPos(Entity entity, int max) {
        Level level = UtilEntity.getLevel(entity);
        Vec3 look = entity.m_20154_();
        Vec3 pos = entity.m_146892_();
        for (int i = 0; i < max; ++i) {
            BlockState block = level.m_8055_(UtilGeometry.toBlockPos(pos));
            if (block != null && !block.m_60795_()) {
                return pos;
            }
            pos = pos.m_82549_(look);
        }
        return pos.m_82549_(look);
    }

    public static boolean isHeadAboveWater(Entity entity) {
        return entity.m_20069_() && !entity.m_5842_();
    }

    public static boolean entityLookAtPos(Entity entity, Vec3 pos, float headTurnRate) {
        Vec3 diff = pos.m_82546_(entity.m_146892_());
        float yRot = UtilAngles.getYaw(diff);
        float xRot = UtilAngles.getPitch(diff);
        float newYRot = UtilAngles.rotLerp(entity.m_146908_(), yRot, headTurnRate);
        float newXRot = UtilAngles.rotLerp(entity.m_146909_(), xRot, headTurnRate);
        entity.m_146922_(newYRot);
        entity.m_146926_(newXRot);
        return xRot == newXRot && yRot == newYRot;
    }

    public static void mobLookAtPos(Mob mob, Vec3 pos, float headTurnRate) {
        mob.m_21563_().m_24950_(pos.f_82479_, pos.f_82480_, pos.f_82481_, headTurnRate, 360.0f);
    }

    public static String getEntityTypeId(Entity entity) {
        return EntityType.m_20613_((EntityType)entity.m_6095_()).toString();
    }

    public static String getEntityIdName(Entity entity) {
        return EntityType.m_20613_((EntityType)entity.m_6095_()).m_135815_();
    }

    public static String getEntityModId(Entity entity) {
        return EntityType.m_20613_((EntityType)entity.m_6095_()).m_135827_();
    }

    public static int getRandomColor() {
        float hue = random.nextFloat();
        float saturation = (float)(random.nextInt(4000) + 6000) / 10000.0f;
        float luminance = (float)(random.nextInt(2000) + 8000) / 10000.0f;
        Color color = Color.getHSBColor(hue, saturation, luminance);
        return color.getRGB();
    }

    @Nullable
    public static EntityHitResult getEntityHitResultAtClip(Level level, Entity projectile, Vec3 start, Vec3 end, AABB aabb, Predicate<Entity> filter, float inflateAmount) {
        double d0 = Double.MAX_VALUE;
        Entity entity = null;
        Vec3 pos = null;
        for (Entity entity1 : level.m_6249_(projectile, aabb, filter)) {
            double d1;
            AABB aabb1 = entity1.m_20191_().m_82400_((double)inflateAmount);
            Optional optional = aabb1.m_82371_(start, end);
            if (!optional.isPresent() || !((d1 = start.m_82557_((Vec3)optional.get())) < d0)) continue;
            entity = entity1;
            d0 = d1;
            pos = (Vec3)optional.get();
        }
        return entity == null ? null : new EntityHitResult(entity, pos);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static EntityType<?> getEntityType(String entityTypeKey, EntityType<?> alt) {
        void var1_1;
        return UtilEntityImpl.getEntityType(entityTypeKey, var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean doesEntityTypeExist(String entityTypeKey) {
        return UtilEntityImpl.doesEntityTypeExist(entityTypeKey);
    }

    @Nullable
    public static Class<? extends Entity> getEntityClass(String className) {
        try {
            return Class.forName(className, false, UtilParse.class.getClassLoader()).asSubclass(Entity.class);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static boolean isPlayer(Entity entity) {
        if (entity == null) {
            return false;
        }
        return entity.m_6095_().m_20675_().equals(EntityType.f_20532_.m_20675_());
    }

    public static void dropItemStack(Level level, ItemStack stack, Vec3 pos) {
        Containers.m_18992_((Level)level, (double)pos.f_82479_, (double)pos.f_82480_, (double)pos.f_82481_, (ItemStack)stack);
    }

    public static void dropItemStack(Entity entity, ItemStack stack) {
        UtilEntity.dropItemStack(UtilEntity.getLevel(entity), stack, entity.m_20182_());
    }

    public static boolean arePlayersAllied(@NotNull ServerPlayer player1, @NotNull ServerPlayer player2) {
        if (OWLDependencySafety.arePlayersAlliedModdedTeamSystem(player1, player2)) {
            return true;
        }
        return player1.m_7307_((Entity)player2);
    }

    public static boolean areEntitiesAllied(@NotNull Entity entity1, @NotNull Entity entity2) {
        if (entity1 instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity1;
            return UtilEntity.areEntitiesAllied(player, entity2);
        }
        LivingEntity controller = entity1.m_6688_();
        if (controller instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)controller;
            return UtilEntity.areEntitiesAllied(player, entity2);
        }
        return entity1.m_7307_(entity2);
    }

    public static boolean areEntitiesAllied(@NotNull ServerPlayer player, @NotNull Entity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)entity;
            return UtilEntity.arePlayersAllied(player, player2);
        }
        return player.m_7307_(entity);
    }

    public static List<ServerPlayer> getPlayersTrackingEntity(Entity entity) {
        if (UtilEntity.getLevel(entity).m_5776_()) {
            return new ArrayList<ServerPlayer>();
        }
        return ((ServerLevel)UtilEntity.getLevel((Entity)entity)).m_7726_().f_8325_.m_183262_(entity.m_146902_(), false);
    }

    public static Level getLevel(Entity entity) {
        return entity.m_9236_();
    }
}

