/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.client.model.obj;

import com.onewhohears.onewholibs.client.model.obj.ObjEntityModels;
import com.onewhohears.onewholibs.client.model.obj.ObjModelHandler;
import com.onewhohears.onewholibs.util.math.Mat4f;
import com.onewhohears.onewholibs.util.math.QuaternionF;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import com.onewhohears.onewholibs.util.math.UtilGeometry;
import com.onewhohears.onewholibs.util.math.Vec3f;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;

public class ObjEntityModel<T extends class_1297> {
    public static final Mat4f INVISIBLE = Mat4f.createScaleMatrix(0.0f, 0.0f, 0.0f);
    public final String modelId;
    private final Map<String, Mat4f> transforms = new HashMap<String, Mat4f>();
    private ObjEntityModels.ModelOverrides modelOverride;
    private ObjModelHandler modelHandler;

    public ObjEntityModel(String modelId) {
        this.modelId = modelId;
    }

    public void render(T entity, class_4587 poseStack, class_4597 bufferSource, int lightmap, float partialTicks) {
        this.rotate(entity, partialTicks, poseStack);
        this.handleGlobalOverrides(entity, partialTicks, poseStack);
        this.transforms.clear();
        this.addComponentTransforms(this.transforms, entity, partialTicks);
        this.getObjModelHandler().render(poseStack, bufferSource, partialTicks, this.getLight(entity, lightmap), this.getOverlay(entity), this.transforms, this.getTextureRenderTypeLookup(entity));
    }

    protected ObjModelHandler getObjModelHandler() {
        if (this.modelHandler == null) {
            this.modelHandler = ObjEntityModels.get().getObjModelHandler(this.modelId);
        }
        return this.modelHandler;
    }

    protected void rotate(T entity, float partialTicks, class_4587 poseStack) {
        Vec3f pivot = this.getGlobalPivot();
        QuaternionF yRot = Vec3f.YN.rotationDegrees(entity.method_5705(partialTicks));
        QuaternionF xRot = Vec3f.XP.rotationDegrees(entity.method_5695(partialTicks));
        if (!UtilGeometry.isZero(pivot)) {
            if (this.globalRotateY()) {
                poseStack.method_34425(UtilAngles.pivotInvRot(pivot, yRot).convert());
            }
            if (this.globalRotateX()) {
                poseStack.method_34425(UtilAngles.pivotInvRot(pivot, xRot).convert());
            }
        } else {
            if (this.globalRotateY()) {
                poseStack.method_22907(yRot.convert());
            }
            if (this.globalRotateX()) {
                poseStack.method_22907(xRot.convert());
            }
        }
    }

    protected void handleGlobalOverrides(T entity, float partialTicks, class_4587 poseStack) {
        Vec3f pivot = this.getGlobalPivot();
        if (!UtilGeometry.isZero(pivot)) {
            poseStack.method_46416(pivot.x(), pivot.y(), pivot.z());
        }
        this.getModelOverride().applyNoTranslate(poseStack);
    }

    public ObjEntityModels.ModelOverrides getModelOverride() {
        if (this.modelOverride == null) {
            this.modelOverride = ObjEntityModels.get().getModelOverride(this.modelId);
        }
        return this.modelOverride;
    }

    protected void addComponentTransforms(Map<String, Mat4f> transforms, T entity, float partialTicks) {
    }

    protected Function<class_2960, class_1921> getTextureRenderTypeLookup(T entity) {
        return class_1921::method_23580;
    }

    protected int getLight(T entity, int lightmap) {
        return lightmap;
    }

    protected int getOverlay(T entity) {
        return class_4608.field_21444;
    }

    public Vec3f getGlobalPivot() {
        return this.getModelOverride().translate;
    }

    public boolean globalRotateX() {
        return true;
    }

    public boolean globalRotateY() {
        return true;
    }
}

