/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.data.jsonpreset;

import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetInstance;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetType;
import com.onewhohears.onewholibs.util.UtilGsonMerge;
import com.onewhohears.onewholibs.util.UtilMCText;
import com.onewhohears.onewholibs.util.UtilParse;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public abstract class JsonPresetStats {
    protected static final Logger LOGGER = LogUtils.getLogger();
    private final class_2960 key;
    private final JsonObject data;
    private final String id;
    private final String displayName;
    private final int sort_factor;
    private final String copyId;
    private final int priority;
    private boolean hasBeenMerged = false;

    public JsonPresetStats(class_2960 key, JsonObject json) {
        this.key = key;
        this.data = json;
        this.id = UtilParse.getStringSafe(json, "presetId", UtilParse.getCleanFileName(key));
        this.displayName = UtilParse.getStringSafe(json, "displayName", "preset." + key.method_12836() + "." + this.id);
        this.sort_factor = UtilParse.getIntSafe(json, "sort_factor", 0);
        this.copyId = UtilParse.getStringSafe(json, "copyId", "");
        this.priority = UtilParse.getIntSafe(json, "priority", 0);
    }

    public abstract JsonPresetType getType();

    public class_2960 getKey() {
        return this.key;
    }

    protected JsonObject getJsonData() {
        return this.data;
    }

    public JsonObject copyJsonData() {
        return this.data.deepCopy();
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getNameSpace() {
        return this.getKey().method_12836();
    }

    public class_5250 getDisplayNameComponent() {
        String dn = this.getDisplayName();
        if (dn.startsWith("preset.") || dn.startsWith("item.")) {
            return UtilMCText.translatable(dn);
        }
        return UtilMCText.literal(dn);
    }

    public int getSortFactor() {
        return this.sort_factor;
    }

    public boolean isCopy() {
        return !this.copyId.isEmpty();
    }

    public String getCopyId() {
        return this.copyId;
    }

    public boolean hasBeenMerged() {
        return this.hasBeenMerged;
    }

    public boolean mergeWithParent(JsonPresetStats parent) {
        try {
            UtilGsonMerge.extendJsonObject(this.data, UtilGsonMerge.ConflictStrategy.PREFER_FIRST_OBJ, parent.data.deepCopy());
            this.hasBeenMerged = true;
            return true;
        }
        catch (UtilGsonMerge.JsonObjectExtensionConflictException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean equals(Object o) {
        if (o instanceof JsonPresetStats) {
            JsonPresetStats j = (JsonPresetStats)o;
            return j.getId().equals(this.getId());
        }
        return false;
    }

    public String toString() {
        return this.getKey().toString() + " " + this.getJsonData().toString();
    }

    public <T extends JsonPresetStats> int compare(T other) {
        if (!this.getType().is(other.getType())) {
            return this.getType().getSortFactor() - other.getType().getSortFactor();
        }
        if (this.getSortFactor() != other.getSortFactor()) {
            return this.getSortFactor() - other.getSortFactor();
        }
        return this.getId().compareToIgnoreCase(other.getId());
    }

    @Nullable
    public JsonPresetInstance<?> createPresetInstance(@Nullable class_2487 nbt) {
        JsonPresetInstance<?> instance = this.createPresetInstance();
        if (instance == null) {
            return null;
        }
        if (nbt != null) {
            instance.readNBT(nbt);
        }
        return instance;
    }

    @Nullable
    public abstract JsonPresetInstance<?> createPresetInstance();

    @Nullable
    public <T extends JsonPresetStats> T as(JsonPresetType type) {
        if (this.getType().is(type)) {
            return (T)this;
        }
        return null;
    }

    public int getPriority() {
        return this.priority;
    }
}

