/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.util;

import com.onewhohears.onewholibs.OWLDependencySafety;
import com.onewhohears.onewholibs.util.UtilParse;
import com.onewhohears.onewholibs.util.fabric.UtilEntityImpl;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import com.onewhohears.onewholibs.util.math.UtilGeometry;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.class_1264;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3966;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UtilEntity {
    public static final Random random = new Random();

    public static boolean canPosSeePos(class_1937 level, class_243 start_pos, class_243 end_pos, int maxBlockCheckDepth, double throWater, double throBlock) {
        class_243 diff = end_pos.method_1020(start_pos);
        class_243 look = diff.method_1029();
        double distance = diff.method_1033();
        double[] through = new double[]{throWater, throBlock};
        if (distance <= (double)maxBlockCheckDepth) {
            if (!UtilEntity.checkBlocksByRange(level, start_pos, look, (int)distance, through, false)) {
                return false;
            }
        } else {
            int maxCheckDist = maxBlockCheckDepth / 2;
            if (!UtilEntity.checkBlocksByRange(level, start_pos, look, maxCheckDist, through, false)) {
                return false;
            }
            if (!UtilEntity.checkBlocksByRange(level, start_pos.method_1019(look.method_1021(distance - (double)maxCheckDist).method_1020(look)), look, maxCheckDist, through, false)) {
                return false;
            }
        }
        return true;
    }

    public static boolean canPosSeeEntity(class_243 start_pos, class_1297 entity, int maxBlockCheckDepth, double throWater, double throBlock) {
        return UtilEntity.canPosSeePos(UtilEntity.getLevel(entity), start_pos, entity.method_33571(), maxBlockCheckDepth, throWater, throBlock);
    }

    public static boolean canEntitySeeEntity(class_1297 entity1, class_1297 entity2, int maxBlockCheckDepth) {
        return UtilEntity.canEntitySeeEntity(entity1, entity2, maxBlockCheckDepth, 0.0, 0.0);
    }

    public static boolean canEntitySeeEntity(class_1297 entity1, class_1297 entity2, int maxBlockCheckDepth, double throWater, double throBlock) {
        return UtilEntity.canPosSeeEntity(entity1.method_33571(), entity2, maxBlockCheckDepth, throWater, throBlock);
    }

    private static boolean checkBlocksByRange(class_1937 level, class_243 pos, class_243 look, int dist, double[] through, boolean endIfNoChunk) {
        int k = 0;
        while (k++ < dist) {
            pos = pos.method_1019(look);
            class_2338 bp = UtilGeometry.toBlockPos(pos);
            class_1923 cp = new class_1923(bp);
            if (!level.method_8393(cp.field_9181, cp.field_9180)) {
                if (!endIfNoChunk) continue;
                return true;
            }
            class_2680 block = level.method_8320(bp);
            if (block == null || block.method_26215() || !UtilEntity.blocksMotion(block) && !UtilEntity.isLiquid(block)) continue;
            if (through[0] <= 0.0 && through[1] <= 0.0) {
                return false;
            }
            if (block.method_26227().method_15772().method_15780((class_3611)class_3612.field_15910)) {
                if (through[0] > 0.0) {
                    through[0] = through[0] - 1.0;
                    continue;
                }
                return false;
            }
            if (through[1] > 0.0) {
                through[1] = through[1] - 1.0;
                continue;
            }
            return false;
        }
        return true;
    }

    public static boolean isLocalVisionBlocked(class_1937 level, class_243 start, class_243 end, double throWater, double throBlock, int maxDepth) {
        class_243 diff = end.method_1020(start);
        class_243 look = diff.method_1029();
        double[] through = new double[]{throWater, throBlock};
        return UtilEntity.checkBlocksByRange(level, start, look, maxDepth, through, true);
    }

    public static boolean blocksMotion(class_2680 state) {
        return state.method_51366();
    }

    public static boolean isLiquid(class_2680 state) {
        return state.method_51176();
    }

    @Nullable
    public static class_243 raycastBlock(class_1937 level, class_243 start, class_243 end) {
        block2: {
            class_243 diff = end.method_1020(start);
            class_243 dir = diff.method_1029();
            double dist = diff.method_1033();
            class_243 pos = start;
            if (UtilEntity.posBlocksMotion(level, pos)) {
                return pos;
            }
            int k = 1;
            do {
                int n = k++;
                if (!((double)n < dist)) break block2;
            } while (!UtilEntity.posBlocksMotion(level, pos = pos.method_1019(dir)));
            return pos;
        }
        return null;
    }

    public static boolean posBlocksMotion(class_1937 level, class_243 pos) {
        class_2338 bp = UtilGeometry.toBlockPos(pos);
        class_1923 cp = new class_1923(bp);
        if (!level.method_8393(cp.field_9181, cp.field_9180)) {
            return false;
        }
        class_2680 block = level.method_8320(bp);
        if (block == null || block.method_26215()) {
            return false;
        }
        return UtilEntity.blocksMotion(block);
    }

    public static int getDistFromGround(class_1297 entity) {
        class_2680 block;
        class_1937 l = UtilEntity.getLevel(entity);
        int[] pos = new int[]{entity.method_31477(), entity.method_31478(), entity.method_31479()};
        int dist = 0;
        while (pos[1] >= -64 && ((block = l.method_8320(new class_2338(pos[0], pos[1], pos[2]))) == null || block.method_26215())) {
            pos[1] = pos[1] - 1;
            ++dist;
        }
        return dist;
    }

    public static int getDistFromSeaLevel(class_1297 e) {
        return UtilEntity.getDistFromSeaLevel(e.method_19538().field_1351, UtilEntity.getLevel(e));
    }

    public static int getDistFromSeaLevel(double yPos, class_1937 level) {
        int sea = UtilEntity.getSeaLevel(level);
        return (int)yPos - sea;
    }

    public static int getSeaLevel(class_1937 level) {
        if (level.method_8597().comp_645()) {
            return 64;
        }
        return 0;
    }

    public static class_243 getLookingAtBlockPos(class_1297 entity, int max) {
        class_1937 level = UtilEntity.getLevel(entity);
        class_243 look = entity.method_5720();
        class_243 pos = entity.method_33571();
        for (int i = 0; i < max; ++i) {
            class_2680 block = level.method_8320(UtilGeometry.toBlockPos(pos));
            if (block != null && !block.method_26215()) {
                return pos;
            }
            pos = pos.method_1019(look);
        }
        return pos.method_1019(look);
    }

    public static boolean isHeadAboveWater(class_1297 entity) {
        return entity.method_5799() && !entity.method_5869();
    }

    public static boolean entityLookAtPos(class_1297 entity, class_243 pos, float headTurnRate) {
        class_243 diff = pos.method_1020(entity.method_33571());
        float yRot = UtilAngles.getYaw(diff);
        float xRot = UtilAngles.getPitch(diff);
        float newYRot = UtilAngles.rotLerp(entity.method_36454(), yRot, headTurnRate);
        float newXRot = UtilAngles.rotLerp(entity.method_36455(), xRot, headTurnRate);
        entity.method_36456(newYRot);
        entity.method_36457(newXRot);
        return xRot == newXRot && yRot == newYRot;
    }

    public static void mobLookAtPos(class_1308 mob, class_243 pos, float headTurnRate) {
        mob.method_5988().method_6230(pos.field_1352, pos.field_1351, pos.field_1350, headTurnRate, 360.0f);
    }

    public static String getEntityTypeId(class_1297 entity) {
        return class_1299.method_5890((class_1299)entity.method_5864()).toString();
    }

    public static String getEntityIdName(class_1297 entity) {
        return class_1299.method_5890((class_1299)entity.method_5864()).method_12832();
    }

    public static String getEntityModId(class_1297 entity) {
        return class_1299.method_5890((class_1299)entity.method_5864()).method_12836();
    }

    public static int getRandomColor() {
        float hue = random.nextFloat();
        float saturation = (float)(random.nextInt(4000) + 6000) / 10000.0f;
        float luminance = (float)(random.nextInt(2000) + 8000) / 10000.0f;
        Color color = Color.getHSBColor(hue, saturation, luminance);
        return color.getRGB();
    }

    @Nullable
    public static class_3966 getEntityHitResultAtClip(class_1937 level, class_1297 projectile, class_243 start, class_243 end, class_238 aabb, Predicate<class_1297> filter, float inflateAmount) {
        double d0 = Double.MAX_VALUE;
        class_1297 entity = null;
        class_243 pos = null;
        for (class_1297 entity1 : level.method_8333(projectile, aabb, filter)) {
            double d1;
            class_238 aabb1 = entity1.method_5829().method_1014((double)inflateAmount);
            Optional optional = aabb1.method_992(start, end);
            if (!optional.isPresent() || !((d1 = start.method_1025((class_243)optional.get())) < d0)) continue;
            entity = entity1;
            d0 = d1;
            pos = (class_243)optional.get();
        }
        return entity == null ? null : new class_3966(entity, pos);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static class_1299<?> getEntityType(String entityTypeKey, class_1299<?> alt) {
        void var1_1;
        return UtilEntityImpl.getEntityType(entityTypeKey, var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean doesEntityTypeExist(String entityTypeKey) {
        return UtilEntityImpl.doesEntityTypeExist(entityTypeKey);
    }

    @Nullable
    public static Class<? extends class_1297> getEntityClass(String className) {
        try {
            return Class.forName(className, false, UtilParse.class.getClassLoader()).asSubclass(class_1297.class);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static boolean isPlayer(class_1297 entity) {
        if (entity == null) {
            return false;
        }
        return entity.method_5864().method_5882().equals(class_1299.field_6097.method_5882());
    }

    public static void dropItemStack(class_1937 level, class_1799 stack, class_243 pos) {
        class_1264.method_5449((class_1937)level, (double)pos.field_1352, (double)pos.field_1351, (double)pos.field_1350, (class_1799)stack);
    }

    public static void dropItemStack(class_1297 entity, class_1799 stack) {
        UtilEntity.dropItemStack(UtilEntity.getLevel(entity), stack, entity.method_19538());
    }

    public static boolean arePlayersAllied(@NotNull class_3222 player1, @NotNull class_3222 player2) {
        if (OWLDependencySafety.arePlayersAlliedModdedTeamSystem(player1, player2)) {
            return true;
        }
        return player1.method_5722((class_1297)player2);
    }

    public static boolean areEntitiesAllied(@NotNull class_1297 entity1, @NotNull class_1297 entity2) {
        if (entity1 instanceof class_3222) {
            class_3222 player = (class_3222)entity1;
            return UtilEntity.areEntitiesAllied(player, entity2);
        }
        class_1309 controller = entity1.method_5642();
        if (controller instanceof class_3222) {
            class_3222 player = (class_3222)controller;
            return UtilEntity.areEntitiesAllied(player, entity2);
        }
        return entity1.method_5722(entity2);
    }

    public static boolean areEntitiesAllied(@NotNull class_3222 player, @NotNull class_1297 entity) {
        if (entity instanceof class_3222) {
            class_3222 player2 = (class_3222)entity;
            return UtilEntity.arePlayersAllied(player, player2);
        }
        return player.method_5722(entity);
    }

    public static List<class_3222> getPlayersTrackingEntity(class_1297 entity) {
        if (UtilEntity.getLevel(entity).method_8608()) {
            return new ArrayList<class_3222>();
        }
        return ((class_3218)UtilEntity.getLevel((class_1297)entity)).method_14178().field_17254.method_17210(entity.method_31476(), false);
    }

    public static class_1937 getLevel(class_1297 entity) {
        return entity.method_37908();
    }
}

