/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.util.math;

import com.onewhohears.onewholibs.util.UtilParse;
import com.onewhohears.onewholibs.util.math.Mat4f;
import com.onewhohears.onewholibs.util.math.Vec3f;
import com.onewhohears.onewholibs.util.math.Vec4f;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class UtilGeometry {
    public static final Random RANDOM = new Random();
    public static boolean DEBUG_CATMULLROM = false;

    public static boolean isPointInsideCone(class_243 point, class_243 origin, class_243 direction, double maxAngle, double maxDistance) {
        class_243 diff = point.method_1020(origin);
        double dist = diff.method_1033();
        if (dist > maxDistance) {
            return false;
        }
        double dot = diff.method_1026(direction);
        double mag = dist * direction.method_1033();
        double angle = Math.acos(dot / mag);
        return !((angle = Math.toDegrees(angle)) > maxAngle);
    }

    public static double angleBetween(class_243 dir, class_243 base) {
        double dot = dir.method_1026(base);
        double mag = Math.sqrt(dir.method_1027() * base.method_1027());
        return Math.acos(dot / mag);
    }

    public static double angleBetweenDegrees(class_243 dir, class_243 base) {
        return Math.toDegrees(UtilGeometry.angleBetween(dir, base));
    }

    public static double angleBetweenVecPlane(class_243 dir, class_243 planeNormal) {
        double a = UtilGeometry.angleBetween(dir, planeNormal);
        return 1.5707963267948966 - a;
    }

    public static double angleBetweenVecPlaneDegrees(class_243 dir, class_243 planeNormal) {
        return Math.toDegrees(UtilGeometry.angleBetweenVecPlane(dir, planeNormal));
    }

    public static class_243 interceptPos(class_243 mPos, class_243 mVel, class_243 tPos, class_243 tVel) {
        double x = UtilGeometry.interceptComponent(mPos.field_1352, tPos.field_1352, mVel.field_1352, tVel.field_1352);
        double y = UtilGeometry.interceptComponent(mPos.field_1351, tPos.field_1351, mVel.field_1351, tVel.field_1351);
        double z = UtilGeometry.interceptComponent(mPos.field_1350, tPos.field_1350, mVel.field_1350, tVel.field_1350);
        return new class_243(x, y, z);
    }

    private static double interceptComponent(double mPos, double tPos, double mVel, double tVel) {
        double dp = tPos - mPos;
        double dv = tVel - mVel;
        if (dp > 0.0 && dv < 0.0 || dp < 0.0 && dv > 0.0) {
            tPos += tVel * dp / -dv;
        }
        return tPos;
    }

    public static class_243 vecCompByAxis(class_243 u, class_243 v) {
        if (UtilGeometry.isZero(v)) {
            return class_243.field_1353;
        }
        return v.method_1021(u.method_1026(v) / v.method_1027());
    }

    public static class_243 vecCompByNormAxis(class_243 u, class_243 n) {
        return n.method_1021(u.method_1026(n));
    }

    public static double vecCompMagSqrDirByAxis(class_243 u, class_243 v) {
        if (UtilGeometry.isZero(v)) {
            return 0.0;
        }
        double dot = u.method_1026(v);
        double vl2 = v.method_1027();
        class_243 vec = v.method_1021(dot / vl2);
        return vec.method_1027() * Math.signum(dot);
    }

    public static double vecCompMagSqrDirByNormAxis(class_243 u, class_243 n) {
        double dot = u.method_1026(n);
        class_243 vec = n.method_1021(dot);
        return vec.method_1027() * Math.signum(dot);
    }

    public static double vecCompMagDirByAxis(class_243 u, class_243 v) {
        if (UtilGeometry.isZero(v)) {
            return 0.0;
        }
        double dot = u.method_1026(v);
        double vl2 = v.method_1027();
        class_243 vec = v.method_1021(dot / vl2);
        return vec.method_1033() * Math.signum(dot);
    }

    public static double vecCompMagDirByNormAxis(class_243 u, class_243 n) {
        double dot = u.method_1026(n);
        class_243 vec = n.method_1021(dot);
        return vec.method_1033() * Math.signum(dot);
    }

    public static boolean isZero(class_243 v) {
        return v.field_1352 == 0.0 && v.field_1351 == 0.0 && v.field_1350 == 0.0;
    }

    public static boolean isZero(Vec3f v) {
        return v.x() == 0.0f && v.y() == 0.0f && v.z() == 0.0f;
    }

    public static class_243 getClosestPointOnAABB(class_243 pos, class_238 aabb) {
        if (pos == null) {
            return aabb.method_1005();
        }
        double rx = pos.field_1352;
        double ry = pos.field_1351;
        double rz = pos.field_1350;
        if (rx >= aabb.field_1320) {
            rx = aabb.field_1320;
        } else if (rx <= aabb.field_1323) {
            rx = aabb.field_1323;
        }
        if (ry >= aabb.field_1325) {
            ry = aabb.field_1325;
        } else if (ry <= aabb.field_1322) {
            ry = aabb.field_1322;
        }
        if (rz >= aabb.field_1324) {
            rz = aabb.field_1324;
        } else if (rz <= aabb.field_1321) {
            rz = aabb.field_1321;
        }
        return new class_243(rx, ry, rz);
    }

    public static boolean vec3NAN(class_243 v) {
        return Double.isNaN(v.field_1352) || Double.isNaN(v.field_1351) || Double.isNaN(v.field_1350);
    }

    public static int[] worldToScreenPosInt(class_243 world_pos, Mat4f view_mat, Mat4f proj_mat, int width, int height) {
        float[] sp = UtilGeometry.worldToScreenPos(world_pos, view_mat, proj_mat, width, height);
        return new int[]{(int)sp[0], (int)sp[1]};
    }

    public static float[] worldToScreenPos(class_243 world_pos, Mat4f view_mat, Mat4f proj_mat, int width, int height) {
        Vec4f clipSpace = new Vec4f((float)world_pos.field_1352, (float)world_pos.field_1351, (float)world_pos.field_1350, 1.0f);
        clipSpace.transform(view_mat);
        clipSpace.transform(proj_mat);
        if (clipSpace.w() <= 0.0f) {
            return new float[]{-1.0f, -1.0f};
        }
        Vec3f ndcSpace = new Vec3f(clipSpace);
        ndcSpace.mul(1.0f / clipSpace.w());
        float win_x = (ndcSpace.x() + 1.0f) / 2.0f * (float)width;
        float win_y = (ndcSpace.y() + 1.0f) / 2.0f * (float)height;
        return new float[]{win_x, (float)height - win_y};
    }

    public static Vec3f convertVector(class_243 v) {
        return new Vec3f((float)v.field_1352, (float)v.field_1351, (float)v.field_1350);
    }

    public static class_243 convertVector(Vec3f v) {
        return new class_243((double)v.x(), (double)v.y(), (double)v.z());
    }

    public static class_243 getBBFeet(class_238 bb) {
        return new class_243(bb.method_1005().field_1352, bb.field_1322, bb.method_1005().field_1350);
    }

    public static class_243 toFloats(class_243 v) {
        return new class_243((double)((float)v.field_1352), (double)((float)v.field_1351), (double)((float)v.field_1350));
    }

    public static class_243 toVec3(class_2338 pos) {
        return new class_243((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
    }

    public static class_243 inaccurateTargetPos(class_243 origin, class_243 targetPos, float inaccuracy) {
        double dist = origin.method_1022(targetPos);
        double i = dist * Math.tan((float)Math.PI / 180 * inaccuracy);
        return targetPos.method_1031((RANDOM.nextDouble() - 0.5) * i, (RANDOM.nextDouble() - 0.5) * i, (RANDOM.nextDouble() - 0.5) * i);
    }

    public static boolean isEqual(class_243 v1, class_243 v2) {
        return v1.field_1352 == v2.field_1352 && v1.field_1351 == v2.field_1351 && v1.field_1350 == v2.field_1350;
    }

    public static boolean isEqual(class_243 a, class_243 b, double maxDiff) {
        return Math.abs(a.field_1352 - b.field_1352) <= maxDiff && Math.abs(a.field_1351 - b.field_1351) <= maxDiff && Math.abs(a.field_1350 - b.field_1350) <= maxDiff;
    }

    public static double[] roots(double a, double b, double c) {
        double[] roots = new double[4];
        double d = b * b - 4.0 * a * c;
        if (d > 0.0) {
            double sqrtD = Math.sqrt(d);
            roots[0] = (-b + sqrtD) / (2.0 * a);
            roots[1] = 0.0;
            roots[2] = (-b - sqrtD) / (2.0 * a);
            roots[3] = 0.0;
        } else if (d == 0.0) {
            double root;
            roots[0] = root = -b / (2.0 * a);
            roots[1] = 0.0;
            roots[2] = root;
            roots[3] = 0.0;
        } else {
            double real = -b / (2.0 * a);
            double imaginary = Math.sqrt(-d) / (2.0 * a);
            roots[0] = real;
            roots[1] = imaginary;
            roots[2] = real;
            roots[3] = -imaginary;
        }
        return roots;
    }

    public static double @Nullable [] rootsNoI(double a, double b, double c) {
        double d = b * b - 4.0 * a * c;
        if (d < 0.0) {
            return null;
        }
        double[] roots = new double[2];
        if (d == 0.0) {
            double root;
            roots[0] = root = -b / (2.0 * a);
            roots[1] = root;
        } else {
            double sqrtD = Math.sqrt(d);
            roots[0] = (-b + sqrtD) / (2.0 * a);
            roots[1] = (-b - sqrtD) / (2.0 * a);
        }
        return roots;
    }

    public static int numTrue(boolean[] bools) {
        int num = 0;
        for (boolean bool : bools) {
            if (!bool) continue;
            ++num;
        }
        return num;
    }

    public static int getMaxYIndex(class_243[] array) {
        if (array.length == 0) {
            return -1;
        }
        int maxIndex = 0;
        double max = array[0].field_1351;
        for (int i = 1; i < array.length; ++i) {
            if (!(array[i].field_1351 > max)) continue;
            maxIndex = i;
            max = array[i].field_1351;
        }
        return maxIndex;
    }

    public static int getMinYIndex(class_243[] array) {
        if (array.length == 0) {
            return -1;
        }
        int minIndex = 0;
        double min = array[0].field_1351;
        for (int i = 1; i < array.length; ++i) {
            if (!(array[i].field_1351 < min)) continue;
            minIndex = i;
            min = array[i].field_1351;
        }
        return minIndex;
    }

    public static int getMaxXIndex(class_243[] array) {
        if (array.length == 0) {
            return -1;
        }
        int maxIndex = 0;
        double max = array[0].field_1352;
        for (int i = 1; i < array.length; ++i) {
            if (!(array[i].field_1352 > max)) continue;
            maxIndex = i;
            max = array[i].field_1352;
        }
        return maxIndex;
    }

    public static int getMinXIndex(class_243[] array) {
        if (array.length == 0) {
            return -1;
        }
        int minIndex = 0;
        double min = array[0].field_1352;
        for (int i = 1; i < array.length; ++i) {
            if (!(array[i].field_1352 < min)) continue;
            minIndex = i;
            min = array[i].field_1352;
        }
        return minIndex;
    }

    public static int getMaxZIndex(class_243[] array) {
        if (array.length == 0) {
            return -1;
        }
        int maxIndex = 0;
        double max = array[0].field_1350;
        for (int i = 1; i < array.length; ++i) {
            if (!(array[i].field_1350 > max)) continue;
            maxIndex = i;
            max = array[i].field_1350;
        }
        return maxIndex;
    }

    public static int getMinZIndex(class_243[] array) {
        if (array.length == 0) {
            return -1;
        }
        int minIndex = 0;
        double min = array[0].field_1350;
        for (int i = 1; i < array.length; ++i) {
            if (!(array[i].field_1350 < min)) continue;
            minIndex = i;
            min = array[i].field_1350;
        }
        return minIndex;
    }

    public static int getMinIndex(double[] array) {
        if (array.length == 0) {
            return -1;
        }
        int minIndex = 0;
        double min = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (!(array[i] < min)) continue;
            minIndex = i;
            min = array[i];
        }
        return minIndex;
    }

    public static float crossProduct(class_241 v1, class_241 v2) {
        return v1.field_1343 * v2.field_1342 - v1.field_1342 * v2.field_1343;
    }

    public static boolean isIn2DTriangle(class_241 p, class_241[] v) {
        if (v.length < 3) {
            return false;
        }
        float area = 0.5f * (-v[1].field_1342 * v[2].field_1343 + v[0].field_1342 * (-v[1].field_1343 + v[2].field_1343) + v[0].field_1343 * (v[1].field_1342 - v[2].field_1342) + v[1].field_1343 * v[2].field_1342);
        float a = 1.0f / (2.0f * area);
        float s0 = a * (v[0].field_1342 * v[2].field_1343 - v[0].field_1343 * v[2].field_1342 + (v[2].field_1342 - v[0].field_1342) * p.field_1343 + (v[0].field_1343 - v[2].field_1343) * p.field_1342);
        float t0 = a * (v[0].field_1343 * v[1].field_1342 - v[0].field_1342 * v[1].field_1343 + (v[0].field_1342 - v[1].field_1342) * p.field_1343 + (v[1].field_1343 - v[0].field_1343) * p.field_1342);
        return s0 >= 0.0f && t0 >= 0.0f && 1.0f - s0 - t0 >= 0.0f;
    }

    public static boolean isIn2DQuad(class_241 p, class_241[] v) {
        if (v.length < 4) {
            return false;
        }
        class_241[] t1 = new class_241[]{v[0], v[1], v[2]};
        class_241[] t2 = new class_241[]{v[0], v[2], v[3]};
        return UtilGeometry.isIn2DTriangle(p, t1) || UtilGeometry.isIn2DTriangle(p, t2);
    }

    public static int add(int n, int a, int max) {
        double r = (double)(n += a) / (double)max;
        return n -= (int)r * max;
    }

    @Nullable
    public static class_241 intersect(class_241 as, class_241 ae, class_241 bs, class_241 be) {
        class_241 ad = ae.method_35586(as.method_35588());
        class_241 bd = be.method_35586(bs.method_35588());
        float det = UtilGeometry.crossProduct(bd, ad);
        if (det == 0.0f) {
            return null;
        }
        class_241 D = bs.method_35586(as.method_35588());
        float u = (D.field_1342 * bd.field_1343 - D.field_1343 * bd.field_1342) / det;
        return as.method_35586(ad.method_35582(u));
    }

    public static float[] calcCatmullromTs(float a, float x0, float y0, float x1, float y1, float x2, float y2, float x3, float y3) {
        if (a < 0.0f) {
            a = 0.0f;
        } else if (a > 1.0f) {
            a = 1.0f;
        }
        float t0 = 0.0f;
        float t1 = UtilGeometry.calcT(x0, x1, y0, y1, t0, a);
        float t2 = UtilGeometry.calcT(x1, x2, y1, y2, t1, a);
        float t3 = UtilGeometry.calcT(x2, x3, y2, y3, t2, a);
        return new float[]{t0, t1, t2, t3};
    }

    public static float[] calcCatmullromTs(float a, class_241 P0, class_241 P1, class_241 P2, class_241 P3) {
        return UtilGeometry.calcCatmullromTs(a, P0.field_1343, P0.field_1342, P1.field_1343, P1.field_1342, P2.field_1343, P2.field_1342, P3.field_1343, P3.field_1342);
    }

    public static float findYInCatmullromArray(float x, class_241[] cmr) {
        if (cmr.length == 0) {
            return 0.0f;
        }
        if (x <= cmr[0].field_1343) {
            return cmr[0].field_1342;
        }
        for (int i = 1; i < cmr.length; ++i) {
            class_241 now = cmr[i];
            if (x == now.field_1343) {
                return now.field_1342;
            }
            if (x > now.field_1343) continue;
            class_241 prev = cmr[i - 1];
            float p = (x - prev.field_1343) / (now.field_1343 - prev.field_1343);
            return class_3532.method_16439((float)p, (float)prev.field_1342, (float)now.field_1342);
        }
        return cmr[cmr.length - 1].field_1342;
    }

    public static class_241[] catmullromArray(int points, float a, class_241 P0, class_241 P1, class_241 P2, class_241 P3) {
        int i;
        if (a < 0.0f) {
            a = 0.0f;
        } else if (a > 1.0f) {
            a = 1.0f;
        }
        if (DEBUG_CATMULLROM) {
            System.out.println("CALC CMR array: ");
        }
        if (DEBUG_CATMULLROM) {
            System.out.println("points = " + points + UtilParse.prettyVec2(P0) + UtilParse.prettyVec2(P1) + UtilParse.prettyVec2(P2) + UtilParse.prettyVec2(P3));
        }
        float[] ts = UtilGeometry.calcCatmullromTs(a, P0, P1, P2, P3);
        if (DEBUG_CATMULLROM) {
            System.out.println("ts = " + Arrays.toString(ts));
        }
        float tStep = 1.0f / (float)points;
        class_241[] array = new class_241[points];
        for (i = 0; i < array.length; ++i) {
            array[i] = UtilGeometry.catmullrom(tStep * (float)i, P0, P1, P2, P3, ts);
        }
        if (DEBUG_CATMULLROM) {
            System.out.print("cmrs =");
            for (i = 0; i < array.length; ++i) {
                System.out.print(" " + UtilParse.prettyVec2(array[i]));
            }
            System.out.println();
        }
        return array;
    }

    public static class_241[] catmullromArray(int points, float a, float x0, float y0, float x1, float y1, float x2, float y2, float x3, float y3) {
        return UtilGeometry.catmullromArray(points, a, new class_241(x0, y0), new class_241(x1, y1), new class_241(x2, y2), new class_241(x3, y3));
    }

    public static class_241 catmullrom(float t, float a, class_241 P0, class_241 P1, class_241 P2, class_241 P3) {
        if (a < 0.0f) {
            a = 0.0f;
        } else if (a > 1.0f) {
            a = 1.0f;
        }
        float[] ts = UtilGeometry.calcCatmullromTs(a, P0, P1, P2, P3);
        return UtilGeometry.catmullrom(t, P0, P1, P2, P3, ts);
    }

    private static class_241 catmullrom(float t, class_241 P0, class_241 P1, class_241 P2, class_241 P3, float[] ts) {
        if (t == 0.0f) {
            return P1;
        }
        if (t == 1.0f) {
            return P2;
        }
        float t0 = ts[0];
        float t1 = ts[1];
        float t2 = ts[2];
        float t3 = ts[3];
        t = class_3532.method_16439((float)t, (float)t1, (float)t2);
        class_241 A2 = P1.method_35582(UtilGeometry.slope(t2, t, t2, t1)).method_35586(P2.method_35582(UtilGeometry.slope(t, t1, t2, t1)));
        if (t2 == t3) {
            class_241 A1 = P0.method_35582(UtilGeometry.slope(t1, t, t1, t0)).method_35586(P1.method_35582(UtilGeometry.slope(t, t0, t1, t0)));
            class_241 B1 = A1.method_35582(UtilGeometry.slope(t2, t, t2, t0)).method_35586(A2.method_35582(UtilGeometry.slope(t, t0, t2, t0)));
            return B1;
        }
        if (t0 == t1) {
            class_241 A3 = P2.method_35582(UtilGeometry.slope(t3, t, t3, t2)).method_35586(P3.method_35582(UtilGeometry.slope(t, t2, t3, t2)));
            class_241 B2 = A2.method_35582(UtilGeometry.slope(t3, t, t3, t1)).method_35586(A3.method_35582(UtilGeometry.slope(t, t1, t3, t1)));
            return B2;
        }
        class_241 A1 = P0.method_35582(UtilGeometry.slope(t1, t, t1, t0)).method_35586(P1.method_35582(UtilGeometry.slope(t, t0, t1, t0)));
        class_241 A3 = P2.method_35582(UtilGeometry.slope(t3, t, t3, t2)).method_35586(P3.method_35582(UtilGeometry.slope(t, t2, t3, t2)));
        class_241 B1 = A1.method_35582(UtilGeometry.slope(t2, t, t2, t0)).method_35586(A2.method_35582(UtilGeometry.slope(t, t0, t2, t0)));
        class_241 B2 = A2.method_35582(UtilGeometry.slope(t3, t, t3, t1)).method_35586(A3.method_35582(UtilGeometry.slope(t, t1, t3, t1)));
        return B1.method_35582(UtilGeometry.slope(t2, t, t2, t1)).method_35586(B2.method_35582(UtilGeometry.slope(t, t1, t2, t1)));
    }

    private static float slope(float y1, float y0, float x1, float x0) {
        return (y1 - y0) / (x1 - x0);
    }

    private static float calcT(float x0, float x1, float y0, float y1, float t0, float a) {
        return (float)Math.pow(class_3532.method_15355((float)((float)(Math.pow(x1 - x0, 2.0) + Math.pow(y1 - y0, 2.0)))), a) + t0;
    }

    public static class_243[] getSizeCenter(class_243 ... positions) {
        double minX = 0.0;
        double minY = 0.0;
        double minZ = 0.0;
        double maxX = 0.0;
        double maxY = 0.0;
        double maxZ = 0.0;
        for (class_243 pos : positions) {
            if (pos.method_10216() < minX) {
                minX = pos.method_10216();
            }
            if (pos.method_10214() < minY) {
                minY = pos.method_10214();
            }
            if (pos.method_10215() < minZ) {
                minZ = pos.method_10215();
            }
            if (pos.method_10216() > maxX) {
                maxX = pos.method_10216();
            }
            if (pos.method_10214() > maxY) {
                maxY = pos.method_10214();
            }
            if (!(pos.method_10215() > maxZ)) continue;
            maxZ = pos.method_10215();
        }
        class_243 size = new class_243(maxX - minX, maxY - minY, maxZ - minZ);
        class_243 center = new class_243(minX, minY, minZ).method_1019(size.method_1021(0.5));
        return new class_243[]{size, center};
    }

    public static class_243[] getSizeCenter(List<Vec3f> positions) {
        double minX = 0.0;
        double minY = 0.0;
        double minZ = 0.0;
        double maxX = 0.0;
        double maxY = 0.0;
        double maxZ = 0.0;
        for (Vec3f pos : positions) {
            if ((double)pos.x() < minX) {
                minX = pos.x();
            }
            if ((double)pos.y() < minY) {
                minY = pos.y();
            }
            if ((double)pos.z() < minZ) {
                minZ = pos.z();
            }
            if ((double)pos.x() > maxX) {
                maxX = pos.x();
            }
            if ((double)pos.y() > maxY) {
                maxY = pos.y();
            }
            if (!((double)pos.z() > maxZ)) continue;
            maxZ = pos.z();
        }
        class_243 size = new class_243(maxX - minX, maxY - minY, maxZ - minZ);
        class_243 center = new class_243(minX, minY, minZ).method_1019(size.method_1021(0.5));
        return new class_243[]{size, center};
    }

    public static class_2382 toVec3i(class_243 vec) {
        return new class_2382((int)vec.field_1352, (int)vec.field_1351, (int)vec.field_1350);
    }

    public static class_2338 toBlockPos(class_243 vec) {
        return new class_2338((int)vec.field_1352, (int)vec.field_1351, (int)vec.field_1350);
    }
}

