/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.util.math;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.onewhohears.onewholibs.util.math.Mat3f;
import com.onewhohears.onewholibs.util.math.QuaternionF;
import com.onewhohears.onewholibs.util.math.Vec4f;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import java.util.List;
import net.minecraft.class_156;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import org.joml.Vector3f;

public final class Vec3f {
    public static final Codec<Vec3f> CODEC = Codec.FLOAT.listOf().comapFlatMap(list -> class_156.method_33141((List)list, (int)3).map(listx -> new Vec3f(((Float)listx.get(0)).floatValue(), ((Float)listx.get(1)).floatValue(), ((Float)listx.get(2)).floatValue())), Vec3f2 -> ImmutableList.of((Object)Float.valueOf(Vec3f2.x), (Object)Float.valueOf(Vec3f2.y), (Object)Float.valueOf(Vec3f2.z)));
    public static Vec3f XN = new Vec3f(-1.0f, 0.0f, 0.0f);
    public static Vec3f XP = new Vec3f(1.0f, 0.0f, 0.0f);
    public static Vec3f YN = new Vec3f(0.0f, -1.0f, 0.0f);
    public static Vec3f YP = new Vec3f(0.0f, 1.0f, 0.0f);
    public static Vec3f ZN = new Vec3f(0.0f, 0.0f, -1.0f);
    public static Vec3f ZP = new Vec3f(0.0f, 0.0f, 1.0f);
    public static Vec3f ZERO = new Vec3f(0.0f, 0.0f, 0.0f);
    private float x;
    private float y;
    private float z;

    public Vec3f() {
    }

    public Vec3f(float f, float g, float h) {
        this.x = f;
        this.y = g;
        this.z = h;
    }

    public Vec3f(Vec4f vec4f) {
        this(vec4f.x(), vec4f.y(), vec4f.z());
    }

    public Vec3f(class_243 vec3) {
        this((float)vec3.field_1352, (float)vec3.field_1351, (float)vec3.field_1350);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            Vec3f Vec3f2 = (Vec3f)object;
            if (Float.compare(Vec3f2.x, this.x) != 0) {
                return false;
            }
            if (Float.compare(Vec3f2.y, this.y) != 0) {
                return false;
            }
            return Float.compare(Vec3f2.z, this.z) == 0;
        }
        return false;
    }

    public int hashCode() {
        int i = Float.floatToIntBits(this.x);
        i = 31 * i + Float.floatToIntBits(this.y);
        i = 31 * i + Float.floatToIntBits(this.z);
        return i;
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public float z() {
        return this.z;
    }

    public void mul(float f) {
        this.x *= f;
        this.y *= f;
        this.z *= f;
    }

    public void mul(float f, float g, float h) {
        this.x *= f;
        this.y *= g;
        this.z *= h;
    }

    public void clamp(Vec3f Vec3f2, Vec3f Vec3f22) {
        this.x = class_3532.method_15363((float)this.x, (float)Vec3f2.x(), (float)Vec3f22.x());
        this.y = class_3532.method_15363((float)this.y, (float)Vec3f2.x(), (float)Vec3f22.y());
        this.z = class_3532.method_15363((float)this.z, (float)Vec3f2.z(), (float)Vec3f22.z());
    }

    public void clamp(float f, float g) {
        this.x = class_3532.method_15363((float)this.x, (float)f, (float)g);
        this.y = class_3532.method_15363((float)this.y, (float)f, (float)g);
        this.z = class_3532.method_15363((float)this.z, (float)f, (float)g);
    }

    public void set(float f, float g, float h) {
        this.x = f;
        this.y = g;
        this.z = h;
    }

    public void load(Vec3f Vec3f2) {
        this.x = Vec3f2.x;
        this.y = Vec3f2.y;
        this.z = Vec3f2.z;
    }

    public void add(float f, float g, float h) {
        this.x += f;
        this.y += g;
        this.z += h;
    }

    public void add(Vec3f Vec3f2) {
        this.x += Vec3f2.x;
        this.y += Vec3f2.y;
        this.z += Vec3f2.z;
    }

    public void sub(Vec3f Vec3f2) {
        this.x -= Vec3f2.x;
        this.y -= Vec3f2.y;
        this.z -= Vec3f2.z;
    }

    public float dot(Vec3f Vec3f2) {
        return this.x * Vec3f2.x + this.y * Vec3f2.y + this.z * Vec3f2.z;
    }

    public boolean normalize() {
        float f = this.x * this.x + this.y * this.y + this.z * this.z;
        if ((double)f < 1.0E-5) {
            return false;
        }
        float g = (float)class_3532.method_15345((double)f);
        this.x *= g;
        this.y *= g;
        this.z *= g;
        return true;
    }

    public void cross(Vec3f Vec3f2) {
        float f = this.x;
        float g = this.y;
        float h = this.z;
        float i = Vec3f2.x();
        float j = Vec3f2.y();
        float k = Vec3f2.z();
        this.x = g * k - h * j;
        this.y = h * i - f * k;
        this.z = f * j - g * i;
    }

    public void transform(Mat3f mat3f) {
        float f = this.x;
        float g = this.y;
        float h = this.z;
        this.x = mat3f.m00 * f + mat3f.m01 * g + mat3f.m02 * h;
        this.y = mat3f.m10 * f + mat3f.m11 * g + mat3f.m12 * h;
        this.z = mat3f.m20 * f + mat3f.m21 * g + mat3f.m22 * h;
    }

    public void transform(QuaternionF quaternion) {
        QuaternionF quaternion2 = new QuaternionF(quaternion);
        quaternion2.mul(new QuaternionF(this.x(), this.y(), this.z(), 0.0f));
        QuaternionF quaternion3 = new QuaternionF(quaternion);
        quaternion3.conj();
        quaternion2.mul(quaternion3);
        this.set(quaternion2.i(), quaternion2.j(), quaternion2.k());
    }

    public void lerp(Vec3f Vec3f2, float f) {
        float g = 1.0f - f;
        this.x = this.x * g + Vec3f2.x * f;
        this.y = this.y * g + Vec3f2.y * f;
        this.z = this.z * g + Vec3f2.z * f;
    }

    public QuaternionF rotation(float f) {
        return new QuaternionF(this, f, false);
    }

    public QuaternionF rotationDegrees(float f) {
        return new QuaternionF(this, f, true);
    }

    public Vec3f copy() {
        return new Vec3f(this.x, this.y, this.z);
    }

    public void map(Float2FloatFunction float2FloatFunction) {
        this.x = float2FloatFunction.get(this.x);
        this.y = float2FloatFunction.get(this.y);
        this.z = float2FloatFunction.get(this.z);
    }

    public String toString() {
        return "[" + this.x + ", " + this.y + ", " + this.z + "]";
    }

    public Vector3f convert() {
        return new Vector3f(this.x, this.y, this.z);
    }

    public static Vec3f from(Vector3f v) {
        return new Vec3f(v.x(), v.y(), v.z());
    }
}

