/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.entityscreen.instance;

import com.onewhohears.dscombat.client.entityscreen.instance.EntityScreenInstance;
import com.onewhohears.dscombat.util.UtilRender;
import com.onewhohears.onewholibs.util.math.Mat4f;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3532;
import net.minecraft.class_4597;

public abstract class EntityDynamicScreenInstance
extends EntityScreenInstance {
    protected final class_1043 dynamicTexture;
    protected final class_1921 dynamicRenderType;
    protected final int pixelWidth;
    protected final int pixelHeight;
    protected int prevUpdateTickCount;

    public EntityDynamicScreenInstance(String path, int id, class_2960 baseTexture) {
        super(id, baseTexture);
        class_1011 image;
        try {
            InputStream stream = ((class_3298)class_310.method_1551().method_1478().method_14486(baseTexture).get()).method_14482();
            image = class_1011.method_4309((InputStream)stream);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.dynamicTexture = null;
            this.pixelHeight = 0;
            this.pixelWidth = 0;
            this.dynamicRenderType = null;
            return;
        }
        this.dynamicTexture = new class_1043(image.method_4307(), image.method_4323(), true);
        this.pixelWidth = this.dynamicTexture.method_4525().method_4307();
        this.pixelHeight = this.dynamicTexture.method_4525().method_4323();
        class_2960 dynamicLoc = class_310.method_1551().method_1531().method_4617(path + "/" + id, this.dynamicTexture);
        this.dynamicRenderType = class_1921.method_23028((class_2960)dynamicLoc);
    }

    public EntityDynamicScreenInstance(String path, int id, class_2960 baseTexture, int width, int height) {
        super(id, baseTexture);
        this.pixelWidth = width;
        this.pixelHeight = height;
        this.dynamicTexture = new class_1043(width, height, true);
        class_2960 dynamicLoc = class_310.method_1551().method_1531().method_4617(path + "/" + id, this.dynamicTexture);
        this.dynamicRenderType = class_1921.method_23028((class_2960)dynamicLoc);
    }

    public EntityDynamicScreenInstance(String path, int id, int width, int height) {
        this(path, id, null, width, height);
    }

    public abstract boolean shouldUpdateTexture(class_1297 var1);

    protected abstract void updateTexture(class_1297 var1);

    protected void clearDynamicPixels() {
        for (int i = 0; i < this.pixelWidth; ++i) {
            for (int j = 0; j < this.pixelHeight; ++j) {
                this.dynamicTexture.method_4525().method_4305(i, j, 0);
            }
        }
    }

    protected void setPixel(int x, int y, int color) {
        if (x < 0 || y < 0 || x >= this.pixelWidth || y >= this.pixelHeight) {
            return;
        }
        this.dynamicTexture.method_4525().method_4305(x, y, color);
    }

    protected void drawPlus(int x, int y, int r, int t, int color) {
        int k;
        double half = (double)t * 0.5;
        int kMin = -((int)Math.floor(half));
        int kMax = (int)Math.ceil(half);
        for (int i = x - r; i <= x + r; ++i) {
            for (k = kMin; k < kMax; ++k) {
                this.setPixel(i, y + k, color);
            }
        }
        for (int j = y - r; j <= y + r; ++j) {
            for (k = kMin; k < kMax; ++k) {
                this.setPixel(x + k, j, color);
            }
        }
    }

    protected void drawPlus(int x, int y, int r, int color) {
        this.drawPlus(x, y, r, 1, color);
    }

    protected void drawCross(int x, int y, int r, int t, int color) {
        int k;
        double half = (double)t * 0.5;
        int kMin = -((int)Math.floor(half));
        int kMax = (int)Math.ceil(half);
        int i = x - r;
        int j = y - r;
        while (i <= x + r) {
            for (k = kMin; k < kMax; ++k) {
                this.setPixel(i + k, j, color);
            }
            ++i;
            ++j;
        }
        i = x - r;
        j = y + r;
        while (i <= x + r) {
            for (k = kMin; k < kMax; ++k) {
                this.setPixel(i + k, j, color);
            }
            ++i;
            --j;
        }
    }

    protected void drawCross(int x, int y, int r, int color) {
        this.drawCross(x, y, r, 1, color);
    }

    protected void drawHollowCircle(int x, int y, int r, int t, int color) {
        if (t > r) {
            return;
        }
        float pi2 = (float)Math.PI * 2;
        for (int rad = r; rad > r - t; --rad) {
            float minAngle = (float)Math.atan(1.0f / (float)rad) * 0.65f;
            if (minAngle == 0.0f) {
                this.setPixel(x, y, color);
                return;
            }
            for (float angle = 0.0f; angle < pi2; angle += minAngle) {
                int xr = (int)((float)rad * class_3532.method_15362((float)angle));
                int yr = (int)((float)rad * class_3532.method_15374((float)angle));
                this.setPixel(x + xr, y + yr, color);
            }
        }
    }

    protected void drawHollowCircle(int x, int y, int r, int color) {
        this.drawHollowCircle(x, y, r, 1, color);
    }

    protected void drawDiamond(int x, int y, int r, int t, int color) {
        int k;
        double half = (double)t * 0.5;
        int kMin = -((int)Math.floor(half));
        int kMax = (int)Math.ceil(half);
        int i = x - r;
        int j = y;
        while (i <= x) {
            for (k = kMin; k < kMax; ++k) {
                this.setPixel(i + k, j, color);
            }
            ++i;
            ++j;
        }
        i = x - r;
        j = y;
        while (i <= x) {
            for (k = kMin; k < kMax; ++k) {
                this.setPixel(i + k, j, color);
            }
            ++i;
            --j;
        }
        i = x + r;
        j = y;
        while (i >= x) {
            for (k = kMin; k < kMax; ++k) {
                this.setPixel(i + k, j, color);
            }
            --i;
            ++j;
        }
        i = x + r;
        j = y;
        while (i >= x) {
            for (k = kMin; k < kMax; ++k) {
                this.setPixel(i + k, j, color);
            }
            --i;
            --j;
        }
    }

    protected void drawLine(int x1, int y1, int x2, int y2, int color) {
        this.drawLine(x1, y1, x2, y2, 1, color);
    }

    protected void drawLine(int x1, int y1, int x2, int y2, int t, int color) {
        if (x1 > x2) {
            int xt = x1;
            x1 = x2;
            x2 = xt;
            int yt = y1;
            y1 = y2;
            y2 = yt;
        }
        int xDiff = x2 - x1;
        int yDiff = y2 - y1;
        double half = (double)t * 0.5;
        int kMin = -((int)Math.floor(half));
        int kMax = (int)Math.ceil(half);
        if (Math.abs(xDiff) < 1) {
            int ySign = (int)Math.signum(yDiff);
            int yDiffAbs = Math.abs(yDiff);
            for (int i = 0; i <= yDiffAbs; ++i) {
                int y = y1 + i * ySign;
                for (int k = kMin; k < kMax; ++k) {
                    int x = x1 + k;
                    this.setPixel(x, y, color);
                }
            }
            return;
        }
        double slope = (double)yDiff / (double)xDiff;
        double slopeAbs = Math.abs(slope);
        double slopeSign = Math.signum(slope);
        for (int x = x1; x <= x2; ++x) {
            double y = slope * (double)(x - x1) + (double)y1;
            if (slopeAbs > 1.0) {
                for (double i = 0.0; i < slopeAbs; i += 1.0) {
                    double ye = y - i * slopeSign;
                    if (slopeSign > 0.0 && ye < (double)y1 || slopeSign < 0.0 && ye > (double)y1) continue;
                    int yei = (int)ye;
                    for (int k = kMin; k < kMax; ++k) {
                        this.setPixel(x + k, yei, color);
                    }
                }
                continue;
            }
            int yi = (int)y;
            for (int k = kMin; k < kMax; ++k) {
                this.setPixel(x, yi + k, color);
            }
        }
    }

    @Override
    public void draw(class_1297 entity, Mat4f matrix4f, class_4597 buffer, float partialTicks, int packedLight, float worldWidth, float worldHeight) {
        super.draw(entity, matrix4f, buffer, partialTicks, packedLight, worldWidth, worldHeight);
        if (this.shouldUpdateTexture(entity)) {
            this.updateTexture(entity);
            this.dynamicTexture.method_4524();
            this.prevUpdateTickCount = entity.field_6012;
        }
        UtilRender.drawTextureCentered(this.dynamicRenderType, matrix4f, buffer, packedLight, -0.001f);
    }

    @Override
    public void close() {
        super.close();
        this.dynamicTexture.close();
    }
}

