/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.overlay.components;

import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.client.overlay.VehicleOverlayComponent;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.onewholibs.util.UtilParse;
import com.onewhohears.onewholibs.util.math.QuaternionF;
import net.minecraft.class_243;
import net.minecraft.class_329;
import net.minecraft.class_332;
import org.jetbrains.annotations.NotNull;

public class DebugOverlay
extends VehicleOverlayComponent {
    @Override
    protected boolean shouldRender(class_329 gui, class_332 graphics, float partialTick, int screenWidth, int screenHeight) {
        if (DebugOverlay.defaultRenderConditions()) {
            return false;
        }
        return DebugOverlay.getPlayerRootVehicle() instanceof EntityVehicle && (Boolean)Config.CLIENT.debugMode.get() != false;
    }

    @Override
    protected void render(class_329 gui, class_332 graphics, float partialTick, int screenWidth, int screenHeight) {
        EntityVehicle vehicle = (EntityVehicle)DebugOverlay.getPlayerRootVehicle();
        assert (vehicle != null);
        int color = 65280;
        int space = 160;
        graphics.method_25303(FONT, "V" + UtilParse.prettyVec3((class_243)vehicle.method_18798(), (int)2), screenWidth - space, 0, color);
        graphics.method_25303(FONT, "F" + UtilParse.prettyVec3((class_243)vehicle.forces, (int)0), screenWidth - space, 10, color);
        graphics.method_25303(FONT, "A" + UtilParse.prettyVec3((class_243)vehicle.getAngularVel(), (int)2), screenWidth - space, 20, color);
        graphics.method_25303(FONT, "M" + UtilParse.prettyVec3((class_243)vehicle.getMoment(), (int)2), screenWidth - space, 30, color);
        graphics.method_25303(FONT, "Q" + UtilParse.prettyQ((QuaternionF)vehicle.getClientQ(), (int)2), screenWidth - space, 40, color);
        graphics.method_25303(FONT, "YR: " + String.format("%3.2f", Float.valueOf(vehicle.getYawRate() * 20.0f)) + " TR: " + String.format("%3.2f", Float.valueOf(vehicle.getActualTurnRadius())), screenWidth - space, 50, color);
        QuaternionF q = vehicle.getClientQ();
        class_243 thrust = vehicle.getThrustForce(q);
        class_243 drag = vehicle.calcTotalDrag(q);
        class_243 lift = vehicle.calcTotalLift(q);
        double weight = vehicle.getWeightForce().field_1351;
        double forceY = thrust.field_1351 + drag.field_1351 + lift.field_1351 + weight;
        double thrustDragXZ = thrust.method_37267() - drag.method_37267();
        double tdXZAcc = vehicle.getAccFromForce(thrustDragXZ, true) * 1000.0;
        graphics.method_25303(FONT, "FY: " + String.format("%3.1f", forceY), screenWidth - space, 60, color);
        graphics.method_25303(FONT, "FTD_XZ: " + String.format("%3.1f", thrustDragXZ) + " ATD_XZ: " + String.format("%3.3f", tdXZAcc), screenWidth - space, 70, color);
    }

    @Override
    @NotNull
    protected String componentId() {
        return "dscombat_debug";
    }
}

