/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.overlay.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.onewhohears.dscombat.client.overlay.VehicleOverlayComponent;
import com.onewhohears.dscombat.data.weapon.instance.WeaponInstance;
import com.onewhohears.dscombat.data.weapon.stats.WeaponStats;
import com.onewhohears.dscombat.entity.parts.EntityRidablePart;
import com.onewhohears.dscombat.entity.parts.EntityTurret;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.onewholibs.util.UtilMCText;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class VehicleWeaponsOverlay
extends VehicleOverlayComponent {
    public static final class_2960 WEAPON_TABS = new class_2960("dscombat", "textures/ui/weapon_icons/weapon_tab.png");
    public static final class_2960 SELECTOR = new class_2960("dscombat", "textures/ui/weapon_icons/selection_box.png");
    public static final byte TAB_WIDTH = 93;
    public static final byte TAB_HEIGHT = 24;
    public static final float[] FRAMES = new float[]{0.0f, 5.0f, 10.0f, 13.0f, 16.0f, 18.0f, 20.0f, 22.0f, 23.0f};
    public static final int[] SPACINGS = new int[]{24, 21, 18, 12, 0};
    public static final class_2561 SAFETY = UtilMCText.translatable((String)"ui.dscombat.no_weapon");
    protected boolean weaponChangeState;
    protected boolean weaponChangeQueued;
    protected int weaponChangeCountdown;
    protected int selectedWeapon;
    protected float frame;
    protected int superFrame;

    @Override
    protected boolean shouldRender(class_329 gui, class_332 graphics, float partialTick, int screenWidth, int screenHeight) {
        if (VehicleWeaponsOverlay.defaultRenderConditions()) {
            return false;
        }
        return VehicleWeaponsOverlay.getPlayerVehicle() instanceof EntityRidablePart;
    }

    @Override
    protected void render(class_329 gui, class_332 graphics, float partialTick, int screenWidth, int screenHeight) {
        EntityRidablePart seat = (EntityRidablePart)VehicleWeaponsOverlay.getPlayerVehicle();
        assert (seat != null);
        double yPlacement = screenHeight - 24 - 13;
        int blitPosition = 1;
        if (seat.isTurret()) {
            VehicleWeaponsOverlay.drawFinishedTab(graphics, ((EntityTurret)seat).getWeaponData(), yPlacement, blitPosition);
            return;
        }
        if (!seat.canPassengerShootParentWeapon()) {
            return;
        }
        EntityVehicle vehicle = seat.getParentVehicle();
        if (vehicle == null) {
            return;
        }
        List<WeaponInstance<?>> weapons = vehicle.weaponSystem.getWeapons();
        WeaponInstance<?> selectedWeapon = vehicle.weaponSystem.getSelected();
        int selectedIndex = vehicle.weaponSystem.getSelectedIndex();
        if (weapons == null || weapons.isEmpty()) {
            return;
        }
        if (selectedWeapon == null) {
            return;
        }
        if (selectedIndex != this.selectedWeapon) {
            this.enableWeaponChangeState();
        }
        this.selectedWeapon = selectedIndex;
        if (this.weaponChangeCountdown <= 0) {
            this.weaponChangeState = false;
        }
        if (!this.weaponChangeState) {
            VehicleWeaponsOverlay.drawFinishedTab(graphics, selectedWeapon, yPlacement, blitPosition);
        } else {
            int weaponTabsToRender = Math.min(weapons.size(), 5);
            for (int i = 0; i < weaponTabsToRender; ++i) {
                int shiftedIndex = selectedIndex - i;
                if (shiftedIndex < 0) {
                    shiftedIndex = (shiftedIndex % weapons.size() + weapons.size()) % weapons.size();
                }
                int newYPos = (int)(yPlacement - (double)(24 * i));
                WeaponInstance<?> weaponAt = weapons.get(shiftedIndex);
                VehicleWeaponsOverlay.drawTab(graphics, 13.0, newYPos, blitPosition, 0, false);
                VehicleWeaponsOverlay.drawWeapon(graphics, weaponAt, 13.0, newYPos, blitPosition + 1, 0, false, false, false);
                graphics.method_51448().method_22903();
                graphics.method_51448().method_46416(0.0f, 0.0f, (float)(blitPosition + 3));
                if (!((WeaponStats)weaponAt.getStats()).isNoWeapon()) {
                    graphics.method_25303(FONT, weaponAt.getCurrentAmmo() + "/" + weaponAt.getMaxAmmo(), 16, newYPos + 14, 0xE6E600);
                } else {
                    graphics.method_27535(FONT, SAFETY, 16, newYPos + 14, 0xFF5555);
                }
                graphics.method_27535(FONT, (class_2561)((WeaponStats)weaponAt.getStats()).getDisplayNameComponent(), 16, newYPos + 4, 0xFFFFFF);
                graphics.method_51448().method_22909();
            }
            VehicleWeaponsOverlay.renderSelectionBox(graphics, 13.0, yPlacement, blitPosition + 2);
            --this.weaponChangeCountdown;
        }
    }

    @Override
    @NotNull
    protected String componentId() {
        return "dscombat_weapons";
    }

    public void queueWeaponChange() {
        this.weaponChangeQueued = true;
    }

    public void enableWeaponChangeState() {
        this.weaponChangeCountdown = 200;
        this.weaponChangeState = true;
        VehicleWeaponsOverlay.getPlayer().method_43077((class_3414)class_3417.field_15015.comp_349());
    }

    protected static void drawFinishedTab(class_332 graphics, WeaponInstance<?> selectedWeapon, double yPlacement, int blitPosition) {
        if (selectedWeapon == null) {
            return;
        }
        VehicleWeaponsOverlay.drawWeaponName(graphics, (class_2561)((WeaponStats)selectedWeapon.getStats()).getDisplayNameComponent(), 13.0, yPlacement, blitPosition - 2);
        VehicleWeaponsOverlay.drawTab(graphics, 13.0, yPlacement, blitPosition, 0, false);
        VehicleWeaponsOverlay.drawWeapon(graphics, selectedWeapon, 13.0, yPlacement, blitPosition + 1, 0, false, false, false);
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416(0.0f, 0.0f, (float)(blitPosition + 2));
        if (!((WeaponStats)selectedWeapon.getStats()).isNoWeapon()) {
            graphics.method_25303(FONT, selectedWeapon.getCurrentAmmo() + "/" + selectedWeapon.getMaxAmmo(), 16, (int)(yPlacement + 14.0), 0xE6E600);
        }
        graphics.method_25303(FONT, ((WeaponStats)selectedWeapon.getStats()).getWeaponTypeCode(), 16, (int)yPlacement + 4, 0xE6E600);
        graphics.method_51448().method_22909();
    }

    protected static void drawTab(class_332 graphics, double x, double y, int blitOffset, int frame, boolean scrollsUpward) {
        if (frame < 0 || frame > VehicleWeaponsOverlay.getMaxFrames() - 1) {
            throw new IllegalArgumentException("There are only " + VehicleWeaponsOverlay.getMaxFrames() + " frames!");
        }
        float sign = scrollsUpward ? -1.0f : 1.0f;
        graphics.method_51448().method_22903();
        graphics.method_51448().method_22904(x, y, (double)blitOffset);
        RenderSystem.setShaderTexture((int)0, (class_2960)WEAPON_TABS);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        graphics.method_25290(WEAPON_TABS, 0, 0, 0.0f, sign * FRAMES[frame], 93, 24, 93, 24);
        RenderSystem.disableBlend();
        RenderSystem.disableDepthTest();
        graphics.method_51448().method_22909();
    }

    protected static void drawWeapon(class_332 graphics, WeaponInstance<?> weapon, double x, double y, int blitOffset, int frame, boolean scrollsUpward, boolean scrollsToBlank, boolean scrollsFromBlank) {
        if (frame < 0 || frame > VehicleWeaponsOverlay.getMaxFrames() - 1) {
            throw new IllegalArgumentException("There are only " + VehicleWeaponsOverlay.getMaxFrames() + " frames!");
        }
        if (scrollsToBlank && scrollsFromBlank) {
            throw new IllegalArgumentException("Tabs may not scroll to and from blank!");
        }
        if (weapon == null) {
            throw new NullPointerException("Passed weapon is null!");
        }
        int frameValue = (int)FRAMES[frame];
        class_2960 rl = ((WeaponStats)weapon.getStats()).getWeaponIcon();
        RenderSystem.setShaderTexture((int)0, (class_2960)rl);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        graphics.method_51448().method_22903();
        if (scrollsUpward) {
            graphics.method_51448().method_22904(x, y + (double)frameValue, (double)blitOffset);
            if (scrollsFromBlank) {
                VehicleWeaponsOverlay.blitWithoutTop(graphics, 24 - frameValue, rl);
            }
            if (scrollsToBlank) {
                VehicleWeaponsOverlay.blitWithoutBottom(graphics, frameValue, rl);
            }
        } else {
            graphics.method_51448().method_22904(x, y - (double)frameValue, (double)blitOffset);
            if (scrollsFromBlank) {
                VehicleWeaponsOverlay.blitWithoutBottom(graphics, 24 - frameValue, rl);
            }
            if (scrollsToBlank) {
                VehicleWeaponsOverlay.blitWithoutTop(graphics, frameValue, rl);
            }
        }
        if (!scrollsFromBlank && !scrollsToBlank) {
            VehicleWeaponsOverlay.blitNormal(graphics, rl);
        }
        graphics.method_51448().method_22909();
        RenderSystem.disableBlend();
        RenderSystem.disableDepthTest();
    }

    protected static void drawWeaponName(class_332 graphics, class_2561 name, double x, double y, int blitOffset) {
        graphics.method_51448().method_22903();
        Matrix4f matrix4f = graphics.method_51448().method_23760().method_23761();
        int nameWidth = FONT.method_27525((class_5348)name);
        Objects.requireNonNull(FONT);
        int nameHeight = 9;
        int blitOffsetUnder = blitOffset - 1;
        int xPosInitial = (int)x + 1;
        int xPosFinal = xPosInitial + nameWidth + 6;
        int yPosInitial = (int)y - 12;
        int yPosFinal = yPosInitial + nameHeight + 5;
        class_1921 renderType = class_1921.method_51785();
        graphics.method_51740(renderType, xPosInitial - 1, yPosInitial, xPosInitial, yPosFinal + 1, blitOffsetUnder, -267386864, -267386864);
        graphics.method_51740(renderType, xPosInitial, yPosInitial, xPosFinal, yPosFinal, blitOffsetUnder, -267386864, -267386864);
        graphics.method_51740(renderType, xPosInitial, yPosInitial - 1, xPosFinal, yPosInitial, blitOffsetUnder, -267386864, -267386864);
        graphics.method_51740(renderType, xPosInitial, yPosFinal, xPosFinal, yPosFinal + 1, blitOffsetUnder, -267386864, -267386864);
        graphics.method_51740(renderType, xPosFinal, yPosInitial, xPosFinal + 1, yPosFinal, blitOffsetUnder, -267386864, -267386864);
        graphics.method_51740(renderType, xPosInitial, yPosInitial + 1, xPosInitial + 1, yPosFinal - 1, blitOffsetUnder, 0x505000FF, 1344798847);
        graphics.method_51740(renderType, xPosFinal - 1, yPosInitial + 1, xPosFinal, yPosFinal - 1, blitOffsetUnder, 0x505000FF, 1344798847);
        graphics.method_51740(renderType, xPosInitial, yPosInitial, xPosFinal, yPosInitial + 1, blitOffsetUnder, 0x505000FF, 0x505000FF);
        graphics.method_51740(renderType, xPosInitial, yPosFinal - 1, xPosFinal, yPosFinal, blitOffsetUnder, 1344798847, 1344798847);
        class_4597.class_4598 bufferSource = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        graphics.method_51448().method_22904(x, y - 11.0, (double)blitOffset);
        FONT.method_30882(name, 4.0f, 2.0f, -1, true, matrix4f, (class_4597)bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
        bufferSource.method_22993();
        graphics.method_51448().method_22909();
    }

    protected static void renderSelectionBox(class_332 graphics, double x, double y, int blitOffset) {
        RenderSystem.setShaderTexture((int)0, (class_2960)SELECTOR);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        graphics.method_51448().method_22903();
        graphics.method_51448().method_22904(x, y, (double)blitOffset);
        graphics.method_25290(SELECTOR, 0, 0, 0.0f, 0.0f, 93, 24, 93, 24);
        graphics.method_51448().method_22909();
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
    }

    protected static void blitNormal(class_332 graphics, class_2960 rl) {
        graphics.method_25290(rl, 0, 0, 0.0f, 0.0f, 93, 24, 93, 24);
    }

    protected static void blitWithoutTop(class_332 graphics, int trimPixels, class_2960 rl) {
        graphics.method_25290(rl, 0, trimPixels, 0.0f, (float)trimPixels, 93, 24 - trimPixels, 93, 24);
    }

    protected static void blitWithoutBottom(class_332 graphics, int trimPixels, class_2960 rl) {
        graphics.method_25290(rl, 0, 0, 0.0f, 0.0f, 93, 24 - trimPixels, 93, 24);
    }

    protected static int getMaxFrames() {
        return FRAMES.length;
    }
}

