/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.renderer;

import com.onewhohears.dscombat.client.entityscreen.EntityScreenTypes;
import com.onewhohears.dscombat.client.entityscreen.instance.EntityScreenInstance;
import com.onewhohears.onewholibs.util.math.QuaternionF;
import com.onewhohears.onewholibs.util.math.Vec3f;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntSet;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_4587;
import net.minecraft.class_4597;

public interface EntityScreenRenderer<T extends class_1297> {
    public static final Int2ObjectMap<EntityScreenInstance> screenInstances = new Int2ObjectOpenHashMap();

    public static void clearCache() {
        for (EntityScreenInstance screen : screenInstances.values()) {
            screen.close();
        }
        screenInstances.clear();
    }

    public static EntityScreenInstance getOrCreateEntityScreenById(int screenId, int screenType) {
        if (screenInstances.containsKey(screenId)) {
            return (EntityScreenInstance)screenInstances.get(screenId);
        }
        EntityScreenInstance screen = ((EntityScreenTypes.EntityScreenFactory)EntityScreenTypes.screenTypes.get(screenType)).create(screenId);
        screenInstances.put(screenId, (Object)screen);
        return screen;
    }

    public static int getFreeScreenId(int min) {
        int id = min;
        IntSet keys = screenInstances.keySet();
        while (keys.contains(++id)) {
        }
        return id;
    }

    public boolean shouldRenderScreens(T var1);

    default public void renderScreen(T entity, int screenId, int screenType, class_4587 poseStack, class_4597 buffer, float partialTicks, int packedLight, class_243 pos, float width, float height, float xRot, float yRot, float zRot) {
        if (screenId == -1) {
            return;
        }
        poseStack.method_22903();
        poseStack.method_22904(pos.field_1352, pos.field_1351, pos.field_1350);
        QuaternionF q = Vec3f.XP.rotationDegrees(xRot);
        q.mul(Vec3f.YP.rotationDegrees(yRot));
        q.mul(Vec3f.ZP.rotationDegrees(zRot + 180.0f));
        poseStack.method_22907(q.convert());
        poseStack.method_22905(width, height, 1.0f);
        EntityScreenRenderer.getOrCreateEntityScreenById(screenId, screenType).draw((class_1297)entity, poseStack, buffer, partialTicks, packedLight, width, height);
        poseStack.method_22909();
    }
}

