/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.onewhohears.dscombat.common.container.menu.VehicleBlockContainerMenu;
import com.onewhohears.dscombat.common.network.toserver.ToServerCraftPlane;
import com.onewhohears.dscombat.crafting.VehicleRecipe;
import com.onewhohears.dscombat.data.vehicle.VehiclePresets;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.onewholibs.util.UtilItem;
import com.onewhohears.onewholibs.util.UtilMCText;
import com.onewhohears.onewholibs.util.math.Vec3f;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1263;
import net.minecraft.class_156;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_344;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class VehicleBlockScreen
extends class_465<VehicleBlockContainerMenu> {
    private static final class_2960 BG_TEXTURE = new class_2960("dscombat", "textures/ui/vehicle_forge_ui.png");
    private final int bg_tex_size;
    private AircraftTab tab = AircraftTab.TANKS;
    private List<Integer> fails = new ArrayList<Integer>();

    public VehicleBlockScreen(VehicleBlockContainerMenu menu, class_1661 playerInv, class_2561 title) {
        super((class_1703)menu, playerInv, title);
        this.field_2792 = 352;
        this.field_2779 = 260;
        this.bg_tex_size = 512;
        this.field_25267 = 122;
        this.field_25268 = 24;
        this.field_25269 = 96;
        this.field_25270 = 146;
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(graphics);
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        this.method_2380(graphics, mouseX, mouseY);
        this.renderBookmark(graphics, mouseX, mouseY, partialTicks);
        this.renderIngredients(graphics, mouseX, mouseY, partialTicks);
        this.renderVehicle(graphics, mouseX, mouseY, partialTicks);
    }

    protected void method_2389(class_332 graphics, float f, int i, int j) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)BG_TEXTURE);
        graphics.method_25290(BG_TEXTURE, this.field_2776, this.field_2800, 0.0f, 0.0f, this.field_2792, this.field_2779, this.bg_tex_size, this.bg_tex_size);
    }

    protected void renderBookmark(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)BG_TEXTURE);
        graphics.method_25290(BG_TEXTURE, this.field_2776 + this.tab.getBookmarkXPos(), this.field_2800, 352.0f, 0.0f, 7, 11, this.bg_tex_size, this.bg_tex_size);
    }

    protected void renderVehicle(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        VehicleRecipe ap = this.tab.getSelectedRecipe();
        if (ap == null) {
            return;
        }
        class_1799 stack = ap.method_8110(this.field_22787.field_1687.method_30349());
        int posX = this.field_2776 + 170;
        int posY = this.field_2800 + 52;
        class_4587 modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.method_22903();
        float scale = 3.0f;
        float scaleInv = 1.0f / scale;
        modelViewStack.method_22905(scale, scale, scale);
        float blitOffset = 150.0f;
        modelViewStack.method_46416((float)(posX + 8) * scaleInv, 0.0f, blitOffset);
        long time = class_156.method_658();
        float spinRate = 0.1f;
        modelViewStack.method_22907(Vec3f.YP.rotationDegrees((float)time * spinRate).convert());
        modelViewStack.method_46416((float)(-(posX + 8)) * scaleInv, 0.0f, -blitOffset);
        modelViewStack.method_46416((float)(posX + 8) * (scaleInv - 1.0f), (float)(posY + 8) * (scaleInv - 1.0f), 0.0f);
        graphics.method_51427(stack, posX, posY);
        modelViewStack.method_22909();
    }

    protected void renderIngredients(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        VehicleRecipe ap = this.tab.getSelectedRecipe();
        if (ap == null) {
            return;
        }
        class_310 m = class_310.method_1551();
        class_2371<class_1856> ingredients = ap.method_8117();
        for (int i = 0; i < ((VehicleBlockContainerMenu)this.method_17577()).recipeSlots.method_5439(); ++i) {
            if (i < ingredients.size()) {
                class_1799[] items = ((class_1856)ingredients.get(i)).method_8105();
                class_1799 stack = items.length == 0 ? class_1802.field_8077.method_7854() : items[m.field_1724.field_6012 / 20 % items.length];
                ((VehicleBlockContainerMenu)this.method_17577()).recipeSlots.method_5447(i, stack);
                if (!this.fails.contains(i)) continue;
                class_1735 slot = ((VehicleBlockContainerMenu)this.method_17577()).method_7611(i);
                int left = this.field_2776 + slot.field_7873;
                int top = this.field_2800 + slot.field_7872;
                graphics.method_25294(left, top, left + 17, top + 17, 0x77FF0000);
                continue;
            }
            ((VehicleBlockContainerMenu)this.method_17577()).recipeSlots.method_5447(i, class_1799.field_8037);
        }
    }

    protected void method_2388(class_332 graphics, int mouseX, int mouseY) {
        graphics.method_27535(this.field_22793, this.field_29347, this.field_25269, this.field_25270, 0x404040);
        VehicleRecipe ar = this.tab.getSelectedRecipe();
        if (ar == null) {
            return;
        }
        VehicleStats ap = ar.getVehicleStats();
        if (ap == null) {
            return;
        }
        class_5250 name = ap.getDisplayNameComponent();
        int nameWidth = this.field_22793.method_27525((class_5348)name);
        graphics.method_27535(this.field_22793, (class_2561)name, this.field_25267 - nameWidth / 2 + 54, this.field_25268, 0);
        class_2487 data = ap.getDataAsNBT().method_10562("stats");
        float scale = 1.0f;
        graphics.method_51448().method_22905(scale, scale, scale);
        float invScale = 1.0f / scale;
        int startX = (int)(293.0f * invScale);
        int startY = (int)(34.0f * invScale);
        int pColor = 5046016;
        graphics.method_27535(this.field_22793, (class_2561)UtilMCText.translatable((String)"info.dscombat.health").method_27693(": " + data.method_10574("max_health")), startX, startY, pColor);
        Objects.requireNonNull(this.field_22793);
        graphics.method_27535(this.field_22793, (class_2561)UtilMCText.translatable((String)"info.dscombat.speed").method_27693(": " + (int)(data.method_10574("max_speed") * 20.0) + " m/s"), startX, startY += 9, pColor);
        Objects.requireNonNull(this.field_22793);
        graphics.method_27535(this.field_22793, (class_2561)UtilMCText.translatable((String)"info.dscombat.mass").method_27693(": " + data.method_10574("mass")), startX, startY += 9, pColor);
        Objects.requireNonNull(this.field_22793);
        graphics.method_27535(this.field_22793, (class_2561)UtilMCText.translatable((String)"info.dscombat.cross_sec_area").method_27693(": " + data.method_10574("cross_sec_area")), startX, startY += 9, pColor);
        Objects.requireNonNull(this.field_22793);
        graphics.method_27535(this.field_22793, (class_2561)UtilMCText.translatable((String)"info.dscombat.stealth").method_27693(": " + data.method_10574("stealth")), startX, startY += 9, pColor);
        Objects.requireNonNull(this.field_22793);
        graphics.method_27535(this.field_22793, (class_2561)UtilMCText.translatable((String)"info.dscombat.heat").method_27693(": " + data.method_10574("idleheat")), startX, startY += 9, pColor);
        Objects.requireNonNull(this.field_22793);
        graphics.method_27535(this.field_22793, (class_2561)UtilMCText.translatable((String)"info.dscombat.armor").method_27693(": " + data.method_10583("base_armor")), startX, startY += 9, pColor);
        Objects.requireNonNull(this.field_22793);
        graphics.method_27535(this.field_22793, (class_2561)UtilMCText.translatable((String)"info.dscombat.yaw_rate").method_27693(": " + (int)(data.method_10574("maxyaw") * 20.0) + " d/s"), startX, startY += 9, pColor);
        Objects.requireNonNull(this.field_22793);
        graphics.method_27535(this.field_22793, (class_2561)UtilMCText.translatable((String)"info.dscombat.pitch_rate").method_27693(": " + (int)(data.method_10574("maxpitch") * 20.0) + " d/s"), startX, startY += 9, pColor);
        Objects.requireNonNull(this.field_22793);
        graphics.method_27535(this.field_22793, (class_2561)UtilMCText.translatable((String)"info.dscombat.roll_rate").method_27693(": " + (int)(data.method_10574("maxroll") * 20.0) + " d/s"), startX, startY += 9, pColor);
        graphics.method_51448().method_22905(1.0f / scale, 1.0f / scale, 1.0f / scale);
    }

    protected void method_25426() {
        super.method_25426();
        class_344 tankButton = new class_344(0, 0, 45, 20, 83, 0, 300, BG_TEXTURE, 512, 512, onPress -> this.tabButton(AircraftTab.TANKS));
        tankButton.method_46421(this.field_2776 + 83);
        tankButton.method_46419(this.field_2800);
        this.method_37063((class_364)tankButton);
        class_344 heliButton = new class_344(0, 0, 45, 20, 130, 0, 300, BG_TEXTURE, 512, 512, onPress -> this.tabButton(AircraftTab.HELIS));
        heliButton.method_46421(this.field_2776 + 130);
        heliButton.method_46419(this.field_2800);
        this.method_37063((class_364)heliButton);
        class_344 planeButton = new class_344(0, 0, 45, 20, 177, 0, 300, BG_TEXTURE, 512, 512, onPress -> this.tabButton(AircraftTab.PLANES));
        planeButton.method_46421(this.field_2776 + 177);
        planeButton.method_46419(this.field_2800);
        this.method_37063((class_364)planeButton);
        class_344 boatButton = new class_344(0, 0, 45, 20, 224, 0, 300, BG_TEXTURE, 512, 512, onPress -> this.tabButton(AircraftTab.BOATS));
        boatButton.method_46421(this.field_2776 + 224);
        boatButton.method_46419(this.field_2800);
        this.method_37063((class_364)boatButton);
        class_344 prevButton = new class_344(0, 0, 41, 10, 78, 52, 230, BG_TEXTURE, 512, 512, onPress -> this.prevButton());
        prevButton.method_46421(this.field_2776 + 78);
        prevButton.method_46419(this.field_2800 + 52);
        this.method_37063((class_364)prevButton);
        class_344 nextButton = new class_344(0, 0, 41, 10, 233, 52, 230, BG_TEXTURE, 512, 512, onPress -> this.nextButton());
        nextButton.method_46421(this.field_2776 + 233);
        nextButton.method_46419(this.field_2800 + 52);
        this.method_37063((class_364)nextButton);
        class_4185 craftButton = new class_4185(0, 0, 80, 20, (class_2561)UtilMCText.translatable((String)"ui.dscombat.craft_button"), onPress -> this.craftButton(), Supplier::get);
        craftButton.method_46421(this.field_2776 + 140);
        craftButton.method_46419(this.field_2800 + 86);
        this.method_37063((class_364)craftButton);
    }

    private void tabButton(AircraftTab tab) {
        this.tab = tab;
        this.resetFails();
    }

    private void prevButton() {
        this.tab.cycleIndexLeft();
        this.resetFails();
    }

    private void nextButton() {
        this.tab.cycleIndexRight();
        this.resetFails();
    }

    private void craftButton() {
        this.resetFails();
        class_310 m = class_310.method_1551();
        class_746 player = m.field_1724;
        if (player == null) {
            return;
        }
        VehicleRecipe ap = this.tab.getSelectedRecipe();
        if (ap == null) {
            return;
        }
        if (ap.matches(player.method_31548(), (class_1937)m.field_1687)) {
            new ToServerCraftPlane(ap.method_8114(), ((VehicleBlockContainerMenu)this.field_2797).getPos()).sendToServer();
        } else {
            player.method_7353((class_2561)UtilMCText.translatable((String)"error.dscombat.cant_craft"), true);
            this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15008, (float)1.0f));
            this.setFails(UtilItem.testRecipeFails(ap.method_8117(), (class_1263)player.method_31548()));
        }
    }

    public void setFails(List<Integer> fails) {
        if (fails == null) {
            return;
        }
        this.fails = fails;
    }

    public void resetFails() {
        this.fails.clear();
    }

    public static enum AircraftTab {
        TANKS(() -> VehiclePresets.get().getTankRecipes(class_310.method_1551().field_1687.method_8433()), 86),
        HELIS(() -> VehiclePresets.get().getHeliRecipes(class_310.method_1551().field_1687.method_8433()), 133),
        PLANES(() -> VehiclePresets.get().getPlaneRecipes(class_310.method_1551().field_1687.method_8433()), 180),
        BOATS(() -> VehiclePresets.get().getBoatRecipes(class_310.method_1551().field_1687.method_8433()), 227);

        private final int bookmarkX;
        private AircraftPresetList presetFactory;
        private int index = 0;

        private AircraftTab(AircraftPresetList presetFactory, int bookmarkX) {
            this.presetFactory = presetFactory;
            this.bookmarkX = bookmarkX;
        }

        public VehicleRecipe[] getRecipes() {
            return this.presetFactory.get();
        }

        public int getIndex() {
            return this.checkIndex();
        }

        private int checkIndex() {
            if (this.getRecipes().length == 0) {
                this.index = -1;
            } else if (this.index >= this.getRecipes().length) {
                this.index = this.getRecipes().length - 1;
            } else if (this.index < 0) {
                this.index = 0;
            }
            return this.index;
        }

        @Nullable
        public VehicleRecipe getSelectedRecipe() {
            if (this.checkIndex() == -1) {
                return null;
            }
            return this.getRecipes()[this.getIndex()];
        }

        public int cycleIndexRight() {
            ++this.index;
            if (this.index >= this.getRecipes().length) {
                this.index = 0;
            }
            return this.index;
        }

        public int cycleIndexLeft() {
            --this.index;
            if (this.index < 0) {
                this.index = this.getRecipes().length - 1;
            }
            return this.index;
        }

        public int getBookmarkXPos() {
            return this.bookmarkX;
        }
    }

    public static interface AircraftPresetList {
        public VehicleRecipe[] get();
    }
}

