/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.common.network.toclient;

import com.onewhohears.dscombat.common.network.PacketHandler;
import com.onewhohears.dscombat.entity.parts.EntityTurret;
import com.onewhohears.dscombat.entity.parts.EntityWeaponRack;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.util.UtilClientPacket;
import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.networking.simple.MessageType;
import net.minecraft.class_1297;
import net.minecraft.class_2540;

public class ToClientOnShoot
extends BaseS2CMessage {
    public final int vehicleId;
    public final int shooterId;
    public final UtilClientPacket.ShootType type;

    public static void onShootWeaponRack(EntityWeaponRack rack, class_1297 shooter) {
        if (rack.isClientSide()) {
            return;
        }
        PacketHandler.sendToTrackers(new ToClientOnShoot(rack.method_5628(), shooter.method_5628(), UtilClientPacket.ShootType.WEAPON_RACK), (class_1297)rack);
    }

    public static void onShootTurret(EntityTurret turret, class_1297 shooter) {
        if (turret.isClientSide()) {
            return;
        }
        PacketHandler.sendToTrackers(new ToClientOnShoot(turret.method_5628(), shooter.method_5628(), UtilClientPacket.ShootType.TURRET), (class_1297)turret);
    }

    public static void onShootFlareRack(EntityVehicle vehicle, class_1297 shooter) {
        if (vehicle.getWorld().method_8608()) {
            return;
        }
        PacketHandler.sendToTrackers(new ToClientOnShoot(vehicle.method_5628(), shooter.method_5628(), UtilClientPacket.ShootType.FLARE), (class_1297)vehicle);
    }

    public static void onShootChaffRack(EntityVehicle vehicle, class_1297 shooter) {
        if (vehicle.getWorld().method_8608()) {
            return;
        }
        PacketHandler.sendToTrackers(new ToClientOnShoot(vehicle.method_5628(), shooter.method_5628(), UtilClientPacket.ShootType.CHAFF), (class_1297)vehicle);
    }

    private ToClientOnShoot(int vehicleId, int shooterId, UtilClientPacket.ShootType type) {
        this.vehicleId = vehicleId;
        this.shooterId = shooterId;
        this.type = type;
    }

    public ToClientOnShoot(class_2540 buffer) {
        this.vehicleId = buffer.readInt();
        this.shooterId = buffer.readInt();
        this.type = (UtilClientPacket.ShootType)buffer.method_10818(UtilClientPacket.ShootType.class);
    }

    public MessageType getType() {
        return PacketHandler.S2C_ON_SHOOT;
    }

    public void write(class_2540 buffer) {
        buffer.writeInt(this.vehicleId);
        buffer.writeInt(this.shooterId);
        buffer.method_10817((Enum)this.type);
    }

    public void handle(NetworkManager.PacketContext context) {
        context.queue(() -> UtilClientPacket.onShoot(this.vehicleId, this.shooterId, this.type));
    }
}

