/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.crafting;

import com.onewhohears.dscombat.data.parts.instance.PartInstance;
import com.onewhohears.dscombat.data.parts.stats.PartStats;
import com.onewhohears.dscombat.init.ModRecipes;
import com.onewhohears.dscombat.init.ModTags;
import com.onewhohears.dscombat.util.UtilPresetParse;
import com.onewhohears.onewholibs.util.UtilItem;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_7710;
import net.minecraft.class_8566;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VehiclePartRepairRecipe
extends class_1852 {
    public VehiclePartRepairRecipe(class_2960 id) {
        super(id, class_7710.field_40251);
    }

    public boolean matches(class_8566 container, class_1937 level) {
        if (this.getRepairTool(container) == null) {
            return false;
        }
        class_1799 partItem = this.getVehiclePart(container);
        if (partItem == null) {
            return false;
        }
        if (partItem.method_7947() != 1) {
            return false;
        }
        PartInstance<?> part = this.getPart(partItem);
        if (part == null) {
            return false;
        }
        if (!part.isDamaged()) {
            return false;
        }
        return UtilItem.testRecipe(((PartStats)part.getStats()).getRepairCost(), (class_1263)container);
    }

    @NotNull
    public class_1799 assemble(class_8566 container, class_5455 registry) {
        class_1799 partItem = this.getVehiclePart(container).method_7972();
        partItem.method_7948().method_10556("damaged", false);
        return partItem;
    }

    @NotNull
    public class_2371<class_1799> getRemainingItems(class_8566 container) {
        int repairIndex = this.getRepairToolIndex(container);
        class_1799 repairTool = container.method_5438(repairIndex).method_7972();
        repairTool.method_7974(repairTool.method_7919() + 5);
        class_1799 partItem = this.getVehiclePart(container);
        PartInstance<?> part = this.getPart(partItem);
        partItem.method_7939(0);
        class_2371 rem = UtilItem.getRemainingItemsStackIngredients((class_1263)container, ((PartStats)part.getStats()).getRepairCost());
        if (repairTool.method_7919() < repairTool.method_7936()) {
            rem.set(repairIndex, (Object)repairTool);
        } else {
            rem.set(repairIndex, (Object)class_1799.field_8037);
        }
        container.method_5448();
        return rem;
    }

    @Nullable
    public class_1799 getRepairTool(class_8566 container) {
        for (int i = 0; i < container.method_5439(); ++i) {
            if (!this.isRepairTool(container.method_5438(i))) continue;
            return container.method_5438(i);
        }
        return null;
    }

    protected int getRepairToolIndex(class_8566 container) {
        for (int i = 0; i < container.method_5439(); ++i) {
            if (!this.isRepairTool(container.method_5438(i))) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    public class_1799 getVehiclePart(class_8566 container) {
        class_1799 part = null;
        for (int i = 0; i < container.method_5439(); ++i) {
            if (!this.isVehiclePart(container.method_5438(i))) continue;
            if (part == null) {
                part = container.method_5438(i);
                continue;
            }
            return null;
        }
        return part;
    }

    public boolean isRepairTool(class_1799 stack) {
        return stack.method_31573(ModTags.Items.VEHICLE_REPAIR_TOOL);
    }

    public boolean isVehiclePart(class_1799 stack) {
        return stack.method_31573(ModTags.Items.VEHICLE_PART);
    }

    @Nullable
    public PartInstance<?> getPart(class_1799 stack) {
        return UtilPresetParse.parsePartFromItem(stack);
    }

    public boolean method_8113(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public class_1865<?> method_8119() {
        return (class_1865)ModRecipes.VEHICLE_PART_REPAIR.get();
    }
}

