/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.parts;

import com.mojang.logging.LogUtils;
import com.onewhohears.dscombat.data.parts.PartPresets;
import com.onewhohears.dscombat.data.parts.PartSlot;
import com.onewhohears.dscombat.data.parts.instance.FlareDispenserInstance;
import com.onewhohears.dscombat.data.parts.instance.FuelTankInstance;
import com.onewhohears.dscombat.data.parts.instance.PartInstance;
import com.onewhohears.dscombat.data.parts.instance.ReloadablePartInstance;
import com.onewhohears.dscombat.data.parts.instance.SeatInstance;
import com.onewhohears.dscombat.data.parts.instance.StorageInstance;
import com.onewhohears.dscombat.data.parts.stats.PartStats;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.util.UtilPresetParse;
import com.onewhohears.onewholibs.util.UtilEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class PartsManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int SLOT_VERSION = 1;
    public static final int SYNC_PARTS_RATE = 10;
    private final EntityVehicle parent;
    private List<PartSlot> slots = new ArrayList<PartSlot>();
    private class_1263 inventory = new class_1277(0);
    private boolean readData = false;
    private int storageIndex = -1;

    public PartsManager(EntityVehicle parent) {
        this.parent = parent;
    }

    public void read(class_2487 entityNbt, class_2487 presetNbt) {
        this.slots.clear();
        class_2499 entityNbtList = entityNbt.method_10554("slots", 10);
        class_2499 presetNbtList = presetNbt.method_10554("slots", 10);
        for (int i = 0; i < entityNbtList.size(); ++i) {
            class_2487 entitySlot = entityNbtList.method_10602(i);
            class_2487 presetSlot = this.findPresetSlot(entitySlot, presetNbtList);
            PartSlot slot = new PartSlot(entitySlot, presetSlot);
            this.slots.add(slot);
        }
        this.readData = true;
    }

    @Nullable
    private class_2487 findPresetSlot(class_2487 entitySlot, class_2499 presetNbtList) {
        String slotId = entitySlot.method_10558("name");
        for (int i = 0; i < presetNbtList.size(); ++i) {
            class_2487 presetSlot = presetNbtList.method_10602(i);
            String presetSlotId = presetSlot.method_10558("name");
            if (!PartSlot.getSlotId(slotId).equals(PartSlot.getSlotId(presetSlotId))) continue;
            return presetSlot;
        }
        return null;
    }

    private void createNewInventory() {
        this.inventory = new class_1277(this.slots.size()){

            public void method_5431() {
                super.method_5431();
            }

            public void method_5447(int i, class_1799 stack) {
                if (PartsManager.this.readData && !PartsManager.this.parent.isClientSide()) {
                    PartsManager.this.inventorySetItem(i, stack);
                }
                super.method_5447(i, stack);
            }

            @NotNull
            public class_1799 method_5434(int i, int count) {
                if (PartsManager.this.readData && !PartsManager.this.parent.isClientSide()) {
                    PartsManager.this.inventoryRemoveItem(i, count);
                }
                return super.method_5434(i, count);
            }

            public int method_5444() {
                return 1;
            }
        };
        for (int i = 0; i < this.slots.size(); ++i) {
            if (!this.slots.get(i).filled()) continue;
            this.inventory.method_5447(i, this.slots.get(i).getPartData().getNewItemStack());
        }
    }

    private void inventorySetItem(int i, class_1799 stack) {
        if (i < 0 || i >= this.slots.size()) {
            LOGGER.warn("WARNING! INDEX " + i + " IS OUT OF BOUNDS IN PARTS MANAGER " + String.valueOf(this));
            return;
        }
        PartSlot slot = this.slots.get(i);
        class_1309 pilot = null;
        if (slot.isPilotSlot()) {
            pilot = this.parent.method_5642();
        }
        if (stack.method_7960()) {
            slot.removePartData(this.parent);
            if (pilot != null && pilot.method_5854() == null) {
                SeatInstance<?> seatdata = this.getDefaultSeat();
                slot.addPartData(seatdata, this.parent);
                this.parent.rideAvailableSeat((class_1297)pilot);
            }
        } else {
            PartInstance<?> data = UtilPresetParse.parsePartFromItem(stack);
            if (data == null) {
                LOGGER.warn("ERROR! COULD NOT GET PART DATA FROM " + String.valueOf(stack) + " " + String.valueOf(stack.method_7969()));
                return;
            }
            if (slot.filled()) {
                slot.removePartData(this.parent);
            }
            slot.addPartData(data, this.parent);
            if (pilot != null && pilot.method_5854() == null) {
                this.parent.rideAvailableSeat((class_1297)pilot);
            }
        }
    }

    private void inventoryRemoveItem(int i, int count) {
        if (i < 0 || i >= this.slots.size()) {
            LOGGER.warn("WARNING! INDEX " + i + " IS OUT OF BOUNDS IN PARTS MANAGER " + String.valueOf(this));
            return;
        }
        class_1309 pilot = null;
        if (this.slots.get(i).isPilotSlot()) {
            pilot = this.parent.method_5642();
        }
        this.slots.get(i).removePartData(this.parent);
        if (pilot != null && pilot.method_5854() == null) {
            SeatInstance<?> seatdata = this.getDefaultSeat();
            this.slots.get(i).addPartData(seatdata, this.parent);
            this.parent.rideAvailableSeat((class_1297)pilot);
        }
    }

    public SeatInstance<?> getDefaultSeat() {
        return (SeatInstance)((PartStats)PartPresets.get().get("seat")).createPartInstance();
    }

    public void write(class_2487 compound) {
        class_2499 list = new class_2499();
        for (PartSlot s : this.slots) {
            list.add((Object)s.write());
        }
        compound.method_10566("slots", (class_2520)list);
    }

    public static List<PartSlot> readSlotsFromBuffer(class_2540 buffer) {
        ArrayList<PartSlot> ps = new ArrayList<PartSlot>();
        int num = buffer.readInt();
        for (int i = 0; i < num; ++i) {
            ps.add(new PartSlot(buffer));
        }
        return ps;
    }

    public static void writeSlotsToBuffer(class_2540 buffer, List<PartSlot> slots) {
        buffer.writeInt(slots.size());
        for (PartSlot p : slots) {
            p.write(buffer);
        }
    }

    public void setPartSlots(List<PartSlot> slots) {
        this.slots = slots;
        this.readData = true;
    }

    public void setupParts() {
        for (PartSlot p : this.slots) {
            p.serverSetup(this.parent);
        }
    }

    public void clientPartsSetup() {
        for (PartSlot p : this.slots) {
            p.clientSetup(this.parent);
        }
    }

    public void serverTickParts() {
        boolean syncParts = this.parent.field_6012 % 10 == 0;
        for (PartSlot p : this.slots) {
            p.serverTick();
            if (!syncParts) continue;
            p.checkDirtyToSync(this.parent);
        }
    }

    public void clientTickParts() {
        for (PartSlot p : this.slots) {
            p.clientTick();
        }
    }

    @Nullable
    public PartSlot getSlot(String slotId) {
        for (PartSlot p : this.slots) {
            if (!p.getSlotId().equals(slotId)) continue;
            return p;
        }
        return null;
    }

    public boolean killPartInSlot(String slotId) {
        PartSlot slot = this.getSlot(slotId);
        if (slot == null) {
            return false;
        }
        class_1309 pilot = null;
        if (slot.isPilotSlot()) {
            pilot = this.parent.method_5642();
        }
        slot.setPartDamaged(this.parent);
        if (pilot != null && pilot.method_5854() == null) {
            SeatInstance<?> seatdata = this.getDefaultSeat();
            slot.addPartData(seatdata, this.parent);
            this.parent.rideAvailableSeat((class_1297)pilot);
        }
        return true;
    }

    public void repairAllParts() {
        for (PartSlot p : this.slots) {
            p.setPartRepaired(this.parent);
        }
    }

    public boolean dropPartInSlot(String slotId) {
        PartSlot slot = this.getSlot(slotId);
        if (slot == null) {
            return false;
        }
        return slot.dropPartItem(this.parent);
    }

    public String toString() {
        Object s = "Parts:";
        for (int i = 0; i < this.slots.size(); ++i) {
            s = (String)s + this.slots.get(i).toString();
        }
        return (String)s + " client?" + this.parent.isClientSide();
    }

    public boolean isReadData() {
        return this.readData;
    }

    public float getPartsWeight() {
        float total = 0.0f;
        for (PartSlot p : this.slots) {
            if (!p.filled()) continue;
            float w = p.getPartData().getWeight();
            if (Float.isNaN(w)) {
                LOGGER.warn("ERROR: PART WEIGHT IS NAN " + p.toString());
                continue;
            }
            total += w;
        }
        return total;
    }

    public float getTotalPushThrust() {
        float total = 0.0f;
        for (PartSlot p : this.slots) {
            if (!p.filled()) continue;
            total += p.getPartData().getPushThrust((VehicleStats)this.parent.getStats());
        }
        return total;
    }

    public float getAfterburnerTotalPushThrust() {
        float total = 0.0f;
        for (PartSlot p : this.slots) {
            if (!p.filled()) continue;
            total += p.getPartData().getAfterburnerMaxPushThrust((VehicleStats)this.parent.getStats());
        }
        return total;
    }

    public float getTotalSpinThrust() {
        float total = 0.0f;
        for (PartSlot p : this.slots) {
            if (!p.filled()) continue;
            total += p.getPartData().getSpinThrust((VehicleStats)this.parent.getStats());
        }
        return total;
    }

    public float getTotalEngineHeat() {
        float total = 0.0f;
        for (PartSlot p : this.slots) {
            if (!p.filled()) continue;
            total += p.getPartData().getEngineHeat((VehicleStats)this.parent.getStats());
        }
        return total;
    }

    public float getTotalEngineFuelConsume() {
        float total = 0.0f;
        for (PartSlot p : this.slots) {
            if (!p.filled()) continue;
            total += p.getPartData().getFuelPerTick((VehicleStats)this.parent.getStats());
        }
        return total;
    }

    public float getCurrentFuel() {
        float total = 0.0f;
        for (PartSlot p : this.slots) {
            if (!p.filled()) continue;
            total += p.getPartData().getCurrentFuel();
        }
        return total;
    }

    public float getMaxFuel() {
        float total = 0.0f;
        for (PartSlot p : this.slots) {
            if (!p.filled()) continue;
            total += p.getPartData().getMaxFuel();
        }
        return total;
    }

    public float addFuel(float fuel) {
        if (fuel > 0.0f) {
            fuel = this.addFuel(fuel, false);
            fuel = this.addFuel(fuel, true);
        } else if (fuel < 0.0f) {
            fuel = this.addFuel(fuel, true);
            fuel = this.addFuel(fuel, false);
        }
        return fuel;
    }

    public float addFuel(float fuel, boolean external) {
        FuelTankInstance data;
        PartSlot p;
        Iterator<PartSlot> iterator = this.slots.iterator();
        while (!(!iterator.hasNext() || (p = iterator.next()).filled() && ((PartStats)p.getPartData().getStats()).isFuelTank() && !p.getSlotType().isExternal() ^ external && (fuel = (data = (FuelTankInstance)p.getPartData()).addFuel(fuel)) == 0.0f)) {
        }
        return fuel;
    }

    public boolean isFuelTankDamaged() {
        for (PartSlot p : this.slots) {
            if (!p.filled() || !((PartStats)p.getPartData().getStats()).isFuelTank() || !p.getPartData().isDamaged()) continue;
            return true;
        }
        return false;
    }

    public boolean isEngineDamaged() {
        for (PartSlot p : this.slots) {
            if (!p.filled() || !((PartStats)p.getPartData().getStats()).isEngine() || !p.getPartData().isDamaged()) continue;
            return true;
        }
        return false;
    }

    public boolean isAllEnginesDamaged() {
        boolean hasAnEngine = false;
        boolean hasDamagedEngine = false;
        for (PartSlot p : this.slots) {
            if (!p.filled() || !((PartStats)p.getPartData().getStats()).isEngine()) continue;
            hasAnEngine = true;
            if (!p.getPartData().isDamaged()) {
                return false;
            }
            hasDamagedEngine = true;
        }
        if (!hasAnEngine) {
            return true;
        }
        return hasDamagedEngine;
    }

    public Set<String> getEngineFireHitboxNames() {
        HashSet<String> names = new HashSet<String>();
        for (PartSlot p : this.slots) {
            if (!p.filled() || !((PartStats)p.getPartData().getStats()).isEngine() || !p.getPartData().isDamaged()) continue;
            names.add(p.getLinkedHitbox());
        }
        return names;
    }

    public void tickFuel() {
        float amount = -this.getTotalEngineFuelConsume() * Math.abs(this.parent.getCurrentThrottle());
        this.addFuel(amount);
    }

    public List<PartSlot> getFuelTanks() {
        ArrayList<PartSlot> tanks = new ArrayList<PartSlot>();
        for (PartSlot p : this.slots) {
            if (!p.filled() || !((PartStats)p.getPartData().getStats()).isFuelTank()) continue;
            tanks.add(p);
        }
        return tanks;
    }

    public List<PartSlot> getSlots() {
        return this.slots;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.slots.size(); ++i) {
            if (!this.slots.get(i).filled()) continue;
            return false;
        }
        return true;
    }

    public boolean dropPartItem() {
        if (this.parent.isClientSide()) {
            return false;
        }
        if (this.slots.isEmpty()) {
            return false;
        }
        for (int i = 0; i < this.slots.size(); ++i) {
            if (!this.slots.get(i).dropPartItem(this.parent)) continue;
            return true;
        }
        return false;
    }

    public void dropAllItems() {
        if (this.parent.isClientSide()) {
            return;
        }
        class_1264.method_5451((class_1937)this.parent.getWorld(), (class_2338)this.parent.method_24515().method_10086(1), (class_1263)this.getInventory());
        this.removeAllParts();
    }

    public void removeAllParts() {
        if (this.parent.isClientSide()) {
            return;
        }
        for (int i = 0; i < this.slots.size(); ++i) {
            if (this.slots.get(i).isSeat()) continue;
            this.slots.get(i).removePartData(this.parent);
        }
    }

    public class_1263 getInventory() {
        this.readData = false;
        this.createNewInventory();
        this.readData = true;
        return this.inventory;
    }

    public List<PartSlot> getFlares() {
        ArrayList<PartSlot> flares = new ArrayList<PartSlot>();
        for (PartSlot p : this.slots) {
            if (!p.filled() || !((PartStats)p.getPartData().getStats()).isFlareDispenser()) continue;
            flares.add(p);
        }
        return flares;
    }

    public boolean useFlares(boolean consume) {
        if (this.parent.getFlareNum() < 1) {
            return false;
        }
        for (PartSlot p : this.getFlares()) {
            if (!((FlareDispenserInstance)p.getPartData()).flare(consume)) continue;
            return true;
        }
        return false;
    }

    public int getNumFlares() {
        int num = 0;
        for (PartSlot p : this.slots) {
            if (!p.filled()) continue;
            num += p.getPartData().getFlares();
        }
        return num;
    }

    public int addFlares(int num) {
        for (PartSlot p : this.getFlares()) {
            FlareDispenserInstance fd = (FlareDispenserInstance)p.getPartData();
            num = fd.addFlares(num);
            if (num != 0) continue;
            return 0;
        }
        return num;
    }

    public List<PartSlot> getReloadableParts() {
        ArrayList<PartSlot> slots = new ArrayList<PartSlot>();
        for (PartSlot p : this.getSlots()) {
            if (!(p.getPartData() instanceof ReloadablePartInstance)) continue;
            slots.add(p);
        }
        return slots;
    }

    @Nullable
    public ReloadablePartInstance getReloadablePart(String slotId) {
        for (PartSlot p : this.getSlots()) {
            PartInstance<?> partInstance;
            if (!p.getSlotId().equals(slotId) || !((partInstance = p.getPartData()) instanceof ReloadablePartInstance)) continue;
            ReloadablePartInstance part = (ReloadablePartInstance)((Object)partInstance);
            return part;
        }
        return null;
    }

    public List<PartSlot> getExternalParts() {
        ArrayList<PartSlot> slots = new ArrayList<PartSlot>();
        for (PartSlot p : this.getSlots()) {
            if (p.getPartData() == null || !p.getPartData().canJetesin()) continue;
            slots.add(p);
        }
        return slots;
    }

    public float getTotalExtraArmor() {
        float armor = 0.0f;
        for (PartSlot p : this.slots) {
            if (!p.filled()) continue;
            armor += ((PartStats)p.getPartData().getStats()).getAdditionalArmor();
        }
        return armor;
    }

    public boolean hasGimbal() {
        for (PartSlot p : this.slots) {
            if (!p.filled() || !((PartStats)p.getPartData().getStats()).isGimbal()) continue;
            return true;
        }
        return false;
    }

    public int getStorageIndex() {
        return this.storageIndex;
    }

    public boolean hasStorageBoxes() {
        return !this.getStorageBoxes().isEmpty();
    }

    public int getStorageBoxesNum() {
        return this.getStorageBoxes().size();
    }

    public List<StorageInstance<?>> getStorageBoxes() {
        ArrayList list = new ArrayList();
        for (PartSlot p : this.slots) {
            if (!p.filled() || !((PartStats)p.getPartData().getStats()).isStorageBox()) continue;
            list.add((StorageInstance)p.getPartData());
        }
        return list;
    }

    @Nullable
    public StorageInstance<?> getStorageData(int index) {
        List<StorageInstance<?>> boxes = this.getStorageBoxes();
        if (boxes.isEmpty()) {
            this.storageIndex = -1;
            return null;
        }
        this.storageIndex = index;
        if (this.storageIndex <= -1) {
            this.storageIndex = boxes.size() - 1;
        } else if (this.storageIndex >= boxes.size()) {
            this.storageIndex = 0;
        }
        return boxes.get(this.storageIndex);
    }

    @Nullable
    public StorageInstance<?> cycleStorageData() {
        List<StorageInstance<?>> boxes = this.getStorageBoxes();
        if (boxes.isEmpty()) {
            this.storageIndex = -1;
            return null;
        }
        if (this.storageIndex == -1 || this.storageIndex >= boxes.size() - 1) {
            this.storageIndex = 0;
            return boxes.get(this.storageIndex);
        }
        return boxes.get(++this.storageIndex);
    }

    public List<PartSlot> getPartsLinkedToVehicleRoot() {
        ArrayList<PartSlot> parts = new ArrayList<PartSlot>();
        for (PartSlot p : this.slots) {
            if (!p.isLinkedWithVehicleRoot()) continue;
            parts.add(p);
        }
        return parts;
    }

    public List<PartSlot> getPartsLinkedToHitbox(String hitboxName) {
        ArrayList<PartSlot> parts = new ArrayList<PartSlot>();
        for (PartSlot p : this.slots) {
            if (!p.isLinkedToHitbox(hitboxName)) continue;
            parts.add(p);
        }
        return parts;
    }

    public void damageRootPart() {
        for (PartSlot p : this.getSlotsRandomOrder()) {
            if (!p.isLinkedWithVehicleRoot() || !p.canGetDamaged()) continue;
            p.setPartDamaged(this.parent);
            return;
        }
    }

    public void damageAllRootParts() {
        for (PartSlot p : this.slots) {
            if (!p.isLinkedWithVehicleRoot() || !p.canGetDamaged()) continue;
            p.setPartDamaged(this.parent);
        }
    }

    public void damageHitboxPart(String hitboxName) {
        for (PartSlot p : this.getSlotsRandomOrder()) {
            if (!p.isLinkedToHitbox(hitboxName) || !p.canGetDamaged()) continue;
            p.setPartDamaged(this.parent);
            return;
        }
    }

    public void damageAllHitboxParts(String hitboxName) {
        for (PartSlot p : this.slots) {
            if (!p.isLinkedToHitbox(hitboxName) || !p.canGetDamaged()) continue;
            p.setPartDamaged(this.parent);
        }
    }

    public void damageAllParts() {
        for (PartSlot p : this.slots) {
            if (!p.canGetDamaged()) continue;
            p.setPartDamaged(this.parent);
        }
    }

    public List<PartSlot> getSlotsRandomOrder() {
        ArrayList<PartSlot> random = new ArrayList<PartSlot>(this.slots);
        Collections.shuffle(random, UtilEntity.random);
        return random;
    }

    public class_243 calcRotInertialFromParts() {
        class_243 inertia = class_243.field_1353;
        for (PartSlot p : this.slots) {
            if (!p.getSlotType().isExternal() || p.getPartData() == null) continue;
            inertia = inertia.method_1019(p.getPartData().getRotInertia());
        }
        return inertia;
    }
}

