/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.parts.instance;

import com.onewhohears.dscombat.crafting.FlareDispenserLoadRecipe;
import com.onewhohears.dscombat.crafting.PartItemLoadRecipe;
import com.onewhohears.dscombat.crafting.PartItemUnloadRecipe;
import com.onewhohears.dscombat.data.parts.instance.PartInstance;
import com.onewhohears.dscombat.data.parts.instance.ReloadablePartInstance;
import com.onewhohears.dscombat.data.parts.stats.FlareDispenserStats;
import com.onewhohears.dscombat.entity.weapon.EntityFlare;
import com.onewhohears.onewholibs.util.UtilMCText;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;

public class FlareDispenserInstance<T extends FlareDispenserStats>
extends PartInstance<T>
implements ReloadablePartInstance {
    private int flares = 0;
    private static final PartItemLoadRecipe<?> LOAD_RECIPE = new FlareDispenserLoadRecipe(new class_2960("dscombat:flare_load_recipe"));

    public FlareDispenserInstance(T stats) {
        super(stats);
    }

    @Override
    public void setFilled(String param) {
        super.setFilled(param);
        this.flares = ((FlareDispenserStats)this.getStats()).getMaxFlares();
    }

    @Override
    public void readNBT(class_2487 tag) {
        super.readNBT(tag);
        this.flares = tag.method_10550("flares");
    }

    @Override
    public class_2487 writeNBT() {
        class_2487 tag = super.writeNBT();
        tag.method_10569("flares", this.flares);
        return tag;
    }

    @Override
    public void readBuffer(class_2540 buffer) {
        super.readBuffer(buffer);
        this.flares = buffer.readInt();
    }

    @Override
    public void writeBuffer(class_2540 buffer) {
        super.writeBuffer(buffer);
        buffer.writeInt(this.flares);
    }

    public int addFlares(int flares) {
        int max = ((FlareDispenserStats)this.getStats()).getMaxFlares();
        this.flares += flares;
        if (this.flares < 0) {
            int r = this.flares;
            this.flares = 0;
            return r;
        }
        if (this.flares > max) {
            int r = this.flares - max;
            this.flares = max;
            return r;
        }
        this.setDirty();
        return 0;
    }

    public void setFlares(int flares) {
        int max = ((FlareDispenserStats)this.getStats()).getMaxFlares();
        if (flares > max) {
            flares = max;
        } else if (flares < 0) {
            flares = 0;
        }
        this.flares = flares;
        this.setDirty();
    }

    @Override
    public int getFlares() {
        return this.flares;
    }

    public boolean flare(boolean consume) {
        if (this.isDamaged()) {
            return false;
        }
        if (this.getParent() == null) {
            return false;
        }
        if (this.getFlares() <= 0) {
            return false;
        }
        class_1937 level = this.getParent().getWorld();
        EntityFlare flare = new EntityFlare(level, ((FlareDispenserStats)this.getStats()).getInitHeat(), ((FlareDispenserStats)this.getStats()).getMaxAge(), 3.0f);
        flare.method_33574(this.getParent().method_19538().method_1019(this.getRelPos()));
        flare.method_18799(this.getParent().method_18798());
        level.method_8649((class_1297)flare);
        if (consume) {
            this.addFlares(-1);
        }
        return true;
    }

    @Override
    public float getCurrentAmmo() {
        return this.getFlares();
    }

    @Override
    public float getMaxAmmo() {
        return ((FlareDispenserStats)this.getStats()).getMaxFlares();
    }

    @Override
    public void setCurrentAmmo(float ammo) {
        this.setFlares((int)ammo);
    }

    @Override
    public void setMaxAmmo(float max) {
    }

    @Override
    public boolean isCompatibleWithAmmoContinuity(String continuity) {
        return true;
    }

    @Override
    public boolean updateContinuityIfEmpty() {
        return false;
    }

    @Override
    public void setContinuity(String continuity) {
    }

    @Override
    public String getContinuity() {
        return "";
    }

    @Override
    public PartItemLoadRecipe<?> getLoadRecipe() {
        return LOAD_RECIPE;
    }

    @Override
    public PartItemUnloadRecipe<?> getUnloadRecipe() {
        return null;
    }

    @Override
    public void addToolTips(List<class_2561> tips, class_1836 isAdvanced) {
        super.addToolTips(tips, isAdvanced);
        tips.add((class_2561)UtilMCText.translatable((String)"info.dscombat.ammo").method_27693(" " + (int)this.getCurrentAmmo() + "/" + (int)this.getMaxAmmo()).method_10862(class_2583.field_24360.method_36139(0xAAAAAA)));
    }
}

