/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.parts.stats;

import com.google.gson.JsonObject;
import com.onewhohears.dscombat.data.parts.PartType;
import com.onewhohears.dscombat.data.parts.SlotType;
import com.onewhohears.dscombat.data.parts.instance.PartInstance;
import com.onewhohears.onewholibs.data.crafting.IngredientStackBuilder;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetStats;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetType;
import com.onewhohears.onewholibs.util.UtilEntity;
import com.onewhohears.onewholibs.util.UtilItem;
import com.onewhohears.onewholibs.util.UtilMCText;
import com.onewhohears.onewholibs.util.UtilParse;
import java.util.List;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1836;
import net.minecraft.class_1856;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_4048;
import org.jetbrains.annotations.Nullable;

public abstract class PartStats
extends JsonPresetStats {
    private final float weight;
    private final float hitbox_width;
    private final float hitbox_height;
    private final String itemId;
    private final String externalEntityId;
    private final SlotType compatibleSlotType;
    private class_1792 item;
    private class_1299<?> externalEntityType;
    private class_2371<class_1856> repair_cost;
    private class_4048 dimensions;
    private class_2371<class_1856> ingredients;

    public PartStats(class_2960 key, JsonObject json) {
        super(key, json);
        this.weight = UtilParse.getFloatSafe((JsonObject)json, (String)"weight", (float)0.0f);
        this.itemId = UtilParse.getStringSafe((JsonObject)json, (String)"item", (String)"");
        this.externalEntityId = this.getExternalEntityId(json);
        this.compatibleSlotType = SlotType.getByName(UtilParse.getStringSafe((JsonObject)json, (String)"slotType", (String)""));
        this.hitbox_width = UtilParse.getFloatSafe((JsonObject)json, (String)"hitbox_width", (float)0.8f);
        this.hitbox_height = UtilParse.getFloatSafe((JsonObject)json, (String)"hitbox_height", (float)0.8f);
    }

    public boolean isCompatible(SlotType type) {
        if (type == null) {
            return false;
        }
        return this.compatibleSlotType.isCompatible(type);
    }

    public PartInstance<?> createPartInstance() {
        return (PartInstance)this.createPresetInstance();
    }

    public PartInstance<?> createFilledPartInstance(String param) {
        PartInstance filled = (PartInstance)this.createPresetInstance();
        filled.setFilled(param);
        return filled;
    }

    public float getWeight() {
        return this.weight;
    }

    public String getItemId() {
        return this.itemId;
    }

    public class_1792 getItem() {
        if (this.item == null) {
            this.item = UtilItem.getItem((String)this.itemId);
        }
        return this.item;
    }

    public class_2371<class_1856> getRepairCost() {
        if (this.repair_cost == null) {
            this.repair_cost = IngredientStackBuilder.getIngredients((JsonObject)this.getJsonData(), (String)"repair_cost");
        }
        return this.repair_cost;
    }

    public boolean hasExternalEntity() {
        return !this.externalEntityId.isEmpty();
    }

    @Nullable
    public class_1299<?> getExernalEntityType() {
        if (!this.hasExternalEntity()) {
            return null;
        }
        if (this.externalEntityType == null) {
            this.externalEntityType = UtilEntity.getEntityType((String)this.externalEntityId, this.getDefaultExternalEntity());
        }
        return this.externalEntityType;
    }

    @Nullable
    public class_1299<?> getDefaultExternalEntity() {
        return null;
    }

    protected String getExternalEntityId(JsonObject json) {
        return UtilParse.getStringSafe((JsonObject)json, (String)"externalEntity", (String)"");
    }

    public void addToolTips(List<class_2561> tips, class_1836 isAdvanced) {
        tips.add((class_2561)UtilMCText.translatable((String)"info.dscombat.compatible").method_27693(": ").method_10862(class_2583.field_24360.method_36139(0xFFFF55)).method_10852((class_2561)UtilMCText.translatable((String)this.compatibleSlotType.getTranslatableName())));
        tips.add((class_2561)UtilMCText.translatable((String)"info.dscombat.mass").method_27693(": " + this.weight).method_10862(class_2583.field_24360.method_36139(0xAAAAAA)));
    }

    public float getExternalEntityDefaultHealth() {
        return 100000.0f;
    }

    public boolean isFlareDispenser() {
        return this.getType().is((JsonPresetType)PartType.FLARE_DISPENSER);
    }

    public boolean isGimbal() {
        return this.getType().is((JsonPresetType)PartType.GIMBAL);
    }

    public boolean isChainHook() {
        return this.getType().is((JsonPresetType)PartType.CHAIN_HOOK);
    }

    public boolean isRadio() {
        return false;
    }

    public boolean isEngine() {
        return false;
    }

    public boolean isSeat() {
        return false;
    }

    public boolean isStorageBox() {
        return false;
    }

    public boolean isFuelTank() {
        return false;
    }

    public float getAdditionalArmor() {
        return 0.0f;
    }

    public class_4048 getEntityDimensions() {
        if (this.dimensions == null) {
            this.dimensions = class_4048.method_18385((float)this.hitbox_width, (float)this.hitbox_height);
        }
        return this.dimensions;
    }

    public class_2371<class_1856> getIngredients() {
        if (this.ingredients == null) {
            this.ingredients = IngredientStackBuilder.getIngredients((JsonObject)this.getJsonData());
        }
        return this.ingredients;
    }

    public boolean isCraftableWeaponPart() {
        return false;
    }
}

