/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.radar;

import com.onewhohears.dscombat.DependencySafety;
import com.onewhohears.dscombat.client.input.DSCClientInputs;
import com.onewhohears.dscombat.command.DSCGameRules;
import com.onewhohears.dscombat.common.network.PacketHandler;
import com.onewhohears.dscombat.common.network.VehicleSyncAction;
import com.onewhohears.dscombat.common.network.toclient.ToClientRWRWarning;
import com.onewhohears.dscombat.common.network.toclient.ToClientRadarPings;
import com.onewhohears.dscombat.data.radar.RadarInstance;
import com.onewhohears.dscombat.data.radar.RadarStats;
import com.onewhohears.dscombat.data.radar.TrackableEntitiesManager;
import com.onewhohears.dscombat.data.weapon.instance.WeaponInstance;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.entity.weapon.EntityMissile;
import com.onewhohears.dscombat.init.DataSerializers;
import com.onewhohears.onewholibs.util.UtilEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RadarSystem {
    private final EntityVehicle parent;
    private boolean readData = false;
    private final List<RadarInstance<?>> radars = new ArrayList();
    private final List<EntityMissile<?>> rockets = new ArrayList();
    private final List<RadarStats.RadarPing> targets = new ArrayList<RadarStats.RadarPing>();
    private int selectedIndex = -1;
    private List<RadarStats.RadarPing> clientTargets = new ArrayList<RadarStats.RadarPing>();
    private int clientSelectedIndex = -1;
    private int clientSelectedTime = -21;
    public int clientPingRefreshTime = 0;
    public int clientRwrRefreshTime = 0;
    private final List<RadarStats.RadarPing> dataLinkBuffer = new ArrayList<RadarStats.RadarPing>();
    private final Map<Integer, RWRWarning> rwrWarnings = new HashMap<Integer, RWRWarning>();
    private boolean rwrMissile;
    private boolean rwrRadar;
    public boolean dataLink = false;

    public RadarSystem(EntityVehicle parent) {
        this.parent = parent;
    }

    public List<RadarInstance<?>> getRadars() {
        return this.radars;
    }

    public boolean hasDataLink() {
        return this.dataLink || this.parent.getWorld().method_8450().method_8355(DSCGameRules.DATA_LINK_ALWAYS_ON);
    }

    public void tick() {
        if (this.parent.isClientSide()) {
            this.clientTick();
        } else if (this.canServerTick()) {
            this.serverTick();
        }
    }

    public boolean canServerTick() {
        return this.parent.isOperational() && (this.parent.isStationaryRadar() || this.parent.isPlayerRiding() || this.parent.getWorld().method_8450().method_8355(DSCGameRules.MOBS_TICK_RADAR) && this.parent.isBotUsingRadar());
    }

    public void tickUpdateTargets() {
        RadarStats.RadarPing old = null;
        if (this.selectedIndex != -1 && this.selectedIndex < this.targets.size()) {
            old = this.targets.get(this.selectedIndex);
        }
        this.selectedIndex = -1;
        for (RadarInstance<?> r : this.radars) {
            r.tickUpdateTargets(this.parent, this.targets);
        }
        if (this.parent.field_6012 % 20 == 0) {
            this.updateDataLink();
        }
        if (old != null) {
            for (int i = 0; i < this.targets.size(); ++i) {
                if (this.targets.get((int)i).id != old.id) continue;
                this.selectedIndex = i;
                class_1297 class_12972 = this.getSelectedTarget();
                if (!(class_12972 instanceof EntityVehicle)) break;
                EntityVehicle plane = (EntityVehicle)class_12972;
                plane.lockedOnto((class_1297)this.parent);
                break;
            }
        }
        this.updateSemiActiveTrackMissiles();
        if (this.parent.field_6012 % 20 == 0) {
            if (this.parent.isStationaryRadar()) {
                this.parent.toTrackers(new ToClientRadarPings(this.parent.method_5628(), this.targets));
            } else {
                this.parent.toClientPassengers(new ToClientRadarPings(this.parent.method_5628(), this.targets));
            }
        }
    }

    protected void updateVisibility() {
        if (this.parent.getWorld().method_8608()) {
            return;
        }
        if (!this.parent.isPlayerRiding()) {
            TrackableEntitiesManager.addTrackableEntity((class_1297)this.parent);
            DependencySafety.addExtraEntityToRDP(Objects.requireNonNull(this.parent.method_5682()), (class_1297)this.parent, new class_3222[0]);
        } else {
            TrackableEntitiesManager.removeTrackableEntity((class_1297)this.parent);
        }
    }

    public void onParentRemove() {
        if (this.parent.getWorld().method_8608()) {
            return;
        }
        TrackableEntitiesManager.removeTrackableEntity((class_1297)this.parent);
    }

    protected void updateDataLink() {
        if (this.parent.getWorld().method_8608()) {
            return;
        }
        this.refreshDataLink();
        if (!this.hasDataLink()) {
            return;
        }
        class_1297 controller = this.parent.getControllingPlayerOrBot();
        boolean check_equals = true;
        if (this.parent.isStationaryRadar() && controller == null) {
            controller = this.parent.getOwner();
            check_equals = false;
        }
        if (controller == null) {
            return;
        }
        class_3222 playerController = null;
        if (controller instanceof class_3222) {
            class_3222 sp;
            playerController = sp = (class_3222)controller;
        }
        List players = this.parent.getWorld().method_18456();
        for (class_1657 p : players) {
            Object object;
            if (check_equals && controller.equals((Object)p) || (playerController == null ? !controller.method_5722((class_1297)p) : !UtilEntity.arePlayersAllied((class_3222)playerController, (class_3222)((class_3222)p)))) continue;
            if (!UtilEntity.getLevel((class_1297)controller).method_27983().equals(UtilEntity.getLevel((class_1297)p).method_27983()) || !((object = p.method_5668()) instanceof EntityVehicle)) continue;
            EntityVehicle plane = (EntityVehicle)object;
            if (!plane.radarSystem.hasDataLink() || plane.equals(this.parent)) continue;
            object = this.targets.iterator();
            while (object.hasNext()) {
                RadarStats.RadarPing rp = (RadarStats.RadarPing)object.next();
                if (rp.id == plane.method_5628() || rp.isShared() || plane.radarSystem.hasDataLinkBuffer(rp.id)) continue;
                plane.radarSystem.dataLinkBuffer.add(rp.getCopy(true));
            }
        }
    }

    public int getClientPingIndexByEntityId(int id) {
        for (int i = 0; i < this.clientTargets.size(); ++i) {
            if (this.clientTargets.get((int)i).id != id) continue;
            return i;
        }
        return -1;
    }

    public boolean hasTargets() {
        return !this.targets.isEmpty();
    }

    public boolean hasTarget(class_1297 entity) {
        class_1297 v;
        if (this.hasTarget(entity.method_5628())) {
            return true;
        }
        return entity.method_5765() && this.hasTarget((v = entity.method_5668()).method_5628());
    }

    public boolean hasTarget(int id) {
        for (RadarStats.RadarPing rp : this.targets) {
            if (rp.id != id) continue;
            return true;
        }
        return false;
    }

    private boolean hasDataLinkBuffer(int id) {
        for (RadarStats.RadarPing rp : this.dataLinkBuffer) {
            if (rp.id != id) continue;
            return true;
        }
        return false;
    }

    private void refreshDataLink() {
        int i;
        for (i = 0; i < this.targets.size(); ++i) {
            if (!this.targets.get(i).isShared()) continue;
            this.targets.remove(i--);
        }
        for (i = 0; i < this.dataLinkBuffer.size(); ++i) {
            if (this.hasTarget(this.dataLinkBuffer.get((int)i).id)) continue;
            this.targets.add(this.dataLinkBuffer.get(i));
        }
        this.dataLinkBuffer.clear();
    }

    private void updateSemiActiveTrackMissiles() {
        for (int i = 0; i < this.rockets.size(); ++i) {
            EntityMissile<?> r = this.rockets.get(i);
            if (r.method_31481()) {
                this.rockets.remove(i--);
                continue;
            }
            boolean b = false;
            for (int j = 0; j < this.targets.size(); ++j) {
                if (this.targets.get((int)j).id != r.target.method_5628()) continue;
                r.targetPos = this.targets.get((int)j).pos;
                b = true;
                break;
            }
            if (b) continue;
            this.rockets.remove(i--);
            r.method_5768();
        }
    }

    public void addRocket(EntityMissile<?> r) {
        if (!this.rockets.contains(r)) {
            this.rockets.add(r);
        }
    }

    public void selectTarget(RadarStats.RadarPing ping) {
        this.selectTarget(ping.id);
    }

    public void selectTarget(int id) {
        this.selectedIndex = -1;
        for (int i = 0; i < this.targets.size(); ++i) {
            if (this.targets.get((int)i).id != id) continue;
            this.selectedIndex = i;
            break;
        }
    }

    public void selectTarget(class_1297 entity) {
        class_1297 v;
        this.selectedIndex = -1;
        if (this.hasTarget(entity.method_5628())) {
            this.selectTarget(entity.method_5628());
        } else if (entity.method_5765() && this.hasTarget((v = entity.method_5668()).method_5628())) {
            this.selectTarget(v.method_5628());
        }
    }

    @Nullable
    public class_1297 getSelectedTarget() {
        if (this.selectedIndex == -1) {
            return null;
        }
        int id = this.targets.get((int)this.selectedIndex).id;
        return this.parent.getWorld().method_8469(id);
    }

    @Nullable
    public RadarStats.RadarPing getServerSelectedPing() {
        if (this.selectedIndex == -1) {
            return null;
        }
        return this.targets.get(this.selectedIndex);
    }

    @Nullable
    public class_1309 getLivingTargetByWeapon(WeaponInstance<?> wd) {
        for (RadarStats.RadarPing ping : this.targets) {
            class_1297 entity;
            if (ping.isFriendly || !((entity = this.parent.getWorld().method_8469(ping.id)) instanceof class_1309)) continue;
            class_1309 target = (class_1309)entity;
            if (!wd.couldRadarWeaponTargetEntity(entity, (class_1297)this.parent)) continue;
            return target;
        }
        return null;
    }

    @Nullable
    public class_1657 getPlayerTargetByWeapon(WeaponInstance<?> wd) {
        for (RadarStats.RadarPing ping : this.targets) {
            class_1657 target;
            class_1657 target2;
            class_1297 entity;
            if (ping.isFriendly || (entity = this.parent.getWorld().method_8469(ping.id)) == null) continue;
            if (entity instanceof class_1657 && !(target2 = (class_1657)entity).method_7337() && wd.couldRadarWeaponTargetEntity(entity, (class_1297)this.parent)) {
                return target2;
            }
            class_1309 class_13092 = entity.method_5642();
            if (!(class_13092 instanceof class_1657) || (target = (class_1657)class_13092).method_7337() || !wd.couldRadarWeaponTargetEntity(entity, (class_1297)this.parent)) continue;
            return target;
        }
        return null;
    }

    public void clientSelectTarget(RadarStats.RadarPing ping) {
        this.clientSelectedIndex = -1;
        for (int i = 0; i < this.clientTargets.size(); ++i) {
            if (this.clientTargets.get((int)i).id != ping.id) continue;
            this.clientSelectTarget(i);
        }
    }

    public void clientSelectNextTarget() {
        int size = this.getClientRadarPings().size();
        if (size == 0) {
            return;
        }
        int k = 0;
        int s = this.clientSelectedIndex;
        while (k++ < size) {
            if (++s >= size) {
                s = 0;
            }
            if (this.getClientRadarPings().get((int)s).entityType.isMissile()) continue;
        }
        this.clientSelectTarget(s);
    }

    public void clientSelectTarget(int pingIndex) {
        if (pingIndex < 0 || pingIndex >= this.getClientRadarPings().size()) {
            return;
        }
        if (this.parent.field_6012 - this.clientSelectedTime < 2) {
            return;
        }
        this.clientSelectedIndex = pingIndex;
        this.parent.soundManager.playPassengerRadarLockSound();
        VehicleSyncAction.sendSyncAction(new VehicleSyncAction.PingSelectAction(this.clientTargets.get(pingIndex)));
        this.clientSelectedTime = this.parent.field_6012;
    }

    public int getClientSelectedPingIndex() {
        return this.clientSelectedIndex;
    }

    @NotNull
    public List<RadarStats.RadarPing> getClientRadarPings() {
        return this.clientTargets;
    }

    @Nullable
    public RadarStats.RadarPing getClientSelectedPing() {
        if (this.clientSelectedIndex < 0 || this.clientSelectedIndex >= this.getClientRadarPings().size()) {
            return null;
        }
        return this.getClientRadarPings().get(this.clientSelectedIndex);
    }

    public boolean isClientLocking() {
        return this.getClientSelectedPingIndex() != -1;
    }

    public void readClientPingsFromServer(List<RadarStats.RadarPing> pings) {
        this.removeUnwantedPings(pings);
        RadarStats.RadarPing oldSelect = null;
        if (this.clientSelectedIndex != -1) {
            oldSelect = this.clientTargets.get(this.clientSelectedIndex);
        }
        this.clientTargets = pings;
        this.clientSelectedIndex = -1;
        if (oldSelect != null) {
            int id = oldSelect.id;
            for (int i = 0; i < this.clientTargets.size(); ++i) {
                if (this.clientTargets.get((int)i).id != id) continue;
                this.clientSelectedIndex = i;
                break;
            }
        }
        this.updateClientPingPos();
        this.clientPingRefreshTime = this.parent.field_6012;
    }

    private void removeUnwantedPings(List<RadarStats.RadarPing> pings) {
        RadarStats.RadarMode mode = DSCClientInputs.getPreferredRadarMode();
        for (int i = 0; i < pings.size(); ++i) {
            if (!pings.get(i).dontDisplayByMode(mode)) continue;
            pings.remove(i--);
        }
    }

    public boolean hasRadar() {
        return this.radars.size() > 0;
    }

    public boolean hasRadar(String id) {
        for (RadarInstance<?> r : this.radars) {
            if (!r.getStatsId().equals(id)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public RadarInstance<?> get(String id, String slotId) {
        for (RadarInstance<?> r : this.radars) {
            if (!r.idMatch(id, slotId)) continue;
            return r;
        }
        return null;
    }

    public boolean addRadar(RadarInstance<?> r) {
        if (this.get(r.getStatsId(), r.getSlotId()) != null) {
            return false;
        }
        this.radars.add(r);
        return true;
    }

    public boolean removeRadar(String id, String slotId) {
        RadarInstance<?> radar = this.get(id, slotId);
        if (radar == null) {
            return false;
        }
        radar.resetPings(this.targets);
        return this.radars.remove(radar);
    }

    public double getMaxAirRange() {
        double max = 0.0;
        for (RadarInstance<?> r : this.radars) {
            if (!((RadarStats)r.getStats()).isScanAir() || !(((RadarStats)r.getStats()).getRange() > max)) continue;
            max = ((RadarStats)r.getStats()).getRange();
        }
        return max;
    }

    public String toString() {
        Object s = "Radars:";
        for (int i = 0; i < this.radars.size(); ++i) {
            s = (String)s + this.radars.get(i).toString();
        }
        return s;
    }

    public boolean isReadData() {
        return this.readData;
    }

    public void addRWRWarning(int fromId, class_243 pos, boolean isMissile, boolean fromGround) {
        if (this.parent == null || this.parent.isClientSide() || !this.hasRadar()) {
            return;
        }
        RWRWarning warning = new RWRWarning(fromId, pos, fromGround, isMissile);
        PacketHandler.sendToTrackers(new ToClientRWRWarning(this.parent.method_5628(), warning), (class_1297)this.parent);
    }

    public void readRWRWarningFromServer(RWRWarning warning) {
        if (this.rwrWarnings.containsKey(warning.fromId)) {
            RWRWarning w = this.rwrWarnings.get(warning.fromId);
            w.age = 0;
            w.pos = warning.pos;
        } else {
            this.rwrWarnings.put(warning.fromId, warning);
        }
        if (warning.isMissile) {
            this.rwrMissile = true;
        }
        this.rwrRadar = true;
        this.clientRwrRefreshTime = this.parent.field_6012;
    }

    public boolean isTrackedByMissile() {
        return this.rwrMissile;
    }

    public boolean isTrackedByRadar() {
        return this.rwrRadar;
    }

    public boolean clientConsumePingWarningSound() {
        return false;
    }

    public void serverTick() {
        this.tickUpdateTargets();
        this.updateVisibility();
    }

    public void clientTick() {
        this.ageRWR();
        this.updateClientPingPos();
    }

    private void ageRWR() {
        this.rwrRadar = false;
        this.rwrMissile = false;
        if (this.rwrWarnings.isEmpty()) {
            return;
        }
        Iterator<RWRWarning> it = this.rwrWarnings.values().iterator();
        while (it.hasNext()) {
            RWRWarning n = it.next();
            ++n.age;
            if (n.age <= 10) {
                if (n.isMissile) {
                    this.rwrMissile = true;
                }
                this.rwrRadar = true;
            }
            if (n.isMissile && n.age > 20) {
                it.remove();
                continue;
            }
            if (n.age <= 60) continue;
            it.remove();
        }
    }

    private void updateClientPingPos() {
        for (RadarStats.RadarPing ping : this.clientTargets) {
            ping.setClientPos(this.parent.getWorld());
        }
    }

    public boolean clientHasRWRWarnings() {
        return !this.rwrWarnings.isEmpty();
    }

    public Collection<RWRWarning> getClientRWRWarnings() {
        return this.rwrWarnings.values();
    }

    public int getJammedTicks() {
        if (!this.hasRadar()) {
            return 0;
        }
        return 0;
    }

    public static class RWRWarning {
        public final int fromId;
        public final boolean fromGround;
        public final boolean isMissile;
        public class_243 pos;
        public int age = 0;

        public RWRWarning(int fromId, class_243 pos, boolean fromGround, boolean isMissile) {
            this.fromId = fromId;
            this.pos = pos;
            this.fromGround = fromGround;
            this.isMissile = isMissile;
        }

        public RWRWarning(class_2540 buffer) {
            this.fromId = buffer.readInt();
            this.pos = (class_243)DataSerializers.VEC3.method_12716(buffer);
            this.fromGround = buffer.readBoolean();
            this.isMissile = buffer.readBoolean();
        }

        public void write(class_2540 buffer) {
            buffer.writeInt(this.fromId);
            DataSerializers.VEC3.method_12715(buffer, (Object)this.pos);
            buffer.writeBoolean(this.fromGround);
            buffer.writeBoolean(this.isMissile);
        }

        public String toString() {
            return "RWR[" + (int)this.pos.field_1352 + "," + (int)this.pos.field_1351 + "," + (int)this.pos.field_1350 + "]";
        }
    }
}

