/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.vehicle;

import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.data.sound.PassengerSoundPack;
import com.onewhohears.dscombat.data.sound.VehiclePassengerSoundPacks;
import com.onewhohears.dscombat.data.vehicle.VehicleLoopingSounds;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.init.ModSounds;
import com.onewhohears.dscombat.util.UtilClientSafeSounds;
import com.onewhohears.dscombat.util.UtilSound;
import com.onewhohears.dscombat.util.UtilVehicleEntity;
import net.minecraft.class_1282;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class VehicleSoundManager {
    private static final class_5819 RANDOM_SRC = class_5819.method_43047();
    public final EntityVehicle parent;
    private VehicleLoopingSounds loopManager;
    private int prevSonicBoomTime = -1;
    private boolean didSonicBoom;

    public VehicleSoundManager(EntityVehicle parent) {
        this.parent = parent;
    }

    public void loadSounds(VehicleStats acp) {
        class_2487 sounds = acp.getDataAsNBT().method_10562("sounds");
        String loopSoundType = sounds.method_10558("loopSoundType");
        this.loopManager = VehicleLoopingSounds.getByType(loopSoundType, this.parent);
        this.loopManager.loadPreset(sounds);
    }

    public void read(class_2487 nbt) {
        if (!nbt.method_10545("sounds")) {
            return;
        }
        class_2487 sounds = nbt.method_10562("sounds");
    }

    public void write(class_2487 nbt) {
        class_2487 sounds = new class_2487();
        nbt.method_10566("sounds", (class_2520)sounds);
    }

    public void read(class_2540 buffer) {
    }

    public void write(class_2540 buffer) {
    }

    public void onTick() {
        if (this.parent.isClientSide()) {
            this.onClientTick();
        } else {
            this.onServerTick();
        }
    }

    protected void onClientTick() {
        if (UtilClientSafeSounds.isClientRidingVehicle(this.parent)) {
            PassengerSoundPack pack = this.getPassengerSoundPack();
            if (pack != null) {
                pack.clientTickPassengerSounds(this.parent);
            }
        } else if (!this.didSonicBoom) {
            this.didSonicBoom = UtilClientSafeSounds.vehicleSonicBoom(this.parent);
        }
        this.tickLoopingSounds();
    }

    protected void tickLoopingSounds() {
        if (this.loopManager != null) {
            this.loopManager.baseTick();
        }
    }

    protected void onServerTick() {
    }

    public void onClientInit() {
    }

    @Nullable
    public PassengerSoundPack getPassengerSoundPack() {
        String selectedPack = (String)Config.CLIENT.passengerSoundPack.get();
        return (PassengerSoundPack)VehiclePassengerSoundPacks.get().get(selectedPack);
    }

    public void playPassengerRadarLockSound() {
        if (!this.parent.getWorld().method_8608()) {
            return;
        }
        PassengerSoundPack pack = this.getPassengerSoundPack();
        if (pack != null) {
            pack.playRadarLockSound();
        }
    }

    public void playPassengerRadarFoundSound() {
        if (!this.parent.getWorld().method_8608()) {
            return;
        }
        PassengerSoundPack pack = this.getPassengerSoundPack();
        if (pack != null) {
            pack.playRadarFoundSound();
        }
    }

    public void playPassengerFlareSound() {
        if (!this.parent.getWorld().method_8608()) {
            return;
        }
        PassengerSoundPack pack = this.getPassengerSoundPack();
        if (pack != null) {
            pack.playFlareSound();
        }
    }

    public void playPassengerChaffSound() {
        if (!this.parent.getWorld().method_8608()) {
            return;
        }
        PassengerSoundPack pack = this.getPassengerSoundPack();
        if (pack != null) {
            pack.playChaffSound();
        }
    }

    public void onHurt(class_1282 source, float amount) {
        if (this.parent.isClientSide() || !this.parent.isOperational()) {
            return;
        }
        float volume = class_3532.method_15363((float)(amount * 0.5f), (float)0.12f, (float)1.88f);
        float pitch = class_3532.method_15363((float)(1.0f + (RANDOM_SRC.method_43057() - 0.5f) / 2.94f), (float)0.83f, (float)1.17f);
        class_3414 forBroadcast = VehicleSoundManager.soundForHurt(source);
        UtilSound.sendDelayedSound((class_3218)this.parent.getWorld(), forBroadcast, this.parent.method_19538(), 160.0f, volume, pitch);
    }

    public void onRadioSongUpdate(String song) {
        if (!this.parent.isClientSide()) {
            return;
        }
        if (song.isEmpty()) {
            return;
        }
        UtilClientSafeSounds.aircraftRadio(this.parent, song);
    }

    public static class_3414 soundForHurt(class_1282 source) {
        class_3414 toReturn = UtilVehicleEntity.isProjectile(source) ? ModSounds.VEHICLE_HURT_PROJECTILE_METAL : ModSounds.VEHICLE_HURT_COLLISION_METAL;
        return toReturn;
    }
}

