/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.weapon;

import com.onewhohears.dscombat.DependencySafety;
import com.onewhohears.dscombat.entity.weapon.EntityMissile;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class NonTickingMissileManager {
    private static final List<EntityMissile<?>> missiles = new ArrayList();

    public static void serverTick(MinecraftServer server) {
        for (int i = 0; i < missiles.size(); ++i) {
            if (NonTickingMissileManager.tickMissile(missiles.get(i), server)) continue;
            missiles.remove(i--);
        }
    }

    private static boolean tickMissile(EntityMissile<?> missile, MinecraftServer server) {
        if (NonTickingMissileManager.isKilled(missile)) {
            return false;
        }
        class_1923 cp = missile.method_31476();
        boolean hasChunk = missile.getWorld().method_8393(cp.field_9181, cp.field_9180);
        boolean inTickRange = missile.inEntityTickingRange();
        int repeats = missile.getTickCountRepeats();
        if (hasChunk && inTickRange && repeats < 5) {
            if (NonTickingMissileManager.isUnloaded(missile)) {
                missile.invokeRevive();
                missile.method_5826(UUID.randomUUID());
                missile.getWorld().method_8649(missile);
            }
        } else {
            if (!missile.method_31481()) {
                missile.discardButTick();
            }
            missile.tickOutRange();
            DependencySafety.addExtraEntityToRDP(server, missile, new class_3222[0]);
        }
        return true;
    }

    private static boolean isKilled(EntityMissile<?> missile) {
        if (missile.isDiscardedButTicking()) {
            return false;
        }
        class_1297.class_5529 rr = missile.method_35049();
        if (rr == null) {
            return false;
        }
        return rr == class_1297.class_5529.field_26998 || rr == class_1297.class_5529.field_26999;
    }

    private static boolean isUnloaded(EntityMissile<?> missile) {
        if (missile.isDiscardedButTicking()) {
            return true;
        }
        class_1297.class_5529 rr = missile.method_35049();
        if (rr == null) {
            return false;
        }
        return rr == class_1297.class_5529.field_27002 || rr == class_1297.class_5529.field_27000 || rr == class_1297.class_5529.field_27001;
    }

    public static void addMissile(EntityMissile<?> missile) {
        missiles.add(missile);
    }

    public static List<EntityMissile<?>> getMissiles() {
        return missiles;
    }
}

