/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.weapon;

import com.onewhohears.dscombat.command.DSCGameRules;
import com.onewhohears.dscombat.data.weapon.instance.NoWeaponInstance;
import com.onewhohears.dscombat.data.weapon.instance.WeaponInstance;
import com.onewhohears.dscombat.data.weapon.stats.WeaponStats;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.onewholibs.util.UtilMCText;
import com.onewhohears.onewholibs.util.math.QuaternionF;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import com.onewhohears.onewholibs.util.math.Vec3f;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class WeaponSystem {
    private final EntityVehicle parent;
    private boolean readData = false;
    private List<WeaponInstance<?>> weapons = new ArrayList();
    private int weaponIndex = 0;
    private class_243 targetPos = class_243.field_1353;

    public WeaponSystem(EntityVehicle parent) {
        this.parent = parent;
        this.weapons.add(NoWeaponInstance.get());
    }

    public boolean addWeapon(WeaponInstance<?> data) {
        if (this.get(data.getStatsId(), data.getSlotId()) != null) {
            return false;
        }
        this.weapons.add(data);
        return true;
    }

    public boolean removeWeapon(String id, String slotId) {
        WeaponInstance<?> w = this.get(id, slotId);
        if (w == null) {
            return false;
        }
        if (((WeaponStats)w.getStats()).isNoWeapon()) {
            return false;
        }
        return this.weapons.remove(w);
    }

    @Nullable
    public WeaponInstance<?> get(String id, String slotId) {
        for (WeaponInstance<?> w : this.weapons) {
            if (!w.idMatch(id, slotId)) continue;
            return w;
        }
        return null;
    }

    @Nullable
    public WeaponInstance<?> get(String slotId) {
        for (WeaponInstance<?> w : this.weapons) {
            if (!w.getSlotId().equals(slotId)) continue;
            return w;
        }
        return null;
    }

    public WeaponInstance<?> getSelected() {
        this.checkIndex();
        return this.weapons.get(this.weaponIndex);
    }

    public int getSelectedIndex() {
        return this.weaponIndex;
    }

    public boolean shootSelected(class_1297 controller) {
        class_1657 p;
        boolean consume = true;
        if (this.parent.isNoConsume()) {
            consume = false;
        } else if (controller instanceof class_1657 && (p = (class_1657)controller).method_7337()) {
            consume = false;
        }
        boolean consumeAmmo = this.parent.getWorld().method_8450().method_8355(DSCGameRules.CONSUME_AMMO);
        return this.shootSelected(controller, consume && consumeAmmo);
    }

    public boolean shootSelected(class_1297 controller, boolean consume) {
        WeaponInstance<?> data = this.getSelected();
        if (data == null) {
            return false;
        }
        String name = data.getStatsId();
        String reason = null;
        data.shootFromVehicle(this.parent.getWorld(), controller, this.getShootDirection(data), this.parent, consume);
        if (data.isFailedLaunch()) {
            reason = data.getFailedLaunchReason();
        }
        for (WeaponInstance<?> wd : this.weapons) {
            if (!((WeaponStats)wd.getStats()).isBullet() || !wd.getStatsId().equals(name) || wd.getSlotId().equals(data.getSlotId())) continue;
            wd.shootFromVehicle(this.parent.getWorld(), controller, this.getShootDirection(wd), this.parent, consume);
            if (reason != null || !wd.isFailedLaunch()) continue;
            reason = wd.getFailedLaunchReason();
        }
        if (reason != null && controller instanceof class_3222) {
            class_3222 player = (class_3222)controller;
            player.method_7353((class_2561)UtilMCText.translatable((String)reason), true);
        }
        return true;
    }

    public class_243 getShootDirection(WeaponInstance<?> data) {
        QuaternionF q = this.parent.getQ();
        if (this.parent.isWeaponAngledDown() && ((WeaponStats)data.getStats()).canAngleDown()) {
            q.mul(Vec3f.XP.rotationDegrees(25.0f));
        }
        return UtilAngles.getRollAxis((QuaternionF)q);
    }

    public void selectNextWeapon(int input) {
        if (input == 1) {
            ++this.weaponIndex;
        } else if (input == -1) {
            --this.weaponIndex;
        } else {
            return;
        }
        this.checkIndex();
    }

    public void setSelected(int index) {
        this.weaponIndex = index;
        this.checkIndex();
    }

    private void checkIndex() {
        if (this.weaponIndex >= this.weapons.size()) {
            this.weaponIndex = 0;
        } else if (this.weaponIndex < 0) {
            this.weaponIndex = this.weapons.size() - 1;
        }
    }

    public void serverTick() {
        for (int i = 0; i < this.weapons.size(); ++i) {
            this.weapons.get(i).tick(this.parent, i == this.getSelectedIndex());
        }
    }

    public boolean isReadData() {
        return this.readData;
    }

    public List<WeaponInstance<?>> getWeapons() {
        return this.weapons;
    }

    public String toString() {
        Object s = "Weapons:";
        for (WeaponInstance<?> w : this.weapons) {
            s = (String)s + String.valueOf(w);
        }
        return s;
    }

    public int addAmmo(String id, int ammo, boolean updateClient) {
        for (WeaponInstance<?> w : this.weapons) {
            if (!w.getStatsId().equals(id)) continue;
            ammo = w.addAmmo(ammo);
            if (updateClient) {
                w.updateClientAmmo(this.parent);
            }
            if (ammo != 0) continue;
            return 0;
        }
        return ammo;
    }

    public void refillAll() {
        if (this.parent.isClientSide()) {
            return;
        }
        for (WeaponInstance<?> w : this.weapons) {
            w.addAmmo(100000);
            w.updateClientAmmo(this.parent);
        }
    }

    public class_243 getTargetPos() {
        return this.targetPos;
    }

    public void setTargetPos(class_243 targetPos) {
        this.targetPos = targetPos;
    }
}

