/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.weapon.stats;

import com.google.gson.JsonObject;
import com.onewhohears.dscombat.data.vehicle.physics.DSCPhyCons;
import com.onewhohears.dscombat.data.weapon.WeaponType;
import com.onewhohears.dscombat.data.weapon.instance.AntiRadarMissileInstance;
import com.onewhohears.dscombat.data.weapon.stats.MissileStats;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetInstance;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetType;
import com.onewhohears.onewholibs.util.UtilMCText;
import com.onewhohears.onewholibs.util.UtilParse;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;

public class AntiRadarMissileStats
extends MissileStats {
    private final double scan_range;

    public AntiRadarMissileStats(class_2960 key, JsonObject json) {
        super(key, json);
        this.scan_range = UtilParse.getFloatSafe((JsonObject)json, (String)"scan_range", (float)0.0f);
    }

    @Override
    public JsonPresetType getType() {
        return WeaponType.ANTI_RADAR_MISSILE;
    }

    @Override
    public JsonPresetInstance<?> createPresetInstance() {
        return new AntiRadarMissileInstance<AntiRadarMissileStats>(this);
    }

    @Override
    public void addToolTips(List<class_2561> tips, boolean advanced) {
        super.addToolTips(tips, advanced);
        tips.add((class_2561)UtilMCText.translatable((String)"info.dscombat.targets_grounded").method_10862(class_2583.field_24360.method_36139(8388564)));
        tips.add((class_2561)UtilMCText.translatable((String)"info.dscombat.scan_range").method_27693(": " + this.getScanRange()).method_10862(class_2583.field_24360.method_36139(6266528)));
    }

    public double getUnscaledScanRange() {
        return this.scan_range;
    }

    public double getScanRange() {
        if (this.isUseSpeedScale()) {
            return DSCPhyCons.getIRLScale() * this.getUnscaledScanRange();
        }
        return this.getUnscaledScanRange();
    }

    @Override
    public String getWeaponTypeCode() {
        return UtilMCText.transString((String)"weapon_code.dscombat.magnum");
    }

    @Override
    public String getDefaultIconLocation() {
        return "dscombat:textures/ui/weapon_icons/anti_radar_missile.png";
    }
}

