/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.weapon.stats;

import com.google.gson.JsonObject;
import com.onewhohears.dscombat.data.vehicle.physics.DSCPhyCons;
import com.onewhohears.dscombat.data.weapon.AbstractWeaponBuilders;
import com.onewhohears.dscombat.data.weapon.WeaponType;
import com.onewhohears.dscombat.data.weapon.stats.BulletStats;
import com.onewhohears.onewholibs.util.UtilMCText;
import com.onewhohears.onewholibs.util.UtilParse;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;

public abstract class MissileStats
extends BulletStats {
    private final float turnRadius;
    private final double acceleration;
    private final double fuseDist;
    private final float fov;
    private final double bleed;
    private final int fuelTicks;
    private final int seeThroWater;
    private final int seeThroBlock;

    public MissileStats(class_2960 key, JsonObject json) {
        super(key, json);
        this.turnRadius = UtilParse.getFloatSafe((JsonObject)json, (String)"turnRadius", (float)500.0f);
        this.acceleration = UtilParse.getFloatSafe((JsonObject)json, (String)"acceleration", (float)0.0f);
        this.fuseDist = UtilParse.getFloatSafe((JsonObject)json, (String)"fuseDist", (float)1.0f);
        this.fov = UtilParse.getFloatSafe((JsonObject)json, (String)"fov", (float)-1.0f);
        this.bleed = UtilParse.getFloatSafe((JsonObject)json, (String)"bleed", (float)0.0f);
        this.fuelTicks = UtilParse.getIntSafe((JsonObject)json, (String)"fuelTicks", (int)this.getMaxAge());
        this.seeThroWater = UtilParse.getIntSafe((JsonObject)json, (String)"seeThroWater", (int)0);
        this.seeThroBlock = UtilParse.getIntSafe((JsonObject)json, (String)"seeThroBlock", (int)0);
    }

    public float getTurnRadius() {
        return this.turnRadius;
    }

    public double getUnscaledAcceleration() {
        return this.acceleration;
    }

    public double getFuseDist() {
        return this.fuseDist;
    }

    public float getFov() {
        return this.fov;
    }

    public double getUnscaledBleed() {
        return this.bleed;
    }

    public int getFuelTicks() {
        return this.fuelTicks;
    }

    public int getSeeThroWater() {
        return this.seeThroWater;
    }

    public int getSeeThroBlock() {
        return this.seeThroBlock;
    }

    public double getAcceleration() {
        if (this.isUseSpeedScale()) {
            return DSCPhyCons.getIRLScale() * this.getUnscaledAcceleration();
        }
        return this.getUnscaledAcceleration();
    }

    public double getBleed() {
        if (this.isUseSpeedScale()) {
            return DSCPhyCons.getIRLScale() * this.getUnscaledBleed();
        }
        return this.getUnscaledBleed();
    }

    @Override
    public boolean isBullet() {
        return false;
    }

    @Override
    public boolean isAimAssist() {
        return false;
    }

    @Override
    public double getMobTurretRange() {
        return Math.min(20000.0, this.getSpeed() * (double)this.getMaxAge() * 0.5);
    }

    @Override
    public void addToolTips(List<class_2561> tips, boolean advanced) {
        super.addToolTips(tips, advanced);
        if (advanced) {
            if (this.getFov() != -1.0f) {
                tips.add((class_2561)UtilMCText.translatable((String)"info.dscombat.field_of_view").method_27693(": " + this.getFov()).method_10862(class_2583.field_24360.method_36139(6266528)));
            }
            tips.add((class_2561)UtilMCText.translatable((String)"info.dscombat.turn_radius").method_27693(": " + this.getTurnRadius()).method_10862(class_2583.field_24360.method_36139(6266528)));
            tips.add((class_2561)UtilMCText.translatable((String)"info.dscombat.acceleration").method_27693(": " + this.getAcceleration()).method_10862(class_2583.field_24360.method_36139(6266528)));
        }
    }

    public static class Builder
    extends AbstractWeaponBuilders.MissileBuilder<Builder> {
        protected Builder(String namespace, String name, WeaponType type) {
            super(namespace, name, type);
        }

        public static Builder posMissileBuilder(String namespace, String name) {
            return new Builder(namespace, name, WeaponType.POS_MISSILE);
        }

        public static Builder irMissileBuilder(String namespace, String name) {
            return new Builder(namespace, name, WeaponType.IR_MISSILE);
        }

        public static Builder trackMissileBuilder(String namespace, String name) {
            return new Builder(namespace, name, WeaponType.TRACK_MISSILE);
        }

        public static Builder torpedoBuilder(String namespace, String name) {
            return new Builder(namespace, name, WeaponType.TORPEDO);
        }

        public static Builder antiRadarMissileBuilder(String namespace, String name) {
            return new Builder(namespace, name, WeaponType.ANTI_RADAR_MISSILE);
        }

        public static Builder dumbTorpedoBuilder(String namespace, String name) {
            return new Builder(namespace, name, WeaponType.DUMB_TORPEDO);
        }
    }
}

