/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.weapon.stats;

import com.google.gson.JsonObject;
import com.onewhohears.dscombat.data.weapon.WeaponType;
import com.onewhohears.dscombat.data.weapon.instance.TrackMissileInstance;
import com.onewhohears.dscombat.data.weapon.stats.MissileStats;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetInstance;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetType;
import com.onewhohears.onewholibs.util.UtilMCText;
import com.onewhohears.onewholibs.util.UtilParse;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;

public class TrackMissileStats
extends MissileStats {
    private final TargetType targetType;
    private final boolean active;

    public TrackMissileStats(class_2960 key, JsonObject json) {
        super(key, json);
        this.targetType = (TargetType)UtilParse.getEnumSafe((JsonObject)json, (String)"targetType", TargetType.class);
        this.active = UtilParse.getBooleanSafe((JsonObject)json, (String)"activeTrack", (boolean)true);
    }

    @Override
    public JsonPresetType getType() {
        return WeaponType.TRACK_MISSILE;
    }

    @Override
    public JsonPresetInstance<?> createPresetInstance() {
        return new TrackMissileInstance<TrackMissileStats>(this);
    }

    public TargetType getTargetType() {
        return this.targetType;
    }

    public boolean isActiveTrack() {
        return this.active;
    }

    @Override
    public void addToolTips(List<class_2561> tips, boolean advanced) {
        super.addToolTips(tips, advanced);
        switch (this.getTargetType().ordinal()) {
            case 0: {
                tips.add((class_2561)UtilMCText.translatable((String)"info.dscombat.targets_flying").method_10862(class_2583.field_24360.method_36139(8388564)));
                break;
            }
            case 1: {
                tips.add((class_2561)UtilMCText.translatable((String)"info.dscombat.targets_grounded").method_10862(class_2583.field_24360.method_36139(8388564)));
                break;
            }
            case 2: {
                tips.add((class_2561)UtilMCText.translatable((String)"info.dscombat.targets_in_water").method_10862(class_2583.field_24360.method_36139(8388564)));
            }
        }
        if (advanced) {
            if (this.active) {
                tips.add((class_2561)UtilMCText.translatable((String)"info.dscombat.active_track").method_10862(class_2583.field_24360.method_36139(8388564)));
            } else {
                tips.add((class_2561)UtilMCText.translatable((String)"info.dscombat.semi_active").method_10862(class_2583.field_24360.method_36139(8388564)));
            }
        }
    }

    @Override
    public String getWeaponTypeCode() {
        switch (this.getTargetType().ordinal()) {
            case 0: {
                if (this.active) {
                    return UtilMCText.transString((String)"weapon_code.dscombat.fox3");
                }
                return UtilMCText.transString((String)"weapon_code.dscombat.fox1");
            }
            case 1: {
                return UtilMCText.transString((String)"weapon_code.dscombat.rifel");
            }
            case 2: {
                return UtilMCText.transString((String)"weapon_code.dscombat.bruiser");
            }
        }
        return "";
    }

    @Override
    public String getDefaultIconLocation() {
        return "dscombat:textures/ui/weapon_icons/radar_missile.png";
    }

    @Override
    public boolean requiresRadar() {
        return true;
    }

    public static enum TargetType {
        AIR,
        GROUND,
        WATER;

    }
}

