/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.entity.parts;

import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.command.DSCGameRules;
import com.onewhohears.dscombat.data.parts.PartType;
import com.onewhohears.dscombat.data.parts.instance.TurretInstance;
import com.onewhohears.dscombat.data.parts.stats.TurretStats;
import com.onewhohears.dscombat.data.weapon.instance.WeaponInstance;
import com.onewhohears.dscombat.data.weapon.stats.WeaponStats;
import com.onewhohears.dscombat.entity.ai.goal.TurretShootGoal;
import com.onewhohears.dscombat.entity.ai.goal.TurretTargetGoal;
import com.onewhohears.dscombat.entity.parts.EntityRidablePart;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.entity.weapon.EntityWeapon;
import com.onewhohears.dscombat.init.ModTags;
import com.onewhohears.onewholibs.util.UtilMCText;
import com.onewhohears.onewholibs.util.math.QuaternionF;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class EntityTurret
extends EntityRidablePart<TurretStats, TurretInstance<TurretStats>> {
    public static final class_2940<Float> RELROTX = class_2945.method_12791(EntityTurret.class, (class_2941)class_2943.field_13320);
    public static final class_2940<Float> RELROTY = class_2945.method_12791(EntityTurret.class, (class_2941)class_2943.field_13320);
    public float xRotRelO;
    public float yRotRelO;
    private int newRiderCoolDown;
    private int overrideAnglesTime = -100;
    private float overrideRotX;
    private float overrideRotY;
    protected int lastShootTick;
    protected class_1352 shootGoal;
    protected class_1352 targetGoal;

    public EntityTurret(class_1299<?> type, class_1937 level, String defaultPreset) {
        super(type, level, defaultPreset);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(RELROTX, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(RELROTY, (Object)Float.valueOf(0.0f));
    }

    @Override
    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.method_36457(tag.method_10583("xRot"));
        this.method_36456(tag.method_10583("yRot"));
        this.setRelRotX(tag.method_10583("relrotx"));
        this.setRelRotY(tag.method_10583("relroty"));
    }

    @Override
    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10548("xRot", this.method_36455());
        tag.method_10548("yRot", this.method_36454());
        tag.method_10548("relrotx", this.getRelRotX());
        tag.method_10548("relroty", this.getRelRotY());
    }

    @Override
    public void method_5773() {
        super.method_5773();
        this.tickRotate();
    }

    public void setOverrideLookAngles(float overrideRotX, float overrideRotY) {
        this.overrideAnglesTime = this.field_6012;
        this.overrideRotX = overrideRotX;
        this.overrideRotY = overrideRotY;
    }

    protected void tickRotate() {
        float goalRotY;
        float goalRotX;
        this.xRotRelO = this.getRelRotX();
        this.yRotRelO = this.getRelRotY();
        class_1309 gunner = this.getPassenger();
        if (this.field_6012 - this.overrideAnglesTime < 100) {
            goalRotX = this.overrideRotX;
            goalRotY = this.overrideRotY;
        } else if (gunner != null) {
            goalRotX = gunner.method_36455();
            goalRotY = gunner.method_5791();
        } else {
            return;
        }
        this.rotateTowards(goalRotX, goalRotY);
    }

    protected void rotateTowards(float goalRotX, float goalRotY) {
        QuaternionF ra = QuaternionF.ONE;
        EntityVehicle vehicle = this.getParentVehicle();
        if (vehicle != null) {
            ra = vehicle.getQBySide();
        }
        if (!this.isClientSide()) {
            if (this.newRiderCoolDown > 0) {
                --this.newRiderCoolDown;
            }
            float rely = this.yRotRelO;
            float relx = this.xRotRelO;
            float rotrate = this.getRotRate();
            float minrotx = this.getMinRotX();
            float maxrotx = this.getMaxRotX();
            WeaponInstance<?> data = this.getWeaponData();
            if (data != null) {
                data.tick(vehicle, true);
            }
            float[] relangles = UtilAngles.globalToRelativeDegrees((float)goalRotX, (float)goalRotY, (QuaternionF)ra);
            float rg1 = relangles[1] + 360.0f;
            float rg2 = relangles[1] - 360.0f;
            float d1 = Math.abs(rg1 - rely);
            float d2 = Math.abs(rg2 - rely);
            float d3 = Math.abs(relangles[1] - rely);
            if (d1 < d2 && d1 < d3) {
                relangles[1] = relangles[1] + 360.0f;
            } else if (d2 < d1 && d2 < d3) {
                relangles[1] = relangles[1] - 360.0f;
            }
            if (relangles[0] > maxrotx) {
                relangles[0] = maxrotx;
            } else if (relangles[0] < minrotx) {
                relangles[0] = minrotx;
            }
            float rotdiffx = relangles[0] - relx;
            float rotdiffy = relangles[1] - rely;
            float dx = Math.abs(rotdiffx) < rotrate ? rotdiffx : rotrate * Math.signum(rotdiffx);
            float dy = Math.abs(rotdiffy) < rotrate ? rotdiffy : rotrate * Math.signum(rotdiffy);
            this.setRelRotX(class_3532.method_15393((float)(relx + dx)));
            this.setRelRotY(class_3532.method_15393((float)(rely + dy)));
        }
        float[] global = UtilAngles.relativeToGlobalDegrees((float)this.getRelRotX(), (float)this.getRelRotY(), (QuaternionF)ra);
        this.method_36457(global[0]);
        this.method_36456(global[1]);
    }

    @Override
    protected class_243 getPassengerRelPos(class_1297 passenger, EntityVehicle craft) {
        QuaternionF q = this.isClientSide() ? craft.getClientQ() : craft.getQ();
        double offset = this.method_5621() + passenger.method_5678() + (double)passenger.method_5751();
        float cos = class_3532.method_15362((float)(this.getRelRotY() * ((float)Math.PI / 180)));
        float sin = class_3532.method_15374((float)(this.getRelRotY() * ((float)Math.PI / 180)));
        return UtilAngles.rotateVector((class_243)new class_243(this.getPassengerOffsets().field_1352 * (double)cos + this.getPassengerOffsets().field_1350 * (double)sin, offset, this.getPassengerOffsets().field_1350 * (double)cos + this.getPassengerOffsets().field_1352 * (double)sin), (QuaternionF)q).method_1023(0.0, (double)passenger.method_5751(), 0.0);
    }

    protected void addTurretAI(class_1308 mob) {
        this.shootGoal = this.makeShootGoal(mob);
        mob.field_6201.method_6277(0, this.shootGoal);
        if (mob.method_5864().method_20210(ModTags.EntityTypes.TURRET_TARGET_PLAYERS)) {
            this.targetGoal = this.makeTargetPlayerGoal(mob);
            mob.field_6185.method_6277(0, this.targetGoal);
        } else if (mob.method_5864().method_20210(ModTags.EntityTypes.TURRET_TARGET_MONSTERS)) {
            this.targetGoal = this.makeTargetEnemyGoal(mob);
            mob.field_6185.method_6277(0, this.targetGoal);
        }
    }

    protected void removeTurretAI(class_1308 mob) {
        if (this.shootGoal != null) {
            mob.field_6201.method_6280(this.shootGoal);
            this.shootGoal = null;
        }
        if (this.targetGoal != null) {
            mob.field_6185.method_6280(this.targetGoal);
            this.targetGoal = null;
        }
    }

    protected class_1352 makeShootGoal(class_1308 mob) {
        return new TurretShootGoal(mob, this);
    }

    protected class_1352 makeTargetPlayerGoal(class_1308 mob) {
        return TurretTargetGoal.targetPlayers(mob, this);
    }

    protected class_1352 makeTargetEnemyGoal(class_1308 mob) {
        return TurretTargetGoal.targetEnemy(mob, this);
    }

    @Override
    public boolean hasAIUsingTurret() {
        return this.targetGoal != null;
    }

    public boolean isBotUsingRadar() {
        if (!this.hasAIUsingTurret()) {
            return false;
        }
        WeaponInstance<?> wd = this.getWeaponData();
        if (wd == null) {
            return false;
        }
        return ((WeaponStats)wd.getStats()).requiresRadar();
    }

    public double getAIHorizontalRange() {
        WeaponInstance<?> wd = this.getWeaponData();
        if (wd == null) {
            return 300.0;
        }
        return ((WeaponStats)wd.getStats()).getMobTurretRange();
    }

    public double getAIVerticalRange() {
        return this.getWorld().method_8450().method_8356(DSCGameRules.MOB_TURRET_VERTICAL_RANGE);
    }

    @Override
    protected void method_5627(class_1297 passenger) {
        super.method_5627(passenger);
        this.newRiderCoolDown = 10;
        if (passenger instanceof class_1308) {
            class_1308 m = (class_1308)passenger;
            this.addTurretAI(m);
        }
    }

    @Override
    protected void method_5793(class_1297 passenger) {
        super.method_5793(passenger);
        if (passenger instanceof class_1308) {
            class_1308 m = (class_1308)passenger;
            this.removeTurretAI(m);
        }
    }

    @Override
    public boolean shouldRender() {
        return true;
    }

    @Override
    protected double getClientRenderDistance() {
        return (Double)Config.CLIENT.renderTurretDistance.get();
    }

    public int getAmmo() {
        if (this.getPartInstance() == null) {
            return 0;
        }
        return (int)((TurretInstance)this.getPartInstance()).getCurrentAmmo();
    }

    public int getMaxAmmo() {
        if (this.getPartInstance() == null) {
            return 0;
        }
        return (int)((TurretInstance)this.getPartInstance()).getMaxAmmo();
    }

    public int addAmmo(int ammo) {
        if (this.getPartInstance() == null) {
            return 0;
        }
        return ((TurretInstance)this.getPartInstance()).addWeaponAmmo(ammo);
    }

    public String getWeaponId() {
        if (this.getPartInstance() == null) {
            return "";
        }
        return ((TurretInstance)this.getPartInstance()).getWeaponId();
    }

    @Nullable
    public WeaponInstance<?> getWeaponData() {
        TurretInstance instance = (TurretInstance)this.getPartInstance();
        if (instance == null) {
            return null;
        }
        return instance.getWeaponData();
    }

    public void shoot(class_1297 shooter) {
        WeaponInstance<?> data = this.getWeaponData();
        if (this.isClientSide() || data == null || this.newRiderCoolDown > 0) {
            return;
        }
        boolean consume = true;
        class_243 pos = this.method_19538();
        EntityVehicle parent = null;
        class_1297 class_12972 = this.method_5854();
        if (class_12972 instanceof EntityVehicle) {
            EntityVehicle craft = (EntityVehicle)class_12972;
            if (!craft.isOperational()) {
                return;
            }
            pos = pos.method_1019(UtilAngles.rotateVector((class_243)new class_243(0.0, ((TurretStats)this.getStats()).getWeaponOffset(), 0.0), (QuaternionF)craft.getQ()));
            if (craft.isNoConsume()) {
                consume = false;
            }
            parent = craft;
        }
        class_3222 p = null;
        if (shooter instanceof class_3222) {
            class_3222 player = (class_3222)shooter;
            if (player.method_7337()) {
                consume = false;
            }
            p = player;
        }
        boolean consumeAmmo = this.getWorld().method_8450().method_8355(DSCGameRules.CONSUME_AMMO);
        boolean couldShoot = data.checkRecoil();
        data.setSlot(this.getSlotId());
        data.shootFromTurret(this.getWorld(), shooter, this.method_5720(), pos, parent, consume && consumeAmmo);
        if (couldShoot) {
            this.specialShoot(shooter, pos, parent, consume && consumeAmmo, data);
        }
        if (data.isFailedLaunch()) {
            if (p != null) {
                p.method_7353((class_2561)UtilMCText.translatable((String)data.getFailedLaunchReason()), true);
            }
        } else {
            this.setLastShootTick(this.field_6012);
            TurretInstance instance = (TurretInstance)this.getPartInstance();
            if (instance != null) {
                instance.setCurrentAmmo(data.getCurrentAmmo());
            }
        }
    }

    @Nullable
    public EntityWeapon<?> getFiredWeapon() {
        WeaponInstance<?> data = this.getWeaponData();
        if (data == null) {
            return null;
        }
        return data.getFiredWeapon();
    }

    protected void specialShoot(class_1297 shooter, class_243 pos, EntityVehicle parent, boolean consume, WeaponInstance<?> data) {
        if (this.getShootType() == ShootType.NORMAL) {
            return;
        }
        if (this.getShootType() == ShootType.MARK7) {
            float d = 1.0f;
            float yRad = this.method_36454() * ((float)Math.PI / 180);
            class_243 posL = pos.method_1019(new class_243((double)(-d * class_3532.method_15362((float)yRad)), 0.0, (double)(-d * (float)class_3532.method_17822((double)yRad))));
            class_243 posR = pos.method_1019(new class_243((double)(d * class_3532.method_15362((float)yRad)), 0.0, (double)(d * (float)class_3532.method_17822((double)yRad))));
            data.shootFromTurret(this.getWorld(), shooter, this.method_5720(), posL, parent, consume, true);
            data.shootFromTurret(this.getWorld(), shooter, this.method_5720(), posR, parent, consume, true);
        }
    }

    public ShootType getShootType() {
        return ((TurretStats)this.getStats()).getShootType();
    }

    public int getLastShootTick() {
        return this.lastShootTick;
    }

    public void setLastShootTick(int tick) {
        this.lastShootTick = tick;
    }

    @Override
    public PartType getPartType() {
        return PartType.TURRENT;
    }

    public TurretStats.RotBounds getRotBounds() {
        return ((TurretStats)this.getStats()).getRotBounds();
    }

    public float getMinRotX() {
        return this.getRotBounds().minRotX;
    }

    public float getMaxRotX() {
        return this.getRotBounds().maxRotX;
    }

    public float getRotRate() {
        return this.getRotBounds().rotRate;
    }

    public float getRelRotX() {
        return ((Float)this.field_6011.method_12789(RELROTX)).floatValue();
    }

    public float getRelRotY() {
        return ((Float)this.field_6011.method_12789(RELROTY)).floatValue();
    }

    public void setRelRotX(float degrees) {
        this.field_6011.method_12778(RELROTX, (Object)Float.valueOf(degrees));
    }

    public void setRelRotY(float degrees) {
        this.field_6011.method_12778(RELROTY, (Object)Float.valueOf(degrees));
    }

    @Override
    public boolean canGetHurt() {
        return true;
    }

    @Override
    public boolean isTurret() {
        return true;
    }

    @Override
    public boolean method_5732() {
        return true;
    }

    @Override
    public boolean method_5805() {
        return true;
    }

    public void onClientShoot() {
        this.setLastShootTick(this.field_6012);
    }

    public static enum ShootType {
        NORMAL,
        MARK7;

    }
}

