/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.entity.vehicle;

import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.command.DSCGameRules;
import com.onewhohears.dscombat.data.graph.AoaLiftKGraph;
import com.onewhohears.dscombat.data.graph.FloatFloatGraph;
import com.onewhohears.dscombat.data.graph.TurnRatesBySpeedGraph;
import com.onewhohears.dscombat.data.vehicle.VehicleType;
import com.onewhohears.dscombat.data.vehicle.physics.LiftSurfaceInstance;
import com.onewhohears.dscombat.data.vehicle.stats.PlaneStats;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.onewholibs.util.math.QuaternionF;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import com.onewhohears.onewholibs.util.math.UtilGeometry;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3532;

public class EntityPlane
extends EntityVehicle {
    private float aoa;
    private float liftK;
    private float airFoilSpeedSqr;
    private float airSpeed;
    private float fuselageAoa;
    private float fuselageLiftK;
    private float dragC;
    private float centripetalForce;
    private float centrifugalForce;
    private float aoaTurnRateMod = 1.0f;
    private double wingLiftMag;
    private double arcadeIgnoreGravityFactor;
    private class_243 liftDir = class_243.field_1353;
    private class_243 liftForce = class_243.field_1353;
    private boolean isArcadeMode = false;
    private int pullUpWarningTicks;
    private int altitudeWarningTicks;

    public EntityPlane(class_1299<? extends EntityPlane> entity, class_1937 level, String defaultPreset) {
        super(entity, level, defaultPreset);
    }

    @Override
    public VehicleType getVehicleType() {
        return VehicleType.PLANE;
    }

    @Override
    public void method_5773() {
        if (this.field_6012 % 10 == 0) {
            this.isArcadeMode = DSCGameRules.isPlaneArcadeMode(this.getWorld());
        }
        super.method_5773();
    }

    @Override
    public void calcUniversalForces(QuaternionF q) {
        super.calcUniversalForces(q);
        if (this.isArcadeMode) {
            this.addForce(this.getWeightForce().method_1021(-this.getArcadeIgnoreGravityFactor()));
            if (this.isOnGround() && this.isFlapsDown()) {
                this.addForce(new class_243(0.0, 2000.0, 0.0));
            }
        }
    }

    protected void calcIgnoreGravityFactor(QuaternionF q) {
        class_243 u = this.method_18798();
        class_243 rollAxis = UtilAngles.getRollAxis((QuaternionF)q);
        double speed = UtilGeometry.vecCompByNormAxis((class_243)u, (class_243)rollAxis).method_1033();
        double minTakeOffSpeed = (double)((VehicleStats)this.getStats()).cruise_speed * this.getHorizontalSpeedScaleOrOne() * 0.33;
        this.arcadeIgnoreGravityFactor = Math.min(speed / minTakeOffSpeed, 1.0);
    }

    public double getArcadeIgnoreGravityFactor() {
        return this.arcadeIgnoreGravityFactor;
    }

    @Override
    public void calcAcc() {
        super.calcAcc();
        if (this.isArcadeMode && !this.isOnGround() && this.getArcadeIgnoreGravityFactor() == 1.0) {
            double speed = this.method_18798().method_1033();
            class_243 look = this.method_5720();
            this.method_18799(look.method_1021(speed));
        }
    }

    @Override
    public void calcMoveStatsPre(QuaternionF q) {
        super.calcMoveStatsPre(q);
        if (this.isArcadeMode) {
            this.aoa = 0.0f;
            this.calcIgnoreGravityFactor(q);
            return;
        }
        this.calculateAOA(q);
        this.calculateLift(q);
        this.calculateCentripetalForce();
        double ym = this.method_18798().field_1351;
        this.pullUpWarningTicks = ym <= -0.5 && this.getAltitude() / -ym <= 80.0 ? ++this.pullUpWarningTicks : 0;
        this.altitudeWarningTicks = this.method_18798().field_1351 < 0.0 && this.getAltitude() < 40.0 ? ++this.altitudeWarningTicks : 0;
    }

    @Override
    public double getDriveAcc() {
        return 0.0;
    }

    @Override
    public double getMaxSpeedForMotion() {
        return super.getMaxSpeedForMotion();
    }

    @Override
    public double getMaxSpeedFactor() {
        return super.getMaxSpeedFactor() * (Double)Config.SERVER.planeSpeedFactor.get();
    }

    @Override
    public boolean isGroundBraking() {
        return this.inputs.special2;
    }

    @Override
    public boolean isFlapsDown() {
        return this.inputs.special;
    }

    protected void calculateAOA(QuaternionF q) {
        float goalAOA;
        class_243 u = this.method_18798();
        class_243 pitchAxis = UtilAngles.getPitchAxis((QuaternionF)q);
        this.liftDir = u.method_1036(pitchAxis).method_1029();
        class_243 airFoilAxes = UtilAngles.getRollAxis((QuaternionF)q);
        this.airFoilSpeedSqr = (float)UtilGeometry.vecCompByNormAxis((class_243)u, (class_243)airFoilAxes).method_1027();
        this.airSpeed = class_3532.method_15355((float)this.airFoilSpeedSqr);
        if (this.isOnGround() || UtilGeometry.isZero((class_243)u)) {
            goalAOA = 0.0f;
        } else {
            class_243 wingNormal = UtilAngles.getYawAxis((QuaternionF)q).method_1021(-1.0);
            goalAOA = (float)UtilGeometry.angleBetweenVecPlaneDegrees((class_243)u, (class_243)wingNormal);
        }
        if (this.isFlapsDown()) {
            goalAOA += this.getPlaneStats().flapsAOABias;
        }
        this.aoa = class_3532.method_16439((float)LiftSurfaceInstance.getAOAChangeRate(this), (float)this.aoa, (float)goalAOA);
        float speedScaleSqr = (float)(1.0 / this.getHorizontalSpeedScale() / this.getHorizontalSpeedScale() * 400.0);
        this.liftK = this.getWingLiftKGraph().getLerpFloat(this.aoa) * speedScaleSqr;
        double goalAoaTurnRateMod = this.isAboutToStall() ? 0.05 : 1.0;
        this.aoaTurnRateMod = goalAoaTurnRateMod < (double)this.aoaTurnRateMod ? (float)class_3532.method_16436((double)0.05, (double)this.aoaTurnRateMod, (double)goalAoaTurnRateMod) : (float)class_3532.method_16436((double)0.5, (double)this.aoaTurnRateMod, (double)goalAoaTurnRateMod);
    }

    protected void calculateLift(QuaternionF q) {
        this.wingLiftMag = (double)this.liftK * this.getFluidDensity() * (double)this.airFoilSpeedSqr * (double)this.getWingSurfaceArea() * (double)this.getWingLiftPercent();
        double fuselageLift = (double)this.fuselageLiftK * this.getFluidDensity() * (double)this.airFoilSpeedSqr * (double)this.getFuselageLiftArea();
        double cenScale = this.getCentripetalScale();
        this.liftForce = this.liftDir.method_1021(this.getLiftMag()).method_18805(cenScale, 1.0, cenScale).method_1031(0.0, fuselageLift, 0.0);
    }

    protected void calculateCentripetalForce() {
        class_243 cenAxis = UtilAngles.getRollAxis((double)0.0, (double)((this.method_36454() + 90.0f) * ((float)Math.PI / 180)));
        this.centripetalForce = (float)UtilGeometry.vecCompMagDirByNormAxis((class_243)this.liftForce, (class_243)cenAxis);
        if ((double)class_3532.method_15379((float)this.centripetalForce) < 0.01) {
            this.centripetalForce = 0.0f;
        }
        if ((double)class_3532.method_15379((float)this.centrifugalForce) < 0.01) {
            this.centrifugalForce = 0.0f;
        }
        this.centrifugalForce = this.getTotalMass() * this.xzSpeed * this.getYawRate() * ((float)Math.PI / 180);
    }

    public class_243 getLiftForce(QuaternionF q) {
        return this.liftForce;
    }

    public double getLiftMag() {
        return this.wingLiftMag;
    }

    @Override
    public class_243 getThrustForce(QuaternionF q) {
        return UtilAngles.getRollAxis((QuaternionF)q).method_1021(this.getPushThrustMag());
    }

    public float getAOA() {
        return this.aoa;
    }

    @Override
    public boolean isCustomBoundingBox() {
        return true;
    }

    public final float getWingSurfaceArea() {
        return this.getPlaneStats().wing_area;
    }

    public float getFuselageLiftArea() {
        return this.getPlaneStats().fuselage_lift_area;
    }

    @Override
    public boolean isWeaponAngledDown() {
        return this.getPlaneStats().canAimDown && !this.isOnGround() && this.inputs.special2;
    }

    @Override
    public boolean canAngleWeaponDown() {
        return this.getPlaneStats().canAimDown;
    }

    public AoaLiftKGraph getWingLiftKGraph() {
        return this.getPlaneStats().getWingLiftKGraph();
    }

    public AoaLiftKGraph getFuselageLiftKGraph() {
        return this.getPlaneStats().getFuselageLiftKGraph();
    }

    public FloatFloatGraph getDragAoaGraph() {
        return this.getPlaneStats().getDragAoaGraph();
    }

    @Override
    public boolean canToggleLandingGear() {
        return true;
    }

    @Override
    public boolean canFlapsDown() {
        return true;
    }

    public float getCentripetalForce() {
        return this.centripetalForce;
    }

    public float getCentrifugalForce() {
        return this.centrifugalForce;
    }

    @Override
    public boolean isStalling() {
        return Math.abs(this.getAOA()) >= this.getWingLiftKGraph().getCriticalAOA() || this.liftLost();
    }

    @Override
    public boolean isAboutToStall() {
        return Math.abs(this.getAOA()) >= this.getWingLiftKGraph().getWarnAOA() && !this.isFlapsDown();
    }

    @Override
    public boolean liftLost() {
        return !this.isOnGround() && this.getForces().field_1351 < -10.0 && this.method_18798().field_1351 < -0.1 && Math.abs(this.zRot) > 15.0f;
    }

    @Override
    protected float calcDamageFromBullet(class_1282 source, float amount) {
        return amount * DSCGameRules.getBulletDamagePlaneFactor(this.getWorld());
    }

    public float getWingLiftPercent() {
        float total = this.getPlaneStats().wingLiftHitboxNames.length;
        if (total == 0.0f) {
            return 1.0f;
        }
        float num = this.getNumberOfAliveHitboxes(this.getPlaneStats().wingLiftHitboxNames);
        return num / total;
    }

    @Override
    public float getControlMaxDeltaPitch() {
        if (this.isArcadeMode || this.isTestMode() || !this.isUsingTurnAssist()) {
            return super.getControlMaxDeltaPitch();
        }
        return this.getTurnRateGraph().getMaxPitchRate(this.airSpeed) * this.aoaTurnRateMod;
    }

    @Override
    public float getControlMaxDeltaYaw() {
        if (this.isArcadeMode || this.isTestMode() || !this.isUsingTurnAssist()) {
            return super.getControlMaxDeltaYaw();
        }
        return this.getTurnRateGraph().getMaxYawRate(this.airSpeed) * this.aoaTurnRateMod;
    }

    @Override
    public float getControlMaxDeltaRoll() {
        if (this.isArcadeMode || this.isTestMode()) {
            return super.getControlMaxDeltaRoll();
        }
        return this.getTurnRateGraph().getMaxRollRate(this.airSpeed);
    }

    public TurnRatesBySpeedGraph getTurnRateGraph() {
        return this.getPlaneStats().getTurnRatesGraph();
    }

    public PlaneStats getPlaneStats() {
        return ((VehicleStats)this.getStats()).asPlane();
    }

    public double getCentripetalScale() {
        return this.getPlaneStats().centripetal_scale;
    }

    @Override
    public int getPullUpWarningTicks() {
        return this.pullUpWarningTicks;
    }

    @Override
    public int getAltitudeWarningTicks() {
        return this.altitudeWarningTicks;
    }

    @Override
    public boolean isArcadeMode() {
        return this.isArcadeMode;
    }

    @Override
    public boolean canTurnViaTorque() {
        return super.canTurnViaTorque() && (this.physicsInstances.isEmpty() || this.isArcadeMode());
    }
}

