/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.entity.vehicle;

import com.mojang.logging.LogUtils;
import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.client.event.ClientInputEventHandlers;
import com.onewhohears.dscombat.client.input.DSCClientInputs;
import com.onewhohears.dscombat.client.model.obj.ObjRadarModel;
import com.onewhohears.dscombat.command.DSCGameRules;
import com.onewhohears.dscombat.common.container.menu.VehiclePartsMenu;
import com.onewhohears.dscombat.common.network.PacketHandler;
import com.onewhohears.dscombat.common.network.toclient.ToClientAddForceMoment;
import com.onewhohears.dscombat.common.network.toclient.ToClientOnShoot;
import com.onewhohears.dscombat.common.network.toclient.ToClientVehicleControl;
import com.onewhohears.dscombat.common.network.toclient.ToClientVehicleExplode;
import com.onewhohears.dscombat.common.network.toserver.ToServerFixHitboxes;
import com.onewhohears.dscombat.common.network.toserver.ToServerSyncRotBoxPassengerPos;
import com.onewhohears.dscombat.common.network.toserver.ToServerVehicleCollide;
import com.onewhohears.dscombat.common.network.toserver.ToServerVehicleMoveRot;
import com.onewhohears.dscombat.data.parts.PartSlot;
import com.onewhohears.dscombat.data.parts.PartsManager;
import com.onewhohears.dscombat.data.parts.instance.StorageInstance;
import com.onewhohears.dscombat.data.parts.instance.TurretInstance;
import com.onewhohears.dscombat.data.radar.RadarStats;
import com.onewhohears.dscombat.data.radar.RadarSystem;
import com.onewhohears.dscombat.data.vehicle.VehicleInputManager;
import com.onewhohears.dscombat.data.vehicle.VehiclePresets;
import com.onewhohears.dscombat.data.vehicle.VehicleSoundManager;
import com.onewhohears.dscombat.data.vehicle.VehicleTextureManager;
import com.onewhohears.dscombat.data.vehicle.VehicleType;
import com.onewhohears.dscombat.data.vehicle.client.VehicleClientPresets;
import com.onewhohears.dscombat.data.vehicle.client.VehicleClientStats;
import com.onewhohears.dscombat.data.vehicle.physics.DSCPhyCons;
import com.onewhohears.dscombat.data.vehicle.physics.PhysicsComponentData;
import com.onewhohears.dscombat.data.vehicle.physics.PhysicsComponentInstance;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.dscombat.data.weapon.WeaponSystem;
import com.onewhohears.dscombat.data.weapon.stats.WeaponStats;
import com.onewhohears.dscombat.entity.CustomExplosion;
import com.onewhohears.dscombat.entity.DrivingBody;
import com.onewhohears.dscombat.entity.IREmitter;
import com.onewhohears.dscombat.entity.TrampleHandler;
import com.onewhohears.dscombat.entity.damagesource.VehicleDamageSource;
import com.onewhohears.dscombat.entity.parts.EntityChainHook;
import com.onewhohears.dscombat.entity.parts.EntityGimbal;
import com.onewhohears.dscombat.entity.parts.EntityPart;
import com.onewhohears.dscombat.entity.parts.EntityRidablePart;
import com.onewhohears.dscombat.entity.parts.EntityTurret;
import com.onewhohears.dscombat.entity.vehicle.hitbox.RotableHitbox;
import com.onewhohears.dscombat.init.DataSerializers;
import com.onewhohears.dscombat.init.ModTags;
import com.onewhohears.dscombat.item.VehicleInteractItem;
import com.onewhohears.dscombat.util.UtilClientPacket;
import com.onewhohears.dscombat.util.UtilParticles;
import com.onewhohears.dscombat.util.UtilServerPacket;
import com.onewhohears.dscombat.util.UtilVehicleEntity;
import com.onewhohears.dscombat.util.math.UtilRandom;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetAssetReader;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetReloadListener;
import com.onewhohears.onewholibs.entity.CustomAnimEntity;
import com.onewhohears.onewholibs.util.UtilEntity;
import com.onewhohears.onewholibs.util.UtilItem;
import com.onewhohears.onewholibs.util.UtilMCText;
import com.onewhohears.onewholibs.util.math.QuaternionF;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import com.onewhohears.onewholibs.util.math.UtilGeometry;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1807;
import net.minecraft.class_1813;
import net.minecraft.class_1856;
import net.minecraft.class_1923;
import net.minecraft.class_1927;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_270;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_8111;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public abstract class EntityVehicle
extends CustomAnimEntity<VehicleStats, VehicleClientStats>
implements IREmitter,
CustomExplosion,
DrivingBody,
TrampleHandler {
    protected static final Logger LOGGER = LogUtils.getLogger();
    public static final class_2940<Float> HEALTH = class_2945.method_12791(EntityVehicle.class, (class_2941)class_2943.field_13320);
    public static final class_2940<Float> ARMOR = class_2945.method_12791(EntityVehicle.class, (class_2941)class_2943.field_13320);
    public static final class_2940<QuaternionF> Q = class_2945.method_12791(EntityVehicle.class, DataSerializers.QUATERNION);
    public static final class_2940<class_243> AV = class_2945.method_12791(EntityVehicle.class, DataSerializers.VEC3);
    public static final class_2940<Boolean> TEST_MODE = class_2945.method_12791(EntityVehicle.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> NO_CONSUME = class_2945.method_12791(EntityVehicle.class, (class_2941)class_2943.field_13323);
    public static final class_2940<String> RADIO_SONG = class_2945.method_12791(EntityVehicle.class, (class_2941)class_2943.field_13326);
    public static final class_2940<Boolean> PLAY_IR_TONE = class_2945.method_12791(EntityVehicle.class, (class_2941)class_2943.field_13323);
    public static final class_2940<RadarStats.RadarMode> RADAR_MODE = class_2945.method_12791(EntityVehicle.class, DataSerializers.RADAR_MODE);
    public static final class_2940<Boolean> LANDING_GEAR = class_2945.method_12791(EntityVehicle.class, (class_2941)class_2943.field_13323);
    public static final class_2940<PermMode> PERM_MODE = class_2945.method_12791(EntityVehicle.class, DataSerializers.PERM_MODE);
    public static final int HITBOX_PUSH_COOLDOWN = 4;
    public final VehicleInputManager inputs;
    public final VehicleSoundManager soundManager;
    public final VehicleTextureManager textureManager;
    public final PartsManager partsManager;
    public final WeaponSystem weaponSystem;
    public final RadarSystem radarSystem;
    protected final List<RotableHitbox> hitboxes = new ArrayList<RotableHitbox>();
    private final Set<Integer> collidedEntityIds = new HashSet<Integer>();
    private final Map<Integer, Integer> hitboxEntityCoolDown = new HashMap<Integer, Integer>();
    private final Map<Integer, EntityCollideInfo> entityCollideInfo = new HashMap<Integer, EntityCollideInfo>();
    protected final List<PhysicsComponentInstance<?>> physicsInstances = new ArrayList();
    private final Map<Integer, Integer> formerPassengersServer = new HashMap<Integer, Integer>();
    public int lastShootTime = -1;
    public int ingredientDropIndex = -1;
    public QuaternionF prevQ = QuaternionF.ONE.copy();
    public QuaternionF clientQ = QuaternionF.ONE.copy();
    public class_243 clientAV = class_243.field_1353;
    public float zRot;
    public float zRotO;
    public class_243 prevMotion = class_243.field_1353;
    public class_243 forces = class_243.field_1353;
    public class_243 forcesO = class_243.field_1353;
    public class_243 addForceBetweenTicks = class_243.field_1353;
    public class_243 moment = class_243.field_1353;
    public class_243 momentO = class_243.field_1353;
    public class_243 addMomentBetweenTicks = class_243.field_1353;
    protected class_243 controlMoment = class_243.field_1353;
    protected class_243 additionalRotInertia = class_243.field_1353;
    public boolean nightVisionHud = false;
    public boolean hasRadio = false;
    protected boolean hasFlares;
    protected int xzSpeedDir;
    protected int hurtByFireTime;
    protected int flareTicks;
    protected float xzSpeed;
    protected float totalMass;
    protected float xzYaw;
    protected float slideAngle;
    protected float slideAngleCos;
    protected float maxPushThrust;
    protected float maxSpinThrust;
    protected float currentFuel;
    protected float maxFuel;
    protected float afterburnerMaxPushThrust;
    protected double staticFric;
    protected double kineticFric;
    protected double airDensity;
    protected double currentAltitude;
    protected double maxXZ;
    private int lerpSteps;
    private int deadTicks;
    private int stallWarnTicks;
    private int stallTicks;
    private int engineFireTicks;
    private int fuelLeakTicks;
    private int bingoTicks;
    private int groundTicks;
    private int hitboxRefreshAttempts;
    private int numFlares;
    private int hydraulicsFailureTicks;
    private int missileTicks;
    private int trackedTicks;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private float landingGearPos;
    private float landingGearPosOld;
    private float motorRot;
    private float wheelRot;
    private float previousThrottle;
    private boolean wasInWater;
    private boolean hadControllingPassenger;
    private boolean wasPlayerOrBotRiding;
    protected boolean isDriverCameraLocked = false;
    protected float throttle;
    @Nullable
    protected EntityGimbal pilotGimbal;
    @Nullable
    protected class_1657 chainHolderPlayer;
    @Nullable
    protected EntityChainHook chainHolderHook;
    @Nullable
    private class_1297 owner;
    @Nullable
    private UUID owner_uuid;
    private int owner_id = -1;
    private boolean afterBurnerOverride = false;

    public EntityVehicle(class_1299<? extends EntityVehicle> entityType, class_1937 level, String defaultPreset) {
        super(entityType, level, defaultPreset);
        this.field_23807 = true;
        this.inputs = new VehicleInputManager();
        this.soundManager = new VehicleSoundManager(this);
        this.textureManager = new VehicleTextureManager(this);
        this.partsManager = new PartsManager(this);
        this.weaponSystem = new WeaponSystem(this);
        this.radarSystem = new RadarSystem(this);
        this.updatePhysicsInstances();
        this.field_6013 = 0.6f;
    }

    public void updateStatsHolder(@NotNull String preset) {
        super.updateStatsHolder(preset);
        if (this.isStatsHolderLoaded()) {
            this.updatePhysicsInstances();
        }
    }

    public void updatePhysicsInstances() {
        this.physicsInstances.clear();
        for (PhysicsComponentData data : ((VehicleStats)this.getStats()).getPhysicsComponents()) {
            if (data == null) continue;
            this.physicsInstances.add(data.createInstance());
        }
    }

    protected void method_5693() {
        this.field_6011.method_12784(HEALTH, (Object)Float.valueOf(100.0f));
        this.field_6011.method_12784(ARMOR, (Object)Float.valueOf(100.0f));
        this.field_6011.method_12784(Q, (Object)QuaternionF.ONE);
        this.field_6011.method_12784(AV, (Object)class_243.field_1353);
        this.field_6011.method_12784(TEST_MODE, (Object)false);
        this.field_6011.method_12784(NO_CONSUME, (Object)false);
        this.field_6011.method_12784(RADIO_SONG, (Object)"");
        this.field_6011.method_12784(PLAY_IR_TONE, (Object)false);
        this.field_6011.method_12784(RADAR_MODE, (Object)RadarStats.RadarMode.ALL);
        this.field_6011.method_12784(LANDING_GEAR, (Object)true);
        this.field_6011.method_12784(PERM_MODE, (Object)PermMode.PUBLIC);
    }

    public void method_5674(@NotNull class_2940<?> key) {
        super.method_5674(key);
        if (!this.isClientSide()) {
            return;
        }
        if (Q.equals(key)) {
            if (!this.method_5787()) {
                this.setPrevQ(this.getClientQ());
                this.setClientQ(this.getQ());
            }
        } else if (AV.equals(key)) {
            if (!this.method_5787()) {
                this.clientAV = (class_243)this.field_6011.method_12789(AV);
            }
        } else if (RADIO_SONG.equals(key)) {
            this.soundManager.onRadioSongUpdate(this.getRadioSong());
        }
    }

    public void method_5749(@NotNull class_2487 nbt) {
        super.method_5749(nbt);
        this.setTestMode(nbt.method_10577("test_mode"));
        this.setNoConsume(nbt.method_10577("no_consume"));
        class_2487 presetNbt = ((VehicleStats)this.getStats()).getDataAsNBT();
        if (!nbt.method_10577("merged_preset")) {
            nbt.method_10543(presetNbt);
        }
        this.partsManager.read(nbt, presetNbt);
        this.textureManager.read(nbt);
        this.soundManager.read(nbt);
        this.setHealth(nbt.method_10583("health"));
        this.setArmor(nbt.method_10583("armor"));
        this.setLandingGear(nbt.method_10577("landing_gear"));
        this.setCurrentThrottle(nbt.method_10583("current_throttle"));
        this.setXRotNoQ(nbt.method_10583("xRot"));
        this.setYRotNoQ(nbt.method_10583("yRot"));
        this.setZRot(nbt.method_10583("zRot"));
        QuaternionF q = UtilAngles.toQuaternionF((double)this.method_36454(), (double)this.method_36455(), (double)this.getZRot());
        this.setQ(q);
        this.setPrevQ(q);
        this.setClientQ(q);
        this.setRadarMode(RadarStats.RadarMode.values()[nbt.method_10550("radar_mode")]);
        this.setRadioSong(nbt.method_10558("radio_song"));
        this.createRotableHitboxes(nbt);
        if (nbt.method_10545("ingredientDropIndex")) {
            this.ingredientDropIndex = nbt.method_10550("ingredientDropIndex");
        }
        if (nbt.method_10545("owner_id")) {
            this.owner_uuid = nbt.method_25926("owner_id");
        }
        this.setPermMode(PermMode.values()[nbt.method_10550("perm_mode")]);
        this.maxXZ = nbt.method_10574("maxXZ");
    }

    public void method_5652(@NotNull class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("test_mode", this.isTestMode());
        nbt.method_10556("no_consume", this.isNoConsume());
        nbt.method_10556("merged_preset", true);
        this.partsManager.write(nbt);
        this.textureManager.write(nbt);
        this.soundManager.write(nbt);
        nbt.method_10548("health", this.getHealth());
        nbt.method_10548("armor", this.getArmor());
        nbt.method_10556("landing_gear", this.isLandingGear());
        nbt.method_10548("current_throttle", this.getCurrentThrottle());
        nbt.method_10548("xRot", this.method_36455());
        nbt.method_10548("yRot", this.method_36454());
        nbt.method_10548("zRot", this.zRot);
        nbt.method_10549("maxXZ", this.maxXZ);
        nbt.method_10569("radar_mode", this.getRadarMode().ordinal());
        nbt.method_10582("radio_song", this.getRadioSong());
        class_1297 own = this.getOwner();
        if (own != null) {
            nbt.method_10582("owner_name", own.method_5820());
            nbt.method_25927("owner_id", own.method_5667());
        } else if (this.owner_uuid != null) {
            nbt.method_25927("owner_id", this.owner_uuid);
        }
        class_2561 name = this.method_5797();
        if (name != null) {
            nbt.method_10582("CustomName", class_2561.class_2562.method_10867((class_2561)name));
        }
        if (this.method_5807()) {
            nbt.method_10556("CustomNameVisible", this.method_5807());
        }
        nbt.method_10548("fuel", this.getCurrentFuel());
        nbt.method_10548("flares", (float)this.getFlareNum());
        this.saveRotableHitboxes(nbt);
        nbt.method_10569("ingredientDropIndex", this.ingredientDropIndex);
        nbt.method_10569("perm_mode", this.getPermMode().ordinal());
    }

    public void readSpawnData(class_2540 buffer) {
        super.readSpawnData(buffer);
        int weaponIndex = buffer.readInt();
        boolean gear = buffer.readBoolean();
        boolean freeLook = buffer.readBoolean();
        float throttle = buffer.readFloat();
        this.maxXZ = buffer.readDouble();
        List<PartSlot> slots = PartsManager.readSlotsFromBuffer(buffer);
        this.textureManager.read((ByteBuf)buffer);
        this.soundManager.write(buffer);
        this.weaponSystem.setSelected(weaponIndex);
        this.partsManager.setPartSlots(slots);
        this.partsManager.clientPartsSetup();
        this.setLandingGear(gear);
        this.setDriverCameraLocked(freeLook);
        this.setCurrentThrottle(throttle);
    }

    public void writeSpawnData(class_2540 buffer) {
        super.writeSpawnData(buffer);
        buffer.writeInt(this.weaponSystem.getSelectedIndex());
        buffer.writeBoolean(this.isLandingGear());
        buffer.writeBoolean(this.isDriverCameraLocked());
        buffer.writeFloat(this.getCurrentThrottle());
        buffer.writeDouble(this.maxXZ);
        PartsManager.writeSlotsToBuffer(buffer, this.partsManager.getSlots());
        this.textureManager.write(buffer);
        this.soundManager.write(buffer);
    }

    public abstract VehicleType getVehicleType();

    public void init() {
        this.method_18382();
        if (!this.isClientSide()) {
            this.serverSetup();
        } else {
            this.clientSetup();
        }
        this.soundManager.loadSounds((VehicleStats)this.getStats());
    }

    public void method_5773() {
        if (UtilGeometry.vec3NAN((class_243)this.method_18798())) {
            this.method_18799(class_243.field_1353);
        }
        if (this.field_5953) {
            this.init();
        }
        super.method_5773();
        this.controlSystem();
        this.tickPhysics();
        this.tickCollisions();
        if (!this.getWorld().method_8608() && this.canTrample()) {
            this.tickTrample();
        }
        this.tickLerp();
        this.tickHitboxes();
        this.tickParts();
        this.tickWarnings();
        this.soundManager.onTick();
        this.textureManager.onTick();
        if (this.isClientSide()) {
            this.clientTick();
        } else {
            this.serverTick();
        }
    }

    @Override
    public void calcAirMovement(QuaternionF q) {
        DrivingBody.super.calcAirMovement(q);
        this.method_38785();
    }

    @Override
    public boolean canDriveOnGround() {
        return !this.canToggleLandingGear() || this.isLandingGear();
    }

    @Override
    public void calcWaterMovement(QuaternionF q) {
    }

    @Override
    public void addControllingTorques(QuaternionF q) {
        if (this.canTurnViaTorque()) {
            if (this.canControlPitch()) {
                if (this.isHardCodedRotAcc()) {
                    this.hardCodedAccPitch();
                } else {
                    this.addMomentX(this.inputs.pitch * this.getPitchTorque(), true);
                }
            }
            if (this.canControlYaw()) {
                if (this.isHardCodedRotAcc()) {
                    this.hardCodedAccYaw();
                } else {
                    this.addMomentY(this.inputs.yaw * this.getYawTorque(), true);
                }
            }
            if (this.canControlRoll()) {
                if (this.isHardCodedRotAcc()) {
                    this.hardCodedAccRoll();
                } else if (this.inputs.bothRoll) {
                    this.flatten(q, 0.0f, this.getMaxDeltaRoll(), false);
                } else {
                    this.addMomentZ(this.inputs.roll * this.getRollTorque(), true);
                }
            }
        }
    }

    public boolean canTurnViaTorque() {
        return this.isOperational() && !this.isOnGround();
    }

    @Override
    public class_243 getTotalRotInertia() {
        return new class_243((double)((VehicleStats)this.getStats()).Ix, (double)((VehicleStats)this.getStats()).Iy, (double)((VehicleStats)this.getStats()).Iz).method_1019(this.getAdditionalRotInertia());
    }

    protected class_243 getAdditionalRotInertia() {
        return this.additionalRotInertia;
    }

    public void serverTick() {
        this.waterDamage();
        if (!this.isTestMode() && !this.isOperational()) {
            this.tickNoHealth();
        }
        if (!(!this.hasRadioSong() || this.isOperational() && this.hasRadio)) {
            this.turnRadioOff();
        }
    }

    public void syncControlsToClient() {
        if (this.isClientSide()) {
            return;
        }
        PacketHandler.sendToTrackers(new ToClientVehicleControl(this), (class_1297)this);
    }

    public void tickCollisions() {
        if (!this.isClientSide()) {
            this.knockBack(this.getWorld().method_8333((class_1297)this, this.method_5829(), this.getKnockbackPredicate()));
            this.tickDismountSafety();
            if (!this.method_42148()) {
                this.wallCollisions();
            }
        } else if (this.method_5787()) {
            this.wallCollisions();
        }
    }

    public boolean canTrample() {
        return (this.isOnGround() || this.method_5799()) && this.xzSpeed > 0.0f && this.getWorld().method_8450().method_8355(DSCGameRules.VEHICLE_TRAMPLE);
    }

    protected void tickTrample() {
        class_238 box = this.method_5829().method_997(this.method_18798()).method_1014(0.01);
        class_1309 controller = this.method_5642();
        for (double x = box.field_1323; x < box.field_1320 + 1.0; x += 1.0) {
            for (double z = box.field_1321; z < box.field_1324 + 1.0; z += 1.0) {
                for (double y = box.field_1322; y < box.field_1325 + 1.0; y += 1.0) {
                    class_2338 pos = UtilGeometry.toBlockPos((class_243)new class_243(x, y, z));
                    class_2680 state = this.getWorld().method_8320(pos);
                    if (!state.method_26164(ModTags.Blocks.VEHICLE_TRAMPLE) || !UtilVehicleEntity.vehicleHasPermissionToTrample(pos, state, this.getWorld(), (class_1297)controller)) continue;
                    this.getWorld().method_8651(pos, true, (class_1297)this);
                }
            }
        }
    }

    protected void wallCollisions() {
        if (this.field_5992) {
            this.verticalCollision();
        }
        if (this.field_5976 && !this.field_34927) {
            this.horizontalCollision();
        }
        if (!this.wasInWater() && this.method_5799()) {
            this.waterCollision();
        }
        this.wasInWater = this.method_5799();
    }

    protected void waterCollision() {
        double th;
        double speed = this.prevMotion.method_1033();
        if (speed > (th = 0.5)) {
            float amount = (float)((speed - th) * 300.0);
            this.collideHurt(amount, false);
        }
    }

    protected void horizontalCollision() {
        double th;
        double speed = this.prevMotion.method_37267();
        if (speed > (th = 0.5)) {
            float amount = (float)((speed - th) * 300.0);
            this.collideHurt(amount, false);
        }
    }

    protected void verticalCollision() {
        double my = Math.abs(this.prevMotion.field_1351);
        double th = 0.5;
        if (this.isOperational() && this.isLandingGear() && class_3532.method_15379((float)this.method_36455()) < 15.0f && class_3532.method_15379((float)this.zRot) < 15.0f) {
            th = 1.5;
        }
        if (my > th) {
            float amount = (float)((my - th) * 300.0);
            this.collideHurt(amount, true);
        }
        if (this.isOperational() && this.isOnGround() && !this.isLandingGear() && this.getXZSpeed() > 0.5f && this.field_6012 % 8 == 0) {
            this.collideHurt(10.0f, false);
        }
    }

    public boolean method_5747(float dist, float mult, @NotNull class_1282 source) {
        this.verticalCollision();
        return true;
    }

    public void collideHurt(float amount, boolean isFall) {
        if (!this.isClientSide() && this.field_6012 > 200) {
            if (isFall) {
                this.method_5643(this.method_48923().method_48827(), amount);
            } else {
                this.method_5643(this.method_48923().method_48828(), amount);
            }
        } else if (this.isClientSide() && this.method_5787()) {
            new ToServerVehicleCollide(this.method_5628(), amount, isFall).sendToServer();
        }
    }

    protected Predicate<? super class_1297> getKnockbackPredicate() {
        return entity -> {
            class_1657 p;
            if (entity.field_5960) {
                return false;
            }
            if (entity.method_7325()) {
                return false;
            }
            if (this.equals(entity.method_5668())) {
                return false;
            }
            if (!(entity instanceof class_1309)) {
                return false;
            }
            if (entity instanceof class_1657 && (p = (class_1657)entity).method_7337()) {
                return false;
            }
            return !this.isFormerPassenger((class_1297)entity);
        };
    }

    private void tickDismountSafety() {
        this.formerPassengersServer.forEach((id, time) -> {
            if (time > 0) {
                time = time - 1;
            }
        });
    }

    public boolean isFormerPassenger(class_1297 passenger) {
        return this.formerPassengersServer.containsKey(passenger.method_5628()) && this.formerPassengersServer.get(passenger.method_5628()) > 0;
    }

    public void onSeatDismount(class_1297 entity) {
        if (!this.isClientSide()) {
            this.formerPassengersServer.put(entity.method_5628(), 100);
        } else {
            ClientInputEventHandlers.onEntityDismountVehicle(entity);
        }
    }

    protected void knockBack(List<class_1297> entities) {
        double push_factor = 10.0f * this.xzSpeed;
        if (push_factor < 2.0) {
            push_factor = 2.0;
        }
        double d0 = this.method_5829().method_1005().field_1352;
        double d1 = this.method_5829().method_1005().field_1350;
        for (class_1297 entity : entities) {
            if (entity.field_5960) continue;
            double d2 = entity.method_23317() - d0;
            double d3 = entity.method_23321() - d1;
            double d4 = Math.max(d2 * d2 + d3 * d3, 0.1);
            entity.method_5762(d2 / d4 * push_factor, 0.2, d3 / d4 * push_factor);
            if (!(push_factor > 2.0)) continue;
            entity.method_5643(VehicleDamageSource.roadKill(this), (float)push_factor * 2.0f);
        }
    }

    public void waterDamage() {
        if (this.field_6012 % 20 == 0 && this.method_5799() && this.isOperational()) {
            this.method_5643(this.method_48923().method_48824(), 5.0f);
        }
    }

    public void tickNoHealth() {
        int removeTicks;
        ++this.deadTicks;
        if (this.isFullyLooted()) {
            this.method_5768();
        }
        if ((removeTicks = this.getWorld().method_8450().method_8356(DSCGameRules.REMOVE_DEAD_VEHICLES_TIME) * 20) >= 0 && this.deadTicks >= removeTicks) {
            if (this.getWorld().method_8450().method_8355(class_1928.field_19393)) {
                this.dropAllItems();
            }
            this.method_5768();
        }
    }

    public boolean isFullyLooted() {
        return !this.isOperational() && this.partsManager.isEmpty() && !this.canDropIngredients();
    }

    @Override
    public boolean isOperational() {
        return this.getHealth() > 0.0f;
    }

    public int getDeadTicks() {
        return this.deadTicks;
    }

    public void clientTick() {
        UtilParticles.vehicleParticles(this);
        this.tickClientLandingGear();
    }

    @Override
    public double getMaxClimbSpeed() {
        return 2.5;
    }

    @Override
    public double getMaxFallSpeed() {
        return 5.0;
    }

    @Override
    public double getMaxSpeedForMotion() {
        double max = this.isOnGround() ? this.getMaxGroundSpeed() : (double)this.getMaxSpeed();
        if (this.applyHorizontalSpeedScale()) {
            max *= this.getHorizontalSpeedScale();
        }
        return max * this.getMaxSpeedFactor();
    }

    public double getMaxSpeedFactor() {
        return (Double)Config.SERVER.vehicleSpeedFactor.get();
    }

    public double getMaxGroundSpeed() {
        return ((VehicleStats)this.getStats()).max_ground_speed;
    }

    public void tickThrottle() {
        if (!this.isTestMode()) {
            boolean hasControllingPassenger = this.method_42148();
            boolean isPlayerOrBotRiding = this.isPlayerOrBotRiding();
            if (!this.isOperational() || this.cutThrottleOnNoPilot() && !hasControllingPassenger || this.cutThrottleOnNoPassengers() && !isPlayerOrBotRiding) {
                this.resetControls();
                this.inputs.setThrottleOverride(this.getCurrentThrottle(), this);
                this.previousThrottle = 0.0f;
                return;
            }
            if (!((this.cutThrottleOnNoPilot() || hasControllingPassenger && this.hadControllingPassenger) && (this.cutThrottleOnNoPassengers() || isPlayerOrBotRiding && this.wasPlayerOrBotRiding))) {
                this.inputs.setThrottleOverride(this.previousThrottle, this);
            }
            if (this.currentFuel <= 0.0f || this.isAllEnginesDamaged()) {
                this.throttleToZero();
                this.inputs.setThrottleOverride(this.getCurrentThrottle(), this);
                return;
            }
        }
        this.throttleTowards(this.inputs.getGoalThrottle(this));
    }

    public boolean cutThrottleOnNoPilot() {
        return true;
    }

    public boolean cutThrottleOnNoPassengers() {
        return true;
    }

    @Override
    public float getControlMaxDeltaPitch() {
        return this.getMaxDeltaPitch() * class_3532.method_15379((float)this.inputs.pitch);
    }

    @Override
    public float getControlMaxDeltaYaw() {
        return this.getMaxDeltaYaw() * class_3532.method_15379((float)this.inputs.yaw);
    }

    @Override
    public float getControlMaxDeltaRoll() {
        return this.getMaxDeltaRoll() * class_3532.method_15379((float)this.inputs.roll);
    }

    @Override
    public void calcMoveStatsPre(QuaternionF q) {
        this.totalMass = this.getEmptyVehicleMass() + this.partsManager.getPartsWeight();
        this.staticFric = (double)this.totalMass * 9.81 * 3.0;
        this.kineticFric = (double)this.totalMass * 9.81 * 1.5;
        this.maxPushThrust = this.partsManager.getTotalPushThrust();
        this.afterburnerMaxPushThrust = this.partsManager.getAfterburnerTotalPushThrust();
        this.maxSpinThrust = this.partsManager.getTotalSpinThrust();
        this.currentFuel = this.partsManager.getCurrentFuel();
        this.maxFuel = this.partsManager.getMaxFuel();
        this.hasFlares = !this.partsManager.getFlares().isEmpty();
        this.numFlares = this.partsManager.getNumFlares();
        this.airDensity = UtilVehicleEntity.getAirDensity((class_1297)this);
        this.groundTicks = this.isOnGround() ? ++this.groundTicks : 0;
        this.additionalRotInertia = this.partsManager.calcRotInertialFromParts();
    }

    @Override
    public void calcMoveStatsPost(QuaternionF q) {
        DrivingBody.super.calcMoveStatsPost(q);
        this.currentAltitude = UtilEntity.getDistFromSeaLevel((class_1297)this);
    }

    @Override
    public float getXZSpeed() {
        return this.xzSpeed;
    }

    @Override
    public int getXZSpeedDir() {
        return this.xzSpeedDir;
    }

    @Override
    public boolean applyHorizontalSpeedScale() {
        return ((VehicleStats)this.getStats()).use_horizontal_speed_scale;
    }

    @Override
    public double getHorizontalSpeedScale() {
        return DSCPhyCons.getIRLScale();
    }

    @Override
    public boolean applyVerticalAccScale() {
        return ((VehicleStats)this.getStats()).use_vertical_speed_scale;
    }

    @Override
    public double getVerticalAccScale(double verticalForce) {
        if (verticalForce < 0.0) {
            return 1.0;
        }
        return 0.125;
    }

    @Override
    public void method_5784(@NotNull class_1313 type, @NotNull class_243 move) {
        move = this.verifyLoadedChunk(move);
        super.method_5784(type, move);
        if (!this.field_5960 && this.isOnGround() && this.method_18798().field_1351 == 0.0) {
            this.stepDown(move);
        }
    }

    protected class_243 verifyLoadedChunk(@NotNull class_243 move) {
        class_1309 controller = this.method_5642();
        if (controller == null) {
            return move;
        }
        class_243 nextPos = controller.method_19538().method_1019(move.method_1029().method_1021(64.0));
        class_1923 nextChunk = new class_1923(UtilGeometry.toBlockPos((class_243)nextPos));
        if (this.getWorld().method_8393(nextChunk.field_9181, nextChunk.field_9180)) {
            return move;
        }
        LOGGER.warn("CHUNK AHEAD VEHICLE DOES NOT EXIST STOPPING MOVE FOR PILOT: {} | SPEED: {}", (Object)controller.method_5820(), (Object)move.method_1033());
        return class_243.field_1353;
    }

    protected void stepDown(class_243 move) {
        class_238 aabb = this.method_5829();
        class_243 down = new class_243(0.0, (double)(-this.field_6013) - 0.1, 0.0);
        List list = this.getWorld().method_20743((class_1297)this, aabb.method_18804(down));
        class_243 collide = EntityVehicle.method_20736((class_1297)this, (class_243)down, (class_238)aabb, (class_1937)this.getWorld(), (List)list);
        if (collide.field_1351 < 0.0 && collide.field_1351 >= (double)(-this.field_6013)) {
            this.method_5814(this.method_23317(), this.method_23318() + collide.field_1351, this.method_23321());
        }
    }

    @Override
    public double getDriveAcc() {
        return this.getSpinThrustMag() / (double)this.getTotalMass();
    }

    @Override
    public boolean isGroundBraking() {
        return false;
    }

    @Override
    public boolean canGroundBrake() {
        return this.isOnGround() && ((VehicleStats)this.getStats()).break_deacc_ground > 0.0f && this.isOperational();
    }

    @Override
    public boolean canAirBrake() {
        return !this.isOnGround() && ((VehicleStats)this.getStats()).break_deacc_air > 0.0f && this.isOperational();
    }

    @Override
    public boolean isAirBreaking() {
        return this.isGroundBraking();
    }

    public double getPushThrustMag() {
        if (this.getCurrentFuel() <= 0.0f || !this.isOperational()) {
            return 0.0;
        }
        return this.getCurrentThrottle() * this.getMaxPushThrust();
    }

    public float getMaxPushThrust() {
        return this.maxPushThrust;
    }

    public float getAfterburnerMaxPushThrust() {
        return this.afterburnerMaxPushThrust;
    }

    public double getSpinThrustMag() {
        if (this.getCurrentFuel() <= 0.0f || !this.isOperational()) {
            return 0.0;
        }
        return this.getCurrentThrottle() * this.getMaxSpinThrust();
    }

    public float getMaxSpinThrust() {
        return this.maxSpinThrust;
    }

    @Override
    public double getDragArea() {
        double a = ((VehicleStats)this.getStats()).drag_area;
        if (this.canToggleLandingGear() && this.isLandingGear() && !this.isOnGround()) {
            a += 100.0;
        }
        if (!this.isOperational()) {
            a += 1000.0;
        }
        return a;
    }

    @Override
    public double getDragCoefficient() {
        return DSCPhyCons.getDragScale();
    }

    public double getRadarArea(class_243 radarPos) {
        double a = this.getBaseCrossSecArea();
        if (this.canToggleLandingGear() && this.isLandingGear()) {
            a += 1.0;
        }
        return a;
    }

    @Override
    public float getTotalMass() {
        if (Float.isNaN(this.totalMass)) {
            LOGGER.warn("ERROR: NAN MASS? setting to 10000 | {}", (Object)this);
            this.totalMass = 10000.0f;
        } else if (this.totalMass == 0.0f) {
            LOGGER.warn("ERROR: 0 MASS? setting to 10000 | {}", (Object)this);
            this.totalMass = 10000.0f;
        }
        return this.totalMass;
    }

    public final float getEmptyVehicleMass() {
        return ((VehicleStats)this.getStats()).mass;
    }

    public void controlSystem() {
        this.tickThrottle();
        if (!this.isOperational()) {
            return;
        }
        this.radarSystem.tick();
        class_1309 controller = this.method_5642();
        if (!this.isClientSide()) {
            class_3222 player;
            boolean consume;
            this.weaponSystem.serverTick();
            if (controller == null) {
                return;
            }
            boolean bl = consume = !this.isNoConsume();
            if (controller instanceof class_3222 && (player = (class_3222)controller).method_7337()) {
                consume = false;
            }
            boolean consumeFuel = this.getWorld().method_8450().method_8355(DSCGameRules.CONSUME_FULE);
            if (consume && consumeFuel) {
                this.tickFuel();
            }
            if (this.inputs.flare && this.field_6012 - this.flareTicks >= 10) {
                boolean consumeFlares = this.getWorld().method_8450().method_8355(DSCGameRules.CONSUME_FLARES);
                this.flare((class_1297)controller, consume && consumeFlares);
            }
        }
        this.hadControllingPassenger = this.method_42148();
        this.wasPlayerOrBotRiding = this.isPlayerOrBotRiding();
        if (this.hadControllingPassenger) {
            this.previousThrottle = this.getCurrentThrottle();
        }
    }

    public void openPartsMenu(class_3222 player) {
        MenuRegistry.openExtendedMenu((class_3222)player, (ExtendedMenuProvider)new ExtendedMenuProvider(){

            public void saveExtraData(class_2540 buf) {
            }

            @NotNull
            public class_2561 method_5476() {
                return UtilMCText.translatable((String)"screen.dscombat.vehicle_parts_screen");
            }

            public class_1703 createMenu(int windowId, class_1661 inventory, class_1657 player) {
                return new VehiclePartsMenu(windowId, inventory);
            }
        });
    }

    public void openStorage(class_3222 player, int index) {
        final StorageInstance<?> box = this.partsManager.getStorageData(index);
        if (box == null) {
            player.method_7353((class_2561)UtilMCText.translatable((String)"error.dscombat.no_storage_boxes"), true);
            return;
        }
        MenuRegistry.openExtendedMenu((class_3222)player, (ExtendedMenuProvider)new ExtendedMenuProvider(){
            final /* synthetic */ EntityVehicle this$0;
            {
                this.this$0 = this$0;
            }

            public void saveExtraData(class_2540 buf) {
                buf.writeInt(this.this$0.partsManager.getStorageIndex());
            }

            @NotNull
            public class_2561 method_5476() {
                return UtilMCText.translatable((String)"screen.dscombat.vehicle_inventory_screen");
            }

            @Nullable
            public class_1703 createMenu(int windowId, class_1661 inventory, class_1657 player) {
                return box.createMenu(windowId, inventory);
            }
        });
    }

    public boolean canOpenPartsMenu() {
        return this.isOnGround() && (double)this.xzSpeed < 0.1 || this.isTestMode();
    }

    public String getOpenMenuError() {
        if (!this.isOnGround()) {
            return "error.dscombat.no_menu_in_air";
        }
        return "error.dscombat.no_menu_moving";
    }

    public void flare(class_1297 controller, boolean consume) {
        if (this.partsManager.useFlares(consume)) {
            ToClientOnShoot.onShootFlareRack(this, controller);
            this.flareTicks = this.field_6012;
        }
    }

    public void tickParts() {
        this.findGimbalForPilotCamera();
        if (this.isClientSide()) {
            this.partsManager.clientTickParts();
        } else {
            this.partsManager.serverTickParts();
        }
    }

    public void method_5750(double x, double y, double z) {
        if (!this.method_5787()) {
            super.method_5750(x, y, z);
            return;
        }
    }

    public void method_5759(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpSteps = teleport ? posRotationIncrements : 1;
    }

    private void tickLerp() {
        if (this.method_5787()) {
            this.method_43391(this.method_23317(), this.method_23318(), this.method_23321());
            this.syncMoveRot();
            this.lerpSteps = 0;
            return;
        }
        if (this.lerpSteps > 0) {
            double d0 = this.method_23317() + (this.lerpX - this.method_23317()) / (double)this.lerpSteps;
            double d1 = this.method_23318() + (this.lerpY - this.method_23318()) / (double)this.lerpSteps;
            double d2 = this.method_23321() + (this.lerpZ - this.method_23321()) / (double)this.lerpSteps;
            --this.lerpSteps;
            this.method_5814(d0, d1, d2);
        }
    }

    private void syncMoveRot() {
        if (!this.isClientSide() || this.field_6012 % 10 != 0 || this.field_5953) {
            return;
        }
        new ToServerVehicleMoveRot(this).sendToServer();
    }

    public void resetControls() {
        this.inputs.reset();
        this.throttleToZero();
    }

    public final boolean isDriverCameraLocked() {
        return this.isDriverCameraLocked;
    }

    public final void setDriverCameraLocked(boolean driverCameraLocked) {
        this.isDriverCameraLocked = driverCameraLocked;
    }

    public RadarStats.RadarMode getRadarMode() {
        return (RadarStats.RadarMode)((Object)this.field_6011.method_12789(RADAR_MODE));
    }

    public void setRadarMode(RadarStats.RadarMode mode) {
        this.field_6011.method_12778(RADAR_MODE, (Object)mode);
    }

    public void cycleRadarMode() {
        this.setRadarMode(this.getRadarMode().cycle());
    }

    public final String getRadioSong() {
        return (String)this.field_6011.method_12789(RADIO_SONG);
    }

    public boolean hasRadioSong() {
        return !this.getRadioSong().isEmpty();
    }

    public final void setRadioSong(String song) {
        this.field_6011.method_12778(RADIO_SONG, (Object)song);
    }

    public void turnRadioOff() {
        this.setRadioSong("");
    }

    public void serverSetup() {
        this.partsManager.setupParts();
    }

    public void clientSetup() {
        this.soundManager.onClientInit();
    }

    @NotNull
    public class_1269 method_5688(@NotNull class_1657 player, @NotNull class_1268 hand) {
        class_1269 result;
        if ((double)this.xzSpeed > 0.2 && !this.isTestMode()) {
            return class_1269.field_5811;
        }
        if (player.method_21823()) {
            return class_1269.field_5811;
        }
        if (player.method_5668().equals((Object)this)) {
            return class_1269.field_5811;
        }
        class_1799 stack = player.method_31548().method_7391();
        if (!stack.method_7960() && (result = this.onItemInteract(player, hand, stack)) != class_1269.field_5814) {
            return result;
        }
        if (!this.isOperational()) {
            return this.onDestroyedInteract(player, hand);
        }
        if (!this.isClientSide()) {
            return this.rideAvailableSeat((class_1297)player) ? class_1269.field_21466 : class_1269.field_5811;
        }
        class_310 m = class_310.method_1551();
        if (m.field_1724 != null && m.field_1724.equals((Object)player)) {
            DSCClientInputs.centerMousePos();
        }
        return class_1269.field_5812;
    }

    protected class_1269 onItemInteract(class_1657 player, class_1268 hand, class_1799 stack) {
        if (stack.method_31573(ModTags.Items.SPRAY_CAN)) {
            return this.onSprayCanInteract(player, hand, stack);
        }
        if (!this.isClientSide()) {
            class_1792 item = stack.method_7909();
            if (item instanceof VehicleInteractItem) {
                VehicleInteractItem vii = (VehicleInteractItem)item;
                return vii.onServerInteract(this, stack, player, hand);
            }
            if (!this.isOperational()) {
                return class_1269.field_5814;
            }
            if (stack.method_31573(ModTags.Items.GAS_CAN)) {
                return this.onGasCanInteract(player, hand, stack);
            }
            if (stack.method_31573(ModTags.Items.OIL_BUCKET)) {
                return this.onOilBucketInteract(player, hand, stack);
            }
            if (stack.method_31573(ModTags.Items.VEHICLE_CHAIN)) {
                return this.onChainInteract(player, hand, stack);
            }
            if (item instanceof class_1813) {
                class_1813 disk = (class_1813)item;
                if (!this.hasRadio) {
                    return class_1269.field_5811;
                }
                this.setRadioSong(disk.method_8009().method_14833().toString());
                return class_1269.field_5812;
            }
            if (item instanceof class_1807) {
                class_1807 name = (class_1807)item;
                if (stack.method_7938()) {
                    this.method_5665(stack.method_7964());
                    this.method_5880(true);
                    stack.method_7934(1);
                    return class_1269.field_21466;
                }
                return class_1269.field_5811;
            }
        }
        return class_1269.field_5814;
    }

    protected class_1269 onGasCanInteract(class_1657 player, class_1268 hand, class_1799 stack) {
        int md = stack.method_7936();
        int d = stack.method_7919();
        int r = (int)this.addFuel(md - d);
        stack.method_7974(md - r);
        return class_1269.method_29236((boolean)this.isClientSide());
    }

    protected class_1269 onOilBucketInteract(class_1657 player, class_1268 hand, class_1799 stack) {
        float fuelPerBucket = DSCGameRules.getFuelPerOilBlock(this.getWorld());
        if (this.addFuel(fuelPerBucket) == fuelPerBucket) {
            return class_1269.field_5811;
        }
        class_1799 remain = UtilItem.getCraftingRemainingItem((class_1799)stack);
        player.method_31548().method_5447(player.method_31548().field_7545, remain);
        return class_1269.method_29236((boolean)this.isClientSide());
    }

    protected class_1269 onSprayCanInteract(class_1657 player, class_1268 hand, class_1799 stack) {
        if (this.isClientSide()) {
            UtilClientPacket.openVehicleTextureScreen(this.textureManager);
        }
        return class_1269.method_29236((boolean)this.isClientSide());
    }

    protected class_1269 onChainInteract(class_1657 player, class_1268 hand, class_1799 stack) {
        List hooks = this.getWorld().method_8390(EntityChainHook.class, this.method_5829().method_1014(8.0), hook -> hook.isPlayerConnected(player));
        for (EntityChainHook hook2 : hooks) {
            if (!hook2.addVehicleConnection(player, this)) continue;
            this.chainToHook(hook2);
            stack.method_7934(1);
            break;
        }
        return class_1269.method_29236((boolean)this.isClientSide());
    }

    protected class_1269 onDestroyedInteract(class_1657 player, class_1268 hand) {
        if (this.partsManager.dropPartItem()) {
            this.playTheftSound();
            return class_1269.method_29236((boolean)this.isClientSide());
        }
        if (this.dropIngredient()) {
            this.playTheftSound();
            return class_1269.method_29236((boolean)this.isClientSide());
        }
        return class_1269.field_5811;
    }

    public boolean dropIngredient() {
        if (this.isClientSide()) {
            return false;
        }
        while (this.canDropIngredients()) {
            ++this.ingredientDropIndex;
            class_1856 ing = (class_1856)((VehicleStats)this.getStats()).getIngredients().get(this.ingredientDropIndex);
            for (int i = 0; i < ing.method_8105().length; ++i) {
                if (!ing.method_8105()[i].method_31573(ModTags.Items.RECOVERABLE)) continue;
                class_1799 stack = ing.method_8105()[i].method_7972();
                stack.method_7939(UtilRandom.weightedRandomInt(stack.method_7947(), (Double)Config.COMMON.recoverPartWeight.get()));
                UtilEntity.dropItemStack((class_1297)this, (class_1799)stack);
                return true;
            }
        }
        return false;
    }

    public boolean canDropIngredients() {
        return this.ingredientDropIndex < ((VehicleStats)this.getStats()).getIngredients().size() - 1;
    }

    public void playTheftSound() {
        this.getWorld().method_43129(null, (class_1297)this, class_3417.field_14670, this.method_5634(), 0.5f, 1.0f);
    }

    public void dropAllItems() {
        this.dropAllParts();
        this.dropAllIngredients();
    }

    public void dropAllParts() {
        if (this.getWorld().field_9236) {
            return;
        }
        this.partsManager.dropAllItems();
    }

    public void dropAllIngredients() {
        if (this.getWorld().field_9236) {
            return;
        }
        while (this.dropIngredient()) {
        }
    }

    @Nullable
    public class_1657 getChainHolderPlayer() {
        return this.chainHolderPlayer;
    }

    @Nullable
    public EntityChainHook getChainHolderHook() {
        return this.chainHolderHook;
    }

    public void chainToHook(EntityChainHook hook) {
        this.chainHolderPlayer = null;
        this.chainHolderHook = hook;
    }

    public boolean chainToPlayer(class_1657 player) {
        this.chainHolderPlayer = player;
        this.chainHolderHook = null;
        if (!this.isClientSide()) {
            UtilServerPacket.sendVehicleAddPlayer(this, player);
        }
        return true;
    }

    public void disconnectChain() {
        this.chainHolderPlayer = null;
        this.chainHolderHook = null;
    }

    public boolean isChainConnectedToPlayer(class_1657 player) {
        return this.getChainHolderPlayer() != null && this.getChainHolderPlayer().equals((Object)player);
    }

    public void playRepairSound() {
        class_3414 sound = this.isMaxHealth() ? class_3417.field_14559 : class_3417.field_14785;
        this.getWorld().method_43129(null, (class_1297)this, sound, this.method_5634(), 0.5f, 1.0f);
    }

    private boolean ridePilotSeat(class_1297 e, List<EntityRidablePart> seats) {
        for (EntityRidablePart seat : seats) {
            if (!seat.isPilotSeat()) continue;
            return e.method_5804((class_1297)seat);
        }
        return false;
    }

    public boolean ridePassengerSeat(class_1297 e) {
        List<EntityRidablePart> seats = this.getSeats();
        for (EntityRidablePart seat : seats) {
            if (seat.isPilotSeat() || !e.method_5804((class_1297)seat)) continue;
            return true;
        }
        return false;
    }

    public boolean rideAvailableSeat(class_1297 e) {
        List<EntityRidablePart> seats = this.getSeats();
        if (this.ridePilotSeat(e, seats)) {
            return true;
        }
        for (EntityRidablePart seat : seats) {
            if (!e.method_5804((class_1297)seat)) continue;
            return true;
        }
        return false;
    }

    public boolean switchSeat(class_1297 e) {
        int i;
        List<EntityRidablePart> seats = this.getSeats();
        int seatIndex = -1;
        for (i = 0; i < seats.size(); ++i) {
            class_1657 p = seats.get(i).getPlayer();
            if (p == null || !p.equals((Object)e)) continue;
            seatIndex = i;
            break;
        }
        if (seatIndex == -1) {
            return false;
        }
        i = 0;
        int j = seatIndex + 1;
        while (i < seats.size() - 1) {
            if (j >= seats.size()) {
                j = 0;
            }
            if (e.method_5804((class_1297)seats.get(j))) {
                return true;
            }
            ++i;
            ++j;
        }
        return false;
    }

    public boolean hasOpenPassengerSeat() {
        List<EntityRidablePart> seats = this.getSeats();
        for (EntityRidablePart seat : seats) {
            if (seat.getPassenger() != null) continue;
            return true;
        }
        return false;
    }

    public void method_5865(@NotNull class_1297 passenger, class_1297.class_4738 moveFunction) {
        if (passenger instanceof EntityPart) {
            EntityPart part = (EntityPart)passenger;
            class_243 pos = this.convertRelPos(part.getRelativePos());
            moveFunction.accept(passenger, pos.field_1352, pos.field_1351, pos.field_1350);
            return;
        }
    }

    public class_243 convertRelPos(class_243 rel_pos) {
        return UtilAngles.rotateVector((class_243)rel_pos, (QuaternionF)this.getQBySide()).method_1019(this.method_19538());
    }

    @Nullable
    public class_1309 method_5642() {
        for (EntityRidablePart seat : this.getSeats()) {
            if (!seat.isPilotSeat()) continue;
            return seat.getPlayer();
        }
        return null;
    }

    @Nullable
    public class_1297 getControllingPlayerOrBot() {
        class_1657 playerAlt = null;
        class_1657 alt = null;
        for (EntityRidablePart seat : this.getSeats()) {
            class_1309 mob;
            class_1657 player;
            if (seat.isPilotSeat() && (player = seat.getPlayer()) != null) {
                return player;
            }
            if (playerAlt == null && (player = seat.getPlayer()) != null) {
                playerAlt = player;
            }
            if (alt != null || !seat.hasAIUsingTurret() || (mob = seat.getPassenger()) == null) continue;
            alt = mob;
        }
        return playerAlt != null ? playerAlt : alt;
    }

    public boolean isPlayerRiding() {
        for (EntityRidablePart seat : this.getSeats()) {
            if (seat.getPlayer() == null) continue;
            return true;
        }
        return false;
    }

    public boolean isBotUsingRadar() {
        for (EntityTurret turret : this.getTurrets()) {
            if (!turret.isBotUsingRadar()) continue;
            return true;
        }
        return false;
    }

    public boolean isPlayerOrBotRiding() {
        for (EntityRidablePart seat : this.getSeats()) {
            if (!seat.isPlayerOrBotRiding()) continue;
            return true;
        }
        return false;
    }

    protected void method_5627(@NotNull class_1297 passenger) {
        super.method_5627(passenger);
    }

    protected boolean method_5818(@NotNull class_1297 passenger) {
        return passenger instanceof EntityPart;
    }

    protected boolean method_5860(@NotNull class_1297 entityIn) {
        return false;
    }

    @Nullable
    public EntityRidablePart getPassengerSeat(class_1297 p) {
        for (EntityRidablePart seat : this.getSeats()) {
            if (!p.equals((Object)seat.getPassenger())) continue;
            return seat;
        }
        return null;
    }

    public boolean isVehicleOf(class_1297 e) {
        if (e == null) {
            return false;
        }
        List list = this.method_5685();
        if (list.contains(e)) {
            return true;
        }
        for (class_1297 l : list) {
            EntityRidablePart seat;
            List list2;
            if (!(l instanceof EntityRidablePart) || !(list2 = (seat = (EntityRidablePart)l).method_5685()).contains(e)) continue;
            return true;
        }
        return false;
    }

    public boolean method_5703(@NotNull Predicate<class_1297> pPredicate) {
        for (EntityRidablePart seat : this.getSeats()) {
            if (!pPredicate.test((class_1297)seat.getPassenger())) continue;
            return true;
        }
        return false;
    }

    public double method_5621() {
        return 0.0;
    }

    public boolean method_5810() {
        return false;
    }

    public boolean method_5675() {
        return true;
    }

    public boolean method_5863() {
        return this.rootHitboxEntityInteract();
    }

    public boolean method_5732() {
        return this.rootHitboxEntityInteract();
    }

    public boolean method_30948() {
        return this.rootHitboxEntityInteract();
    }

    public boolean method_30949(@NotNull class_1297 entity) {
        if (!super.method_30949(entity)) {
            return false;
        }
        if (entity.method_5810()) {
            return false;
        }
        return !this.isHitboxParent(entity);
    }

    public boolean method_5643(@NotNull class_1282 source, float amount) {
        return this.hurtLogic(source, amount, null);
    }

    public boolean hurtHitbox(class_1282 source, float amount, RotableHitbox hitbox) {
        return this.hurtLogic(source, amount, hitbox, hitbox.getHitboxData().isDamageRoot());
    }

    public boolean hurtLogic(class_1282 source, float amount, @Nullable RotableHitbox hitbox, boolean hurtRoot) {
        if (this.method_5679(source)) {
            return false;
        }
        if (UtilVehicleEntity.isFire(source)) {
            this.hurtByFireTime = this.field_6012;
        }
        this.soundManager.onHurt(source, amount);
        this.damage(source, amount, hitbox, hurtRoot);
        if (!this.isClientSide()) {
            if (!this.isOperational()) {
                this.partsManager.damageAllParts();
                this.checkExplodeWhenKilled(source);
            } else {
                this.damageParts(source, amount, hitbox, hurtRoot);
            }
        }
        return true;
    }

    public boolean hurtLogic(class_1282 source, float amount, @Nullable RotableHitbox hitbox) {
        return this.hurtLogic(source, amount, hitbox, true);
    }

    protected void damage(class_1282 source, float amount, @Nullable RotableHitbox hitbox) {
        this.damage(source, amount, hitbox, true);
    }

    protected void damage(class_1282 source, float amount, @Nullable RotableHitbox hitbox, boolean hurtRoot) {
        float remainingArmor;
        if (!UtilVehicleEntity.isExplosion(source) && source.method_5526() != null && source.method_5526().method_5864().method_20210(ModTags.EntityTypes.PROJECTILE)) {
            amount = this.calcDamageFromBullet(source, amount);
        }
        float armorDamage = this.calcDamageToArmor(amount);
        float healthDamageWithArmorPercent = EntityVehicle.getHealthDamageWithArmorPercent(source);
        float healthDamage = armorDamage * healthDamageWithArmorPercent;
        armorDamage *= 1.0f - healthDamageWithArmorPercent;
        if (hurtRoot) {
            if (this.getArmor() > 0.0f) {
                remainingArmor = Math.min(this.getArmor() - armorDamage, 0.0f);
                this.addArmor(-armorDamage);
                this.addHealth(-healthDamage + remainingArmor);
            } else {
                this.addHealth(-amount);
            }
        }
        if (hitbox != null) {
            if (hitbox.getArmor() > 0.0f) {
                remainingArmor = Math.min(hitbox.getArmor() - armorDamage, 0.0f);
                hitbox.addArmor(-armorDamage);
                hitbox.addHealth(-healthDamage + remainingArmor);
            } else {
                hitbox.addHealth(-amount);
            }
        }
    }

    public static float getHealthDamageWithArmorPercent(class_1282 source) {
        if (UtilVehicleEntity.isExplosion(source)) {
            return 0.2f;
        }
        if (UtilVehicleEntity.isBypassArmor(source)) {
            return 0.8f;
        }
        if (UtilVehicleEntity.isFire(source)) {
            return 0.7f;
        }
        return 0.0f;
    }

    public float calcDamageToArmor(float amount) {
        return Math.max(0.0f, EntityVehicle.reduceByPercent(amount, ((VehicleStats)this.getStats()).armor_damage_absorbtion * DSCGameRules.getVehicleArmorStrengthFactor(this.getWorld())) - ((VehicleStats)this.getStats()).armor_damage_threshold);
    }

    public float calcDamageToInside(class_1282 source, float amount) {
        return this.calcDamageToArmor(amount) * EntityVehicle.getHealthDamageWithArmorPercent(source);
    }

    public float calcDamageToRider(class_1282 source, float amount) {
        if (this.getArmor() > 0.0f) {
            return this.calcDamageToInside(source, amount);
        }
        return amount;
    }

    private boolean shouldDebug(class_1282 source) {
        return !UtilVehicleEntity.isFire(source);
    }

    protected float calcDamageFromBullet(class_1282 source, float amount) {
        return amount * DSCGameRules.getBulletDamageVehicleFactor(this.getWorld());
    }

    private static float reduceByPercent(float amount, float percent) {
        return Math.max(amount - amount * percent, 0.0f);
    }

    public boolean method_5679(@NotNull class_1282 source) {
        if (this.isTestMode()) {
            return true;
        }
        if (super.method_5679(source)) {
            return true;
        }
        if (UtilVehicleEntity.isFire(source) && this.field_6012 - this.hurtByFireTime < 10) {
            return true;
        }
        return this.isVehicleOf(source.method_5529());
    }

    public void damageParts(class_1282 source, float amount, @Nullable RotableHitbox hitbox, boolean hurtRoot) {
        float healthPercent;
        if (hitbox != null && hitbox.getHitboxData().isDamageParts() && hitbox.isDestroyed()) {
            this.partsManager.damageAllHitboxParts(hitbox.getHitboxName());
            return;
        }
        boolean damageRoot = this.shouldDamageRoot(hitbox, hurtRoot);
        if (damageRoot) {
            healthPercent = this.getHealth() / this.getMaxHealth();
        } else {
            if (hitbox == null) {
                return;
            }
            if (!hitbox.getHitboxData().isDamageParts()) {
                return;
            }
            healthPercent = hitbox.getHealth() / hitbox.getMaxHealth();
        }
        if (healthPercent > 0.5f) {
            return;
        }
        float damagePercent = (1.0f - healthPercent * 2.0f) * amount * 0.1f;
        if (this.field_5974.method_43057() > damagePercent) {
            return;
        }
        if (damageRoot) {
            this.partsManager.damageRootPart();
        } else {
            this.partsManager.damageHitboxPart(hitbox.getHitboxName());
        }
    }

    private boolean shouldDamageRoot(@Nullable RotableHitbox hitbox, boolean hurtRoot) {
        return hurtRoot && (hitbox == null || hitbox.isDestroyed());
    }

    protected boolean checkExplodeWhenKilled(class_1282 source) {
        if (source.method_49708(class_8111.field_42345)) {
            this.explode(VehicleDamageSource.fall(this));
            return true;
        }
        if (source.method_49708(class_8111.field_42346)) {
            this.explode(VehicleDamageSource.collide(this));
            return true;
        }
        return false;
    }

    public void addForceMomentToClient(class_243 force, class_243 moment) {
        if (this.isClientSide()) {
            return;
        }
        this.addForceBetweenTicks = this.addForceBetweenTicks.method_1019(force);
        this.addMomentBetweenTicks = this.addMomentBetweenTicks.method_1019(moment);
        PacketHandler.sendToTrackers(new ToClientAddForceMoment(this, force, moment), (class_1297)this);
    }

    public void explode(class_1282 source) {
        if (this.isClientSide()) {
            return;
        }
        this.getWorld().method_8454((class_1297)this, source, null, this.method_23317(), this.method_23318(), this.method_23321(), ((VehicleStats)this.getStats()).crashExplosionRadius, true, class_1937.class_7867.field_40891);
        this.explodeSeats(source);
        PacketHandler.sendToTrackers(new ToClientVehicleExplode(this), (class_1297)this);
    }

    public void explodeSeats(class_1282 source) {
        for (EntityRidablePart seat : this.getSeats()) {
            seat.explode(source, (class_1297)this);
        }
    }

    public boolean method_5659() {
        return true;
    }

    public void customExplosionHandler(class_1927 exp, @Nullable RotableHitbox hitbox) {
        CustomExplosion entity = hitbox == null ? this : hitbox;
        class_243 s = new class_243(exp.field_9195, exp.field_9192, exp.field_9189);
        class_243 b = this.getClosest(s, hitbox);
        class_243 r = b.method_1020(entity.method_19538());
        float diameter = exp.field_9190 * 2.0f;
        double dist_check = Math.sqrt(b.method_1025(s)) / (double)diameter;
        if (dist_check > 1.0) {
            return;
        }
        class_1297 exp_entity = exp.method_8349().method_5526();
        double dx = b.field_1352 - s.field_1352;
        double dy = b.field_1351 - s.field_1351;
        double dz = b.field_1350 - s.field_1350;
        double d = Math.sqrt(dx * dx + dy * dy + dz * dz);
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return;
        }
        if (d == 0.0) {
            if (exp_entity != null) {
                class_243 dir = exp_entity.method_5720();
                dx = dir.field_1352;
                dy = dir.field_1351;
                dz = dir.field_1350;
            } else {
                dx = 0.0;
                dy = 1.0;
                dz = 0.0;
            }
        } else {
            dx /= d;
            dy /= d;
            dz /= d;
        }
        double seen_percent = class_1927.method_17752((class_243)s, (class_1297)entity);
        double exp_factor = (1.0 - dist_check) * seen_percent;
        float amount = (int)((exp_factor * exp_factor + exp_factor) * 3.5 * (double)diameter + 1.0);
        amount *= DSCGameRules.getExplodeDamagerVehicleFactor(this.getWorld());
        if (hitbox != null) {
            this.hurtLogic(exp.method_8349(), amount, hitbox, false);
        } else {
            this.hurtLogic(exp.method_8349(), amount, null);
        }
        class_243 force = new class_243(dx * exp_factor, dy * exp_factor, dz * exp_factor).method_1021(1.0E7);
        class_243 f = s.equals((Object)b) && exp_entity != null ? exp_entity.method_18798().method_1029().method_1021(exp_factor * 1.0E8) : s.method_1020(b).method_1029().method_1021(exp_factor * 1.0E8);
        class_243 moment = r.method_1036(UtilAngles.rotateVectorInverse((class_243)f, (QuaternionF)this.getQBySide()));
        this.addForceMomentToClient(force, moment);
    }

    @Override
    public void customExplosionHandler(class_1927 exp) {
        this.customExplosionHandler(exp, null);
    }

    private class_243 getClosest(class_243 pos, @Nullable RotableHitbox hitbox) {
        if (hitbox == null) {
            return UtilGeometry.getClosestPointOnAABB((class_243)pos, (class_238)this.method_5829());
        }
        Optional<class_243> clip = hitbox.getHitbox().clip(pos, hitbox.method_19538());
        return clip.orElseGet(() -> ((RotableHitbox)hitbox).method_19538());
    }

    public final float getMaxSpeed() {
        if (this.isUsingAfterburner()) {
            return ((VehicleStats)this.getStats()).max_speed;
        }
        return ((VehicleStats)this.getStats()).cruise_speed;
    }

    @Override
    public final float getCurrentThrottle() {
        return this.throttle;
    }

    public final void setCurrentThrottle(float throttle) {
        if (throttle > 1.0f) {
            throttle = 1.0f;
        } else if (((VehicleStats)this.getStats()).negativeThrottle && throttle < -1.0f) {
            throttle = -1.0f;
        } else if (!((VehicleStats)this.getStats()).negativeThrottle && throttle < 0.0f) {
            throttle = 0.0f;
        }
        this.throttle = throttle;
    }

    public void throttleToZero() {
        float th = this.getCurrentThrottle();
        if (th == 0.0f) {
            return;
        }
        float r = this.getThrottleDecreaseRate();
        if (Math.abs(th -= r * Math.signum(th)) < r) {
            th = 0.0f;
        }
        this.setCurrentThrottle(th);
    }

    public void throttleTowards(float throttle) {
        this.setCurrentThrottle(class_3532.method_15348((float)this.getCurrentThrottle(), (float)throttle, (float)this.getThrottleIncreaseRate()));
    }

    public final float getThrottleIncreaseRate() {
        return ((VehicleStats)this.getStats()).throttleup;
    }

    public final float getThrottleDecreaseRate() {
        return ((VehicleStats)this.getStats()).throttledown;
    }

    public final float getMaxDeltaPitch() {
        return ((VehicleStats)this.getStats()).maxpitch;
    }

    public final float getMaxDeltaYaw() {
        return ((VehicleStats)this.getStats()).maxyaw;
    }

    public final float getMaxDeltaRoll() {
        return ((VehicleStats)this.getStats()).maxroll;
    }

    public final float getPitchTorque() {
        return ((VehicleStats)this.getStats()).torquepitch;
    }

    public final float getYawTorque() {
        return ((VehicleStats)this.getStats()).torqueyaw;
    }

    public final float getRollTorque() {
        return ((VehicleStats)this.getStats()).torqueroll;
    }

    public void increaseThrottle() {
        this.setCurrentThrottle(this.getCurrentThrottle() + this.getThrottleIncreaseRate());
    }

    public void decreaseThrottle() {
        this.setCurrentThrottle(this.getCurrentThrottle() - this.getThrottleDecreaseRate());
    }

    @Override
    public final QuaternionF getQBySide() {
        if (this.isClientSide()) {
            return this.getClientQ();
        }
        return this.getQ();
    }

    @Override
    public final void setQBySide(QuaternionF q) {
        if (this.isClientSide()) {
            this.setClientQ(q);
        } else {
            this.setQ(q);
        }
    }

    public final QuaternionF getQ() {
        return ((QuaternionF)this.field_6011.method_12789(Q)).copy();
    }

    public final void setQ(QuaternionF q) {
        this.field_6011.method_12778(Q, (Object)q.copy());
    }

    public final QuaternionF getClientQ() {
        return this.clientQ.copy();
    }

    public final void setClientQ(QuaternionF q) {
        this.clientQ = q.copy();
    }

    @Override
    public final QuaternionF getPrevQ() {
        return this.prevQ.copy();
    }

    @Override
    public final void setPrevQ(QuaternionF q) {
        this.prevQ = q.copy();
    }

    public QuaternionF getClientQ(float partialTicks) {
        return UtilAngles.lerpQ((float)partialTicks, (QuaternionF)this.getPrevQ(), (QuaternionF)this.getClientQ());
    }

    public final float getBaseCrossSecArea() {
        return ((VehicleStats)this.getStats()).cross_sec_area;
    }

    @Override
    public final class_243 getMoment() {
        return this.moment;
    }

    @Override
    public final class_243 getForces() {
        return this.forces;
    }

    @Override
    public final class_243 getAngularVel() {
        if (this.isClientSide()) {
            return this.clientAV;
        }
        return (class_243)this.field_6011.method_12789(AV);
    }

    @Override
    public final void setMoment(class_243 m) {
        this.moment = m;
    }

    @Override
    public final void setForces(class_243 f) {
        this.forces = f;
    }

    @Override
    public final void setAngularVel(class_243 av) {
        if (this.isClientSide()) {
            this.clientAV = av;
        } else {
            this.field_6011.method_12778(AV, (Object)av);
        }
    }

    public final float getStealth() {
        return ((VehicleStats)this.getStats()).stealth;
    }

    public class_1799 getItem() {
        class_1799 stack = ((VehicleStats)this.getStats()).getItem();
        class_2487 tag = new class_2487();
        this.method_5652(tag);
        class_2487 eTag = new class_2487();
        eTag.method_10566("EntityTag", (class_2520)tag);
        eTag.method_10582("preset", this.getStatsId());
        stack.method_7980(eTag);
        return stack;
    }

    public boolean canBecomeItem() {
        int fresh = this.getWorld().method_8450().method_8356(DSCGameRules.ITEM_COOLDOWN_VEHICLE_FRESH);
        int shoot = this.getWorld().method_8450().method_8356(DSCGameRules.ITEM_COOLDOWN_VEHICLE_SHOOT);
        return this.field_6012 / 20 > fresh && (this.lastShootTime == -1 || (this.field_6012 - this.lastShootTime) / 20 > shoot);
    }

    @Nullable
    public class_2561 getCantBecomeItemReason(class_1657 player) {
        boolean canItemWhileMoving = this.getWorld().method_8450().method_8355(DSCGameRules.CAN_ITEM_WHILE_MOVING);
        if (!(canItemWhileMoving || this.isOnGround() || this.ignoreToItemFlyCheck())) {
            return UtilMCText.translatable((String)"error.dscombat.cant_item_while_flying");
        }
        if (!canItemWhileMoving && this.method_18798().method_1027() > 0.01) {
            return UtilMCText.translatable((String)"error.dscombat.cant_item_while_moving");
        }
        EntityRidablePart seat = this.getPassengerSeat((class_1297)player);
        if (seat == null) {
            return UtilMCText.translatable((String)"error.dscombat.not_a_passenger");
        }
        if (!seat.isPilotSeat()) {
            return UtilMCText.translatable((String)"error.dscombat.not_a_pilot");
        }
        int fresh = this.getWorld().method_8450().method_8356(DSCGameRules.ITEM_COOLDOWN_VEHICLE_FRESH);
        int fresh_diff = fresh - this.field_6012 / 20;
        if (fresh_diff > 0) {
            return UtilMCText.translatable((String)"error.dscombat.cant_item_yet_fresh", (Object[])new Object[]{fresh_diff});
        }
        if (this.lastShootTime == -1) {
            return null;
        }
        int shoot = this.getWorld().method_8450().method_8356(DSCGameRules.ITEM_COOLDOWN_VEHICLE_SHOOT);
        int shoot_diff = shoot - (this.field_6012 - this.lastShootTime) / 20;
        if (shoot_diff > 0) {
            return UtilMCText.translatable((String)"error.dscombat.cant_item_yet_shoot", (Object[])new Object[]{shoot_diff});
        }
        return null;
    }

    public void becomeItem(class_243 pos) {
        if (this.isClientSide()) {
            return;
        }
        class_1799 stack = this.getItem();
        class_1542 e = new class_1542(this.getWorld(), pos.field_1352, pos.field_1351, pos.field_1350, stack);
        this.getWorld().method_8649((class_1297)e);
        this.method_31472();
    }

    public void becomeItem() {
        if (this.isClientSide()) {
            return;
        }
        this.becomeItem(this.method_19538());
    }

    public void becomeItem(@NotNull class_3222 player) {
        class_1799 item = this.getItem();
        if (player.method_31548().method_7376() != -1 && player.method_7270(item)) {
            this.method_31472();
            return;
        }
        this.becomeItem(player.method_19538());
    }

    public class_1799 method_31480() {
        return this.getItem();
    }

    public boolean method_5640(double dist) {
        return dist < 102400.0;
    }

    public boolean ignoreToItemFlyCheck() {
        return false;
    }

    public final float getArmor() {
        return ((Float)this.field_6011.method_12789(ARMOR)).floatValue();
    }

    public final void setArmor(float armor) {
        float max = this.getMaxTotalArmor();
        if (armor > max) {
            armor = max;
        } else if (armor < 0.0f) {
            armor = 0.0f;
        }
        this.field_6011.method_12778(ARMOR, (Object)Float.valueOf(armor));
    }

    public final void addArmor(float armor) {
        this.setArmor(this.getArmor() + armor);
    }

    public final float getMaxHealth() {
        return ((VehicleStats)this.getStats()).max_health;
    }

    public final void addHealth(float h) {
        this.setHealth(this.getHealth() + h);
    }

    public final void setHealth(float h) {
        float max = this.getMaxHealth();
        if (h > max) {
            h = max;
        } else if (h < 0.0f) {
            h = 0.0f;
        }
        if (h > 0.0f) {
            this.deadTicks = 0;
            this.ingredientDropIndex = -1;
        }
        this.field_6011.method_12778(HEALTH, (Object)Float.valueOf(h));
    }

    public final float getHealth() {
        return ((Float)this.field_6011.method_12789(HEALTH)).floatValue();
    }

    public boolean isMaxHealth() {
        return this.getHealth() >= this.getMaxHealth();
    }

    public void repairAll() {
        if (this.isClientSide()) {
            return;
        }
        this.addHealth(100000.0f);
        this.addArmor(100000.0f);
        this.repairAllHitboxes();
        this.repairAllParts();
        this.playRepairSound();
    }

    public int onRepairTool(float repair) {
        if (this.isClientSide()) {
            return 0;
        }
        int damage = 0;
        if (this.getHealth() < this.getMaxHealth()) {
            this.addHealth(repair);
            damage = 1;
        } else if (this.repairOneHitbox(repair)) {
            damage = 1;
        } else if (this.getArmor() < this.getMaxTotalArmor()) {
            this.addArmor(repair);
            damage = 1;
        } else {
            return 0;
        }
        this.playRepairSound();
        return damage;
    }

    public void repairAllParts() {
        if (this.isClientSide()) {
            return;
        }
        this.partsManager.repairAllParts();
    }

    public void repairAllHitboxes() {
        if (this.isClientSide()) {
            return;
        }
        for (RotableHitbox h : this.hitboxes) {
            h.fullyRepair();
        }
    }

    public boolean repairOneHitbox(float repair) {
        for (RotableHitbox h : this.hitboxes) {
            if (!h.isDamaged()) continue;
            h.repair(repair);
            return true;
        }
        return false;
    }

    @Override
    public float getIRHeat() {
        return this.getIdleHeat() + Math.abs(this.getCurrentThrottle()) * this.getEngineHeat();
    }

    public final float getIdleHeat() {
        return ((VehicleStats)this.getStats()).idleheat;
    }

    public float getEngineHeat() {
        return this.partsManager.getTotalEngineHeat();
    }

    public final float getBaseArmor() {
        return ((VehicleStats)this.getStats()).base_armor;
    }

    public float getMaxTotalArmor() {
        return this.getBaseArmor() + this.partsManager.getTotalExtraArmor();
    }

    public List<class_1657> getRidingPlayers() {
        ArrayList<class_1657> players = new ArrayList<class_1657>();
        for (EntityRidablePart seat : this.getSeats()) {
            class_1657 p = seat.getPlayer();
            if (p == null) continue;
            players.add(p);
        }
        return players;
    }

    public EntityPart getPilotSeat() {
        return this.getPartBySlotId("pilot_seat");
    }

    public List<EntityRidablePart> getSeats() {
        ArrayList<EntityRidablePart> seats = new ArrayList<EntityRidablePart>();
        for (class_1297 e : this.method_5685()) {
            if (!(e instanceof EntityRidablePart)) continue;
            EntityRidablePart seat = (EntityRidablePart)e;
            seats.add(seat);
        }
        return seats;
    }

    public List<EntityTurret> getTurrets() {
        ArrayList<EntityTurret> turrets = new ArrayList<EntityTurret>();
        for (class_1297 e : this.method_5685()) {
            if (!(e instanceof EntityTurret)) continue;
            EntityTurret turret = (EntityTurret)e;
            turrets.add(turret);
        }
        return turrets;
    }

    public List<EntityPart> getPartEntities() {
        ArrayList<EntityPart> parts = new ArrayList<EntityPart>();
        for (class_1297 e : this.method_5685()) {
            if (!(e instanceof EntityPart)) continue;
            EntityPart part = (EntityPart)e;
            parts.add(part);
        }
        return parts;
    }

    public List<EntityGimbal> getGimbals() {
        ArrayList<EntityGimbal> gimbals = new ArrayList<EntityGimbal>();
        for (class_1297 e : this.method_5685()) {
            if (!(e instanceof EntityGimbal)) continue;
            EntityGimbal gimbal = (EntityGimbal)e;
            gimbals.add(gimbal);
        }
        return gimbals;
    }

    protected void findGimbalForPilotCamera() {
        List<EntityGimbal> gimbals = this.getGimbals();
        this.pilotGimbal = gimbals.isEmpty() ? null : gimbals.get(0);
    }

    @Nullable
    public EntityGimbal getGimbalForPilotCamera() {
        return this.pilotGimbal;
    }

    @Nullable
    public EntityPart getPartBySlotId(String slotId) {
        for (class_1297 e : this.method_5685()) {
            EntityPart part;
            if (!(e instanceof EntityPart) || !(part = (EntityPart)e).getSlotId().equals(slotId)) continue;
            return part;
        }
        return null;
    }

    public void trackedByMissile(class_1297 missile) {
        if (this.method_42148()) {
            this.radarSystem.addRWRWarning(missile.method_5628(), missile.method_19538(), true, false);
        }
    }

    public void lockedOnto(class_1297 radar) {
        if (this.method_42148()) {
            this.radarSystem.addRWRWarning(radar.method_5628(), radar.method_19538(), false, UtilVehicleEntity.isOnGroundOrWater(radar));
        }
    }

    public void playIRTone() {
        this.field_6011.method_12778(PLAY_IR_TONE, (Object)true);
    }

    public void stopIRTone() {
        this.field_6011.method_12778(PLAY_IR_TONE, (Object)false);
    }

    public boolean shouldPlayLowIRTone() {
        return ((WeaponStats)this.weaponSystem.getSelected().getStats()).isIRMissile();
    }

    public boolean shouldPlayHighIRTone() {
        return (Boolean)this.field_6011.method_12789(PLAY_IR_TONE);
    }

    @NotNull
    public class_4048 method_18377(@NotNull class_4050 pose) {
        if (!this.isStatsHolderLoaded()) {
            return super.method_18377(pose);
        }
        return ((VehicleStats)this.getStats()).dimensions;
    }

    @NotNull
    protected class_238 method_33332() {
        if (this.isCustomBoundingBox()) {
            return this.makeCustomBoundingBox();
        }
        return this.method_18377(this.method_18376()).method_30757(this.method_19538());
    }

    protected class_238 makeCustomBoundingBox() {
        double pX = this.method_23317();
        double pY = this.method_23318();
        double pZ = this.method_23321();
        class_4048 d = this.method_18377(this.method_18376());
        float f = d.field_18067 / 2.0f;
        float f1 = d.field_18068 / 2.0f;
        return new class_238(pX - (double)f, pY - (double)f1, pZ - (double)f, pX + (double)f, pY + (double)f1, pZ + (double)f);
    }

    public boolean isCustomBoundingBox() {
        return false;
    }

    @NotNull
    protected class_238 method_20343(@NotNull class_4050 pose) {
        return this.method_33332();
    }

    @NotNull
    public class_238 method_5830() {
        return this.method_5829().method_1014(((VehicleStats)this.getStats()).cameraDistance);
    }

    public double method_23320() {
        return this.method_5829().method_1005().field_1351;
    }

    public float getMaxFuel() {
        return this.maxFuel;
    }

    public void tickFuel() {
        this.partsManager.tickFuel();
    }

    public float getCurrentFuel() {
        return this.currentFuel;
    }

    public float addFuel(float fuel) {
        return this.partsManager.addFuel(fuel);
    }

    public void refillAll() {
        if (this.isClientSide()) {
            return;
        }
        this.refillFuel();
        this.refillAllWeapons();
    }

    public void refillFlares() {
        if (this.isClientSide()) {
            return;
        }
        this.partsManager.addFlares(100000);
    }

    public void refillFuel() {
        if (this.isClientSide()) {
            return;
        }
        this.addFuel(100000.0f);
        this.getWorld().method_43129(null, (class_1297)this, class_3417.field_14978, class_3419.field_15248, 1.0f, 1.0f);
    }

    public void refillAllWeapons() {
        if (this.isClientSide()) {
            return;
        }
        this.refillFlares();
        this.weaponSystem.refillAll();
        for (EntityTurret t : this.getTurrets()) {
            TurretInstance ti = (TurretInstance)t.getPartInstance();
            if (ti == null) continue;
            ti.setWeaponAmmo(100000);
        }
        this.getWorld().method_43129(null, (class_1297)this, class_3417.field_20680, class_3419.field_15248, 1.0f, 1.0f);
    }

    public abstract boolean canToggleLandingGear();

    public boolean isLandingGear() {
        return (Boolean)this.field_6011.method_12789(LANDING_GEAR);
    }

    public void setLandingGear(boolean gear) {
        this.field_6011.method_12778(LANDING_GEAR, (Object)gear);
    }

    @Override
    public boolean isTestMode() {
        return (Boolean)this.field_6011.method_12789(TEST_MODE);
    }

    public void setTestMode(boolean testMode) {
        this.field_6011.method_12778(TEST_MODE, (Object)testMode);
    }

    public boolean toggleLandingGear() {
        if (!this.canToggleLandingGear()) {
            return this.isLandingGear();
        }
        this.setLandingGear(!this.isLandingGear());
        return this.isLandingGear();
    }

    public void tickClientLandingGear() {
        this.landingGearPosOld = this.landingGearPos;
        if (this.isLandingGear()) {
            if (this.landingGearPos > 0.0f) {
                this.landingGearPos -= 0.02f;
            } else if (this.landingGearPos < 0.0f) {
                this.landingGearPos = 0.0f;
            }
        } else if (this.landingGearPos < 1.0f) {
            this.landingGearPos += 0.02f;
        } else if (this.landingGearPos > 1.0f) {
            this.landingGearPos = 1.0f;
        }
    }

    public float getLandingGearPos(float partialTicks) {
        return class_3532.method_16439((float)partialTicks, (float)this.landingGearPosOld, (float)this.landingGearPos);
    }

    public void foldLandingGearNow() {
        this.landingGearPos = 1.0f;
        this.landingGearPosOld = 1.0f;
    }

    public void method_5768() {
        super.method_5768();
    }

    @Override
    public final float getTurnRadius() {
        return ((VehicleStats)this.getStats()).turn_radius;
    }

    public boolean isNoConsume() {
        return (Boolean)this.field_6011.method_12789(NO_CONSUME);
    }

    public void setNoConsume(boolean noConsume) {
        this.field_6011.method_12778(NO_CONSUME, (Object)noConsume);
    }

    @NotNull
    public class_243 method_24829(@NotNull class_1309 livingEntity) {
        return super.method_24829(livingEntity);
    }

    public int getFlareNum() {
        return this.numFlares;
    }

    public boolean hasFlares() {
        return this.hasFlares;
    }

    @Override
    public void debug(String debug) {
        this.debug(debug, true);
    }

    public void debug(String debug, boolean passengerCheck) {
        if (!passengerCheck || this.method_42148()) {
            System.out.println(debug);
        }
    }

    protected void debugTick() {
        String side = "SERVER";
        if (this.isClientSide()) {
            side = "CLIENT";
        }
        System.out.println(side + " TICK " + this.field_6012 + " " + String.valueOf(this));
    }

    public void toClientPassengers(BaseS2CMessage packet) {
        if (this.isClientSide()) {
            return;
        }
        for (class_1657 p : this.getRidingPlayers()) {
            if (UtilEntity.getLevel((class_1297)p).method_8608()) continue;
            packet.sendTo((class_3222)p);
        }
    }

    public void toTrackers(BaseS2CMessage packet) {
        if (this.isClientSide()) {
            return;
        }
        PacketHandler.sendToTrackers(packet, (class_1297)this);
    }

    public boolean isWeaponAngledDown() {
        return false;
    }

    public boolean canAngleWeaponDown() {
        return false;
    }

    public boolean canFlapsDown() {
        return false;
    }

    @Override
    public boolean isFlapsDown() {
        return false;
    }

    public boolean canHover() {
        return false;
    }

    public boolean method_5822() {
        return this.isOperational();
    }

    @Override
    public boolean canTrample(@NotNull class_2680 state, @NotNull class_2338 pos, float fallDistance) {
        return true;
    }

    public boolean method_5722(@NotNull class_1297 entity) {
        if (entity == null) {
            return false;
        }
        class_1309 c = entity.method_5642();
        if (c != null && c.method_5781() != null) {
            return this.method_5645(c.method_5781());
        }
        return super.method_5722(entity);
    }

    public boolean method_5645(@NotNull class_270 team) {
        if (team == null) {
            return false;
        }
        class_1297 c = this.getControllingPlayerOrBot();
        if (c != null) {
            return team.method_1206(c.method_5781());
        }
        return super.method_5645(team);
    }

    public List<RotableHitbox> getHitboxes() {
        return this.hitboxes;
    }

    @Nullable
    public RotableHitbox getHitboxByName(String name) {
        for (RotableHitbox hitbox : this.hitboxes) {
            if (!hitbox.getHitboxName().equals(name)) continue;
            return hitbox;
        }
        return null;
    }

    @Nullable
    public RotableHitbox getHitboxById(int id) {
        for (RotableHitbox hitbox : this.hitboxes) {
            if (hitbox.method_5628() != id) continue;
            return hitbox;
        }
        return null;
    }

    public boolean isHitboxParent(class_1297 hitbox) {
        for (RotableHitbox rotableHitbox : this.hitboxes) {
            if (!rotableHitbox.equals(hitbox)) continue;
            return true;
        }
        return false;
    }

    protected void createRotableHitboxes(class_2487 nbt) {
        class_2487 hitbox_data = nbt.method_10562("hitbox_data");
        this.hitboxes.clear();
        this.hitboxes.addAll(((VehicleStats)this.getStats()).createRotableHitboxes(this));
        for (RotableHitbox hitbox : this.hitboxes) {
            hitbox.method_33574(this.method_19538());
            hitbox.readNbt(hitbox_data);
            hitbox.method_5838(field_5978.incrementAndGet());
            this.getWorld().method_8649((class_1297)hitbox);
        }
    }

    protected void saveRotableHitboxes(class_2487 nbt) {
        class_2487 hitbox_data = new class_2487();
        for (RotableHitbox hitbox : this.hitboxes) {
            hitbox.writeNbt(hitbox_data);
        }
        nbt.method_10566("hitbox_data", (class_2520)hitbox_data);
    }

    public void refreshHitboxes() {
        if (this.isClientSide()) {
            return;
        }
        class_2487 nbt = new class_2487();
        this.saveRotableHitboxes(nbt);
        for (RotableHitbox hitbox : this.hitboxes) {
            hitbox.method_31472();
        }
        this.createRotableHitboxes(nbt);
    }

    public void addRotableHitboxForClient(RotableHitbox hitbox) {
        if (!this.isClientSide()) {
            return;
        }
        String name = hitbox.getHitboxName();
        for (int i = 0; i < this.hitboxes.size(); ++i) {
            if (!this.hitboxes.get(i).getHitboxName().equals(name)) continue;
            this.hitboxes.remove(i);
            break;
        }
        this.hitboxes.add(hitbox);
    }

    public void tickHitboxes() {
        if (this.isClientSide() && this.hitboxes.size() < ((VehicleStats)this.getStats()).getHitboxNum() && this.field_6012 % 200 == 20) {
            LOGGER.debug("Vehicle {} on client side has {}/{} hitboxes. Sending hitbox refresh packet. Attempt {}", new Object[]{this.method_5628(), this.hitboxes.size(), ((VehicleStats)this.getStats()).getHitboxNum(), ++this.hitboxRefreshAttempts});
            new ToServerFixHitboxes(this).sendToServer();
        }
        for (RotableHitbox box : this.hitboxes) {
            box.method_5773();
        }
        this.collidedEntityIds.clear();
        this.hitboxEntityCoolDown.forEach((id, time) -> {
            if (time > 0) {
                time = time - 1;
                this.hitboxEntityCoolDown.put((Integer)id, (Integer)time);
            }
        });
    }

    public boolean isEntityHitboxCooldown(class_1297 entity) {
        return this.hitboxEntityCoolDown.containsKey(entity.method_5628()) && this.hitboxEntityCoolDown.get(entity.method_5628()) > 0;
    }

    public void addEntityToHitboxCooldown(class_1297 entity) {
        this.hitboxEntityCoolDown.put(entity.method_5628(), 4);
    }

    public void addEntityCollideInfo(class_1297 entity, RotableHitbox hitbox, class_243 pos) {
        EntityCollideInfo info = this.entityCollideInfo.get(entity.method_5628());
        if (info == null) {
            info = new EntityCollideInfo();
            this.entityCollideInfo.put(entity.method_5628(), info);
        }
        info.addPush(hitbox.method_5628(), this.field_6012, pos);
    }

    public boolean isStuckInHitbox(class_1297 entity) {
        EntityCollideInfo info = this.entityCollideInfo.get(entity.method_5628());
        if (info == null || info.collides.isEmpty()) {
            return false;
        }
        CollideInfo currentPush = info.collides.get(0);
        if (currentPush.time != this.field_6012) {
            return false;
        }
        int prevTime = this.field_6012 - 1;
        boolean multiCollideSameTick = false;
        for (int i = 1; i < info.collides.size(); ++i) {
            CollideInfo push = info.collides.get(i);
            if (!multiCollideSameTick) {
                if (push.time == this.field_6012 && push.hitboxId != currentPush.hitboxId) {
                    multiCollideSameTick = true;
                } else {
                    return false;
                }
            }
            if (push.time != prevTime || push.hitboxId != currentPush.hitboxId) continue;
            return UtilGeometry.isEqual((class_243)push.pos, (class_243)currentPush.pos, (double)0.001);
        }
        return false;
    }

    public double getMaxHitboxY() {
        double max = this.method_23318();
        for (RotableHitbox hitbox : this.hitboxes) {
            double y = hitbox.getMaxY();
            if (!(y > max)) continue;
            max = y;
        }
        return max;
    }

    @Override
    public boolean canUseTurnAssist() {
        return ((VehicleStats)this.getStats()).has_turn_assist;
    }

    @Override
    public boolean isUsingTurnAssist() {
        return this.canUseTurnAssist() && this.inputs.turnAssist;
    }

    private void syncHitboxCollidePositions() {
        if (!this.isClientSide() || this.collidedEntityIds.isEmpty() || !this.method_5787()) {
            return;
        }
        int[] ids = new int[this.collidedEntityIds.size()];
        class_243[] pos = new class_243[this.collidedEntityIds.size()];
        int i = 0;
        for (Integer id : this.collidedEntityIds) {
            ids[i] = id;
            class_1297 entity = this.getWorld().method_8469(id.intValue());
            pos[i] = entity != null ? entity.method_19538() : new class_243(0.0, -1000.0, 0.0);
            ++i;
        }
        new ToServerSyncRotBoxPassengerPos(ids, pos).sendToServer();
    }

    public void addEntityCollidedHitbox(class_1297 entity) {
        this.collidedEntityIds.add(entity.method_5628());
    }

    public boolean didEntityAlreadyCollide(class_1297 entity) {
        return this.collidedEntityIds.contains(entity.method_5628());
    }

    @Override
    public boolean areAllHitboxesDead(String ... hitbox_names) {
        return hitbox_names.length > 0 && this.getNumberOfAliveHitboxes(hitbox_names) == 0;
    }

    public int getNumberOfAliveHitboxes(String ... hitbox_names) {
        int num = 0;
        for (String hitboxName : hitbox_names) {
            RotableHitbox box = this.getHitboxByName(hitboxName);
            if (box == null || box.isDestroyed()) continue;
            ++num;
        }
        return num;
    }

    public ObjRadarModel.MastType getMastType() {
        return ((VehicleStats)this.getStats()).mastType;
    }

    public boolean isFuelLeak() {
        return this.partsManager.isFuelTankDamaged();
    }

    public boolean isEngineFire() {
        return this.partsManager.isEngineDamaged();
    }

    public boolean isAllEnginesDamaged() {
        return this.partsManager.isAllEnginesDamaged();
    }

    public boolean showAfterBurnerParticles() {
        return this.isUsingAfterburner();
    }

    public boolean showMoreAfterBurnerParticles() {
        return (double)this.getCurrentThrottle() > 0.85;
    }

    public boolean showContrailParticles() {
        return this.showAfterBurnerParticles() && this.method_19538().field_1351 > 128.0;
    }

    public float getMotorRotation(float partialTicks, float spinRate) {
        this.motorRot += spinRate * this.getCurrentThrottle() * partialTicks;
        return this.motorRot;
    }

    public float getWheelRotation(float partialTicks, float spinRate) {
        this.wheelRot += spinRate * this.xzSpeed * (float)this.xzSpeedDir * partialTicks * 0.05f;
        return this.wheelRot;
    }

    public class_243[] getAfterBurnerSmokePos() {
        return ((VehicleStats)this.getStats()).afterBurnerSmokePos;
    }

    public List<class_243> getEngineFirePos() {
        Set<String> hitboxNames = this.partsManager.getEngineFireHitboxNames();
        ArrayList<class_243> pos = new ArrayList<class_243>();
        for (String name : hitboxNames) {
            if (name.isEmpty()) {
                pos.add(this.method_19538());
                continue;
            }
            RotableHitbox hitbox = this.getHitboxByName(name);
            if (hitbox == null) continue;
            pos.add(hitbox.method_19538());
        }
        return pos;
    }

    public boolean liftLost() {
        return false;
    }

    public boolean isStalling() {
        return false;
    }

    public int getStallTicks() {
        return this.stallTicks;
    }

    public boolean isAboutToStall() {
        return false;
    }

    public int getAboutToStallTicks() {
        return this.stallWarnTicks;
    }

    public boolean isBingoFuelWarning() {
        if (this.getMaxFuel() <= 0.0f) {
            return true;
        }
        return (double)(this.getCurrentFuel() / this.getMaxFuel()) < 0.1;
    }

    public int getEngineFireTicks() {
        return this.engineFireTicks;
    }

    public int getFuelLeakTicks() {
        return this.fuelLeakTicks;
    }

    public int getBingoTicks() {
        return this.bingoTicks;
    }

    public void tickWarnings() {
        this.stallTicks = this.isStalling() ? ++this.stallTicks : 0;
        this.stallWarnTicks = this.isAboutToStall() ? ++this.stallWarnTicks : 0;
        this.engineFireTicks = this.isEngineFire() ? ++this.engineFireTicks : 0;
        this.fuelLeakTicks = this.isFuelLeak() ? ++this.fuelLeakTicks : 0;
        this.bingoTicks = this.isBingoFuelWarning() ? ++this.bingoTicks : 0;
        this.hydraulicsFailureTicks = this.isHydraulicsFailure() ? ++this.hydraulicsFailureTicks : 0;
        this.missileTicks = this.isTrackedByMissile() ? ++this.missileTicks : 0;
        this.trackedTicks = this.isTrackedByRadar() ? ++this.trackedTicks : 0;
    }

    @Override
    public void method_36456(float yRot) {
        super.method_36456(yRot);
        DrivingBody.super.method_36456(yRot);
    }

    @Override
    public void method_36457(float xRot) {
        super.method_36457(xRot);
        DrivingBody.super.method_36457(xRot);
    }

    public void method_5641(double pX, double pY, double pZ, float pYRot, float pXRot) {
        this.method_30634(pX, pY, pZ);
    }

    @Override
    public void setYRotNoQ(float yRot) {
        super.method_36456(yRot);
    }

    @Override
    public void setXRotNoQ(float xRot) {
        super.method_36457(xRot);
    }

    public boolean isAircraft() {
        return ((VehicleStats)this.getStats()).isAircraft();
    }

    public int getGroundTicks() {
        return this.groundTicks;
    }

    public boolean rootHitboxEntityInteract() {
        return !((VehicleStats)this.getStats()).rootHitboxNoCollide;
    }

    public boolean canControlPitch() {
        return this.isPitchControllable() && !this.areAllHitboxesDead(((VehicleStats)this.getStats()).controllPitchHitboxNames);
    }

    public boolean canControlYaw() {
        return this.isYawControllable() && !this.areAllHitboxesDead(((VehicleStats)this.getStats()).controllYawHitboxNames);
    }

    public boolean canControlRoll() {
        return this.isRollControllable() && !this.areAllHitboxesDead(((VehicleStats)this.getStats()).controllRollHitboxNames);
    }

    public boolean isPitchControllable() {
        return true;
    }

    public boolean isYawControllable() {
        return true;
    }

    public boolean isRollControllable() {
        return true;
    }

    public float getYawRate() {
        return this.method_36454() - this.field_5982;
    }

    public float getActualTurnRadius() {
        return this.xzSpeed / (this.getYawRate() * ((float)Math.PI / 180));
    }

    @Override
    public double getMaxAltitude() {
        return ((VehicleStats)this.getStats()).max_altitude;
    }

    @Override
    public double getAltitude() {
        return this.currentAltitude;
    }

    public boolean canReload(class_1657 player) {
        if (!this.isPilotOrCopilot((class_1297)player)) {
            player.method_7353((class_2561)UtilMCText.translatable((String)"error.dscombat.not_a_pilot"), true);
            return false;
        }
        if ((double)this.xzSpeed > 0.1) {
            player.method_7353((class_2561)UtilMCText.translatable((String)"error.dscombat.cant_load_while_moving"), true);
            return false;
        }
        if (!this.isOnGround()) {
            player.method_7353((class_2561)UtilMCText.translatable((String)"error.dscombat.cant_load_while_flying"), true);
            return false;
        }
        return true;
    }

    public boolean isPilotOrCopilot(class_1297 entity) {
        EntityRidablePart seat = this.getPassengerSeat(entity);
        if (seat == null) {
            return false;
        }
        return seat.canPassengerShootParentWeapon();
    }

    public boolean jetesinPart(String slotId) {
        return this.partsManager.dropPartInSlot(slotId);
    }

    public void setOwner(class_1297 owner) {
        this.owner = owner;
        this.owner_uuid = owner.method_5667();
    }

    @Nullable
    public class_1297 getOwner() {
        if (this.owner_uuid == null) {
            return null;
        }
        if (this.owner == null || this.getWorld().method_8469(this.owner_id) == null) {
            this.owner = this.getWorld().method_18470(this.owner_uuid);
            this.owner_id = this.owner != null ? this.owner.method_5628() : -1;
        }
        return this.owner;
    }

    public PermMode getPermMode() {
        return (PermMode)((Object)this.field_6011.method_12789(PERM_MODE));
    }

    public void setPermMode(PermMode mode) {
        this.field_6011.method_12778(PERM_MODE, (Object)mode);
    }

    public boolean hasPermission(@NotNull class_1297 entity) {
        if (this.getWorld().method_8608()) {
            return false;
        }
        if (DSCGameRules.isForcePublicPerm(this.getWorld())) {
            return true;
        }
        if (this.getPermMode() == PermMode.PUBLIC) {
            return true;
        }
        class_1297 owner = this.getOwner();
        if (this.getPermMode() == PermMode.ALLIES) {
            if (entity.equals((Object)owner)) {
                return true;
            }
            if (owner != null) {
                return UtilEntity.areEntitiesAllied((class_1297)owner, (class_1297)entity);
            }
            return false;
        }
        return entity.equals((Object)owner);
    }

    public boolean isOwner(class_1297 entity) {
        return entity.equals((Object)this.getOwner());
    }

    public boolean hasOwner() {
        return this.owner_uuid != null;
    }

    public boolean isStationaryRadar() {
        return ((VehicleStats)this.getStats()).isStationaryRadar();
    }

    @Nullable
    public String getAssetId() {
        return ((VehicleStats)this.getStats()).getAssetId();
    }

    @NotNull
    public JsonPresetReloadListener<VehicleStats> getPresets() {
        return VehiclePresets.get();
    }

    @Nullable
    public JsonPresetAssetReader<VehicleClientStats> getClientPresets() {
        return VehicleClientPresets.get();
    }

    @NotNull
    public class_2561 method_5477() {
        class_2561 name = this.method_5797();
        if (name != null) {
            return name;
        }
        class_1297 owner = this.getOwner();
        if (owner != null) {
            return UtilMCText.empty().method_10852(owner.method_5476()).method_27693("'s ").method_10852((class_2561)((VehicleStats)this.getStats()).getBaseDisplayName());
        }
        return ((VehicleStats)this.getStats()).getBaseDisplayName();
    }

    public int getPullUpWarningTicks() {
        return 0;
    }

    public int getAltitudeWarningTicks() {
        return 0;
    }

    public boolean isHydraulicsFailure() {
        return !this.canControlPitch() || !this.canControlRoll() || !this.canControlYaw();
    }

    public int getHydraulicsFailureTicks() {
        return this.hydraulicsFailureTicks;
    }

    public boolean isTrackedByMissile() {
        return this.radarSystem.isTrackedByMissile();
    }

    public int getMissileTicks() {
        return this.missileTicks;
    }

    public boolean isTrackedByRadar() {
        return this.radarSystem.isTrackedByRadar();
    }

    public int getTrackedTicks() {
        return this.trackedTicks;
    }

    public boolean isAfterBurnerEnabled() {
        return this.inputs.afterburner;
    }

    public boolean canUseAfterburner() {
        return ((VehicleStats)this.getStats()).canUseAfterBurner();
    }

    public boolean isUsingAfterburner() {
        return this.afterBurnerOverride || this.canUseAfterburner() && this.isAfterBurnerEnabled() && (double)this.getCurrentThrottle() > 0.8;
    }

    public void setUseAfterBurnerOverride(boolean enable) {
        this.afterBurnerOverride = enable;
    }

    @Override
    public double getFluidDensity() {
        if (this.method_5799()) {
            return 1000.0;
        }
        return this.getAirDensity();
    }

    @Override
    public double getAirDensity() {
        return this.airDensity;
    }

    @Override
    public float getAngularDragScale() {
        return 4000.0f;
    }

    @Override
    public List<PhysicsComponentInstance<?>> getPhysicsInstances() {
        return this.physicsInstances;
    }

    @Override
    public double getAccTimeScale() {
        return 0.0025;
    }

    @Override
    public double getLerpMaxXZ() {
        return this.maxXZ;
    }

    @Override
    public void setLerpMaxXZ(double maxXZ) {
        this.maxXZ = maxXZ;
    }

    @Override
    public double getAccGravity() {
        return 9.81;
    }

    @Override
    public float getZRot() {
        return this.zRot;
    }

    @Override
    public void setZRot(float rot) {
        this.zRot = rot;
    }

    @Override
    public float getPrevZRot() {
        return this.zRotO;
    }

    @Override
    public void setPrevZRot(float rot) {
        this.zRotO = rot;
    }

    @Override
    public class_243 getPrevDeltaMove() {
        return this.prevMotion;
    }

    @Override
    public void setPrevDeltaMove(class_243 move) {
        this.prevMotion = move;
    }

    @Override
    public class_243 getForcesBetweenTicks() {
        return this.addForceBetweenTicks;
    }

    @Override
    public void setForcesBetweenTicks(class_243 forces) {
        this.addForceBetweenTicks = forces;
    }

    @Override
    public class_243 getPrevForces() {
        return this.forcesO;
    }

    @Override
    public void setPrevForces(class_243 forces) {
        this.forcesO = forces;
    }

    @Override
    public class_243 getPrevMoment() {
        return this.momentO;
    }

    @Override
    public void setPrevMoment(class_243 moment) {
        this.momentO = moment;
    }

    @Override
    public class_243 getControlMoment() {
        return this.controlMoment;
    }

    @Override
    public void setControlMoment(class_243 moment) {
        this.controlMoment = moment;
    }

    @Override
    public class_243 getMomentBetweenTicks() {
        return this.addMomentBetweenTicks;
    }

    @Override
    public void setMomentBetweenTicks(class_243 moment) {
        this.addMomentBetweenTicks = moment;
    }

    @Override
    public float getPitchInput() {
        return this.inputs.pitch;
    }

    @Override
    public float getYawInput() {
        return this.inputs.yaw;
    }

    @Override
    public float getRollInput() {
        return this.inputs.roll;
    }

    @Override
    public double getKineticFriction() {
        return this.kineticFric;
    }

    @Override
    public double getStaticFriction() {
        return this.staticFric;
    }

    @Override
    public double getGroundBreaksDeAcceleration() {
        return (double)((VehicleStats)this.getStats()).break_deacc_ground * this.getHorizontalSpeedScaleOrOne();
    }

    @Override
    public double getMinDriveAcc() {
        return (double)((VehicleStats)this.getStats()).min_drive_acc * this.getHorizontalSpeedScaleOrOne() * (double)this.getCurrentThrottle();
    }

    @Override
    public double getAirBreaksDeAcceleration() {
        return (double)((VehicleStats)this.getStats()).break_deacc_air * this.getHorizontalSpeedScaleOrOne();
    }

    @Override
    public void setXZSpeed(float speed) {
        this.xzSpeed = speed;
    }

    @Override
    public void setXZSpeedDir(int direction) {
        this.xzSpeedDir = direction;
    }

    @Override
    public float getXZYaw() {
        return this.xzYaw;
    }

    @Override
    public void setXZYaw(float angle) {
        this.xzYaw = angle;
    }

    @Override
    public float getSlideAngle() {
        return this.slideAngle;
    }

    @Override
    public void setSlideAngle(float angle) {
        this.slideAngle = angle;
    }

    @Override
    public float getSlideAngleCos() {
        return this.slideAngleCos;
    }

    @Override
    public void setSlideAngleCos(float angle) {
        this.slideAngleCos = angle;
    }

    @Override
    public float getGroundXTilt() {
        return ((VehicleStats)this.getStats()).groundXTilt;
    }

    @Override
    public boolean canFlattenOnGround() {
        return this.isOperational();
    }

    @Override
    public int getAge() {
        return this.field_6012;
    }

    @Override
    public boolean isClientSide() {
        return this.getWorld().method_8608();
    }

    public boolean wasInWater() {
        return this.wasInWater;
    }

    @Override
    public boolean isArcadeMode() {
        return false;
    }

    @Override
    public boolean isHardCodedRotAcc() {
        return ((VehicleStats)this.getStats()).is_hard_coded_rot_acc;
    }

    @Override
    public class_243 getHardCodedRotAcc() {
        return ((VehicleStats)this.getStats()).hard_coded_rot_acc;
    }

    @Override
    public float getHardCodedRotDecel() {
        return ((VehicleStats)this.getStats()).hard_coded_rot_decel;
    }

    public void method_5650(@NotNull class_1297.class_5529 reason) {
        this.radarSystem.onParentRemove();
        super.method_5650(reason);
    }

    @NotNull
    public class_1937 getWorld() {
        return UtilEntity.getLevel((class_1297)this);
    }

    @Override
    public boolean isOnGround() {
        return this.method_24828();
    }

    @Override
    public boolean method_5799() {
        return super.method_5799();
    }

    @Override
    public float method_36455() {
        return super.method_36455();
    }

    @Override
    public float method_36454() {
        return super.method_36454();
    }

    @Override
    @NotNull
    public class_243 method_18798() {
        return super.method_18798();
    }

    @Override
    public void method_18799(class_243 move) {
        super.method_18799(move);
    }

    @Override
    public void method_18800(double x, double y, double z) {
        super.method_18800(x, y, z);
    }

    @Override
    @NotNull
    public class_243 method_5720() {
        return super.method_5720();
    }

    public static enum PermMode {
        PUBLIC,
        ALLIES,
        PRIVATE;


        public String getTranslatable() {
            return "permmode.dscombat." + this.name().toLowerCase();
        }
    }

    private static class EntityCollideInfo {
        private final List<CollideInfo> collides = new ArrayList<CollideInfo>();

        EntityCollideInfo() {
        }

        private void addPush(int hitboxId, int time, class_243 pos) {
            this.collides.add(0, new CollideInfo(hitboxId, time, pos));
            while (this.collides.size() > 10) {
                this.collides.remove(this.collides.size() - 1);
            }
        }

        public String toString() {
            return this.collides.toString();
        }
    }

    private static class CollideInfo {
        private final int hitboxId;
        private final int time;
        private final class_243 pos;

        CollideInfo(int hitboxId, int time, class_243 pos) {
            this.hitboxId = hitboxId;
            this.time = time;
            this.pos = pos;
        }

        public String toString() {
            return this.hitboxId + "," + this.time + "," + String.valueOf(this.pos);
        }
    }
}

