/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.item;

import com.onewhohears.dscombat.data.parts.client.PartAssets;
import com.onewhohears.dscombat.data.parts.client.PartClientStats;
import com.onewhohears.dscombat.data.parts.instance.WeaponPartInstance;
import com.onewhohears.dscombat.data.parts.stats.PartStats;
import com.onewhohears.dscombat.data.parts.stats.WeaponPartStats;
import com.onewhohears.dscombat.data.weapon.WeaponPresets;
import com.onewhohears.dscombat.data.weapon.stats.WeaponStats;
import com.onewhohears.dscombat.init.ModCMTabs;
import com.onewhohears.dscombat.item.ItemPart;
import com.onewhohears.dscombat.item.ItemTurret;
import com.onewhohears.dscombat.item.fabric.ItemWeaponPartImpl;
import com.onewhohears.dscombat.util.UtilPresetParse;
import com.onewhohears.onewholibs.client.model.obj.ObjEntityModels;
import com.onewhohears.onewholibs.item.ObjModelItem;
import com.onewhohears.onewholibs.util.UtilMCText;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.List;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemWeaponPart
extends ItemPart
implements ObjModelItem {
    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ItemWeaponPart create(int stackSize, String defaultPresetId) {
        void var1_1;
        return ItemWeaponPartImpl.create(stackSize, (String)var1_1);
    }

    public ItemWeaponPart(int stackSize, String defaultPresetId) {
        super(ItemTurret.weaponPartProps(stackSize), defaultPresetId);
    }

    @Override
    @NotNull
    public class_2561 method_7864(@NotNull class_1799 stack) {
        class_2487 tag = stack.method_7948();
        String weapon = tag.method_10558("weapon");
        class_5250 name = ((class_5250)super.method_7864(stack)).method_27693(" ");
        if (weapon.isEmpty()) {
            name.method_27693("EMPTY");
        } else {
            WeaponStats wd = WeaponPresets.get().get(weapon);
            if (wd != null) {
                name.method_10852((class_2561)wd.getDisplayNameComponent()).method_27693(" ").method_10852((class_2561)UtilMCText.literal((String)wd.getWeaponTypeCode()));
            } else {
                name.method_27693(weapon + "?");
            }
        }
        return name;
    }

    @Override
    public void method_7851(@NotNull class_1799 stack, @Nullable class_1937 level, @NotNull List<class_2561> tips, @NotNull class_1836 isAdvanced) {
        super.method_7851(stack, level, tips, isAdvanced);
        WeaponPartInstance data = (WeaponPartInstance)UtilPresetParse.parsePartFromItem(stack);
        if (data == null) {
            return;
        }
        String id = data.getWeaponId();
        if (id.isEmpty()) {
            return;
        }
        tips.add((class_2561)UtilMCText.translatable((String)"info.dscombat.ammo").method_27693(": " + (int)data.getCurrentAmmo() + "/" + ((WeaponPartStats)data.getStats()).getMaxAmmo()).method_10862(class_2583.field_24360.method_36139(0xAAAAAA)));
        WeaponStats wd = WeaponPresets.get().get(id);
        if (wd == null) {
            return;
        }
        wd.addToolTips(tips, isAdvanced.method_8035());
    }

    @Override
    protected void fillItemCategory(PartStats stats, List<class_1799> items) {
        List<String> list = WeaponPresets.get().getCompatibleWeapons(stats.getId());
        for (String s : list) {
            this.addWeaponRack(stats, s, items);
        }
    }

    private void addWeaponRack(PartStats stats, String preset, List<class_1799> items) {
        class_1799 rack = new class_1799((class_1935)this);
        if (stats != null) {
            rack.method_7980(stats.createFilledPartInstance(preset).writeNBT());
        }
        items.add(rack);
    }

    @Override
    public class_5321<class_1761> getCreativeTab() {
        return ModCMTabs.WEAPON_PARTS.getKey();
    }

    @Override
    @NotNull
    public String getPreset(@NotNull class_1799 stack) {
        PartStats stats = UtilPresetParse.getPartStatsFromItem(stack);
        if (stats == null) {
            return this.getDefaultPartPresetId();
        }
        return stats.getId();
    }

    @NotNull
    public String getObjModelId(@NotNull String preset) {
        PartClientStats pcs = PartAssets.get().get(preset);
        if (pcs == null) {
            return "";
        }
        return pcs.getModelId();
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull ObjEntityModels.ModelOverrides getItemModelOverrides(@NotNull String preset) {
        PartClientStats pcs = PartAssets.get().get(preset);
        if (pcs == null) {
            return ObjEntityModels.NO_OVERRIDES;
        }
        return pcs.getItemModelOverrides();
    }
}

