/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.util;

import com.mojang.logging.LogUtils;
import com.onewhohears.dscombat.client.sounds.AfterBurnerSoundInstance;
import com.onewhohears.dscombat.client.sounds.DopplerSoundInstance;
import com.onewhohears.dscombat.client.sounds.PlaneMusicSoundInstance;
import com.onewhohears.dscombat.client.sounds.VehicleEngineSoundInstance;
import com.onewhohears.dscombat.client.sounds.VehicleWindSoundInstance;
import com.onewhohears.dscombat.data.vehicle.physics.DSCPhyCons;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.dscombat.data.weapon.stats.MissileStats;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.entity.weapon.EntityMissile;
import com.onewhohears.dscombat.init.ModSounds;
import com.onewhohears.dscombat.util.UtilSound;
import com.onewhohears.onewholibs.util.math.UtilGeometry;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.NoSuchElementException;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class UtilClientSafeSounds {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static long prevQueueTime = 0L;
    private static int waitTime = 0;

    public static void dopplerSound(class_1297 entity, class_3414 sound, float initVolume, float initPitch, float velSound, boolean delayed) {
        class_310 m = class_310.method_1551();
        class_746 p = m.field_1724;
        if (p == null) {
            return;
        }
        int delay = 0;
        if (delayed) {
            delay = (int)(p.method_5739(entity) / velSound);
        }
        m.method_1483().method_4872((class_1113)new DopplerSoundInstance(sound, p, entity, initVolume, initPitch, velSound), delay);
    }

    public static void nonPassengerVehicleEngineSound(EntityVehicle plane, class_3414 sound, double range) {
        class_310 m = class_310.method_1551();
        class_746 p = m.field_1724;
        if (p == null) {
            return;
        }
        m.method_1483().method_4873((class_1113)new VehicleEngineSoundInstance(sound, p, plane, DSCPhyCons.getVelSound(), false, range, 0.0f));
    }

    public static void nonPassengerVehicleEngineSound(EntityVehicle plane, class_3414 sound) {
        class_310 m = class_310.method_1551();
        class_746 p = m.field_1724;
        if (p == null) {
            return;
        }
        m.method_1483().method_4873((class_1113)new VehicleEngineSoundInstance(sound, p, plane, DSCPhyCons.getVelSound(), false));
    }

    public static void passengerVehicleEngineSound(EntityVehicle plane, class_3414 sound) {
        class_310 m = class_310.method_1551();
        class_746 p = m.field_1724;
        if (p == null) {
            return;
        }
        m.method_1483().method_4873((class_1113)new VehicleEngineSoundInstance(sound, p, plane, DSCPhyCons.getVelSound(), true));
    }

    public static void nonPassengerAfterBurnerSound(EntityVehicle plane, class_3414 sound, double range, float minDist) {
        class_310 m = class_310.method_1551();
        class_746 p = m.field_1724;
        if (p == null) {
            return;
        }
        m.method_1483().method_4873((class_1113)new AfterBurnerSoundInstance(sound, p, plane, DSCPhyCons.getVelSound(), false, range, minDist));
    }

    public static void passengerAfterBurnerSound(EntityVehicle plane, class_3414 sound) {
        class_310 m = class_310.method_1551();
        class_746 p = m.field_1724;
        if (p == null) {
            return;
        }
        m.method_1483().method_4873((class_1113)new AfterBurnerSoundInstance(sound, p, plane, DSCPhyCons.getVelSound(), true));
    }

    public static void nonPassengerWindSound(EntityVehicle plane, class_3414 sound, double range, float minDist) {
        class_310 m = class_310.method_1551();
        class_746 p = m.field_1724;
        if (p == null) {
            return;
        }
        m.method_1483().method_4873((class_1113)new VehicleWindSoundInstance(sound, p, plane, DSCPhyCons.getVelSound(), false, range, minDist, 0.0));
    }

    public static void passengerWindSound(EntityVehicle plane, class_3414 sound, double minSpeed) {
        class_310 m = class_310.method_1551();
        class_746 p = m.field_1724;
        if (p == null) {
            return;
        }
        m.method_1483().method_4873((class_1113)new VehicleWindSoundInstance(sound, p, plane, DSCPhyCons.getVelSound(), true, minSpeed));
    }

    public static void aircraftRadio(EntityVehicle plane, class_3414 sound) {
        class_310 m = class_310.method_1551();
        class_746 p = m.field_1724;
        if (p == null) {
            return;
        }
        m.method_1483().method_4873((class_1113)new PlaneMusicSoundInstance(sound, p, plane, DSCPhyCons.getVelSound()));
    }

    public static void aircraftRadio(EntityVehicle plane, String sound) {
        try {
            class_3414 se = UtilSound.getSoundByIdClient(sound, class_3417.field_14829);
            UtilClientSafeSounds.aircraftRadio(plane, se);
        }
        catch (NoSuchElementException e) {
            LOGGER.error("ERROR: " + sound + " does not exist!");
        }
    }

    public static void playCockpitSound(RegistrySupplier<class_3414> sound, float pitch, float volume) {
        if (sound == null) {
            return;
        }
        UtilClientSafeSounds.playCockpitSound((class_3414)sound.get(), pitch, volume);
    }

    public static void playCockpitSound(class_3414 sound, float pitch, float volume) {
        if (sound == null) {
            return;
        }
        class_310 m = class_310.method_1551();
        m.method_1483().method_4873((class_1113)UtilClientSafeSounds.forCockpit(sound, pitch, volume));
    }

    public static void queueCockpitSound(class_3414 sound, float pitch, float volume, int length) {
        if (sound == null) {
            return;
        }
        class_310 m = class_310.method_1551();
        long currentTime = m.field_1687.method_8510();
        long timeDiff = currentTime - prevQueueTime;
        if ((waitTime = (int)((long)waitTime - timeDiff)) < 0) {
            waitTime = 0;
        }
        m.method_1483().method_4872((class_1113)UtilClientSafeSounds.forCockpit(sound, pitch, volume), waitTime);
        waitTime += length;
        prevQueueTime = currentTime;
    }

    public static class_1109 forCockpit(class_3414 sound, float pitch, float volume) {
        if (sound == null) {
            sound = class_3417.field_14815;
        }
        final class_310 m = class_310.method_1551();
        final int vehicleId = m.field_1724.method_5668().method_5628();
        return new class_1109(sound.method_14833(), class_3419.field_15248, volume, pitch, class_1113.method_43221(), false, 0, class_1113.class_1114.field_5478, 0.0, 0.0, 0.0, true){

            public float method_4781() {
                if (m.field_1724 != null && m.field_1724.method_5765() && m.field_1724.method_5668().method_5628() == vehicleId) {
                    return super.method_4781();
                }
                return 0.0f;
            }
        };
    }

    public static boolean isClientRidingVehicle(EntityVehicle vehicle) {
        class_310 m = class_310.method_1551();
        if (m.field_1724 == null) {
            return false;
        }
        return m.field_1724.method_5668().equals((Object)vehicle);
    }

    public static boolean missileSonicBoom(@NotNull EntityMissile<?> missile) {
        return UtilClientSafeSounds.entitySonicBoom(missile, ((MissileStats)missile.getStats()).getMass());
    }

    public static boolean vehicleSonicBoom(@NotNull EntityVehicle vehicle) {
        return UtilClientSafeSounds.entitySonicBoom((class_1297)vehicle, ((VehicleStats)vehicle.getStats()).mass);
    }

    public static boolean entitySonicBoom(@NotNull class_1297 entity, float mass) {
        if (UtilGeometry.isZero((class_243)entity.method_18798())) {
            return false;
        }
        class_310 m = class_310.method_1551();
        if (m.field_1724 == null) {
            return false;
        }
        float size = mass / 8573.0f;
        float pitch = UtilClientSafeSounds.getSonicBoomPitch((class_1297)m.field_1724, entity, DSCPhyCons.getVelSound(), size);
        if (pitch <= 0.0f) {
            return false;
        }
        class_243 diff = entity.method_19538().method_1020(m.field_1724.method_19538());
        double distance = diff.method_1033();
        double scale = Math.max(1.0, Math.min(32.0, distance * 0.08));
        class_243 pos = m.field_1724.method_19538().method_1019(diff.method_1029().method_1021(scale));
        float volume = Math.max(0.0f, Math.min(1.0f, 400.0f / (float)distance));
        m.field_1687.method_8486(pos.method_10216(), pos.method_10214(), pos.method_10215(), ModSounds.SONIC_BOOM, class_3419.field_15248, volume, pitch, false);
        return true;
    }

    public static float getSonicBoomPitch(@NotNull class_1297 observer, @NotNull class_1297 aircraft, double speedOfSound, double aircraftSize) {
        class_243 aircraftPos = aircraft.method_19538();
        class_243 observerPos = observer.method_19538();
        class_243 velocity = aircraft.method_18798();
        double aircraftSpeed = velocity.method_1033();
        if (aircraftSpeed <= speedOfSound) {
            return -1.0f;
        }
        class_243 toObserver = observerPos.method_1020(aircraftPos);
        if (toObserver.method_1026(velocity) >= 0.0) {
            return -1.0f;
        }
        double normalizedSize = Math.max(aircraftSize, 0.01);
        double pitch = 1.0 / normalizedSize;
        pitch = Math.max(0.9, Math.min(pitch, 4.0));
        return (float)pitch;
    }
}

