/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.client.model.obj;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.onewhohears.onewholibs.util.math.Mat4f;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.resources.ResourceLocation;

public class ObjBakedModel {
    private final List<Component> components = new ArrayList<Component>();

    public static Builder builder() {
        return new Builder();
    }

    protected ObjBakedModel() {
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, Function<ResourceLocation, RenderType> renderType, int lightmap, int overlay, float partialTicks, Map<String, Mat4f> transforms) {
        for (Component component : this.components) {
            component.render(poseStack, bufferSource, renderType, lightmap, overlay, transforms);
        }
    }

    public Component getCreateComponent(String name) {
        for (Component component : this.components) {
            if (!component.name.equals(name)) continue;
            return component;
        }
        Component c = new Component(name);
        this.components.add(c);
        return c;
    }

    public List<Component> getComponents() {
        return this.components;
    }

    public static class Builder {
        private final ObjBakedModel renderable = new ObjBakedModel();

        private Builder() {
        }

        public PartBuilder<?> child(String name) {
            String[] split = name.split("/");
            if (split.length == 1) {
                Component child = new Component(name);
                this.renderable.components.add(child);
                return new PartBuilder<Builder>(this, child);
            }
            Component parent = this.renderable.getCreateComponent(split[0]);
            PartBuilder<Builder> parentBuilder = new PartBuilder<Builder>(this, parent);
            PartBuilder<Object> childBuilder = null;
            for (int i = 1; i < split.length; ++i) {
                parentBuilder = childBuilder = parentBuilder.child(split[i]);
            }
            return childBuilder != null ? childBuilder : parentBuilder;
        }

        public ObjBakedModel get() {
            return this.renderable;
        }
    }

    public static class Component {
        private final String name;
        private final List<Component> children = new ArrayList<Component>();
        private final List<Mesh> meshes = new ArrayList<Mesh>();

        public Component(String name) {
            this.name = name;
        }

        public void render(PoseStack poseStack, MultiBufferSource bufferSource, Function<ResourceLocation, RenderType> renderType, int lightmap, int overlay, Map<String, Mat4f> context) {
            Mat4f matrix = context.get(this.name);
            if (matrix != null) {
                poseStack.m_85836_();
                poseStack.m_166854_(matrix.convert());
            }
            for (Component part : this.children) {
                part.render(poseStack, bufferSource, renderType, lightmap, overlay, context);
            }
            for (Mesh mesh : this.meshes) {
                mesh.render(poseStack, bufferSource, renderType, lightmap, overlay);
            }
            if (matrix != null) {
                poseStack.m_85849_();
            }
        }

        public Component getCreateChild(String name) {
            for (Component component : this.children) {
                if (!component.name.equals(name)) continue;
                return component;
            }
            Component c = new Component(name);
            this.children.add(c);
            return c;
        }

        public String getName() {
            return this.name;
        }

        public List<Component> getChildren() {
            return this.children;
        }

        public List<Mesh> getMeshes() {
            return this.meshes;
        }
    }

    public static class PartBuilder<T> {
        private final T parent;
        private final Component component;

        private PartBuilder(T parent, Component component) {
            this.parent = parent;
            this.component = component;
        }

        public PartBuilder<PartBuilder<T>> child(String name) {
            Component child = this.component.getCreateChild(name);
            return new PartBuilder<PartBuilder<T>>(this, child);
        }

        public PartBuilder<T> addMesh(ResourceLocation texture, List<BakedQuad> quads) {
            Mesh mesh = new Mesh(texture);
            mesh.quads.addAll(quads);
            this.component.meshes.add(mesh);
            return this;
        }

        public T end() {
            return this.parent;
        }
    }

    public static class Mesh {
        private static final float[] ONES = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        private final ResourceLocation texture;
        private final List<BakedQuad> quads = new ArrayList<BakedQuad>();

        public Mesh(ResourceLocation texture) {
            this.texture = texture;
        }

        public void render(PoseStack poseStack, MultiBufferSource bufferSource, Function<ResourceLocation, RenderType> renderType, int lightmap, int overlay) {
            VertexConsumer consumer = bufferSource.m_6299_(renderType.apply(this.texture));
            for (BakedQuad quad : this.quads) {
                consumer.m_85995_(poseStack.m_85850_(), quad, ONES, 1.0f, 1.0f, 1.0f, new int[]{lightmap, lightmap, lightmap, lightmap}, overlay, true);
            }
        }

        public ResourceLocation getTexture() {
            return this.texture;
        }

        public List<BakedQuad> getQuads() {
            return this.quads;
        }
    }
}

