/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.client.model.obj;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.onewhohears.onewholibs.client.model.obj.ObjBakedModel;
import com.onewhohears.onewholibs.shadow.de.javagl.obj.FloatTuple;
import com.onewhohears.onewholibs.shadow.de.javagl.obj.Mtl;
import com.onewhohears.onewholibs.shadow.de.javagl.obj.Obj;
import com.onewhohears.onewholibs.shadow.de.javagl.obj.ObjFace;
import com.onewhohears.onewholibs.shadow.de.javagl.obj.ObjGroup;
import com.onewhohears.onewholibs.shadow.de.javagl.obj.ObjSplitting;
import com.onewhohears.onewholibs.shadow.de.javagl.obj.ObjUtils;
import com.onewhohears.onewholibs.shadow.de.javagl.obj.Objs;
import com.onewhohears.onewholibs.util.math.UtilGeometry;
import com.onewhohears.onewholibs.util.math.Vec3f;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjUnbakedModel {
    private final ResourceLocation location;
    private final Obj obj;
    private final Map<String, Mtl> mtl;

    public ObjUnbakedModel(ResourceLocation location, Obj obj, Map<String, Mtl> mtl) {
        this.location = location;
        this.obj = obj;
        this.mtl = mtl;
    }

    public static ResourceLocation getTexture(@Nullable Mtl mtl) {
        Object path;
        String namespace;
        String[] split;
        Object mapKd = "onewholibs:mtl_fail.png";
        if (mtl != null) {
            mapKd = mtl.getMapKd();
        }
        if (!((String)mapKd).endsWith(".png")) {
            mapKd = (String)mapKd + ".png";
        }
        if ((split = ((String)mapKd).split(":")).length == 1) {
            namespace = "minecraft";
            path = split[0];
        } else {
            namespace = split[0];
            path = split[1];
        }
        if (!((String)path).startsWith("textures/")) {
            path = "textures/" + (String)path;
        }
        return ResourceLocation.m_214293_((String)namespace, (String)path);
    }

    public static TextureAtlasSprite createSprite(ResourceLocation texture) {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(texture);
    }

    @NotNull
    public ObjBakedModel bake() {
        Map<String, Obj> mtlGroups = ObjSplitting.splitByMaterialGroups(this.obj);
        HashMap groupMtlMap = new HashMap();
        mtlGroups.forEach((mtlName, o) -> {
            int numGroups = o.getNumGroups();
            for (int i = 0; i < numGroups; ++i) {
                ObjGroup group = o.getGroup(i);
                groupMtlMap.put(group.getName(), mtlName);
            }
        });
        ObjBakedModel.Builder builder = ObjBakedModel.builder();
        int numGroups = this.obj.getNumGroups();
        for (int i = 0; i < numGroups; ++i) {
            ObjGroup group = this.obj.getGroup(i);
            String mtlName2 = (String)groupMtlMap.get(group.getName());
            ResourceLocation texture = ObjUnbakedModel.getTexture(this.mtl.get(mtlName2));
            TextureAtlasSprite sprite = ObjUnbakedModel.createSprite(texture);
            this.bakeGroup(builder, group.getName(), group, texture, sprite);
        }
        return builder.get();
    }

    private void bakeGroup(ObjBakedModel.Builder builder, String name, ObjGroup group, ResourceLocation texture, TextureAtlasSprite sprite) {
        ObjBakedModel.PartBuilder<?> groupBuilder = builder.child(name);
        for (int i = 0; i < group.getNumFaces(); ++i) {
            this.bakeFace(groupBuilder, group.getFace(i), texture, sprite);
        }
    }

    private void bakeFace(ObjBakedModel.PartBuilder<?> builder, ObjFace face, ResourceLocation texture, TextureAtlasSprite sprite) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        List<ObjFace> tris = this.triangulateFace(face);
        for (ObjFace tri : tris) {
            Vec3f[] positions = new Vec3f[4];
            Vec3f[] normals = new Vec3f[4];
            float[][] uvs = new float[4][2];
            for (int i = 0; i < 3; ++i) {
                int vIndex = tri.getVertexIndex(i);
                int tIndex = tri.getTexCoordIndex(i);
                int nIndex = tri.getNormalIndex(i);
                FloatTuple pos = this.obj.getVertex(vIndex);
                FloatTuple uv = this.obj.getTexCoord(tIndex);
                FloatTuple norm = nIndex >= 0 ? this.obj.getNormal(nIndex) : null;
                positions[i] = ObjUnbakedModel.vector3f(pos);
                uvs[i] = new float[]{uv.getX(), 1.0f - uv.getY()};
                normals[i] = norm != null ? ObjUnbakedModel.vector3f(norm) : new Vec3f(0.0f, 0.0f, 0.0f);
            }
            positions[3] = positions[2];
            uvs[3] = uvs[2];
            normals[3] = normals[2];
            Vec3f faceNormal = ObjUnbakedModel.cross(positions[0], positions[1], positions[2]);
            for (int i = 0; i < normals.length; ++i) {
                if (!UtilGeometry.isZero(normals[i])) continue;
                normals[i] = faceNormal;
            }
            int[] vertexData = this.packQuadData(positions, normals, uvs, sprite);
            Direction facing = Direction.m_122372_((float)(faceNormal.x() * 0.5f), (float)faceNormal.y(), (float)(faceNormal.z() * 0.5f));
            quads.add(new BakedQuad(vertexData, -1, facing, sprite, true));
        }
        builder.addMesh(texture, quads);
    }

    private static Vec3f cross(Vec3f pos1, Vec3f pos2, Vec3f pos3) {
        Vec3f edge1 = pos2.copy();
        edge1.sub(pos1);
        Vec3f edge2 = pos3.copy();
        edge2.sub(pos1);
        Vec3f faceNormal = edge1.copy();
        faceNormal.cross(edge2);
        return faceNormal;
    }

    private List<ObjFace> triangulateFace(ObjFace face) {
        int n = face.getNumVertices();
        if (n == 3) {
            return Collections.singletonList(face);
        }
        if (n == 4) {
            return ObjUnbakedModel.fourVertsTo2Tris(face);
        }
        Obj temp = Objs.create();
        int[] vIdx = new int[n];
        int[] tIdx = new int[n];
        int[] nIdx = new int[n];
        for (int i = 0; i < n; ++i) {
            vIdx[i] = face.getVertexIndex(i);
            tIdx[i] = face.getTexCoordIndex(i);
            nIdx[i] = face.getNormalIndex(i);
        }
        temp.addFace(vIdx, tIdx, nIdx);
        Obj tri = ObjUtils.triangulate(temp);
        ArrayList<ObjFace> faces = new ArrayList<ObjFace>();
        for (int i = 0; i < tri.getNumFaces(); ++i) {
            faces.add(tri.getFace(i));
        }
        return faces;
    }

    @NotNull
    private static List<ObjFace> fourVertsTo2Tris(ObjFace face) {
        ArrayList<ObjFace> result = new ArrayList<ObjFace>(2);
        result.add(new TriFace(face, 0, 1, 2));
        result.add(new TriFace(face, 0, 2, 3));
        return result;
    }

    public static Vec3f vector3f(FloatTuple tuple) {
        return new Vec3f(tuple.getX(), tuple.getY(), tuple.getZ());
    }

    private int[] packQuadData(Vec3f[] positions, Vec3f[] normals, float[][] uvs, TextureAtlasSprite sprite) {
        int[] data = new int[DefaultVertexFormat.f_85811_.m_86020_() / 4 * 4];
        for (int i = 0; i < 4; ++i) {
            int offset = i * (DefaultVertexFormat.f_85811_.m_86020_() / 4);
            data[offset] = Float.floatToRawIntBits(positions[i].x());
            data[offset + 1] = Float.floatToRawIntBits(positions[i].y());
            data[offset + 2] = Float.floatToRawIntBits(positions[i].z());
            data[offset + 3] = -1;
            data[offset + 4] = Float.floatToRawIntBits(uvs[i][0]);
            data[offset + 5] = Float.floatToRawIntBits(uvs[i][1]);
            data[offset + 6] = 0;
            data[offset + 7] = 0;
        }
        return data;
    }

    public ResourceLocation getLocation() {
        return this.location;
    }

    public Obj getObj() {
        return this.obj;
    }

    public Map<String, Mtl> getMtl() {
        return this.mtl;
    }

    private static class TriFace
    implements ObjFace {
        private final ObjFace parent;
        private final int[] indices;

        private TriFace(ObjFace parent, int ... indices) {
            this.parent = parent;
            this.indices = indices;
        }

        @Override
        public int getNumVertices() {
            return 3;
        }

        @Override
        public boolean containsTexCoordIndices() {
            return this.parent.containsTexCoordIndices();
        }

        @Override
        public boolean containsNormalIndices() {
            return this.parent.containsNormalIndices();
        }

        @Override
        public int getVertexIndex(int i) {
            return this.parent.getVertexIndex(this.indices[i]);
        }

        @Override
        public int getTexCoordIndex(int i) {
            return this.parent.getTexCoordIndex(this.indices[i]);
        }

        @Override
        public int getNormalIndex(int i) {
            return this.parent.getNormalIndex(this.indices[i]);
        }
    }
}

