/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.client.model.obj.customanims.keyframe;

import com.onewhohears.onewholibs.client.model.obj.customanims.keyframe.KFAnimData;
import com.onewhohears.onewholibs.client.model.obj.customanims.keyframe.KFAnimType;
import com.onewhohears.onewholibs.client.model.obj.customanims.keyframe.KeyframeAnimationPlayer;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetAssetReader;
import dev.architectury.registry.ReloadListenerRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public class KFAnimPlayers
extends JsonPresetAssetReader<KFAnimData> {
    private static KFAnimPlayers instance;
    private static final Map<String, KeyframeAnimationPlayerFactory> playerFactoryMap;

    public static KFAnimPlayers get() {
        return instance;
    }

    public static void close() {
        instance = null;
    }

    public static void register() {
        instance = new KFAnimPlayers();
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)instance);
    }

    public static void addAnimationPlayerFactory(String id, KeyframeAnimationPlayerFactory player) {
        playerFactoryMap.put(id, player);
    }

    @Nullable
    public static <T extends Entity> KeyframeAnimationPlayer<T> createAnimationPlayer(String id, KFAnimData stats) {
        if (!playerFactoryMap.containsKey(id)) {
            return null;
        }
        return playerFactoryMap.get(id).create(stats);
    }

    public static <T extends Entity> List<KeyframeAnimationPlayer<T>> getAnimPlayersFromDataIds(String[] anim_data_ids) {
        ArrayList<KeyframeAnimationPlayer<T>> animationPlayers = new ArrayList<KeyframeAnimationPlayer<T>>();
        for (String id : anim_data_ids) {
            KFAnimData data = (KFAnimData)KFAnimPlayers.get().get(id);
            if (data == null) continue;
            animationPlayers.add(data.getAnimationPlayer());
        }
        return animationPlayers;
    }

    private KFAnimPlayers() {
        super("animation_data");
    }

    @Override
    protected void registerPresetTypes() {
        this.addPresetType(KFAnimType.BLOCK_BENCH);
    }

    public KFAnimData[] getNewArray(int size) {
        return new KFAnimData[size];
    }

    @Override
    protected void resetCache() {
    }

    static {
        playerFactoryMap = new HashMap<String, KeyframeAnimationPlayerFactory>();
    }

    public static interface KeyframeAnimationPlayerFactory<T extends Entity> {
        public KeyframeAnimationPlayer<T> create(KFAnimData var1);
    }
}

