/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.data.jsonpreset;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.onewhohears.onewholibs.client.model.obj.ObjEntityModels;
import com.onewhohears.onewholibs.client.model.obj.customanims.keyframe.KeyframeAnimsEntityModel;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetStats;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetType;
import com.onewhohears.onewholibs.data.jsonpreset.PresetBuilder;
import com.onewhohears.onewholibs.util.UtilParse;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public abstract class CustomAnimStats<M extends KeyframeAnimsEntityModel<E>, E extends Entity>
extends JsonPresetStats {
    private final String model_id;
    private final JsonArray custom_anims;
    private final String[] keyframe_anims;
    private ObjEntityModels.ModelOverrides itemModelOverrides;
    private M model;

    public CustomAnimStats(ResourceLocation key, JsonObject json) {
        super(key, json);
        if (json.has("model_data")) {
            JsonObject model_data = json.get("model_data").getAsJsonObject();
            this.model_id = UtilParse.getStringSafe(model_data, "model_id", this.getId());
            this.custom_anims = model_data.has("custom_anims") ? model_data.get("custom_anims").getAsJsonArray() : new JsonArray();
            this.keyframe_anims = UtilParse.getStringArraySafe(model_data, "anim_data");
        } else {
            this.model_id = this.getId();
            this.custom_anims = new JsonArray();
            this.keyframe_anims = new String[0];
        }
    }

    protected abstract M createModel();

    public M getModel() {
        if (this.model == null) {
            this.model = this.createModel();
        }
        return this.model;
    }

    public String getModelId() {
        return this.model_id;
    }

    public JsonArray getCustomAnims() {
        return this.custom_anims;
    }

    public String[] getKeyframeAnimIds() {
        return this.keyframe_anims;
    }

    public ObjEntityModels.ModelOverrides getItemModelOverrides() {
        if (this.itemModelOverrides == null) {
            this.itemModelOverrides = this.getJsonData().has("item_model_overrides") ? new ObjEntityModels.ModelOverrides(UtilParse.getJsonSafe(this.getJsonData(), "item_model_overrides")) : ObjEntityModels.NO_OVERRIDES;
        }
        return this.itemModelOverrides;
    }

    public static abstract class CustomAnimStatsBuilder<B extends CustomAnimStatsBuilder<B>>
    extends PresetBuilder<B> {
        protected JsonObject getModelData() {
            if (!this.getData().has("model_data")) {
                this.getData().add("model_data", (JsonElement)new JsonObject());
            }
            return this.getData().get("model_data").getAsJsonObject();
        }

        public B setKFAnimDataIds(String model_id, String ... animDataIds) {
            this.setKFAnimsDataIds(animDataIds);
            return this.setSimpleModelId(model_id);
        }

        public B setKFAnimsDataIds(String ... animDataIds) {
            this.getModelData().add("anim_data", (JsonElement)UtilParse.stringArrayToJsonArray(animDataIds));
            return (B)this;
        }

        public B setCustomAnims(String model_id, JsonArray anims) {
            this.getModelData().add("custom_anims", (JsonElement)anims);
            return this.setSimpleModelId(model_id);
        }

        public B setCustomAnims(JsonArray anims) {
            return this.setCustomAnims(this.getPresetId(), anims);
        }

        public B setSimpleModelId(String model_id) {
            this.getModelData().addProperty("model_id", model_id);
            return (B)this;
        }

        public B setItemModelOverrides(float scale_all, Vec3 scale, Vec3 translate, Vec3 rotation) {
            JsonObject overrides = new JsonObject();
            overrides.addProperty("scale_all", (Number)Float.valueOf(scale_all));
            UtilParse.writeVec3(overrides, "scale", scale);
            UtilParse.writeVec3(overrides, "translate", translate);
            UtilParse.writeVec3(overrides, "rotation", rotation);
            this.getData().add("item_model_overrides", (JsonElement)overrides);
            return (B)this;
        }

        protected CustomAnimStatsBuilder(String namespace, String name, JsonPresetType type) {
            super(namespace, name, type);
        }

        protected CustomAnimStatsBuilder(String namespace, String name, JsonPresetType type, CustomAnimStats copy) {
            super(namespace, name, type, copy.getJsonData().deepCopy());
        }
    }
}

