/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.shadow.de.javagl.obj;

import com.onewhohears.onewholibs.shadow.de.javagl.obj.Obj;
import com.onewhohears.onewholibs.shadow.de.javagl.obj.ObjGroup;
import com.onewhohears.onewholibs.shadow.de.javagl.obj.ObjSplitter;
import com.onewhohears.onewholibs.shadow.de.javagl.obj.ObjUtils;
import com.onewhohears.onewholibs.shadow.de.javagl.obj.ReadableObj;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ObjSplitting {
    public static Map<String, Obj> splitByGroups(ReadableObj obj) {
        LinkedHashMap<String, Obj> objs = new LinkedHashMap<String, Obj>();
        int numGroups = obj.getNumGroups();
        for (int i = 0; i < numGroups; ++i) {
            ObjGroup group = obj.getGroup(i);
            if (group.getNumFaces() <= 0) continue;
            String groupName = group.getName();
            Obj groupObj = ObjUtils.groupToObj(obj, group, null);
            objs.put(groupName, groupObj);
        }
        return objs;
    }

    public static Map<String, Obj> splitByMaterialGroups(ReadableObj obj) {
        LinkedHashMap<String, Obj> objs = new LinkedHashMap<String, Obj>();
        int numMaterialGroups = obj.getNumMaterialGroups();
        for (int i = 0; i < numMaterialGroups; ++i) {
            ObjGroup materialGroup = obj.getMaterialGroup(i);
            if (materialGroup.getNumFaces() <= 0) continue;
            String materialGroupName = materialGroup.getName();
            Obj materialGroupObj = ObjUtils.groupToObj(obj, materialGroup, null);
            objs.put(materialGroupName, materialGroupObj);
        }
        return objs;
    }

    public static List<Obj> splitByMaxNumVertices(ReadableObj obj, int maxNumVertices) {
        if (maxNumVertices < 3) {
            throw new IllegalArgumentException("The given number of vertices must at least be 3");
        }
        ObjSplitter splitter = new ObjSplitter(maxNumVertices);
        return splitter.split(obj);
    }

    private ObjSplitting() {
    }
}

