/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.util;

import com.onewhohears.onewholibs.data.crafting.IngredientStack;
import com.onewhohears.onewholibs.util.UtilEntity;
import com.onewhohears.onewholibs.util.forge.UtilItemImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class UtilItem {
    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Item getItem(String itemKey, Item alt) {
        void var1_1;
        return UtilItemImpl.getItem(itemKey, (Item)var1_1);
    }

    public static Item getItem(String itemKey) {
        return UtilItem.getItem(itemKey, Items.f_41852_);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ResourceLocation getItemKey(Item item) {
        return UtilItemImpl.getItemKey(item);
    }

    public static String getItemKeyString(Item item) {
        return UtilItem.getItemKey(item).toString();
    }

    public static boolean testRecipe(NonNullList<Ingredient> recipeItems, Container container) {
        for (int i = 0; i < recipeItems.size(); ++i) {
            Ingredient ingredient = (Ingredient)recipeItems.get(i);
            boolean found = false;
            for (int j = 0; j < container.m_6643_(); ++j) {
                if (!ingredient.test(container.m_8020_(j))) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static List<Integer> testRecipeFails(NonNullList<Ingredient> recipeItems, Container container) {
        ArrayList<Integer> fails = new ArrayList<Integer>();
        for (int i = 0; i < recipeItems.size(); ++i) {
            Ingredient ingredient = (Ingredient)recipeItems.get(i);
            boolean found = false;
            for (int j = 0; j < container.m_6643_(); ++j) {
                if (!ingredient.test(container.m_8020_(j))) continue;
                found = true;
                break;
            }
            if (found) continue;
            fails.add(i);
        }
        return fails;
    }

    public static NonNullList<ItemStack> getRemainingItemsStackIngredients(Container container, NonNullList<Ingredient> ingredients) {
        int i;
        NonNullList remainItems = NonNullList.m_122780_((int)container.m_6643_(), (Object)ItemStack.f_41583_);
        for (i = 0; i < remainItems.size(); ++i) {
            remainItems.set(i, (Object)container.m_8020_(i));
        }
        for (i = 0; i < ingredients.size(); ++i) {
            Ingredient ingredient = (Ingredient)ingredients.get(i);
            IngredientStack ing = ingredient.getClass() == IngredientStack.class ? (IngredientStack)ingredient : IngredientStack.fromIngredient(ingredient);
            int found = 0;
            for (int j = 0; j < remainItems.size(); ++j) {
                ItemStack item = (ItemStack)remainItems.get(j);
                if (item.m_41619_() || !ing.test(item)) continue;
                if ((found += item.m_41613_()) >= ing.cost) {
                    item.m_41764_(found - ing.cost);
                    break;
                }
                item.m_41764_(0);
            }
            if (found < ing.cost) break;
        }
        return remainItems;
    }

    public static void handleInventoryRecipe(Player player, Recipe<Inventory> recipe, BlockPos pos) {
        if (!recipe.m_5818_((Container)player.m_150109_(), UtilEntity.getLevel((Entity)player))) {
            return;
        }
        NonNullList<ItemStack> remainingItems = UtilItem.getRemainingItemsStackIngredients((Container)player.m_150109_(), (NonNullList<Ingredient>)recipe.m_7527_());
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            player.m_150109_().m_6836_(i, (ItemStack)remainingItems.get(i));
        }
        ItemStack stack = UtilItem.assembleRecipe(player, recipe);
        Containers.m_18992_((Level)UtilEntity.getLevel((Entity)player), (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 1.125), (double)((double)pos.m_123343_() + 0.5), (ItemStack)stack);
    }

    public static ItemStack assembleRecipe(Player player, Recipe<Inventory> recipe) {
        return recipe.m_5874_((Container)player.m_150109_());
    }

    public static MenuType<?> getChestMenuTypeByRows(int rows) {
        if (rows == 1) {
            return MenuType.f_39957_;
        }
        if (rows == 2) {
            return MenuType.f_39958_;
        }
        if (rows == 3) {
            return MenuType.f_39959_;
        }
        if (rows == 4) {
            return MenuType.f_39960_;
        }
        if (rows == 5) {
            return MenuType.f_39961_;
        }
        if (rows == 6) {
            return MenuType.f_39962_;
        }
        return MenuType.f_39962_;
    }

    public static boolean hasCraftingRemainingItem(@NotNull ItemStack stack) {
        return stack.m_41720_().m_41470_();
    }

    @NotNull
    public static ItemStack getCraftingRemainingItem(@NotNull ItemStack stack) {
        if (UtilItem.hasCraftingRemainingItem(stack)) {
            if (!(stack = stack.m_41720_().m_41469_().m_7968_()).m_41619_() && stack.m_41763_() && stack.m_41773_() > stack.m_41776_()) {
                return ItemStack.f_41583_;
            }
            return stack;
        }
        return ItemStack.f_41583_;
    }
}

