/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.event;

import com.mojang.math.Vector3f;
import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.client.event.CameraAngles;
import com.onewhohears.dscombat.client.input.ClientInputManager;
import com.onewhohears.dscombat.client.input.DSCClientInputs;
import com.onewhohears.dscombat.data.radar.RadarStats;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.dscombat.entity.parts.EntityGimbal;
import com.onewhohears.dscombat.entity.parts.EntityRidablePart;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.mixin.CameraAccess;
import com.onewhohears.onewholibs.util.UtilEntity;
import com.onewhohears.onewholibs.util.math.QuaternionF;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import com.onewhohears.onewholibs.util.math.Vec3f;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWCursorPosCallbackI;

public class ClientCameraEventHandlers {
    private static Entity prevGimbal;
    @Nullable
    private static QuaternionF prevQ;
    private static boolean wasTrackingTarget;
    public static final CameraAngles CAMERA_ANGLES;
    public static final GLFWCursorPosCallbackI customMouseCallback;

    public static void onSetupCameraAngles(Camera camera, float pt, CameraAngles angles) {
        Minecraft m = Minecraft.m_91087_();
        LocalPlayer player = m.f_91074_;
        if (player == null) {
            return;
        }
        if (!player.m_20159_()) {
            if (ClientCameraEventHandlers.isCameraEntityEqual(m, prevGimbal)) {
                m.m_91118_((Entity)player);
            }
            prevGimbal = null;
            return;
        }
        Entity entity = player.m_20201_();
        if (!(entity instanceof EntityVehicle)) {
            return;
        }
        EntityVehicle vehicle = (EntityVehicle)entity;
        boolean detached = !m.f_91066_.m_92176_().m_90612_();
        boolean mirrored = m.f_91066_.m_92176_().m_90613_();
        float camYOffset = 0.0f;
        boolean isPilot = false;
        boolean isCopilot = false;
        Entity entity2 = player.m_20202_();
        if (entity2 instanceof EntityRidablePart) {
            EntityRidablePart seat = (EntityRidablePart)entity2;
            isPilot = seat.isPilotSeat();
            isCopilot = seat.isCoPilotSeat();
            if (DSCClientInputs.isGimbalMode()) {
                camYOffset = seat.getCameraYOffset();
            }
        }
        if (prevGimbal != null && prevGimbal.m_213877_() || !DSCClientInputs.isGimbalMode() && !ClientCameraEventHandlers.isCameraEntityEqual(m, (Entity)player)) {
            m.m_91118_((Entity)player);
            prevGimbal = null;
        }
        if (DSCClientInputs.isGimbalMode() && (isPilot || isCopilot || camYOffset == 0.0f) && vehicle.getGimbalForPilotCamera() != null) {
            EntityGimbal gimbal = vehicle.getGimbalForPilotCamera();
            if (!ClientCameraEventHandlers.isCameraEntityEqual(m, (Entity)gimbal)) {
                m.m_91118_((Entity)gimbal);
            }
            gimbal.m_146926_(player.m_5686_(pt));
            gimbal.m_146922_(player.m_5675_(pt));
            prevGimbal = gimbal;
            camYOffset = -0.2f;
        }
        if (isPilot) {
            boolean resetMousePressed = ClientInputManager.RESET_MOUSE.isPressed();
            RadarStats.RadarPing target = vehicle.radarSystem.getClientSelectedPing();
            Entity camEntity = m.m_91288_();
            if (DSCClientInputs.isCameraTrackTarget() && target != null && !resetMousePressed && camEntity != null) {
                Vec3 diff = target.pos.m_82546_(camEntity.m_20299_(pt));
                float x = UtilAngles.getPitch((Vec3)diff);
                float y = UtilAngles.getYaw((Vec3)diff);
                ClientCameraEventHandlers.setAngles(angles, (Player)player, x, y, mirrored);
                wasTrackingTarget = true;
            } else if (DSCClientInputs.isCameraLockedForward()) {
                ClientCameraEventHandlers.lookForward(angles, (Player)player, mirrored, pt, vehicle);
                wasTrackingTarget = false;
            } else if (DSCClientInputs.isCameraFreeRelative()) {
                QuaternionF qPT = vehicle.getClientQ(pt);
                if (resetMousePressed) {
                    ClientCameraEventHandlers.lookForward(angles, (Player)player, mirrored, pt, vehicle);
                } else if (prevQ != null) {
                    float[] relativeAngles = wasTrackingTarget ? new float[]{DSCClientInputs.xRotPreTrack, DSCClientInputs.yRotPreTrack} : UtilAngles.globalToRelativeDegrees((float)player.m_146909_(), (float)player.m_146908_(), (QuaternionF)prevQ);
                    float[] globalAngles = UtilAngles.relativeToGlobalDegrees((float)relativeAngles[0], (float)relativeAngles[1], (QuaternionF)qPT);
                    float x = globalAngles[0];
                    float y = globalAngles[1];
                    ClientCameraEventHandlers.setAngles(angles, (Player)player, x, y, mirrored);
                    DSCClientInputs.xRotPreTrack = relativeAngles[0];
                    DSCClientInputs.yRotPreTrack = relativeAngles[1];
                }
                prevQ = qPT;
                wasTrackingTarget = false;
            }
        }
        float zi = UtilAngles.lerpAngle((float)pt, (float)vehicle.zRotO, (float)vehicle.zRot);
        if (detached && mirrored) {
            zi *= -1.0f;
        }
        angles.setRoll(zi);
        double camDist = ((VehicleStats)vehicle.getStats()).cameraDistance;
        if (detached && isPilot && camDist > 4.0) {
            double vehicleCamDist = Math.min(0.0, 4.0 - ClientCameraEventHandlers.getMaxDist(camera, (Player)player, camDist));
            ((CameraAccess)camera).invokeSetRotation(angles.getYaw(), angles.getPitch());
            camera.m_90568_(vehicleCamDist, 0.0, 0.0);
        }
        QuaternionF q = null;
        if (camYOffset != 0.0f) {
            q = UtilAngles.lerpQ((float)pt, (QuaternionF)vehicle.getPrevQ(), (QuaternionF)vehicle.getClientQ());
            Vec3 yawAxis = UtilAngles.getYawAxis((QuaternionF)q);
            camera.m_90581_(camera.m_90583_().m_82549_(yawAxis.m_82490_((double)camYOffset)));
        }
        if (DSCClientInputs.getLeanAmount() != 0.0) {
            if (q == null) {
                q = UtilAngles.lerpQ((float)pt, (QuaternionF)vehicle.getPrevQ(), (QuaternionF)vehicle.getClientQ());
            }
            Vec3 pitchAxis = UtilAngles.getPitchAxis((QuaternionF)q);
            camera.m_90581_(camera.m_90583_().m_82549_(pitchAxis.m_82490_(-DSCClientInputs.getLeanAmount())));
        }
    }

    private static boolean isCameraEntityEqual(Minecraft m, @Nullable Entity e) {
        if (e == null || m.m_91288_() == null) {
            return false;
        }
        return m.m_91288_().equals((Object)e);
    }

    private static void lookForward(CameraAngles angles, Player player, boolean mirrored, float pt, EntityVehicle vehicle) {
        float x = UtilAngles.lerpAngle((float)pt, (float)vehicle.f_19860_, (float)vehicle.m_146909_());
        float y = UtilAngles.lerpAngle180((float)pt, (float)vehicle.f_19859_, (float)vehicle.m_146908_());
        ClientCameraEventHandlers.setAngles(angles, player, x, y, mirrored);
        DSCClientInputs.xRotPreTrack = x;
        DSCClientInputs.yRotPreTrack = y;
    }

    private static void setAngles(CameraAngles angles, Player player, float x, float y, boolean mirrored) {
        player.m_146926_(x);
        player.f_19860_ = x;
        player.m_146922_(y);
        player.f_19859_ = y;
        if (mirrored) {
            x *= -1.0f;
            y += 180.0f;
        }
        angles.setPitch(x);
        angles.setYaw(y);
    }

    public static double getMaxDist(Camera cam, Player player, double dist) {
        double d0;
        Vec3 from = cam.m_90583_();
        Vec3f d = Vec3f.from((Vector3f)cam.m_90596_());
        d.mul((float)(-dist));
        Vec3 to = from.m_82520_((double)d.x(), (double)d.y(), (double)d.z());
        BlockHitResult hitresult = UtilEntity.getLevel((Entity)player).m_45547_(new ClipContext(from, to, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, (Entity)player));
        if (hitresult.m_6662_() != HitResult.Type.MISS && (d0 = hitresult.m_82450_().m_82554_(from)) < dist) {
            dist = d0;
        }
        return dist;
    }

    public static void clientTickSetMouseCallback(Minecraft m) {
        if (m.f_91074_ == null || m.f_91074_.f_19797_ != 1) {
            return;
        }
        if (!((Boolean)Config.CLIENT.cameraTurnRelativeToVehicle.get()).booleanValue()) {
            return;
        }
        GLFW.glfwSetCursorPosCallback((long)m.m_91268_().m_85439_(), (GLFWCursorPosCallbackI)customMouseCallback);
    }

    static {
        wasTrackingTarget = false;
        CAMERA_ANGLES = new CameraAngles();
        customMouseCallback = (window, x, y) -> {
            Minecraft m = Minecraft.m_91087_();
            m.execute(() -> {
                Entity patt0$temp;
                double xn = x;
                double yn = y;
                if (window != m.m_91268_().m_85439_()) {
                    return;
                }
                if (DSCClientInputs.isCameraFree() && m.f_91074_ != null && m.f_91080_ == null && (patt0$temp = m.f_91074_.m_20201_()) instanceof EntityVehicle) {
                    EntityVehicle craft = (EntityVehicle)patt0$temp;
                    double r = Math.toRadians(craft.zRot);
                    double dx = x - m.f_91067_.m_91589_();
                    double dy = y - m.f_91067_.m_91594_();
                    double cosR = Math.cos(r);
                    double sinR = Math.sin(r);
                    xn = dx * cosR - dy * sinR + m.f_91067_.m_91589_();
                    yn = dy * cosR + dx * sinR + m.f_91067_.m_91594_();
                    GLFW.glfwSetCursorPos((long)window, (double)xn, (double)yn);
                }
                m.f_91067_.m_91561_(window, xn, yn);
            });
        };
    }
}

