/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.event.forge;

import com.mojang.math.Matrix4f;
import com.onewhohears.dscombat.client.event.ClientCameraEventHandlers;
import com.onewhohears.dscombat.client.event.ClientInputEventHandlers;
import com.onewhohears.dscombat.client.event.ClientRenderEventHandlers;
import com.onewhohears.dscombat.client.input.DSCClientInputs;
import com.onewhohears.dscombat.client.model.obj.ObjWeaponRackModel;
import com.onewhohears.dscombat.client.overlay.OverlayController;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.onewholibs.util.math.Mat4f;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dscombat", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientEventHandlersForge {
    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void playerRenderPre(RenderPlayerEvent.Pre event) {
        ClientRenderEventHandlers.onRenderPlayerPre(event.getEntity(), event.getPartialTick(), event.getPoseStack());
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void playerRenderPost(RenderPlayerEvent.Post event) {
        ClientRenderEventHandlers.onRenderPlayerPost(event.getEntity());
    }

    @SubscribeEvent
    public static void onRenderHand(RenderHandEvent event) {
        event.setCanceled(ClientRenderEventHandlers.isCancelRenderHand());
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void getViewMatrices(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS) {
            return;
        }
        OverlayController.PROJECTION_MATRIX = Mat4f.from((Matrix4f)event.getProjectionMatrix());
        ObjWeaponRackModel.renderedRackWeaponNum = 0;
    }

    @SubscribeEvent
    public static void onRenderGui(RenderGuiOverlayEvent.Pre event) {
        Entity entity = Minecraft.m_91087_().f_91074_.m_20201_();
        if (!(entity instanceof EntityVehicle)) {
            return;
        }
        EntityVehicle vehicle = (EntityVehicle)entity;
        if (DSCClientInputs.isCameraFree()) {
            return;
        }
        if (Objects.equals(event.getOverlay().id(), VanillaGuiOverlay.HOTBAR.id())) {
            event.setCanceled(true);
        }
        if (Objects.equals(event.getOverlay().id(), VanillaGuiOverlay.CROSSHAIR.id())) {
            event.setCanceled(true);
        }
        if (Objects.equals(event.getOverlay().id(), VanillaGuiOverlay.PLAYER_HEALTH.id())) {
            event.setCanceled(true);
        }
        if (Objects.equals(event.getOverlay().id(), VanillaGuiOverlay.ARMOR_LEVEL.id())) {
            event.setCanceled(true);
        }
        if (Objects.equals(event.getOverlay().id(), VanillaGuiOverlay.FOOD_LEVEL.id())) {
            event.setCanceled(true);
        }
        if (Objects.equals(event.getOverlay().id(), VanillaGuiOverlay.EXPERIENCE_BAR.id())) {
            event.setCanceled(true);
        }
        if (Objects.equals(event.getOverlay().id(), VanillaGuiOverlay.ITEM_NAME.id())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void clientMoveInput(MovementInputUpdateEvent event) {
        if (ClientInputEventHandlers.isCancelShiftInput(event.getEntity())) {
            event.getInput().f_108573_ = false;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void cameraSetup(ViewportEvent.ComputeCameraAngles event) {
        ClientCameraEventHandlers.CAMERA_ANGLES.reset();
        ClientCameraEventHandlers.onSetupCameraAngles(event.getCamera(), (float)event.getPartialTick(), ClientCameraEventHandlers.CAMERA_ANGLES);
        if (ClientCameraEventHandlers.CAMERA_ANGLES.isPitchChanged()) {
            event.setPitch(ClientCameraEventHandlers.CAMERA_ANGLES.getPitch());
        }
        if (ClientCameraEventHandlers.CAMERA_ANGLES.isYawChanged()) {
            event.setYaw(ClientCameraEventHandlers.CAMERA_ANGLES.getYaw());
        }
        if (ClientCameraEventHandlers.CAMERA_ANGLES.isRollChanged()) {
            event.setRoll(ClientCameraEventHandlers.CAMERA_ANGLES.getRoll());
        }
    }
}

