/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.overlay.components;

import com.mojang.blaze3d.vertex.PoseStack;
import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.client.input.ActionInput;
import com.onewhohears.dscombat.client.input.ActionInputHolder;
import com.onewhohears.dscombat.client.input.ClientInputManager;
import com.onewhohears.dscombat.client.input.DSCClientInputs;
import com.onewhohears.dscombat.client.input.DSCKeys;
import com.onewhohears.dscombat.client.overlay.VehicleOverlayComponent;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.dscombat.entity.parts.EntityRidablePart;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.onewholibs.util.UtilMCText;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class KeyBindsOverlay
extends VehicleOverlayComponent {
    private static final int DEFAULT_KEY_COLOR = 65280;
    private static final int USE_KEY_COLOR = 0xFFFF00;
    private static final int MAPPING_NAME_WIDTH = 80;
    private static final int KEY_NAME_WIDTH = 40;

    public static Component fixKeyName(ActionInputHolder.Button key) {
        if (((ActionInput.Button)key.getPrimaryAction()).isKeyBind()) {
            KeyMapping map = DSCKeys.getKey(((ActionInput.Button)key.getPrimaryAction()).getId());
            if (map == null) {
                return UtilMCText.literal((String)((ActionInput.Button)key.getPrimaryAction()).getId());
            }
            return switch (map.f_90816_.m_84873_()) {
                case 345 -> UtilMCText.literal((String)"R-CTRL");
                case 341 -> UtilMCText.literal((String)"L-CTRL");
                case 342 -> UtilMCText.literal((String)"L-ALT");
                case 346 -> UtilMCText.literal((String)"R-ALT");
                case 340 -> UtilMCText.literal((String)"LSHIFT");
                case 344 -> UtilMCText.literal((String)"RSHIFT");
                default -> map.f_90816_.m_84875_();
            };
        }
        return key.getName();
    }

    protected void displayMapping(PoseStack poseStack, int screenWidth, int screenHeight, int index, ActionInputHolder.Button key, Component mapName, boolean isUsed, String setting) {
        int pY = 2 + 10 * index;
        int pX = 3;
        int pColor = 65280;
        if (isUsed) {
            pColor = 0xFFFF00;
        }
        KeyBindsOverlay.m_93243_((PoseStack)poseStack, (Font)FONT, (Component)mapName, (int)pX, (int)pY, (int)pColor);
        KeyBindsOverlay.m_93243_((PoseStack)poseStack, (Font)FONT, (Component)KeyBindsOverlay.fixKeyName(key), (int)(pX += 80), (int)pY, (int)pColor);
        if (setting == null || setting.isEmpty()) {
            return;
        }
        KeyBindsOverlay.m_93236_((PoseStack)poseStack, (Font)FONT, (String)setting, (int)(pX += 40), (int)pY, (int)pColor);
    }

    protected void displayMapping(PoseStack poseStack, int screenWidth, int screenHeight, int index, ActionInputHolder.Button key, boolean isUsed, String setting) {
        this.displayMapping(poseStack, screenWidth, screenHeight, index, key, key.getName(), isUsed, setting);
    }

    protected void displayMapping(PoseStack poseStack, int screenWidth, int screenHeight, int index, ActionInputHolder.Button key, boolean isUsed) {
        this.displayMapping(poseStack, screenWidth, screenHeight, index, key, key.getName(), isUsed, null);
    }

    protected void displayMapping(PoseStack poseStack, int screenWidth, int screenHeight, int index, ActionInputHolder.Button key) {
        this.displayMapping(poseStack, screenWidth, screenHeight, index, key, key.isPressed(), null);
    }

    protected void displayMapping(PoseStack poseStack, int screenWidth, int screenHeight, int index, ActionInputHolder.Button key, String setting) {
        this.displayMapping(poseStack, screenWidth, screenHeight, index, key, key.isPressed(), setting);
    }

    protected void displayMapping(PoseStack poseStack, int screenWidth, int screenHeight, int index, ActionInputHolder.Button key, Component mapName, boolean isUsed) {
        this.displayMapping(poseStack, screenWidth, screenHeight, index, key, mapName, isUsed, null);
    }

    protected void displayMapping(PoseStack poseStack, int screenWidth, int screenHeight, int index, ActionInputHolder.Button key, Component mapName) {
        this.displayMapping(poseStack, screenWidth, screenHeight, index, key, mapName, key.isPressed(), null);
    }

    @Override
    protected boolean shouldRender(Gui gui, PoseStack poseStack, float partialTick, int screenWidth, int screenHeight) {
        if (KeyBindsOverlay.defaultRenderConditions()) {
            return false;
        }
        if (((Boolean)Config.CLIENT.enableModernHUD.get()).booleanValue()) {
            return false;
        }
        Entity entity = KeyBindsOverlay.getPlayerVehicle();
        if (!(entity instanceof EntityRidablePart)) {
            return false;
        }
        EntityRidablePart seat = (EntityRidablePart)entity;
        EntityVehicle vehicle = seat.getParentVehicle();
        return vehicle != null;
    }

    @Override
    protected void render(Gui gui, PoseStack poseStack, float partialTick, int screenWidth, int screenHeight) {
        EntityRidablePart seat = (EntityRidablePart)KeyBindsOverlay.getPlayerVehicle();
        assert (seat != null);
        EntityVehicle vehicle = seat.getParentVehicle();
        assert (vehicle != null);
        boolean isPilot = seat.isPilotSeat();
        boolean isCoPilot = seat.isCoPilotSeat();
        int index = 0;
        if (isPilot) {
            this.displayMapping(poseStack, screenWidth, screenHeight, index++, ClientInputManager.MOUSE_MODE, !DSCClientInputs.getMouseMode().isLockedForward(), DSCClientInputs.getMouseMode().name());
        }
        this.displayMapping(poseStack, screenWidth, screenHeight, index++, ClientInputManager.VEHICLE_MENU);
        if (((Boolean)Config.CLIENT.customDismount.get()).booleanValue()) {
            this.displayMapping(poseStack, screenWidth, screenHeight, index++, ClientInputManager.DISMOUNT);
        }
        if (seat.canEject()) {
            this.displayMapping(poseStack, screenWidth, screenHeight, index++, ClientInputManager.EJECT);
        }
        this.displayMapping(poseStack, screenWidth, screenHeight, index++, ClientInputManager.CHANGE_SEAT);
        if (isPilot && vehicle.canToggleLandingGear()) {
            this.displayMapping(poseStack, screenWidth, screenHeight, index++, ClientInputManager.LANDING_GEAR, vehicle.isLandingGear(), vehicle.isLandingGear() ? "OUT" : "IN");
        }
        if (isPilot && vehicle.canGroundBrake()) {
            this.displayMapping(poseStack, screenWidth, screenHeight, index++, ((VehicleStats)vehicle.getStats()).isPlane() ? ClientInputManager.SPECIAL2 : ClientInputManager.SPECIAL1, (Component)UtilMCText.translatable((String)"info.dscombat.breaks"), vehicle.isGroundBraking());
        }
        if (isPilot && vehicle.canAirBrake()) {
            this.displayMapping(poseStack, screenWidth, screenHeight, index++, ((VehicleStats)vehicle.getStats()).isPlane() ? ClientInputManager.SPECIAL2 : ClientInputManager.SPECIAL1, (Component)UtilMCText.translatable((String)"info.dscombat.breaks"), vehicle.isAirBreaking());
        }
        if (isPilot && vehicle.canFlapsDown()) {
            this.displayMapping(poseStack, screenWidth, screenHeight, index++, ClientInputManager.SPECIAL1, (Component)UtilMCText.translatable((String)"info.dscombat.flaps_down"));
        }
        if (isPilot && vehicle.canAngleWeaponDown()) {
            this.displayMapping(poseStack, screenWidth, screenHeight, index++, ClientInputManager.SPECIAL2, (Component)UtilMCText.translatable((String)"info.dscombat.nose_down"));
        }
        if (isPilot && vehicle.canHover()) {
            this.displayMapping(poseStack, screenWidth, screenHeight, index++, ClientInputManager.SPECIAL1, (Component)UtilMCText.translatable((String)"info.dscombat.hover"));
        }
        if (isPilot && vehicle.hasFlares()) {
            this.displayMapping(poseStack, screenWidth, screenHeight, index++, ClientInputManager.FLARE, "" + vehicle.getFlareNum());
        }
        if (isPilot || isCoPilot) {
            this.displayMapping(poseStack, screenWidth, screenHeight, index++, ClientInputManager.WEAPON_CYCLE);
        }
        if (vehicle.radarSystem.hasRadar()) {
            boolean warning = DSCClientInputs.getPreferredRadarMode() != vehicle.getRadarMode();
            this.displayMapping(poseStack, screenWidth, screenHeight, index++, ClientInputManager.RADAR_MODE, warning, DSCClientInputs.getPreferredRadarMode().name());
        }
        if (vehicle.radarSystem.hasRadar()) {
            this.displayMapping(poseStack, screenWidth, screenHeight, index++, ClientInputManager.PING_CYCLE);
        }
        if (vehicle.getGimbalForPilotCamera() != null || seat.getCameraYOffset() != 0.0f) {
            this.displayMapping(poseStack, screenWidth, screenHeight, index++, ClientInputManager.GIMBAL, DSCClientInputs.isGimbalMode(), DSCClientInputs.isGimbalMode() ? "ON" : "OFF");
        }
        if (vehicle.canUseAfterburner()) {
            this.displayMapping(poseStack, screenWidth, screenHeight, index++, ClientInputManager.AFTERBURNER, DSCClientInputs.isAfterBurner(), DSCClientInputs.isAfterBurner() ? "ON" : "OFF");
        }
        if (vehicle.canUseTurnAssist()) {
            this.displayMapping(poseStack, screenWidth, screenHeight, index++, ClientInputManager.TURN_ASSIST, DSCClientInputs.isTurnAssist(), DSCClientInputs.isTurnAssist() ? "ON" : "OFF");
        }
        if (vehicle.radarSystem.hasRadar()) {
            this.displayMapping(poseStack, screenWidth, screenHeight, index++, ClientInputManager.CAMERA_TRACK_TARGET, DSCClientInputs.isCameraTrackTarget(), DSCClientInputs.isCameraTrackTarget() ? "ON" : "OFF");
        }
    }

    @Override
    @NotNull
    protected String componentId() {
        return "dscombat_key_binds";
    }
}

