/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.onewhohears.dscombat.client.entityscreen.EntityScreenTypes;
import com.onewhohears.dscombat.client.entityscreen.instance.EntityScreenInstance;
import com.onewhohears.onewholibs.util.math.QuaternionF;
import com.onewhohears.onewholibs.util.math.Vec3f;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public interface EntityScreenRenderer<T extends Entity> {
    public static final Int2ObjectMap<EntityScreenInstance> screenInstances = new Int2ObjectOpenHashMap();

    public static void clearCache() {
        for (EntityScreenInstance screen : screenInstances.values()) {
            screen.close();
        }
        screenInstances.clear();
    }

    public static EntityScreenInstance getOrCreateEntityScreenById(int screenId, int screenType) {
        if (screenInstances.containsKey(screenId)) {
            return (EntityScreenInstance)screenInstances.get(screenId);
        }
        EntityScreenInstance screen = ((EntityScreenTypes.EntityScreenFactory)EntityScreenTypes.screenTypes.get(screenType)).create(screenId);
        screenInstances.put(screenId, (Object)screen);
        return screen;
    }

    public static int getFreeScreenId(int min) {
        int id = min;
        IntSet keys = screenInstances.keySet();
        while (keys.contains(++id)) {
        }
        return id;
    }

    public boolean shouldRenderScreens(T var1);

    default public void renderScreen(T entity, int screenId, int screenType, PoseStack poseStack, MultiBufferSource buffer, float partialTicks, int packedLight, Vec3 pos, float width, float height, float xRot, float yRot, float zRot) {
        if (screenId == -1) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85837_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        QuaternionF q = Vec3f.XP.rotationDegrees(xRot);
        q.mul(Vec3f.YP.rotationDegrees(yRot));
        q.mul(Vec3f.ZP.rotationDegrees(zRot + 180.0f));
        poseStack.m_85845_(q.convert());
        poseStack.m_85841_(width, height, 1.0f);
        EntityScreenRenderer.getOrCreateEntityScreenById(screenId, screenType).draw((Entity)entity, poseStack, buffer, partialTicks, packedLight, width, height);
        poseStack.m_85849_();
    }
}

