/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.onewhohears.dscombat.client.renderer.RotableHitboxRenderer;
import com.onewhohears.dscombat.client.renderer.VehicleScreenRenderer;
import com.onewhohears.dscombat.data.vehicle.EntityScreenData;
import com.onewhohears.dscombat.data.vehicle.client.VehicleClientStats;
import com.onewhohears.dscombat.entity.parts.EntityPart;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.onewholibs.client.renderer.RendererCustomAnimObjEntity;
import com.onewhohears.onewholibs.util.math.QuaternionF;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.Entity;

public class RendererObjVehicle
extends RendererCustomAnimObjEntity<EntityVehicle>
implements RotableHitboxRenderer,
VehicleScreenRenderer<EntityVehicle> {
    public RendererObjVehicle(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    public void render(EntityVehicle entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        super.m_7392_((Entity)entity, yaw, partialTicks, poseStack, bufferSource, packedLight);
        if (this.shouldDrawRotableHitboxes(entity)) {
            this.drawRotableHitboxeOutlines(entity, partialTicks, poseStack, bufferSource);
        }
        if (this.shouldRenderScreens(entity)) {
            this.renderVehicleScreens(entity, poseStack, bufferSource, packedLight, partialTicks);
        }
    }

    @Override
    public void renderVehicleScreens(EntityVehicle vehicle, PoseStack poseStack, MultiBufferSource buffer, int packedLight, float partialTicks) {
        poseStack.m_85836_();
        QuaternionF q = UtilAngles.lerpQ((float)partialTicks, (QuaternionF)vehicle.getPrevQ(), (QuaternionF)vehicle.getClientQ());
        poseStack.m_85845_(q.convert());
        for (EntityScreenData screen : this.getScreens(vehicle)) {
            this.renderScreen((Entity)vehicle, screen.instanceId, screen.type, poseStack, buffer, partialTicks, packedLight, screen.rel_pos, screen.width, screen.height, screen.xRot, screen.yRot, screen.zRot);
        }
        poseStack.m_85849_();
    }

    @Override
    public boolean shouldRenderScreens(EntityVehicle vehicle) {
        if (this.getScreens(vehicle).isEmpty()) {
            return false;
        }
        Minecraft m = Minecraft.m_91087_();
        if (m.f_91074_ == null) {
            return false;
        }
        EntityPart seat = vehicle.getPilotSeat();
        if (seat == null) {
            return false;
        }
        return m.f_91074_.m_20280_((Entity)seat) < 64.0;
    }

    protected List<EntityScreenData> getScreens(EntityVehicle vehicle) {
        return ((VehicleClientStats)vehicle.getAssets()).getScreens();
    }
}

