/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.entity.vehicle.hitbox.RotableHitbox;
import com.onewhohears.dscombat.util.UtilRender;
import com.onewhohears.onewholibs.util.math.Mat3f;
import com.onewhohears.onewholibs.util.math.Mat4f;
import com.onewhohears.onewholibs.util.math.QuaternionF;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import com.onewhohears.onewholibs.util.math.UtilGeometry;
import com.onewhohears.onewholibs.util.math.Vec3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.phys.Vec3;

public interface RotableHitboxRenderer {
    public static final int[] DEFAULT_COLOR = new int[]{188, 85, 41, 255};
    public static final int[] DESTROYED_COLOR = new int[]{120, 0, 0, 255};

    default public boolean shouldDrawRotableHitboxes(EntityVehicle entity) {
        if (entity.m_20145_() || entity.getHitboxes().isEmpty()) {
            return false;
        }
        Minecraft m = Minecraft.m_91087_();
        return !m.m_91299_() && m.m_91290_().m_114377_();
    }

    default public void drawRotableHitboxeOutlines(EntityVehicle entity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource) {
        VertexConsumer buff = bufferSource.m_6299_(RenderType.m_110504_());
        QuaternionF q = UtilAngles.lerpQ((float)partialTicks, (QuaternionF)entity.getPrevQ(), (QuaternionF)entity.getClientQ());
        for (RotableHitbox hitbox : entity.getHitboxes()) {
            this.drawRotableHitboxOutline(hitbox, poseStack, buff, q);
        }
    }

    private void drawRotableHitboxOutline(RotableHitbox hitbox, PoseStack poseStack, VertexConsumer buff, QuaternionF q) {
        poseStack.m_85836_();
        Vec3 trans = UtilAngles.rotateVector((Vec3)hitbox.getRelPos(), (QuaternionF)q);
        poseStack.m_85837_(trans.f_82479_, trans.f_82480_, trans.f_82481_);
        Mat4f m4 = Mat4f.from((Matrix4f)poseStack.m_85850_().m_85861_());
        Mat3f m3 = Mat3f.from((Matrix3f)poseStack.m_85850_().m_85864_());
        Vec3f ext = UtilGeometry.convertVector((Vec3)hitbox.getHitbox().getExtents());
        Vec3f c0 = ext.copy();
        c0.transform(q);
        Vec3f c1 = ext.copy();
        c1.mul(-1.0f, 1.0f, 1.0f);
        c1.transform(q);
        Vec3f c2 = ext.copy();
        c2.mul(1.0f, -1.0f, 1.0f);
        c2.transform(q);
        Vec3f c3 = ext.copy();
        c3.mul(1.0f, 1.0f, -1.0f);
        c3.transform(q);
        Vec3f c4 = c3.copy();
        c4.mul(-1.0f);
        Vec3f c5 = c2.copy();
        c5.mul(-1.0f);
        Vec3f c6 = c1.copy();
        c6.mul(-1.0f);
        Vec3f c7 = c0.copy();
        c7.mul(-1.0f);
        int[] color = hitbox.isDestroyed() ? DESTROYED_COLOR : DEFAULT_COLOR;
        UtilRender.drawLine(c0, c1, buff, m4, m3, color);
        UtilRender.drawLine(c0, c2, buff, m4, m3, color);
        UtilRender.drawLine(c0, c3, buff, m4, m3, color);
        UtilRender.drawLine(c1, c5, buff, m4, m3, color);
        UtilRender.drawLine(c1, c4, buff, m4, m3, color);
        UtilRender.drawLine(c2, c4, buff, m4, m3, color);
        UtilRender.drawLine(c2, c6, buff, m4, m3, color);
        UtilRender.drawLine(c3, c5, buff, m4, m3, color);
        UtilRender.drawLine(c3, c6, buff, m4, m3, color);
        UtilRender.drawLine(c4, c7, buff, m4, m3, color);
        UtilRender.drawLine(c5, c7, buff, m4, m3, color);
        UtilRender.drawLine(c6, c7, buff, m4, m3, color);
        poseStack.m_85849_();
    }
}

